/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;   File Name: eoc_init.c
;
;   This file contains the EOC initialization functions
;
;***************************************************************************/
#include <string.h>
#include "common.h"
#include "eoc.h"
#include "gdata.h"
#include "showtime.h"
#include "cmv.h"
#include "cmv_Data.h"

/*****************************************************************************
*   Subroutine Name: RxEocInit
*
*   Description:
*      This subroutine initializes variables used by the Ovhd RX functions.
*
*   Prototype:
*       void RxEocInit(void);
*
*   Input Arguments: none
*
*   Output Arguments: none
*
*   Return: none
*
*
*
*******************************************************************************/
void RxEocInit(void)
{
   int16 i;
   int32 l_Index;

   gft_escape_octet_received = FALSE;
   gus_rx_msg_index = 0;

   //XDSLRTFW-3107
   gft_UsOlrInProgress = FALSE;
   gul_first_OHC_bytes = 0xABABABAB;
   gus_first_OHC_bytes_cnt = 0;

   // Initialize the Rx EOC structure
   gt_RxEocMsg.message_priority = 3;       //  Initialize with invalid entry
   gt_RxEocMsg.cntrl_field = 4;          //  EOC message control field
   gt_RxEocMsg.gus_FCS = 0;             //  EOC message FCS

   gt_RxEocMsgFifo.MessageBuffer = &guca_EocMsgBuffers[MAX_TX_EOC_MSG_SIZE];   // Sized MAX_RX_EOC_MSG_SIZE
   gt_RxEocMsgFifo.BufferSize = MAX_RX_EOC_MSG_SIZE;
   gt_RxEocMsgFifo.IndexOfOldest = 0;
   gt_RxEocMsgFifo.NextAvailable = 0;
   gt_RxEocMsgFifo.ErrorCode = 0;
   gt_RxEocMsgFifo.us_OvflowCnt = 0;

   guca_rx_eoc_msg_buffer = &guca_EocMsgBuffers[MAX_TX_EOC_MSG_SIZE+MAX_RX_EOC_MSG_SIZE];   // Sized (MAX_RX_EOC_MSG_SIZE-6)
   guca_tx_eoc_msg_buffer = &guca_EocMsgBuffers[MAX_TX_EOC_MSG_SIZE+MAX_RX_EOC_MSG_SIZE+MAX_RX_EOC_MSG_SIZE-6]; //// Sized (MAX_TX_EOC_MSG_SIZE-6)

   for (l_Index = 0; l_Index < MAX_OVHD_PRIORITY; l_Index++)
   {
      gusa_EocNumTimeouts[l_Index] = 0;
   }

   // Zero out buffer before we try to receive msg
   memset(gt_RxEocMsgFifo.MessageBuffer, 0, MAX_RX_EOC_MSG_SIZE);
   memset(guca_rx_eoc_msg_buffer, 0, (MAX_RX_EOC_MSG_SIZE - 6));

   // Initialize the Self test register
   for(i = 0; i< SELF_TEST_REG_LENGTH; i++)
   {
      gt_RxOvhdRegister.uc_self_test_reg[i] = 0;
   }

   // Clear Rx EOC message indicator
   gul_RxEocMsgIndicator = 0;
   gus_OlrDiscardCnt     = 0;
}
