/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware BIS Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             tx_eoc_form_msg.c
 * DESCRIPTION:      Functions that form Tx EOC msgs.
 *
 **********************************************************************/

// ***********************************************************************************************************
// tx_eoc_form_msg.c
//
// History
//
// 05/3/2013 Vinjam: Report Delay in milli seconds granularity to the far-end
//           Grep for XDSLRTFW-744 Enh_All_VDSL2_All_IntlvDelayIn1By100ms
//
// 07/05/2013 ChihWen: Segmenting the block-read-ack message once its length is more than buffer size.
//                  1. For NVLT-C CO, replacing multi-read-ack with block-read-ack message.
//                  2. Properly segmenting the block-read-ack message once its length is more than buffer size.
//            Grep for: XDSLRTFW-795 Enhance_ALL_VDSL2_All_SegmentedBlockReadAck
//
// 24/07/2013 Ram: Incorporated review comments from Stefan. Look at JIRA 1098 for review comments.
//                 According to G.998.4 spec, prev EFTR_min value should be reported if new EFTR_min
//                 is not yet computed (EFTR_min is computed once per second).
//                 Grep for XDSLRTFW-1098: BugFix_DS_VDSL2_ALL_SES_Not_Incrementing_In_ReTx
//
//01-08-2013 Varun/Palaksha: "XDSLRTFW-1055 VDSL2 US ReTx: Overhead message changes for US ReTx Transmit"
//       Calculation or(and)  sending of below things
//     (i) In  response  to  a  Test Parameter Single  Read  command  if US retransmission is enabled
//      - INP_act_SHINE (Far-end RTX Transmitter Actual Impulse Noise protection against SHINE)
//      - INP_act_REIN (Far-end RTX Transmitter Actual Impulse Noise protection against REIN)
//    (ii)In Response to Management counter Single  Read  command  if US retransmission is enabled send Counter of rtx-tx
//    (iii)Upon reception of the Enter RTX_TESTMODE command, the VTU-R shall acknowledge it with an
//         ACK response. Afterwards, the VTU-R shall acknowledge all received DTUs if retransmission is
//         enabled  in  the  DS  direction  and  shall  stop  retransmitting  any  DTU  if  retransmission  is
//         enabled in upstream. Upon  reception  of  the  Leave  RTX_TESTMODE  command,  the  VTU-R  shall  resume
//         the  normal behaviour of retransmission in the direction where it is enabled
//    grep for XDSLRTFW-1055 Feature_US_VDSL2_ALL_UsReTx_TxOvhdTestMgmtDiag
//
// 29/10/2013 Anantha Ramu: Modifications done to send INP values( REIN & SHINE) used in the calculation of
//                          ATTNDR with attndr_method set to 1 or 2.
//                          Grep for: XDSLRTFW-1286 Feature_US_VDSL2_ALL_UsReTxAmend2_ATTNDR_ohd
//
// 17/10/2014 Palaksha
//    Implementation of "XDSLRTFW-1211: VR9 RETX, Minimum error-free throughput (EFTR_min) extension according to G.998.4 Corrigendum 4"
//    grep for XDSLRTFW-1211_Enh_All_VDSL2_EFTRmin_Corr4Ginp
//
// 10/10/2017 Abu Rahman
// XDSLRTFW-3071: US & DS ATP reporting is swapped
//     Variables contains the DS ActATP and US ActATP were wrongly (swapped) populated.
//     - Fixed the variable initialization.
//     - Fixed variables population for DS ActATP and US ActATP
//     - Fixed HDLC messages relating to these variables both for Showtime and diag mode
//     - Changed two structure names
//       1. old name: gt_G997_NeSignalAndMarginParams, new name: gt_LineStatusDS
//       2. old name: gt_G997_FeSignalAndMarginParams, new name: gt_LineStatusUS
//     Grep for XDSLRTFW-3071
// ************************************************************************************************************

#include <string.h>
#include "common.h"
#include "eoc.h"
#include "gdata.h"
#include "g997.h"
#include "dsp_op.h"
#include "mul.h" // just for MULU16
#include "gdata.h"
#include "cmv_Data.h"
#include "GetQlnHlogForCarrierGroup.h"

//#ifdef MTK_VECTORING_SUPPORT
#include "FormRErrorFeedbackMsg_VDSL2.h"
//#endif

extern void Abandon_DS_OLRPM(void);
extern uint8 GetSnrForCarrierGroup(const uint16 us_CarrierGroup);

//XDSLRTFW-795 Enhance_ALL_VDSL2_All_SegmentedBlockReadAck (START)
uint16 gus_startIx = 0;
uint16 gus_endIx = 0;
uint16 gus_last_hlog_endIx = 0;
int16 gs_sts_pmd_test_rd = -1;
//XDSLRTFW-795 Enhance_ALL_VDSL2_All_SegmentedBlockReadAck (END)

/*^^^
 *------------------------------------------------------------------------------
 *
 *  Name : uint8 Form_EOC_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length)
 *
 *  Description: This subroutine forms the transmit EOC message
 *
 *  Prototype:
 *     uint8 Form_EOC_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length);
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *  Global Variables Used:
 *
 *
 *------------------------------------------------------------------------
 *^^^
 */
uint8 Form_EOC_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length,
                   TxOvhdMsgInfoStruct_t *pt_TxOvhdMsgInfo)
{
   // Initialize with invalid entry
   uint8 uc_comm_or_resp_bit;
   int16 k;

   k = 2;
   uc_comm_or_resp_bit = 1; // response code

   switch(pt_TxOvhdMsgInfo->uc_message_type)
   {
      // Self test acknowledge only sent by RT
      case SELF_TEST_ACK:
         puca_msg_buffer[k++] = 0xFE;       // Time to wait before requested self test result
         break;

      case EOC_ACK:
         break;

      default:
         uc_comm_or_resp_bit = 2;           // Set to an invalid value
         break;
   }

   // Write the tx message length
   *pus_msg_length = k;

   return(uc_comm_or_resp_bit);
}

/*^^^
 *------------------------------------------------------------------------------
 *
 *  Name : Form_time_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length)
 *
 *  Description:  This subroutine forms the time command to be sent
 *
 *  Prototype:
 *      uint8 Form_time_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
uint8 Form_time_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length, TxOvhdMsgInfoStruct_t *pt_TxOvhdMsgInfo)
{
   uint8 uc_comm_or_resp_bit;
   uint16 i,j,us_Digit;

   /* DFH - revisit
      puca_timer[0] = &(gt_Timer.uc_hour);
      puca_timer[1] = &(gt_Timer.uc_minute);
      puca_timer[2] = &(gt_Timer.uc_second);
   */
   uc_comm_or_resp_bit = 1;

   i = 2;
   switch(pt_TxOvhdMsgInfo->uc_message_type)
   {
// These commands only sent by RT

   case TIME_READ_ACK:

      for (j = 0; j < 3; j++)
      {
         switch(j)
         {
         case 0:
            us_Digit = gt_TimeStat.us_RunningTime_HH;
            break;
         case 1:
            us_Digit = gt_TimeStat.us_RunningTime_MM;
            break;
         case 2:
            us_Digit = gt_TimeStat.us_RunningTime_SS;
            break;
         default:
            us_Digit=0;
            break;
         }

         puca_msg_buffer[i++] = (us_Digit/10) + '0';
         puca_msg_buffer[i++] = us_Digit - ((us_Digit/10) * 10) + '0'; // truncation matters
         if (j < 2)
         {
            puca_msg_buffer[i++] = ':';
         }
      } // for

      break;

   case TIME_ACK:
      break;

   default:
      uc_comm_or_resp_bit = 2;        // Set to an invalid value
      break;
   }

   // Write the tx message length
   *pus_msg_length = (uint16)i;

   return(uc_comm_or_resp_bit);
}


/*^^^
 *------------------------------------------------------------------------------
 *
 *  Name : Form_Inventory_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length)
 *
 *  Description:  This subroutine forms the inventory message to be sent
 *
 *  Prototype:
 *      uint8 Form_Inventory_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
uint8 Form_Inventory_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length,
                         TxOvhdMsgInfoStruct_t *pt_TxOvhdMsgInfo)
{
   uint8 uc_comm_or_resp_bit;
   int16 k;


   int16 sa_Length[3][3] = {VENDOR_ID_LENGTH, VERSION_NUM_LENGTH, SERIAL_NUM_LENGTH,
                            VENDOR_ID_LENGTH, 0, 0,
                            SELF_TEST_REG_LENGTH, 0, 0
                           };

   uint8 *puca_Buffer_ToCopyFrom[3][3] = {guca_ne_SystemVendorID, guca_ne_SystemVersionNum, guca_ne_SystemSerialNum,
                                          guca_ne_SystemVendorID, NULL, NULL,
                                          gt_TxOvhdRegister.uc_self_test_reg, NULL, NULL
                                         };

   uint8 uc_message_type;
   int16 sa_NumMessages[3];
   int16 s_MsgType, s_Length, j;

   sa_NumMessages[0] = 3;
   sa_NumMessages[1] = 1;
   sa_NumMessages[2] = 1;
   uc_message_type = pt_TxOvhdMsgInfo->uc_message_type;

   uc_comm_or_resp_bit = (uc_message_type & 0x80) >> 7; // command  or response

   s_MsgType = (uc_message_type & 0xF);

   k=2;   // First two bytes are header.

   switch(uc_message_type)
   {
   case IDENT_READ_ACK:
   case AUX_IDENT_READ_ACK:
   case SELF_TEST_RES_READ_ACK:

      for (j = 0; j < sa_NumMessages[s_MsgType-1]; j++)
      {
         s_Length = sa_Length[s_MsgType-1][j];
         memcpy(puca_msg_buffer+k, puca_Buffer_ToCopyFrom[s_MsgType-1][j], s_Length);
         k += s_Length;
      }

      if ((IDENT_READ_ACK == uc_message_type) || (SELF_TEST_RES_READ_ACK == uc_message_type))
      {
         break;
      }

      for (j=0; j < MAX_AUX_INFO_BYTES; j++)
      {
         puca_msg_buffer[k++] = guca_ne_AuxInvInfo[j];
      }

      break;

   case IDENT_READ:
   case AUX_IDENT_READ:
      uc_comm_or_resp_bit = 0; // command
      break;
   } // switch

   *pus_msg_length = k;

   return(uc_comm_or_resp_bit);

}


/*^^^
 *------------------------------------------------------------------------------
 *
 *  Name : Form_mgmt_counter_read_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length)
 *
 *  Description:  This subroutine forms the management counter read message to be sent
 *
 *  Prototype:
 *      uint8 Form_mgmt_counter_read_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
/*^^^
 *------------------------------------------------------------------------------
 *
 *  Name : cpyCntr(uint8* const pbuf, const uint32 ul_cntr, uint16* const pk)
 *
 *  Description:  This subroutine copies the management counter to a buffer to be sent
 *
 *  Prototype:
 *        void cpyCntr(uint8* const pbuf, const uint32 ul_cntr, uint16* const pk)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void cpyCntr(uint8* const pbuf, const uint32 ul_cntr, uint16* const pk)
{
   pbuf[0] = ul_cntr>>24;
   pbuf[1] = ul_cntr>>16;
   pbuf[2] = ul_cntr>>8;
   pbuf[3] = ul_cntr;

   (*pk) += 4;
}

/*^^^
 *------------------------------------------------------------------------------
 *
 *  Name : cpyTpsTcCntrs(const unsigned char uc_latpath, uint8* const pbuf, uint16* const pidx)
 *
 *  Description:  This subroutine copies the management counter to a buffer to be sent
 *
 *  Prototype:
 *        void cpyTpsTcCntrs(const unsigned char uc_latpath, uint8* const pbuf, uint16* const pidx)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void cpyTpsTcCntrs(const unsigned char uc_latpath, uint8* const pbuf, uint16* const pidx)
{
   int16 s_dpModeDS, s_dpModeUS;

   // To maintain the backward compatibility with INTEROP against BRCM ...

   s_dpModeDS = gta_DsBearerChanAct[uc_latpath].s_TypeEnabled;
   s_dpModeUS = gta_UsBearerChanAct[uc_latpath].s_TypeEnabled;


   if ((s_dpModeDS == s_dpModeUS) && (TPS_TC_TYPE_ATM == s_dpModeDS))
   {
      // get ATM counters

      // HEC anomalies
      cpyCntr(pbuf+(*pidx),gt_g997_AtmPerf_HEC_Running_NE.la_HEC_P_count[uc_latpath],pidx);

      // Total cells
      cpyCntr(pbuf+(*pidx),gt_g997_AtmPerf_CU_Running_NE.la_CU_P_count[uc_latpath],pidx);

      // Total cells passed through ATM function
      cpyCntr(pbuf+(*pidx),gt_g997_AtmPerf_CD_Running_NE.la_CD_P_count[uc_latpath],pidx);

      // Total bit errors
      cpyCntr(pbuf+(*pidx),gt_g997_AtmPerf_IBE_Running_NE.la_IBE_P_count[uc_latpath],pidx);
   }
   else
   {
      // In G.993.2 section K.3.9.3.3 and K.1.9.3.3 ...

      // "The block of counter values corresponding to the PTM-TC function returned in
      // the message described in Table 11-17 shall have zero length"
   }
}

uint8 Form_mgmt_counter_read_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length,
                                 TxOvhdMsgInfoStruct_t *pt_TxOvhdMsgInfo)
{
   uint8 uc_comm_or_resp_bit=2;
   //XDSLRTFW-1098: BugFix_DS_VDSL2_ALL_SES_Not_Incrementing_In_ReTx (Start_End)
   uint32 ul_TempEftrMin;

   /* DFH - revisit */
   uint16 k;

   uc_comm_or_resp_bit = 2;                    // Initialize with an invalid value, 0 - command, 1 - response
   k = 2;

   switch(pt_TxOvhdMsgInfo->uc_message_type)
   {
   case MGMT_CNTR_READ:
      uc_comm_or_resp_bit = 0;                 // command
      break;

   case MGMT_CNTR_READ_ACK:
      uc_comm_or_resp_bit = 1;                 // response

      // Clear the message buffer
      memset (&puca_msg_buffer[2], 0, 100);
      {
         // Send the 32 bit FEC and CRC counter values for all latency paths : MSB first

         // Send the FEC counter value

         //k = FormMgmtShortCountBytes(k, gsa_CorrectedRSErrors, puca_msg_buffer, gt_rx_config.s_Nlp);
         //k = FormMgmtCountBytes(k, gsa_CorrectedRSErrors, puca_msg_buffer, gt_rx_config.s_Nlp, 0);

         //NOTE
         //If reported for a direction where retransmission is enabled, the VTU shall
         //include the fields of the FEC and CRC anomalies for the latency path #0 and #1; the
         //FEC and CRC for the latency path #0 shall be vendor discretionary. If reported for a
         //direction where retransmission is disabled, the VTU shall include only the fields of the
         //FEC and CRC anomalies for the latency path #0.

         if ((gt_rx_TPS_Map.s_BCtoLP[BC0] == LP0) || (gt_rx_TPS_Map.s_BCtoLP[BC1] == LP0))
         {
            cpyCntr(puca_msg_buffer+k,gt_g997_ChPerf_FEC_Running_NE.la_FEC_C_count[LP0],&k);
         }

         if ((gt_rx_TPS_Map.s_BCtoLP[BC0] == LP1) || (gt_rx_TPS_Map.s_BCtoLP[BC1] == LP1))
         {
            cpyCntr(puca_msg_buffer+k,gt_g997_ChPerf_FEC_Running_NE.la_FEC_C_count[LP1],&k);
         }

         // Send the CRC counter value
         //k = FormMgmtCountBytes(k, gsa_CRC_count, puca_msg_buffer, gt_rx_config.s_Nlp, 0);
         if ((gt_rx_TPS_Map.s_BCtoLP[BC0] == LP0) || (gt_rx_TPS_Map.s_BCtoLP[BC1] == LP0))
         {
            cpyCntr(puca_msg_buffer+k,gt_g997_ChPerf_CRC_Running_NE.la_CV_C_count[LP0],&k);
         }

         //k = FormMgmtCountBytes(k, gsa_CRC_count, puca_msg_buffer, gt_rx_config.s_Nlp, 0);
         if ((gt_rx_TPS_Map.s_BCtoLP[BC0] == LP1) || (gt_rx_TPS_Map.s_BCtoLP[BC1] == LP1))
         {
            cpyCntr(puca_msg_buffer+k,gt_g997_ChPerf_CRC_Running_NE.la_CV_C_count[LP1],&k);
         }

//XDSLRTFW-1055 Feature_US_VDSL2_ALL_UsReTx_TxOvhdTestMgmtDiag (Start)
         if(gt_ReTXParams.uc_UsReTxStatus == US_RETX_IN_USE)
         {
            //gt_g997_ReTx_FE_MgmtCnt.l_USRetransmittedDtuCnt is a NE counter. see declaration for more details
            cpyCntr(puca_msg_buffer+k, gt_g997_ReTx_FE_MgmtCnt.l_USRetransmittedDtuCnt, &k);
         }
//XDSLRTFW-1055 Feature_US_VDSL2_ALL_UsReTx_TxOvhdTestMgmtDiag (End)

         if (gt_ReTXParams.uc_OMSG1_DsReTxEnabled == RETX_SELECTED)
         {
            cpyCntr(puca_msg_buffer+k, gt_ReTXStats.ul_CorrectedDtuCnt, &k);
            cpyCntr(puca_msg_buffer+k, gt_ReTXStats.ul_UncorrectedDtuCnt, &k);
         }
         //{
         //   uint32 ula_TempCounts[5];
         //
         //   ula_TempCounts[0] = gs_fec_err_sec_cnt;
         //   ula_TempCounts[1] = gs_err_sec_cnt;
         //   ula_TempCounts[2] = gs_sev_err_sec_cnt;
         //   ula_TempCounts[3] = gs_los_err_sec_cnt;
         //   ula_TempCounts[4] = gs_unavail_err_sec_cnt;
         //   k = FormMgmtCountBytes(k, ula_TempCounts, puca_msg_buffer, 5, 1);
         //}

         // FEC errored seconds
         cpyCntr(puca_msg_buffer+k,gt_g997_LinePerf_Running_NE.l_FECS_L_count,&k);

         // Errored seconds
         cpyCntr(puca_msg_buffer+k,gt_g997_LinePerf_Running_NE.l_ES_L_count,&k);

         // Severely errored seconds
         cpyCntr(puca_msg_buffer+k,gt_g997_LinePerf_Running_NE.l_SES_L_count,&k);

         // LOS errored seconds
         cpyCntr(puca_msg_buffer+k,gt_g997_LinePerf_Running_NE.l_LOSS_L_count,&k);

         // UAS errored seconds
         cpyCntr(puca_msg_buffer+k,gt_g997_LinePerf_Running_NE.l_UAS_L_count,&k);


         if (gt_ReTXParams.uc_OMSG1_DsReTxEnabled == RETX_SELECTED)
         {
            //XDSLRTFW-1098: BugFix_DS_VDSL2_ALL_SES_Not_Incrementing_In_ReTx (Start)
            // LEFTR counter
            cpyCntr(puca_msg_buffer+k, gt_ReTXStats.ul_LEFTR_Cntr, &k);

            //error free bits counter
            gt_ReTXStats.ul_ErrorFreeBits_Prev = gt_ReTXStats.ul_ErrorFreeBits; //Store to aid debugging

            // counting the number of error-free bits passed over the beta1-reference point,
            // divided by 2^16. .
            /* Error free bits => (No of DTUs * DTU size in bytes * 8)/2^16 OR (No of DTUs * DTU size in bytes)/2^13*/
            gt_ReTXStats.ul_ErrorFreeBits = (gt_ReTXStats.ul_ForwardedDtuCnt>>13)*  gt_ReTXParams.us_DS_ReTx_DtuSize;
            cpyCntr(puca_msg_buffer+k, gt_ReTXStats.ul_ErrorFreeBits, &k);

            //XDSLRTFW-1211_Enh_All_VDSL2_EFTRmin_Corr4Ginp (Start)
            // For the  observation periods  in  which   EFTR  is  either  not  defined   or always   less  than  ETR/2,   or both,
            //over the complete observation period, the value of EFTR_min shall be set to a special 32-bit value of 0xFFFFFFFF 16 .
            if ( (guc_EftrLtETRby2OverObsPeriod == TRUE) && (gus_DebugVar1 & 2) == 0)
            {
               gt_ReTXStats.ul_EFTR_min_Prev =  0xFFFFFFFF;
               gt_ReTXStats.ul_EFTR_min =  gt_ReTXStats.ul_EFTR_min_Prev;
            }
            //XDSLRTFW-1211_Enh_All_VDSL2_EFTRmin_Corr4Ginp (End)

            if (gt_ReTXStats.us_New_EFTRMin_Avail == FALSE)
            {
               /* According to Sec 11.4.3 of G.998.4, report previous value of EFTR_Min if
                  no new EFTR measurement is done since last reporting on EOC */
               ul_TempEftrMin = gt_ReTXStats.ul_EFTR_min_Prev;
            }
            else
            {
               ul_TempEftrMin = gt_ReTXStats.ul_EFTR_min;
               gt_ReTXStats.ul_EFTR_min_Prev = ul_TempEftrMin; //Store to aid debugging.
            }

            // EFTR_min
            cpyCntr(puca_msg_buffer+k, ul_TempEftrMin, &k); //ul_EFTR_min in Kbps

            //XDSLRTFW-1211_Enh_All_VDSL2_EFTRmin_Corr4Ginp (Start)
            if ((gus_DebugVar1 & 1) == 0)
            {
               gt_ReTXStats.us_New_EFTRMin_Avail = FALSE;
            }

            if ((gus_DebugVar1 & 2) == 0)
            {
               guc_EftrLtETRby2OverObsPeriod = TRUE;
            }
            //XDSLRTFW-1211_Enh_All_VDSL2_EFTRmin_Corr4Ginp (End)
            //XDSLRTFW-1098: BugFix_DS_VDSL2_ALL_SES_Not_Incrementing_In_ReTx (End)
         }
      }

      {
         //uint8 j;
         //int16 i;
         //uint32 ula_TempCounts[5];

         //for (i = 0; i< gt_rx_config.s_Nbc; i++)
         {
            //Check if this bearer channel is mapped to any latency path or not
            //j = guca_rxBCnToLPp[i];
            //if (j == 0xF)
            //   continue;

            //ula_TempCounts[0] = gula_hec_error_cnt[i];
            //ula_TempCounts[1] = gula_tot_hec_cnt[i];
            //ula_TempCounts[2] = gula_tot_cell_cnt[i];
            //ula_TempCounts[3] = gula_bit_error_cnt[i];
            //k = FormMgmtCountBytes(k, ula_TempCounts, puca_msg_buffer, 4, 1);


            // In G.993.2 section K.3.9.3.3 --
            // "The block of counter values corresponding to the PTM-TC function returned in
            // the message described in Table 11-17 shall have zero length"

            // Counters for TPS-TC-0
            if (gt_rx_TPS_Map.s_BCtoTPS[BC0] != MAP2NONE)
            {
               cpyTpsTcCntrs(BC0, puca_msg_buffer, &k);
            }

            // Counters for TPS-TC-1
            if((gt_ReTXParams.uc_OMSG1_DsReTxEnabled != RETX_SELECTED))
            {
               if (gt_rx_TPS_Map.s_BCtoTPS[BC1] != MAP2NONE)
               {
                  cpyTpsTcCntrs(BC1, puca_msg_buffer, &k);
               }
            }
         }
      }
      break;
   } // switch

   *pus_msg_length = k;

   return(uc_comm_or_resp_bit);
}


/*^^^
 *------------------------------------------------------------------------------
 *
 *  Name : Form_nsf_facility_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length, uint8 uc_message_type)
 *
 *  Description:  This subroutine forms the management counter read message to be sent
 *
 *  Prototype:
 *      uint8 Form_nsf_facility_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length, uint8 uc_message_type)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
uint8 Form_nsf_facility_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length, TxOvhdMsgInfoStruct_t *pt_TxOvhdMsgInfo)
{
   uint8 uc_comm_or_resp_bit = 2;              // Initialize with an invalid value, 0 - command, 1 - response

   switch(pt_TxOvhdMsgInfo->uc_message_type)
   {
   case NSF:
      uc_comm_or_resp_bit = 0;                // command
      *pus_msg_length = 0x8;
      break;

   case NSF_ACK:
   case NSF_NEG_ACK:
      uc_comm_or_resp_bit = 1;               // response
      *pus_msg_length = 0x2;
      break;
   }

   return(uc_comm_or_resp_bit);
}


/*^^^
 *------------------------------------------------------------------------------
 *
 *  Name : Form_test_param_read_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length)
 *
 *  Description:  This subroutine forms the management counter read message to be sent
 *
 *  Prototype:
 *      uint8 Form_test_param_read_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
uint8 Form_test_param_read_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length, TxOvhdMsgInfoStruct_t *pt_TxOvhdMsgInfo)
{
   uint8 uc_comm_or_resp_bit=2;
   int16 s_temp;
   uint8 uc_MessageType;

   uint16 k, j;

   uint16 us_value;
   uint16 us_startIx, us_endIx, us_numTones;
   uint16 i;
   //XDSLRTFW-795 Enhance_ALL_VDSL2_All_SegmentedBlockReadAck (START_END)
   TxEocControl_t *pt_TxEocControlInfo = &gta_TxEocControlInfo[OVHD_LOW_PRIORITY];

   uc_comm_or_resp_bit = 2;            // Initialize with an invalid value, 0 - command, 1 - response
   k = 2;

   uc_MessageType = pt_TxOvhdMsgInfo->uc_message_type;

   switch(uc_MessageType)
   {

   case SINGLE_READ:
      uc_comm_or_resp_bit = 0;         // command code
      break;

   case NEXT_MULT_READ:
      uc_comm_or_resp_bit = 0;         // command code
      pt_TxOvhdMsgInfo->us_param_rd_carrier_index = ++gs_param_rd_carrier_index_Tx;
      break;
      //XDSLRTFW-1777(START)
   case SCALAR_READ:
      uc_comm_or_resp_bit = 0;         // command code
      puca_msg_buffer[k++]=gt_OlrPm_RxOvhdMsgInfoInput.uc_TestParameterId;
      break;
      //XDSLRTFW-1777(END)


   case MULT_READ_ACK:
   case BLOCK_READ_ACK:
   case VECTOR_BLOCK_READ_ACK:
      uc_comm_or_resp_bit = 1;         // response code

      if (uc_MessageType == MULT_READ_ACK)
      {
         us_startIx = pt_TxOvhdMsgInfo->us_param_rd_carrier_index;
         us_endIx = pt_TxOvhdMsgInfo->us_param_rd_carrier_index;
      }
      else
      {
         // BLOCK_READ_ACK and VECTOR_BLOCK_READ_ACK
         us_startIx = pt_TxOvhdMsgInfo->us_param_rd_start_carrier_index;
         us_endIx = pt_TxOvhdMsgInfo->us_param_rd_stop_carrier_index;
      }

      us_numTones = (us_endIx - us_startIx + 1);

      //XDSLRTFW-795 Enhance_ALL_VDSL2_All_SegmentedBlockReadAck (START)
      {
         uint16 us_numBytes_hlog=0;

         //message length of HLog, QLN, and SNR
         if (gs_sts_pmd_test_rd == -1)
         {
            uint16 us_numBytes_qln, us_numBytes_snr, us_numBytes_all;

            us_numBytes_hlog = (2 + (us_numTones * 2));
            us_numBytes_qln = (2 + us_numTones);
            us_numBytes_snr = (2 + us_numTones);
            us_numBytes_all = us_numBytes_hlog + us_numBytes_qln + us_numBytes_snr;

            // XDSLRTFW-1189 : Bug_ALL_VDSL2_ALL_VECTOR_BLOCKREAD
            // Check segmentation for
            //   - Block read or
            //   - Vectored Block read in case of HLOG
            if ( ((uc_MessageType == BLOCK_READ_ACK) && (us_numBytes_all > MAX_TX_EOC_BUFFER_SIZE)) ||
                  ((uc_MessageType == VECTOR_BLOCK_READ_ACK) && (us_numBytes_hlog > MAX_TX_EOC_BUFFER_SIZE) &&
                   (pt_TxOvhdMsgInfo->uc_TestParameterId == TEST_PARAM_HLOG_ID)) )
            {
               gs_sts_pmd_test_rd = 0;
               gus_startIx = us_startIx;
               gus_endIx = us_endIx;
            }
         }

         if (gs_sts_pmd_test_rd >= 0)
         {
            if ((gfta_FirstOvhdMsgSeg[OVHD_LOW_PRIORITY] == FALSE) && (gsa_Tx_OvhdMsgSegIndx[OVHD_LOW_PRIORITY] == -1))
            {
               gfta_FirstOvhdMsgSeg[OVHD_LOW_PRIORITY] = TRUE;
               gsa_Tx_OvhdMsgSegIndx[OVHD_LOW_PRIORITY] = 1;
            }
            else
            {
               gsa_Tx_OvhdMsgSegIndx[OVHD_LOW_PRIORITY]++;
            }

            us_startIx = gus_startIx;
            us_endIx = gus_endIx;
            if (gs_sts_pmd_test_rd == 0)
            {
               if (us_numBytes_hlog > 2+256*2) //the first 256 tones for HLog are in the first segment
               {
                  gs_sts_pmd_test_rd = 1;
                  gus_last_hlog_endIx = us_endIx = 255 + us_startIx;
               }
               else
               {
                  gs_sts_pmd_test_rd = 3;
               }
            }
            else if (gs_sts_pmd_test_rd == 1)
            {
               us_startIx = gus_last_hlog_endIx + 1;
               gs_sts_pmd_test_rd = 2;
            }
            else if (gs_sts_pmd_test_rd == 2)
            {
               gs_sts_pmd_test_rd = 3;
            }
            else if (gs_sts_pmd_test_rd == 3)
            {
               gs_sts_pmd_test_rd = 4;
            }

            if (gs_sts_pmd_test_rd <= 3)
            {
               pt_TxEocControlInfo->ft_ack_expected = TRUE;
               pt_TxEocControlInfo->uc_ExpectedDesignator = SEGMENT_ACK_PRIOR2;
            }
         }
      }
      //XDSLRTFW-795 Enhance_ALL_VDSL2_All_SegmentedBlockReadAck (END)

      // When transferring values of the channel transfer function Hlog(f), the quiet line
      // noise QLN(f), and the signal to noise ratio SNR(f), the measurement time shall be
      // included in the response (the first two octets after the ACK), followed by the
      // value m (see 11.4.1.1.1), value n (see 11.4.1.1.2), and value SNR (see 11.4.1.1.3),
      // respectively. The measurement time shall be included only once in a response to a
      // Block Read command, and shall be included in each response to a Multiple Read or Next
      // Multiple Read command.

      //XDSLRTFW-795 Enhance_ALL_VDSL2_All_SegmentedBlockReadAck (START)
      if((uc_MessageType != VECTOR_BLOCK_READ_ACK) || (pt_TxOvhdMsgInfo->uc_TestParameterId == TEST_PARAM_HLOG_ID))
      {
         if ((gs_sts_pmd_test_rd == -1) || (gs_sts_pmd_test_rd == 1))
         {
            puca_msg_buffer[k++] = (uint8)(gt_ChannelMeasurement_NE.us_HlogMT >> 8);
            puca_msg_buffer[k++] = (uint8)(gt_ChannelMeasurement_NE.us_HlogMT & 0xFF);
         }

         // Hlog(f) content
         if ((gs_sts_pmd_test_rd == -1) || (gs_sts_pmd_test_rd == 1) || (gs_sts_pmd_test_rd == 2))
         {
            for (i = us_startIx; i <= us_endIx; i++)
            {
               us_value = gsa_RxHlog[i];

               puca_msg_buffer[k++] = (uint8)(us_value >> 8);
               puca_msg_buffer[k++] = (uint8)(us_value & 0xFF);
            } // for
         }
      } //if(uc_TestParameterId & TEST_PARAM_HLOG_ID)


      if((uc_MessageType != VECTOR_BLOCK_READ_ACK) || (pt_TxOvhdMsgInfo->uc_TestParameterId == TEST_PARAM_QLN_ID))
      {
         //QLN measurement period
//         if ((gs_sts_pmd_test_rd == -1)||(gs_sts_pmd_test_rd == 3))
//         {
//            puca_msg_buffer[k++] = (uint8)(gt_ChannelMeasurement_NE.us_QlnMT >>8);
//            puca_msg_buffer[k++] = (uint8)(gt_ChannelMeasurement_NE.us_QlnMT & 0xFF);
//         }

         // QLN measurement period and content
         if ((gs_sts_pmd_test_rd == -1) || (gs_sts_pmd_test_rd == 3))
         {
            // QLN measurement period
            puca_msg_buffer[k++] = (uint8)(gt_ChannelMeasurement_NE.us_QlnMT >> 8);
            puca_msg_buffer[k++] = (uint8)(gt_ChannelMeasurement_NE.us_QlnMT & 0xFF);

            // QLN content
            for (i = us_startIx; i <= us_endIx; i++)
            {
               puca_msg_buffer[k++] = guca_QLN[i];
            }
         }
      } //if(uc_TestParameterId & TEST_PARAM_QLN_ID)


      if((uc_MessageType != VECTOR_BLOCK_READ_ACK) || (pt_TxOvhdMsgInfo->uc_TestParameterId == TEST_PARAM_SNR_ID))
      {
         // SNR measurement period
//         if ((gs_sts_pmd_test_rd == -1) || (gs_sts_pmd_test_rd == 4))
//         {
//            puca_msg_buffer[k++] = (uint8)(gt_ChannelMeasurement_NE.us_SnrMT >> 8);
//            // Send the LSB next
//            puca_msg_buffer[k++] = (uint8)(gt_ChannelMeasurement_NE.us_SnrMT & 0xFF);
//         }

         // SNR
         if ((gs_sts_pmd_test_rd == -1) || (gs_sts_pmd_test_rd == 4))
         {
            // SNR measurement period
            puca_msg_buffer[k++] = (uint8)(gt_ChannelMeasurement_NE.us_SnrMT >> 8);
            puca_msg_buffer[k++] = (uint8)(gt_ChannelMeasurement_NE.us_SnrMT & 0xFF);

            for(i = us_startIx; i <= us_endIx; i++)
            {
               puca_msg_buffer[k++] = GetSnrForCarrierGroup(i);
            } // for
         }
      } //if(uc_TestParameterId & TEST_PARAM_SNR_ID)

      if (gs_sts_pmd_test_rd == 4)
      {
         gsa_Tx_OvhdMsgSegIndx[OVHD_LOW_PRIORITY] = 0;
         gus_last_hlog_endIx = 0;
         gs_sts_pmd_test_rd = -1;
         gus_startIx = 0;
         gus_endIx = 0;
      }
      //XDSLRTFW-795 Enhance_ALL_VDSL2_All_SegmentedBlockReadAck (END)

      break;

   case SINGLE_READ_ACK:
      uc_comm_or_resp_bit = 1; // reply
      //form single read parameters
      k = Form_SingleRd_Cmd_msg(puca_msg_buffer, k);
      break;

   case SCALAR_READ_ACK :
      //XDSLRTFW-1777(START)
      uc_comm_or_resp_bit = 1; // reply

      switch(pt_TxOvhdMsgInfo->uc_TestParameterId) //select cases based on ID requested
      {

         //The Scalar Read command shall be used to retrieve all test parameters with ID values from 0x21 to 0x28inclusive.
         //In response to a Scalar Read command, the values for the test parameters (one value per parameter)  shall  be
         //transferred  in  as per the request of  the parameter  ID  shown  in Table  11-27.
      case LINE_ATTENUATION: //0x01
         //puca_msg_buffer[k++] = LINE_ATTENUATION;

         for(j=0; j < 5; j++)
         {
            // if the current band is not used, then transmit 0 instead of out-of-range value
            s_temp = gt_AttenSnrMPerRxBand.t_AttenSnrM[j].s_LATN;
            if (s_temp == OUT_OF_RANGE_LATN)
            {
               s_temp = 0;
            }

            // Send the MSB first
            puca_msg_buffer[k++] = (uint8)(s_temp >> 8);

            // Send the LSB next
            puca_msg_buffer[k++] = (uint8)(s_temp & 0xFF);
         }

         break;

      case SIGNAL_ATTENUATION:
         //puca_msg_buffer[k++] = SIGNAL_ATTENUATION;

         for(j=0; j < 5; j++)
         {
            // if the current band is not used, then transmit 0 instead of out-of-range value
            s_temp = gt_AttenSnrMPerRxBand.t_AttenSnrM[j].s_SATN;
            if (s_temp == OUT_OF_RANGE_SATN)
            {
               s_temp = 0;
            }

            // Send the MSB first
            puca_msg_buffer[k++] = (uint8)(s_temp >> 8);

            // Send the LSB next
            puca_msg_buffer[k++] = (uint8)(s_temp & 0xFF);
         }

         break;

      case SIGNAL_TO_NOISE_MARGIN:

         puca_msg_buffer[k++] = gt_LineStatusDS.s_SnrMargin>>8; // overall SNRM
         puca_msg_buffer[k++] = (uint8)gt_LineStatusDS.s_SnrMargin;

         for(j=0; j < 5; j++)
         {
            // if the current band is not used, then transmit 0 instead of out-of-range value
            s_temp = gt_AttenSnrMPerRxBand.t_AttenSnrM[j].s_SNRM;
            if (s_temp == OUT_OF_RANGE_SNRM)
            {
               s_temp = 0;
            }

            // Send the MSB first
            puca_msg_buffer[k++] = (uint8)(s_temp >> 8);

            // Send the LSB next
            puca_msg_buffer[k++] = (uint8)(s_temp & 0xFF);
         }

         break;

      case ATTAIN_NET_DATA_RATE:

         puca_msg_buffer[k++] = ((gt_LineStatusDS.ul_AttainableDataRate>>24) & 0xFF);
         puca_msg_buffer[k++] = ((gt_LineStatusDS.ul_AttainableDataRate>>16) & 0xFF);
         puca_msg_buffer[k++] = ((gt_LineStatusDS.ul_AttainableDataRate>>8) & 0xFF);
         puca_msg_buffer[k++] = (gt_LineStatusDS.ul_AttainableDataRate & 0xFF);
//XDSLRTFW-1286 Feature_US_VDSL2_ALL_UsReTxAmend2_ATTNDR_ohd(Start)
// As per G.9984 Amd 2, if attndr_method is !=0, the INP used for calculation of ATTNDR
// & delay is to sent along with ATTNDR value.
//The value of INP sent = 10 * actual INP
//The value of delay sent = 10 * actual delay
         if((guc_attndr_method != ATTNDR_METHOD_0) && (guc_attndr_method_from_co != ATTNDR_METHOD_0))
         {
            //XDSLRTFW-1522 (Start)
            if (gt_ReTXParams.uc_OMSG1_DsReTxEnabled == RETX_SELECTED)
            {
               puca_msg_buffer[k++] = (((gt_Improved_ATTNDR_ActParam.us_ATTNDR_ACT_INPds)>>8) & 0xFF); //Shine Inp in 0.1 DMT symbols granularity
               puca_msg_buffer[k++] = ((gt_Improved_ATTNDR_ActParam.us_ATTNDR_ACT_INPds)& 0xFF);
               puca_msg_buffer[k++] = ((gt_Improved_ATTNDR_ActParam.us_ATTNDR_ACT_INP_REINds & 0xFF)); //Rein Inp in 0.1 DMT symbols granularity
               puca_msg_buffer[k++] = ((gt_Improved_ATTNDR_ActParam.us_ATTNDR_ACT_DELAYds/10) & 0xFF); //in 0.1 ms granularity
            }
            else
            {
               // XDSLRTFW-1877 : VDSL2 IFEC ATTNDR (Start)
               puca_msg_buffer[k++] = 0x00;
               puca_msg_buffer[k++] = gt_Improved_ATTNDR_ActParam.us_ATTNDR_ACT_INPds; //Act Inp in 0.1DMT symbols granularity
               puca_msg_buffer[k++] = 0x00;
               puca_msg_buffer[k++] = (gt_Improved_ATTNDR_ActParam.us_ATTNDR_ACT_DELAYds)/10; // in 0.1 ms granularity
               // XDSLRTFW-1877 : VDSL2 IFEC ATTNDR (End)
            }
            //XDSLRTFW-1522 (End)
         }
//XDSLRTFW-1286 Feature_US_VDSL2_ALL_UsReTxAmend2_ATTNDR_ohd(End)

         break;

// XDSLRTFW-3071 US & DS ATP reporting is swapped (Start)
               case NE_ACTUAL_TRANSMIT_POWER: //(0x25)

                  // gt_LineStatusUS structure contains US information.
                  // gt_LineStatusUS.s_ActualAggregateXmtPwr contains US ACT ATP (CPE NE ActATP)

                        puca_msg_buffer[k++] = gt_LineStatusUS.s_ActualAggregateXmtPwr>>8;
                        puca_msg_buffer[k++] = (uint8)gt_LineStatusUS.s_ActualAggregateXmtPwr;

                  break;

               case FE_ACTUAL_TRANSMIT_POWER:    //0x26
                  // gt_LineStatusDS structure contains DS information.
                  // gt_LineStatusDS.s_ActualAggregateXmtPwr contains DS ACT ATP (CPE FE ActATP)

                        puca_msg_buffer[k++] = gt_LineStatusDS.s_ActualAggregateXmtPwr>>8;
                        puca_msg_buffer[k++] = (uint8)gt_LineStatusDS.s_ActualAggregateXmtPwr;
                  break;
// XDSLRTFW-3071 US & DS ATP reporting is swapped (End)
//XDSLRTFW-1055 Feature_US_VDSL2_ALL_UsReTx_TxOvhdTestMgmtDiag (Start)

      case FE_ACTUAL_INP_IFEC:  //INP_act_IFEC mode

         //Report INP in 0.1 dmt symbols granularity to the far-end
         if(!gft_DsErasureDecodingFlag)
         {
            puca_msg_buffer[k++] = (uint8) ((t_DSRateInfo.s_ActInpNoErasure[LP0])& 0xFF);//for bearer channel 0, LP0 ==> BP0 always in IFEC mode
         }
         else
         {
            puca_msg_buffer[k++] = (uint8) ((t_DSRateInfo.s_ActInpErasure[LP0])& 0xFF);//for bearer channel 0, LP0 ==> BP0 always in IFEC mode
         }

         puca_msg_buffer[k++] = (uint8) (0xFF);//bearer channel 1 disabled

         break;


      case FE_ACTUAL_SNRM_ROC:  //INP_act_SHINE 1 octets

         //ROC Not implemented
         //Report INP in 0.1 dmt symbols granularity to the far-end
         //puca_msg_buffer[k++] = (uint8) gt_ReTXStats.us_US_InpActRein;
         break;

      } /* end of switch(uc_TestParameterId) */
      //XDSLRTFW-1777(END)
      if (k == 2)
      {
         // protect sending msg which doesn't have valid test parameter ID
         uc_comm_or_resp_bit = 2;
      }

      break;

   case PMD_TEST_PAR_READ_NACK:
      uc_comm_or_resp_bit = 1;// response code

      break;

   default:
      if (pt_TxOvhdMsgInfo->uc_message_type == guc_MULT_READ)
      {
         uc_comm_or_resp_bit = 0;// command code

         puca_msg_buffer[k++] = (uint8)((pt_TxOvhdMsgInfo->us_param_rd_carrier_index >>8) & 0xFF);
         puca_msg_buffer[k++] = (uint8)(pt_TxOvhdMsgInfo->us_param_rd_carrier_index & 0xFF);

         gs_param_rd_carrier_index_Tx = pt_TxOvhdMsgInfo->us_param_rd_carrier_index;
      }
      else if (pt_TxOvhdMsgInfo->uc_message_type == guc_BLOCK_READ)
      {
         uc_comm_or_resp_bit = 0;// command code

         puca_msg_buffer[k++] = (uint8)((pt_TxOvhdMsgInfo->us_param_rd_start_carrier_index >>8) & 0xFF);
         puca_msg_buffer[k++] = (uint8)(pt_TxOvhdMsgInfo->us_param_rd_start_carrier_index & 0xFF);
         puca_msg_buffer[k++] = (uint8)((pt_TxOvhdMsgInfo->us_param_rd_stop_carrier_index >>8) & 0xFF);
         puca_msg_buffer[k++] = (uint8)(pt_TxOvhdMsgInfo->us_param_rd_stop_carrier_index & 0xFF);
      }
      //XDSLRTFW-2184: Vector Block read
      else if (pt_TxOvhdMsgInfo->uc_message_type == VECTOR_BLOCK_READ)
      {
         uc_comm_or_resp_bit = 0;// command code

         puca_msg_buffer[k++] = (uint8)((pt_TxOvhdMsgInfo->uc_TestParameterId) & 0xFF);
         puca_msg_buffer[k++] = (uint8)((pt_TxOvhdMsgInfo->us_param_rd_start_carrier_index >>8) & 0xFF);
         puca_msg_buffer[k++] = (uint8)(pt_TxOvhdMsgInfo->us_param_rd_start_carrier_index & 0xFF);
         puca_msg_buffer[k++] = (uint8)((pt_TxOvhdMsgInfo->us_param_rd_stop_carrier_index >>8) & 0xFF);
         puca_msg_buffer[k++] = (uint8)(pt_TxOvhdMsgInfo->us_param_rd_stop_carrier_index & 0xFF);
      }
      break;

   } // switch


   *pus_msg_length = k;

   return(uc_comm_or_resp_bit);
}
/*^^^
 *------------------------------------------------------------------------------
 *
 *  Name : Form_SingleRd_Cmd_msg(uint8* puca_msg_buffer, uint16 k)
 *
 *  Description:  This subroutine forms the single read parameters
 *
 *  Prototype:
 *  uint16 Form_SingleRd_Cmd_msg(uint8* puca_msg_buffer, uint16 k)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
uint16 Form_SingleRd_Cmd_msg(uint8* puca_msg_buffer, uint16 k)
{

   int16 s_temp;
   uint16 j;

   uint32 ul_Temp;

   //The Single Read command shall be used to retrieve all test parameters with ID values from 0x21 to 0x26inclusive.
   //In response to a Single Read command, the values for the test parameters (one value per parameter)  shall  be
   //transferred  in  numerically  increasing  order  of  the parameter  ID  shown  in Table  11-27.

   //LINE_ATTENUATION: //0x01
   for(j=0; j < 5; j++)
   {
      // if the current band is not used, then transmit 0 instead of out-of-range value
      s_temp = gt_AttenSnrMPerRxBand.t_AttenSnrM[j].s_LATN;
      if (s_temp == OUT_OF_RANGE_LATN)
      {
         s_temp = 0;
      }

      // Send the MSB first
      puca_msg_buffer[k++] = (uint8)(s_temp >> 8);

      // Send the LSB next
      puca_msg_buffer[k++] = (uint8)(s_temp & 0xFF);
   }


   //SIGNAL_ATTENUATION:
   for(j=0; j < 5; j++)
   {
      // if the current band is not used, then transmit 0 instead of out-of-range value
      s_temp = gt_AttenSnrMPerRxBand.t_AttenSnrM[j].s_SATN;
      if (s_temp == OUT_OF_RANGE_SATN)
      {
         s_temp = 0;
      }

      // Send the MSB first
      puca_msg_buffer[k++] = (uint8)(s_temp >> 8);

      // Send the LSB next
      puca_msg_buffer[k++] = (uint8)(s_temp & 0xFF);
   }


   //SIGNAL_TO_NOISE_MARGIN:
   puca_msg_buffer[k++] = gt_LineStatusDS.s_SnrMargin>>8; // overall SNRM
   puca_msg_buffer[k++] = (uint8)gt_LineStatusDS.s_SnrMargin;

   for(j=0; j < 5; j++)
   {
      // if the current band is not used, then transmit 0 instead of out-of-range value
      s_temp = gt_AttenSnrMPerRxBand.t_AttenSnrM[j].s_SNRM;
      if (s_temp == OUT_OF_RANGE_SNRM)
      {
         s_temp = 0;
      }

      // Send the MSB first
      puca_msg_buffer[k++] = (uint8)(s_temp >> 8);

      // Send the LSB next
      puca_msg_buffer[k++] = (uint8)(s_temp & 0xFF);
   }

   //ATTAIN_NET_DATA_RATE:
   puca_msg_buffer[k++] = ((gt_LineStatusDS.ul_AttainableDataRate>>24) & 0xFF);
   puca_msg_buffer[k++] = ((gt_LineStatusDS.ul_AttainableDataRate>>16) & 0xFF);
   puca_msg_buffer[k++] = ((gt_LineStatusDS.ul_AttainableDataRate>>8) & 0xFF);
   puca_msg_buffer[k++] = (gt_LineStatusDS.ul_AttainableDataRate & 0xFF);
   //XDSLRTFW-1286 Feature_US_VDSL2_ALL_UsReTxAmend2_ATTNDR_ohd(Start)
   // As per G.9984 Amd 2, if attndr_method is !=0, the INP used for calculation of ATTNDR
   // & delay is to sent along with ATTNDR value.
   //The value of INP sent = 10 * actual INP
   //The value of delay sent = 10 * actual delay
   if((guc_attndr_method != ATTNDR_METHOD_0) && (guc_attndr_method_from_co != ATTNDR_METHOD_0))
   {
      //XDSLRTFW-1522 (Start)
      if (gt_ReTXParams.uc_OMSG1_DsReTxEnabled == RETX_SELECTED)
      {
         puca_msg_buffer[k++] = (((gt_Improved_ATTNDR_ActParam.us_ATTNDR_ACT_INPds)>>8) & 0xFF); //Act Shine Inp in 0.1DMT symbols granularity
         puca_msg_buffer[k++] = ((gt_Improved_ATTNDR_ActParam.us_ATTNDR_ACT_INPds)& 0xFF);
         puca_msg_buffer[k++] = ((gt_Improved_ATTNDR_ActParam.us_ATTNDR_ACT_INP_REINds & 0xFF)); //Act Rein Inp in 0.1DMT symbols granularity
         puca_msg_buffer[k++] = ((gt_Improved_ATTNDR_ActParam.us_ATTNDR_ACT_DELAYds/10) & 0xFF); //Act Delay in 0.1 ms granularity
      }
      else
      {
         // XDSLRTFW-1877 : VDSL2 IFEC ATTNDR (Start)
         puca_msg_buffer[k++] = 0x00;
         puca_msg_buffer[k++] = gt_Improved_ATTNDR_ActParam.us_ATTNDR_ACT_INPds; //Act Inp in 0.1DMT symbols granularity
         puca_msg_buffer[k++] = 0x00;
         puca_msg_buffer[k++] = (gt_Improved_ATTNDR_ActParam.us_ATTNDR_ACT_DELAYds)/10; //Act Delay in 0.1 ms granularity
         // XDSLRTFW-1877 : VDSL2 IFEC ATTNDR (End)
      }
      //XDSLRTFW-1522 (Start)
   }
   //XDSLRTFW-1286 Feature_US_VDSL2_ALL_UsReTxAmend2_ATTNDR_ohd(End)

// XDSLRTFW-3071 US & DS ATP reporting is swapped (Start)
   //NE_ACTUAL_TRANSMIT_POWER:(0x25)

   // gt_LineStatusUS structure contains US information.
   // gt_LineStatusUS.s_ActualAggregateXmtPwr contains US ACT ATP (CPE NE ActATP)
   puca_msg_buffer[k++] = gt_LineStatusUS.s_ActualAggregateXmtPwr>>8;
   puca_msg_buffer[k++] = (uint8)gt_LineStatusUS.s_ActualAggregateXmtPwr;


   //FE_ACTUAL_TRANSMIT_POWER: 0x26
   // gt_LineStatusDS structure contains DS information.
   // gt_LineStatusDS.s_ActualAggregateXmtPwr contains DS ACT ATP (CPE FE ActATP)
   puca_msg_buffer[k++] = gt_LineStatusDS.s_ActualAggregateXmtPwr>>8;
   puca_msg_buffer[k++] = (uint8)gt_LineStatusDS.s_ActualAggregateXmtPwr;
// XDSLRTFW-3071 US & DS ATP reporting is swapped (end)
   //XDSLRTFW-1055 Feature_US_VDSL2_ALL_UsReTx_TxOvhdTestMgmtDiag (Start)
   //US_INP_act_SHINE:  //INP_act_SHINE 2 octets
   //The  parameter  with  ID=41 contains  the  actual  INP  against  SHINE  The test parameter INP_act_SHINE shall
   //be represented as a 16-bit unsigned integer expressing the value in fractions of DMT symbols with a
   //granularity of 0.1 symbols.  The valid range is from 0 to 204.6. The special value 204.7 indicates a value of 204.7 or higher.
   //This parameter shall be included  in  the  response  of  a  VTU  to  a  Single  Read  command
   //if  retransmission is enabled in its transmit direction
   if (gt_ReTXParams.uc_UsReTxStatus == US_RETX_IN_USE)
   {
      //Report INP in 0.1 dmt symbols granularity to the far-end
      puca_msg_buffer[k++] = (uint8) ((gt_ReTXStats.us_US_InpActShine >> 8)& 0xFF);
      puca_msg_buffer[k++] = (uint8) (gt_ReTXStats.us_US_InpActShine & 0xFF);

   }

   //US_INP_act_REIN:  //INP_act_SHINE 1 octets
   //The  parameter  with  ID=42 contains  the  actual  INP  against  REIN  as  derived  by  the  far-end transmitter
   //The test parameter INP_act_REIN shall be represented as a 8 bit unsigned integer expressing the
   //value is coded in fractions of DMT symbols with a granularity of 0.1 symbols
   //The range is from 0 to 25.4. The special value 25.5 indicates a value of 25.5 or higher.
   if (gt_ReTXParams.uc_UsReTxStatus == US_RETX_IN_USE)
   {
      //Report INP in 0.1 dmt symbols granularity to the far-end
      puca_msg_buffer[k++] = (uint8) gt_ReTXStats.us_US_InpActRein;
   }

   //XDSLRTFW-1055 Feature_US_VDSL2_ALL_UsReTx_TxOvhdTestMgmtDiag (End)
   //RETX_RECEIVER_ETR:
   if (gt_ReTXParams.uc_OMSG1_DsReTxEnabled == RETX_SELECTED)
   {
      ul_Temp = gt_ReTXStats.ul_ReTX_ReceiverETR; //in kbps

      puca_msg_buffer[k++] = (uint8)(ul_Temp >> 24);
      puca_msg_buffer[k++] = (uint8)(ul_Temp >> 16);
      puca_msg_buffer[k++] = (uint8)(ul_Temp >> 8);
      puca_msg_buffer[k++] = (uint8)ul_Temp;
   }

   //RETX_RECEIVER_ACTUAL_DELAY:
   if (gt_ReTXParams.uc_OMSG1_DsReTxEnabled == RETX_SELECTED)
   {
      //XDSLRTFW-744 Enh_All_VDSL2_All_IntlvDelayIn1By100ms (Start_End)
      //Report Delay in milli seconds granularity to the far-end
      puca_msg_buffer[k++] = (uint8)(gt_ReTXStats.us_ReTX_ReceiverActualDelay/100);

   }


   return(k);
}


/*^^^
 *------------------------------------------------------------------------------
 *
 *  Name : Form_Clear_EOC_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length)
 *
 *  Description:  This subroutine forms the management counter read message to be sent
 *
 *  Prototype:
 *      uint8 Form_Clear_EOC_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
uint8 Form_Clear_EOC_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length,
                         TxOvhdMsgInfoStruct_t *pt_TxOvhdMsgInfo)
{

   uint8 uc_comm_or_resp_bit = 2;
#ifdef CLEAR_EOC
   int16 i;
   int16 k = 2;

   switch(pt_TxOvhdMsgInfo->uc_message_type)
   {
   case CLEAR_EOC_MSG:
      uc_comm_or_resp_bit = 0;// command code

      for (i = 0; i < gt_INFO_CEocTxBuf.us_NumBytes; i++)
      {
         puca_msg_buffer[k++] = gt_INFO_CEocTxBuf.uca_MEMsg[i];
      }

      break;

   case CLEAR_EOC_ACK:
      uc_comm_or_resp_bit = 1;// response code
      break;

   case CLEAR_EOC_NACK:
      uc_comm_or_resp_bit = 1;// response code
      puca_msg_buffer[k++] = CLEAR_EOC_NOT_SUPPORT;

      break;

   }
   *pus_msg_length = k;
#endif
   return(uc_comm_or_resp_bit);
}

//#ifdef MTK_VECTORING_SUPPORT
/*^^^
 *------------------------------------------------------------------------------
 *
 *  Name : Form_G9935_ErrorFB_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length)
 *
 *  Description:  This subroutine forms the management counter read message to be sent
 *
 *  Prototype:
 *      uint8 Form_G9935_ErrorFB_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
uint8 Form_G9935_ErrorFB_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length,
                             TxOvhdMsgInfoStruct_t *pt_TxOvhdMsgInfo)
{
   uint8 uc_comm_or_resp_bit = 1; // response code
   int16 s_N_ERB = 0;
   int16 k = 2;  // points to third octet. octet 1 and 2 are already populated

   switch(pt_TxOvhdMsgInfo->uc_message_type)
   {
   case EOC_G9935_NACK:
      puca_msg_buffer[k++] = pt_TxOvhdMsgInfo->uc_defer_reason_code; // Reason Code Table 8-8 G.993.5

//         if (gs_PauseControl == 0x31)
//         {
//            Pause(gs_PauseControl);
//         }
      break;

   case EOC_G9935_ACK:

      // XDSLRTFW-3656: EOC backchannel code has been removed
      puca_msg_buffer[k++]  = 0x0;  //Octet 3 Table 8-7/G993.5
      puca_msg_buffer[k++]  = 0x0;    //Octet 4 Table 8-7/G993.5
      puca_msg_buffer[k++]  = 0xC0; //Octet 4 Table 8-7/G993.5   Segment code ( clause 11.2.3.3./G993.2)
      puca_msg_buffer[k++]  = 0x0;  //Octet 6 Table 8-7/G993.5
      break;

   default:
      uc_comm_or_resp_bit = 2;// response code
   }

   *pus_msg_length = k;

   return(uc_comm_or_resp_bit);
}


/*^^^
 *------------------------------------------------------------------------------
 *
 *  Name : Form_G9935_PilotUpdateResp_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length)
 *
 *  Description:  This subroutine forms the G.993.5 Pilot Seq Update read response to be sent
 *
 *  Prototype:
 *      uint8 Form_G9935_PilotUpdateResp_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
uint8 Form_G9935_PilotUpdateResp_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length,
                                     TxOvhdMsgInfoStruct_t *pt_TxOvhdMsgInfo)
{
   uint8 uc_comm_or_resp_bit = 2;
   int16 k = 2;  // points to third octet. octet 1 and two are already populated

   switch(pt_TxOvhdMsgInfo->uc_message_type)
   {
   case EOC_G9935_NACK:
      uc_comm_or_resp_bit = 1;// response code
      puca_msg_buffer[k++] = pt_TxOvhdMsgInfo->uc_defer_reason_code; // Reason Code Table 8-8 G.993.5

      break;

   case EOC_G9935_ACK:
      uc_comm_or_resp_bit = 1;// response code
      break;

   }
   *pus_msg_length = k;

   return(uc_comm_or_resp_bit);
}

//#endif //MTK_VECTORING_SUPPORT


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : OvhdMsg_Timeout_Handler(uint8 uc_priority_index )
 *
 *  Description:  This subroutine handles the EOC ovhd request timeout
 *
 *  Prototype:
 *      void  OvhdMsg_Timeout_Handler(uint8 uc_priority_index )
 *
 *  Input Arguments:
 *       uc_priority_index: the ovhd msg priority index
 *
 *  Output Arguments:
 *
 *  Return:
 *      None
 *
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void OvhdMsg_Timeout_Handler(int32 l_PriorityIndex)
{
   TxEocControl_t *ptxEocControlInfo;
   uint16 us_numframes1000ms;
   int32 l_EocSymCntDelta;

   ptxEocControlInfo = &gta_TxEocControlInfo[l_PriorityIndex];

   // gl_RxSymbolCount and ptxEocControlInfo->lRxSymCnt are positive
   // but the difference could be negative if gl_RxSymbolCount wraps
   l_EocSymCntDelta = gl_RxSymbolCount - ptxEocControlInfo->lRxSymCnt;
   if (l_EocSymCntDelta < 0) // account for wrap around
   {
      l_EocSymCntDelta += MAX_32;
   }

   // For priority 0 message, timeout after 400ms
   // For priority 1 message, timeout after 800ms
   // For priority 2 message, timeout after 1000ms
   switch(l_PriorityIndex)
   {
   case OVHD_HIGH_PRIORITY:
      //(Mei: The standard specifies 400ms timeout period, but there is problem with this timeout
      //when the micro interrupts are enabled with 500 ms interrupt, so we increase it to 800ms)
      if (l_EocSymCntDelta < (gus_EocFramesPer100ms << 3)) // 800ms
      {
         return;   // no timeout
      }

      // Else timeout and recover from the last pending message
      Abandon_DS_OLRPM();
      uint8 uc_ExpectedMsgType = gta_TxEocControlInfo[0].uc_ExpectedMsgType;
      // XDSLRTFW-1032_New_framing_for_SRA_in_DS-ReTx_mode (START)
      if (gta_TxEocControlInfo[0].uc_ExpectedMsgType == SRA_RETX_REQ)
      {
         // Update the SRA timeout count as per the location in gt_UsOLRPMCnt
         uc_ExpectedMsgType = SRA_REQ;
      }
      // XDSLRTFW-1032_New_framing_for_SRA_in_DS-ReTx_mode (END)
      //Increase the timeout counter
      Update_OLRPMCnt(&gt_DsOLRPMCnt, uc_ExpectedMsgType, TIMEOUT_CNT);

      break;

   case OVHD_NORMAL_PRIORITY:
      if (l_EocSymCntDelta < (gus_EocFramesPer100ms << 3)) // 800ms
      {
         return;   // no timeout
      }
      // XDSLRTFW-650 / XDSLRTFW-1384 (Start)
      if (gta_TxEocControlInfo[OVHD_NORMAL_PRIORITY].uc_ExpectedMsgType == STATE_TRANS_REQ)
      {
         // Assume L3 request grant
         guc_PM_L3_Response = PM_L3_RESPONSE_TIMEOUT; //honored only if(guc_PM_L3_InternalState == WAITING_FOR_L3_RESPONSE)
         PM_L3_State_Machine();
      }
      // XDSLRTFW-650 / XDSLRTFW-1384 (End)
      break;

   case OVHD_LOW_PRIORITY:
      MULU16(us_numframes1000ms,gus_EocFramesPer100ms,10);
      if (l_EocSymCntDelta < us_numframes1000ms) // 1000ms
      {
         return;   // no timeout
      }

      break;
   } // switch


   // Reset message-expected control
   ptxEocControlInfo->ft_ack_expected = FALSE;

   // clear any flags that indicate a msg is pending
   CheckMsgPendingFlags(ptxEocControlInfo->uc_ExpectedDesignator,
                        ptxEocControlInfo->uc_ExpectedMsgType,
                        ptxEocControlInfo->ft_MECmd, 1);

   EocTrail(EOC_TRAIL_TIMEOUTDELIM, ptxEocControlInfo->uc_ExpectedDesignator, ptxEocControlInfo->uc_ExpectedMsgType,0);

   gusa_EocNumTimeouts[l_PriorityIndex]++;
}

