/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;   File Name: eoc_init.c
;
;   This file contains the EOC initialization functions
;
;***************************************************************************/
#include <string.h>
#include "common.h"
#include "eoc.h"
#include "cmv.h"
#include "gdata.h"


/*****************************************************************************
*   Subroutine Name: TxEocInit
*
*   Description:
*      This subroutine initializes variables used by the Tx EOC functions.
*
*   Prototype:
*       void TxEocInit(void);
*
*   Input Arguments: none
*
*   Output Arguments: none
*
*   Return: none
*
*
*
*******************************************************************************/

extern int16 gs_EocGroupSizeSNR ;
extern int16 gs_EocGroupSizeHLOG ;
void TxEocInit(void)
{
   int16 i;
   int32 l_Index;
   int16 s_FeParamsPollingTime = 0;

   // Initialize the Tx EOC structure
   gt_TxEocMsg.message_priority = 3;    //  Invalid EOC message priority
   gt_TxEocMsg.cntrl_field = 1;       //  EOC message control field
   gt_TxEocMsg.gus_FCS = 0;          //  EOC message FCS

   gt_TxEocMsgFifo.MessageBuffer = &guca_EocMsgBuffers[0];   // Sized MAX_TX_EOC_MSG_SIZE
   gt_TxEocMsgFifo.BufferSize = MAX_TX_EOC_MSG_SIZE;
   gt_TxEocMsgFifo.IndexOfOldest = 0;
   gt_TxEocMsgFifo.NextAvailable = 0;
   gt_TxEocMsgFifo.ErrorCode = 0;
   gt_TxEocMsgFifo.us_OvflowCnt = 0;

   // Initialize Tx ovhd msg buffer
   memset(gt_TxEocMsgFifo.MessageBuffer, 0, MAX_TX_EOC_MSG_SIZE);


   memset(gta_TxEocControlInfo, 0, sizeof(gta_TxEocControlInfo));

   for (l_Index = 0; l_Index < MAX_OVHD_PRIORITY; l_Index++)
   {
      if (l_Index == 0)
      {
         // ME cannot request priority messages.
         gta_TxEocControlInfo[l_Index].uca_MaxMsgTypeCount[AUTO_CMD_SOURCE] = MAX_EOC_AUTO_CMD + MAX_EOC_ME_CMD;
         //gta_TxEocControlInfo[l_Index].uca_MaxMsgTypeCount[ME_CMD_SOURCE] = 0;
      }
      else
      {
         gta_TxEocControlInfo[l_Index].uca_MaxMsgTypeCount[AUTO_CMD_SOURCE] = MAX_EOC_AUTO_CMD;
         gta_TxEocControlInfo[l_Index].uca_MaxMsgTypeCount[ME_CMD_SOURCE] = MAX_EOC_ME_CMD;
      }

      gta_TxEocControlInfo[l_Index].uca_MaxMsgTypeCount[RESPONSE_SOURCE] = MAX_EOC_RESPONSE;

      // reset the ovhd segment info
      gsa_Tx_OvhdMsgSegIndx[l_Index] = -1;
      gsa_Rx_OvhdMsgSegIndx[l_Index] = -1;
      gfta_FirstOvhdMsgSeg[l_Index] = FALSE;

   }

   // Initialize the Self test register
   for(i = 0; i< SELF_TEST_REG_LENGTH; i++)
   {
      gt_TxOvhdRegister.uc_self_test_reg[i] = 0;
   }
   //XDSLRTFW-2184
   for(i=0; i < 4; i++)
   {
      if((gs_CarrierGroupSizeTx_Disc>>i) & 0x1)
      {
         gs_EocGroupSizeHLOG = i;
         break;
      }
   }

   for(i=0; i < 4; i++)
   {
      if((gs_CarrierGroupSizeTx_Medley>>i) & 0x1)
      {
         gs_EocGroupSizeSNR = i;
         break;
      }
   }
   //XDSLRTFW-2184
   s_FeParamsPollingTime = (OPTNArray[OPTN_FeParamControl] >> 8) & 0xF;
   gus_EocTimerInterval *= s_FeParamsPollingTime;
   gus_FeParamTimerInterval *= s_FeParamsPollingTime;

}

