/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;   File Name: ApplyBandLimit.c
;
'
*****************************************************************************/

#include "common.h"
#include "gdata.h"
#include "mul.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *
 *  Description:  Apply the minimum and maximum frequency limit to the TX band plan.
 *
 *  Prototype:
 *           void ApplyBandLimit(void);
 *
 *
 *  Input Arguments:
 *      s_MinTone -- the minimum frequency tone index
 *      s_MaxTone -- the maximum frequency tone index
 *
 *  Output Arguments:
 *      None
 *
 *  Global Variables Used:
 *      gs_NumOfTxBands -- (I/O) the number of TX bands
 *      gsa_TxBandLeftChannel[] -- (I/O) the array of TX band left edges
 *      gsa_TxBandRightChannel[] -- (I/O) the array of TX band right edges
 *
 *  Return:
 *      TRUE or FALSE
 *
 *------------------------------------------------------------------------
 *^^^
 */

int16 ApplyBandLimit(uint16 s_MinTone, uint16 s_MaxTone)
{
   int16 s_FirstBand, s_LastBand, s_NumBands, j, i;

   if (gul_dbgSocMsgControl2 & DISABLE_APPLY_BAND_LIMIT)
   {
      return(TRUE);
   }

   //Find out the lowest band such that s_MinTone is less or equal to its right edge
   s_FirstBand = gs_NumOfTxBands;
   for (j = 0; j < gs_NumOfTxBands; j++ )
   {
      if(s_MinTone <= gsa_TxBandRightChannel[j])
      {
         s_FirstBand = j;
         break;
      }
   }

   //If no band mets the above condition, return FALSE
   if(s_FirstBand == gs_NumOfTxBands)
   {
      return(FALSE);
   }

   //Find out the highest band such that s_MaxTone is greater or equal to its left edge
   s_LastBand = gs_NumOfTxBands;
   for (j = gs_NumOfTxBands-1; j >= 0; j-- )
   {
      if(s_MaxTone >= gsa_TxBandLeftChannel[j])
      {
         s_LastBand = j;
         break;
      }
   }

   //If no band mets the above condition, return FALSE
   if(s_LastBand == gs_NumOfTxBands)
   {
      return(FALSE);
   }

   //Limit the lowest frequency
   if(s_MinTone > gsa_TxBandLeftChannel[s_FirstBand])
   {
      gsa_TxBandLeftChannel[s_FirstBand] = s_MinTone;
   }

   //Limit the highest frequency
   if(s_MaxTone < gsa_TxBandRightChannel[s_LastBand])
   {
      gsa_TxBandRightChannel[s_LastBand] = s_MaxTone;
   }

   //Shift the bands down if the lowest band is not band 0
   if(s_FirstBand > 0)
   {
      for(i = 0, j=s_FirstBand; j<=s_LastBand; j++, i++)
      {
         gsa_TxBandLeftChannel[i] = gsa_TxBandLeftChannel[j];
         gsa_TxBandRightChannel[i] = gsa_TxBandRightChannel[j];
      }
   }

   //Compute the final number of bands
   s_NumBands = s_LastBand - s_FirstBand + 1;

   //Set unused bands to 0
   for(i=s_NumBands; i<gs_NumOfTxBands; i++)
   {
      gsa_TxBandLeftChannel[i] = 0;
      gsa_TxBandRightChannel[i] = 0;
   }

   gs_NumOfTxBands = s_NumBands;

   return(TRUE);

}



