/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1432 USA
 * TELEPHONE:        (781) 276-4000
 * FAX:              (781) 276-4001
 * WEB:              http://www.aware.com
 *
 * FILE:             DemodSocMsgForDiagMode.c
 * DESCRIPTION:      Encodes and decodes SOC Messages in diagnostic mode.
 *
 **********************************************************************/
#include "common.h"
#include "gdata.h"
#include "ghs.h"
#include "ModulateSocMessages.h"


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : DemodSocMsgForDiagMode
 *
 *  Description:  In the loop diagnostic mode, all SOC messages shall be sent using
 *  1 information bit per DMT symbol, where each bit is sent 5 times in 5 consecutive symbols.
 *  For the information bit value of 1, the value 11 shall be mapped to all the allowed tones
 *  using 4-QAM. For the information bit value of 0, the value 00 shall be mapped to all
 *  the allowed tones using 4-QAM.
 *
 *  This function demodulates the middle three symbols in each five symbol group to decide
 *  the receiving bit and then a byte.
 *
 *  Prototype:
 *      void DemodSocMsgForDiagMode(void)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *  Return:
 *
 *  Global Variables Used:
 *      gs_NumOfTonesInBand -- (I) the number of tones to use for demodulation of a symbol
 *      gpsa_RxToneBuf -- (I) pointer to the input RX tone buffer
 *      gs_SymCntPerBit -- (I/O) symbol count on per bit basis (0, 1, .. 4, 0, 1, .., 4)
 *      gs_RxNumSocBitPerByte -- (I/O) count the number of received bit in the current byte
 *      guc_RxSocByte -- (I/O) byte to hold the current receiving bits
 *      gs_SegueSymCntPerBit -- (I/O) count the number of segue symbols for each three middle symbols
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

void DemodSocMsgForDiagMode(void)
{
   uint8 uc_octet, uc_bit;
   int16 i, j;

   //Decode the current symbol
   DecodeSOCMessage(gpsa_RxToneBuf, gs_NumOfToneClustersForMsgDecode, gs_RxNumBytesPerSymbol, &uc_octet);

   //Decide if this symbol represents bit 0 or 1
   //Count the number of 1's in the decoded byte
   j = 0;
   for(i=0; i<8; i++)
   {
      j += uc_octet & 1;
      uc_octet >>= 1;
   }

   //Use the majority vote to decide what this bit is
   if(j>4)
   {
      uc_bit = 1;
   }
   else
   {
      uc_bit = 0;
   }



   //Reset variable for a new byte
   if(gs_RxNumSocBitPerByte == 8)
   {
      //Note: these two variables are used in RxHDLCMsgHandler()
      gs_RxNumSocBitPerByte = 0;
      guc_RxSocByte = 0;

      gs_SymCntPerBit = 0;
      gs_SegueSymCntPerBit = 0;
   }

   //count the number of 1's in the current byte
   gs_SegueSymCntPerBit += uc_bit;

   //Update the symbol count for this bit group
   gs_SymCntPerBit++;

   //If all the five symbols (per bit) have been received, set the count for decoding next bit
   if(gs_SymCntPerBit == gus_NumSymbolsPerBit)
   {
      //Make the decision on the current bit based on majority vote
      //If three out of five symbols are Segue, assume this bit is 1, else 0
      if(gs_SegueSymCntPerBit >= gus_NumSymbolsPerBitThresh)
      {
         guc_RxSocByte |= (1<<gs_RxNumSocBitPerByte);
      }

      //Update the number of bits received for the current byte
      gs_RxNumSocBitPerByte++;

      //Reset the symbol counts for decoding the next bit
      gs_SegueSymCntPerBit = 0;
      gs_SymCntPerBit = 0;
   }

}


