/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;   FILE NAME: FormMsgLD_VDSL2Diag.c

;   The function for forming O/R-MSG-LD message.
;
*****************************************************************************/

// ***********************************************************************************************************
// FormMsgLD_VDSL2Diag.c
//
// History

// 10/10/2017 Abu Rahman
// XDSLRTFW-3071: US & DS ATP reporting is swapped
//     Variables contains the DS ActATP and US ActATP were wrongly (swapped) populated.
//     - Fixed the variable initialization.
//     - Fixed variables population for DS ActATP and US ActATP
//     - Fixed HDLC messages relating to these variables both for Showtime and diag mode
//     - Changed two structure names
//       1. old name: gt_G997_NeSignalAndMarginParams, new name: gt_LineStatusDS
//       2. old name: gt_G997_FeSignalAndMarginParams, new name: gt_LineStatusUS
//     Grep for XDSLRTFW-3071
// ************************************************************************************************************
#include "common.h"
#include "gdata.h"
#include "socmessage.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *
 *  Description:  Forms the O/R-MSG-LD message.
 *
 *  Prototype:
 *           void FormMsgLD_VDSL2Diag(void);
 *
 *
 *  Input Arguments:
 *      None
 *
 *  Output Arguments:
 *      None
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

extern uint8 GetSnrForCarrierGroup(const uint16 us_CarrierGroup);
extern void RemoveHlinSc(uint16 *pusa_HlinBuf);

void FormMsgLD_VDSL2(void)
{
   int16 i, j;
   uint16 *pusa_Hlin, us_temp;
   uint8 *pusa_TxMsgBuf;

   // Populate Message code
   i = 0;
   gpuca_TxSocMsg[i++] = (uint8)VDSL2_SOC_MSG_R_MSG_LD;

   // Field2
   // Hlin 6x512 bytes
   pusa_Hlin = gpusa_HlinBuf_NE;
   pusa_TxMsgBuf = gpuca_TxSocMsg+i;

   for(j=0; j<512*3; j++)
   {
      us_temp = *pusa_Hlin++;

      *pusa_TxMsgBuf++ = (uint8)(us_temp>>8);
      *pusa_TxMsgBuf++ = (uint8)(us_temp);
   }
   i += 512*6;

   //Remove "scale" from the Hlin table since it is required by the external interface
   RemoveHlinSc(gpusa_HlinBuf_NE);

   // Field3
   // SNR, 512 byte
   for(j=0; j<512; j++)
   {
      // Downsample the SNR buffer and convert to messaging format
      guca_SNRBuf_NE[j] = GetSnrForCarrierGroup(j);
      *pusa_TxMsgBuf++ = guca_SNRBuf_NE[j];
   }
   i += 512;

   // Field4
   // LATN-pb (2*5) bytes
   for(j=0; j < 5; j++)
   {
      // Send the MSB first
      gpuca_TxSocMsg[i++] = (gt_AttenSnrMPerRxBand.t_AttenSnrM[j].s_LATN >> 8);

      // Send the LSB next
      gpuca_TxSocMsg[i++]   = (gt_AttenSnrMPerRxBand.t_AttenSnrM[j].s_LATN & 0xFF);
   }

   // Field5
   // SATN-pb (2*5) bytes
   for(j=0; j < 5; j++)
   {
      // Send the MSB first
      gpuca_TxSocMsg[i++] = (gt_AttenSnrMPerRxBand.t_AttenSnrM[j].s_SATN >> 8);

      // Send the LSB next
      gpuca_TxSocMsg[i++] = (gt_AttenSnrMPerRxBand.t_AttenSnrM[j].s_SATN & 0xFF);
   }

   // Field6
   // SNRM and SNRM-pb (2+2*5) bytes
   gpuca_TxSocMsg[i++] = gt_LineStatusDS.s_SnrMargin>>8; // overall SNRM
   gpuca_TxSocMsg[i++] = (uint8)gt_LineStatusDS.s_SnrMargin;

   for(j=0; j < 5; j++)
   {
      // Send the MSB first
      gpuca_TxSocMsg[i++] = (gt_AttenSnrMPerRxBand.t_AttenSnrM[j].s_SNRM >> 8);

      // Send the LSB next
      gpuca_TxSocMsg[i++] = (gt_AttenSnrMPerRxBand.t_AttenSnrM[j].s_SNRM & 0xFF);
   }

   // Field7
   // ATTNDR 4 bytes
   gpuca_TxSocMsg[i++]= gt_LineStatusDS.ul_AttainableDataRate>>24;
   gpuca_TxSocMsg[i++] = gt_LineStatusDS.ul_AttainableDataRate>>16;
   gpuca_TxSocMsg[i++] = gt_LineStatusDS.ul_AttainableDataRate>>8;
   gpuca_TxSocMsg[i++] = (uint8)gt_LineStatusDS.ul_AttainableDataRate;

   // XDSLRTFW-3071 US & DS ATP reporting is swapped (Start)
   // Field8
   // ACTATP 2 bytes
   gt_LineStatusDS.s_ActualAggregateXmtPwr = gs_MedleyNOMATP_dBm;
    if((gt_LineStatusDS.s_ActualAggregateXmtPwr > (31*10)) || (gt_LineStatusDS.s_ActualAggregateXmtPwr <(-31*10)))
   {
      //special value indicating the ACTAPT is out of the range
      gt_LineStatusDS.s_ActualAggregateXmtPwr = -512;
   }

    //DS ActATP
    gpuca_TxSocMsg[i++] = (uint8)(gt_LineStatusDS.s_ActualAggregateXmtPwr>>8);
   gpuca_TxSocMsg[i++] = (uint8)gt_LineStatusDS.s_ActualAggregateXmtPwr;
   // XDSLRTFW-3071 US & DS ATP reporting is swapped (End)

   gs_NumOctetsInTxHDLCMsg = i; // Set msg buffer length for HDLC encapsulation

   DSH_SendStream(DSH_R_MSG_LD, (uint16)i,(void *)gpuca_TxSocMsg);

   gs_FormMsgFlag = TRAINING_DONE;

}


void RemoveHlinSc(uint16 *pusa_HlinBuf)
{
   int16 j;
   uint16 *pusa_Hlin_src, *pusa_Hlin_des;
   pusa_Hlin_src = pusa_HlinBuf+1;
   pusa_Hlin_des = pusa_HlinBuf;
   for(j=0; j<512; j++)
   {
      *pusa_Hlin_des++ = *pusa_Hlin_src++;
      *pusa_Hlin_des++ = *pusa_Hlin_src++;
      pusa_Hlin_src++;
   }
}

