/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;   The function for forming O/R REPEAT_REQUEST message
;
*****************************************************************************/
#include "common.h"
#include "gdata.h"
#include "socmessage.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *
 *  Description:  Forms the O/R REPEAT_REQUEST message
 *
 *  Prototype:
 *           void FormORRepeatRqstMsg_VDSL2(void);
 *
 *
 *  Input Arguments:
 *      None
 *
 *  Output Arguments:
 *      None
 *
 *  Global Variables Used:
 *      gpuca_TxSocMsg -- (I) pointer to the TX SOC message buffer
 *      gs_NumOctetsInTxHDLCMsg -- (O) the length of the TX SOC message payload
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

void FormORRepeatRqstMsg_VDSL2(void)
{
   int16 i;


   i = 0;
   gpuca_TxSocMsg[i++] = SOC_MSG_REPEAT_REQUEST;  // Msg code

   DSH_SendStream(DSH_R_REPEAT_REQUEST, (uint16)i,(void *)gpuca_TxSocMsg);

   gs_NumOctetsInTxHDLCMsg = 1; // Set msg buffer length for HDLC encapsulation
}
