/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;   File Name: FormRAckMsg_VDSL2.c
;
;   The function for forming the CPE R-ACK or R-NACK message.
;
*****************************************************************************/
#include "vdsl_compiler.h"
#include "typedef.h"
#include "gdata.h"
#include "vdsl_const.h"
#include "cmv.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : FormRAckMsg_VDSL2
 *
 *  Description:  Forms the CPE R-ACK or R-NACK message.
 *
 *  Prototype:
 *           void FormRAckMsg_VDSL2();
 *
 *
 *  Input Arguments:
 *      None
 *
 *  Output Arguments:
 *      None
 *
 *  Global Variables Used:
 *      gpuca_TxSocMsg -- (I) pointer to the TX SOC message buffer
 *      gs_SendRAckFlag -- (I) flag to indicate which one, R-ACK or R-NACK, to be formed
 *      gs_NumOctetsInTxHDLCMsg -- (O) the length of the TX SOC message payload
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

void FormRAckMsg_VDSL2(void)
{
   int16 i;
   i = 0;

   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START)
   gsa_IndirectStat0[4]=VDSL2_R_P_TRAINING2;
   gsa_IndirectStat0[2]=VDSL2_R_ACK;
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (END)
   // Populate R-MSG1 Message:

   //Message code
   gpuca_TxSocMsg[i++] = (uint8)VDSL2_SOC_MSG_R_ACK;

   gs_NumOctetsInTxHDLCMsg = 1;       // Set msg buffer length for HDLC encapsulation

   DSH_SendStream(DSH_R_ACK, (uint16)i,(void *)gpuca_TxSocMsg);

   gs_FormMsgFlag = TRAINING_DONE;
}
