/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright C 2016 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;
;   Lantiq Deutschland
;
;   Written by Adeel Jalil
;
;   The function for forming R-Error-Feedback message.
;
*****************************************************************************/

//#ifdef MTK_VECTORING_SUPPORT
#include <string.h>
#include "common.h"
#include "gdata.h"
#include "socmessage.h"
#include "vdsl_state.h"
#include "cmv.h"

#define O_TA_UPDATE_G9935_MAX_N_BANDS      (8)
#define TRAINING_DONE                       (2)
#define VDSL2_SOC_MSG_R_ERROR_FEEDBACK           (0x8B)
#define INCREMENT_BUFFER_INDEX_FLAG            (0x0100)

extern uint8 guc_FEXTSymbolIndexk;

//#include "cri_iof.h"
//uint32 gl_mipsdebug6=0;

//Function prototypes
uint16 PackBitsInByteBuffer(uint8 *pt_OutputBufferCurrentIndex,int16 s_Value, uint8 uc_WordLength,
                            uint8 uc_CurrentPosition);

/*^^^
*------------------------------------------------------------------------
*
*
*  Description:  Forms the ERB Error Report Block.
*
*  Prototype:
*           int16 FormG9935ERB(int16 *pt_VectoringFFTbuffer, uint8 *puca_OutputBuffer, uint8 uc_ErrorFormat,
*                 uint8 uc_HWDecimRate, uint8 uc_CorruptedFrame) ;
*
*
*  Input Arguments:
*      pt_VectoringFFTbuffer   - Pointer to Error Buffer read out by using Iridia HW features
*      puca_OutputBuffer       - Pointer to first address of Output ERB
*      uc_ErrorFormat         - Format value of received Error.
*                                 // 0 - 3.13
*                                 // 1 - 1.7
*                                 // 2 - 1.3
*                                 // 3 - 1.1
*      uc_HWDecimRate          - Decimation Rate at which Values are read out (1<<x)
*      uc_CorruptedFrame       - Flag which indicates that the Clipped Error Samples are Potentially
*                                 corrupted (e.g., due to impulse noise, or RFI)
*
*  Return Value:
*      Number of Bytes in message
*
*  Global Variables Used:
*
*  Notes:
*
*------------------------------------------------------------------------
*^^^
*/
int16 FormG9935ERB(int16 *pt_VectoringFFTbuffer, uint8 *puca_OutputBuffer, uint8 uc_ErrorFormat,
                   uint8 uc_HWDecimRate, uint8 uc_CorruptedFrame)
{
   int16 i,j,k;
   uint16 us_Temp;
   uint32 ul_MeanErrorVectoredBand = 0,ul_MEq = 0;
   uint32 ul_Temp;


   int16 s_NormalizeShift=0;

   int8 c_B_M,c_B_L,uc_S;
   uint8 uc_ME_S, uc_ME_B_M, uc_ME_B_L;
   uint16 us_ClippedErrorMask;
   uint8 uc_WordLength, uc_CurrentPosition;
   uint16 us_NewBitPos;


   // decode Parameters from O-TA-Update Message
   uint8 uc_G9935_NumBands;
   uint8 uc_Padding;
   uint8 uc_FBlock;

   uint16 us_Fsub[8];
   uint16 us_Lw[8];
   uint16 us_Bmin[8];
   uint16 us_Bmax[8];

   int16 s_Error_sample_re, s_Error_sample_im;
   int16 s_MaxError = 0;
   //Band Descriptors Received in the O-SIGNATURE Message
   uint16 us_VectoredBandLeftChannel[8];
   uint16 us_VectoredBandRightChannel[8];

   int16 iii = 0;

//   uint32 ul_RxTimer1, ul_RxTimer2;
//   int32 s_MIPS;

   // debug abu
   //   gsa_RxVecBandRightChannel[0] = 50;
   //   gsa_RxVecBandRightChannel[1] = 520;
   //   uc_Padding = 0;
   // debug end

   //  Populate global control parameters to calculate ERB
   uc_G9935_NumBands = gt_DecMsg_O_TA_Update.t_G9935_O_TA_Update_Prm.uc_Nband;
   uc_Padding        = gt_DecMsg_O_TA_Update.t_G9935_O_TA_Update_Prm.uc_Padding;
   uc_FBlock         = gt_DecMsg_O_TA_Update.t_G9935_O_TA_Update_Prm.uc_Fblock;

   for(k = 0; k < (int16)uc_G9935_NumBands; k++)
   {
      us_Temp = gt_DecMsg_O_TA_Update.t_G9935_O_TA_Update_Prm.usa_VectoredBandParams[k];
      us_Bmax[k] = (us_Temp)& 0x000F;
      us_Bmin[k] = (us_Temp>> 4)& 0x000F;
      us_Lw[k]   = (us_Temp>> 8)& 0x000F;
      us_Fsub[k] = 1 << ((us_Temp>>12)& 0x000F);

      // RTV contains only every gs_IR_NPR_DECIM tone
      // This is possible because Fsub is 2,4,8,16,32 and 64.
      us_Fsub[k] >>= uc_HWDecimRate;
      us_VectoredBandLeftChannel[k] = (gsa_RxVecBandLeftChannel[k] >> uc_HWDecimRate);//gt_G9935VBDescriptor.us_G9935_VBLeftChannel[k];
      us_VectoredBandRightChannel[k] = (gsa_RxVecBandRightChannel[k] >> uc_HWDecimRate);//gt_G9935VBDescriptor.us_G9935_VBRightChannel[k];
   }

   // Assumption is that the variables contain the correct G.993.5 configuration Parameters
   if ( gs_RxState != R_O_SHOWTIME_RX) // only for training
   {
      // uc_ErrorFormat - Format value of received Error.
      //       0 - 3.13, i.e. 001.0000000000000 (pos) or 111.0000000000000 (neg) no error
      //       1 - 1.7
      //       2 - 1.3
      //       3 - 1.1
      switch(uc_ErrorFormat)
      {
      case 0:
         s_NormalizeShift = 2; //14-12,  12 corresponds to N_max, i.e. 1.11 format
         break;
      case 1:
         s_NormalizeShift = -4; //8-12,  12 corresponds to N_max
         break;
      case 2:
         s_NormalizeShift = -8; //4-12,  12 corresponds to N_max
         break;
      case 3:
         s_NormalizeShift = -10; //2-12,  12 corresponds to N_max
         break;
      }  // end  switch(uc_ErrorFormat)
   } // end if ( gs_RxState != R_O_SHOWTIME_RX)



   // pointer to output buffer:
   i = 0;

   // Field3 Error Report Block (N_ERB bytes)
   //  |---ERB_ID----|----VBB-a------|----VBB-b------|----VBB-c------|

   // ERB_ID Field
   // the remaining 7 bits of the ERB ID are set to 0 and reserved by ITU-T
   puca_OutputBuffer[i++] = uc_CorruptedFrame<<7;

// Switchoff Abus Debug code
   // for ( iii = 0; iii<2048; iii++)
   // {
   //    gpsa_LinearPsdExpBuffer[iii] = pt_VectoringFFTbuffer[iii];
   // }

   // loop over all Vectored Bands
   for(j = 0; j < uc_G9935_NumBands; j++)
   {
      ul_MeanErrorVectoredBand = 0;
      // skip this band if VCE has configured L_w to 0
      if(!us_Lw[j])
      {
         continue;
      }

      // Possible Formats for VBB-x
      // 1) F_block = ceil(N_carrier/F_sub)   code = 0
      //    |--VBB_ID--|--VBB_AUX--|--B_M--|------F_block error samples------|--Pad--|
      //
      // 2) F_block = 1                       code = 1
      //    |--VBB_ID--|--B_M--|--1 sample Block0--|-
      //                 -B_M--|--1 sample Block0--|-
      //                ......
      //                 -B_M--|--1 sample BlockN--|--Pad--|
      //
      // 3) F_block = 32                      code = 2
      //    |--VBB_ID--|--VBB_AUX--|--B_M--|--32 error samples Block 0--|-
      //                -Block ID--|--B_M--|--32 error samples Block 1--|-
      //                ......
      //                -Block ID--|--B_M--|--32 error samples Block N--|--Pad--|
      //

      // This is common for all formats
      // VBB_ID Field, 3 MSBs contain the number of the Vectored Band, Rest 0
      puca_OutputBuffer[i++] = (uint8)j << 5;

      s_MaxError = 0;

// Switchoff Abus Debug code
      // gpsa_LinearPsdExpBuffer[iii++] = 0xAAAA;

      // For F_block = ceil(N_carrier/F_sub)
      if (uc_FBlock == 0)
      {
         // First Run - Find Maximum Error Sample for B_M, B_L and accumulate Mean Error Value
         for (k = us_VectoredBandLeftChannel[j]; k <= us_VectoredBandRightChannel[j]; k+= us_Fsub[j])
         {
            s_Error_sample_re = pt_VectoringFFTbuffer[k*2];
            s_Error_sample_im = pt_VectoringFFTbuffer[k*2+1];

// Switchoff Abus Debug code
            // gpsa_LinearPsdExpBuffer[iii++] = s_Error_sample_re;
            // gpsa_LinearPsdExpBuffer[iii++] = s_Error_sample_im;

            // Showtime code
// Not needed during training. This is only needed in case of a common fct..
//            if ( gs_RxState == R_O_SHOWTIME_RX)
//            {
//               s_Error_sample_re = s_Error_sample_re^(0x0800);
//               s_Error_sample_re = s_Error_sample_re<<4;
//               s_Error_sample_re = s_Error_sample_re>>4;
//
//               s_Error_sample_im = s_Error_sample_im^(0x0800);
//               s_Error_sample_im = s_Error_sample_im<<4;
//               s_Error_sample_im = s_Error_sample_im>>4;
//            }
//            else  // Training code
            {
               // Adjust Error Samples to N_max = 12
               if(s_NormalizeShift > 0)
               {
                  s_Error_sample_re >>= s_NormalizeShift;
                  s_Error_sample_im >>= s_NormalizeShift;
               }
               else
               {
                  s_Error_sample_re <<= -s_NormalizeShift;
                  s_Error_sample_im <<= -s_NormalizeShift;
               }
            } // end  if ( gs_RxState == R_O_SHOWTIME_RX)

            // before clipping, update Mean Error Value
            if (s_Error_sample_re < 0)
            {
               ul_MeanErrorVectoredBand -= s_Error_sample_re;
            }
            else
            {
               ul_MeanErrorVectoredBand += s_Error_sample_re;
            }

            if (s_Error_sample_im < 0)
            {
               ul_MeanErrorVectoredBand -= s_Error_sample_im;
            }
            else
            {
               ul_MeanErrorVectoredBand += s_Error_sample_im;
            }

            // Clip Error Sample to B_max
            if(s_Error_sample_re >  ((1<<us_Bmax[j])-1))
            {
               s_Error_sample_re = ((1<<us_Bmax[j])-1);
            }
            else if(s_Error_sample_re <  -(1<<us_Bmax[j]))
            {
               s_Error_sample_re = -(1<<us_Bmax[j]);
            }

            if(s_Error_sample_im >  ((1<<us_Bmax[j])-1))
            {
               s_Error_sample_im = ((1<<us_Bmax[j])-1);
            }
            else if(s_Error_sample_im <  -(1<<us_Bmax[j]))
            {
               s_Error_sample_im = -(1<<us_Bmax[j]);
            }

            // store clipped Error sample in buffer for next round
            pt_VectoringFFTbuffer[k*2] = s_Error_sample_re;
            pt_VectoringFFTbuffer[k*2+1] = s_Error_sample_im;

            // This operation is for finding the most significant bit
            if (s_Error_sample_re < 0)
            {
               s_Error_sample_re = -s_Error_sample_re-1;
            }
            if (s_Error_sample_im < 0)
            {
               s_Error_sample_im = -s_Error_sample_im-1;
            }

            // bug : blackout tones have to be discarded from the calculation
            // Update the maximum value found till yet
            if(s_MaxError < s_Error_sample_re)
            {
               s_MaxError = s_Error_sample_re;
            }
            if(s_MaxError < s_Error_sample_im)
            {
               s_MaxError = s_Error_sample_im;
            }
         } // for k

// Switchoff Abus Debug code
         // gpsa_LinearPsdExpBuffer[iii++] = 0xBBBB;

         // Calculate S from the maximum Error Sample
         // S = ceil(log2(MaximumError))
         for ( us_Temp = s_MaxError, uc_S = 0; us_Temp>0 ; us_Temp>>=1 )
         {
            uc_S++;
         }

         // if Padding is enabled then there are two ways to format the error
         // 1) Zero Padding  2) Sign Extension
         // We have implemented default configuration for zero padding
         c_B_M = uc_S;
         if( !uc_Padding && (us_Bmin[j] > c_B_M))
         {
            c_B_M = (int8) us_Bmin[j];
         }

         c_B_L = c_B_M - us_Lw[j] + 1;
         if(!uc_Padding && (us_Bmin[j] > c_B_L))
         {
            c_B_L = (int8) us_Bmin[j];
         }


         // Calculate VBB_Aux Value
         // cap MEq(vb) to 2^(ME_B_max)-1

         if(gs_RxState == R_O_SHOWTIME_RX) // Showtime Code
         {
            ul_MEq = ul_MeanErrorVectoredBand;
         }
         else // Training Code
         {
            ul_MEq = ul_MeanErrorVectoredBand >> 2;
         }

         if (ul_MEq > 0x3FFFFF)
         {
            ul_MEq = 0x3FFFFF;
         }

         //if( ul_MeanErrorVectoredBand > 0x3FFFFF)
         //   ul_MeanErrorVectoredBand = 0x3FFFFF;

         // Calculate ME_S from the Mean Error Accumulation.
         // S = ceil(log2(ME))
         for (ul_Temp = ul_MEq, uc_ME_S = 0; ul_Temp>0 ; ul_Temp>>=1)
         {
            uc_ME_S++;
         }

         // Format according to Table 7-3/G.993.5
         uc_ME_B_M = uc_ME_S;
         if (uc_ME_S < 7)
         {
            uc_ME_B_M = 7;
         }

         uc_ME_B_L = uc_ME_B_M - 7;

         // Store VBB_Aux Field

         puca_OutputBuffer[i] = uc_ME_B_L << 4;
         ul_MEq >>= uc_ME_B_L;
         ul_MEq &= 0xFF;
         //         puca_OutputBuffer[i++] |= (uint8) ul_MEq >> 4;
         //         puca_OutputBuffer[i]   =  (uint8) ul_MEq << 4;

         // only for debugging
         puca_OutputBuffer[i++] |= (uint8) 0xFF;
         puca_OutputBuffer[i]    = (uint8) 0xF0;
         // debugging end

         // Store B_M value in outgoing message before we adjust it for our implementation
         puca_OutputBuffer[i++] |= (c_B_M & 0xF);

         // Since B_L will be normalized to bit position 0, adjust B_M accordingly
         c_B_M -= c_B_L;

         uc_WordLength = c_B_M + 1;
         us_ClippedErrorMask = (1<<uc_WordLength)-1;

         uc_CurrentPosition = 0;


         // Run 2 -- Package Error Samples
         for (k = us_VectoredBandLeftChannel[j] ; k <= us_VectoredBandRightChannel[j] ; k += us_Fsub[j])
         {
            // get the formatted value from first run
            s_Error_sample_re = pt_VectoringFFTbuffer[k*2];
            s_Error_sample_im = pt_VectoringFFTbuffer[k*2+1];

            // Package the Error According to B_M and B_L
            // Normalize B_L to bit position 0
            if(c_B_L < 0)
            {
               s_Error_sample_re <<= -(c_B_L);
               s_Error_sample_im <<= -(c_B_L);
            }
            else
            {
               s_Error_sample_re >>= (c_B_L);
               s_Error_sample_im >>= (c_B_L);
            }
            s_Error_sample_re &= us_ClippedErrorMask;
            s_Error_sample_im &= us_ClippedErrorMask;


            us_NewBitPos = PackBitsInByteBuffer( &puca_OutputBuffer[i], s_Error_sample_re,
                                                 uc_WordLength, uc_CurrentPosition);
            if (us_NewBitPos & INCREMENT_BUFFER_INDEX_FLAG)
            {
               i++;
            }
            uc_CurrentPosition = (uint8) us_NewBitPos;

            us_NewBitPos = PackBitsInByteBuffer( &puca_OutputBuffer[i], s_Error_sample_im,
                                                 uc_WordLength, uc_CurrentPosition);

            if (us_NewBitPos & INCREMENT_BUFFER_INDEX_FLAG)
            {
               i++;
            }
            uc_CurrentPosition = (uint8) us_NewBitPos;
         }

         if(uc_CurrentPosition > 0)
         {
            i++;   // Pad
         }

      } // end if (uc_FBlock == 0)
      else if(uc_FBlock == 1)
      {
         // F_Block = 1
         uc_CurrentPosition = 0;


         for (k = us_VectoredBandLeftChannel[j]; k <= us_VectoredBandRightChannel[j]; k += us_Fsub[j])
         {
//            //Read RX timer value
//            ReadRxTimer(&ul_RxTimer1);

            {
               // find B_M for error sample
               s_Error_sample_re = pt_VectoringFFTbuffer[k*2];
               s_Error_sample_im = pt_VectoringFFTbuffer[(k*2)+1];
            }

            // Showtime code
// Not needed during training. This is only needed in case of a common fct..
//            if ( gs_RxState == R_O_SHOWTIME_RX)
//            {
//               s_Error_sample_re = s_Error_sample_re^(0x0800);
//               s_Error_sample_re = s_Error_sample_re<<4;
//               s_Error_sample_re = s_Error_sample_re>>4;
//
//
//               s_Error_sample_im = s_Error_sample_im^(0x0800);
//               s_Error_sample_im = s_Error_sample_im<<4;
//               s_Error_sample_im = s_Error_sample_im>>4;
//            }
//            else  // Training code
            {
               // Adjust Error Samples to N_max = 12
               if(s_NormalizeShift > 0)
               {
                  s_Error_sample_re >>= s_NormalizeShift;
                  s_Error_sample_im >>= s_NormalizeShift;
               }
               else
               {
                  s_Error_sample_re <<= -s_NormalizeShift;
                  s_Error_sample_im <<= -s_NormalizeShift;
               }
            } // end  if ( gs_RxState == R_O_SHOWTIME_RX)


            // Clip Error Sample to B_max, i.e.
            //  - set postive to max positive value
            //  - set negative to max negative value
            //  - otherwise value stays unchanged
            {
               if(s_Error_sample_re > ((1<<us_Bmax[j])-1))
               {
                  s_Error_sample_re = ((1<<us_Bmax[j])-1);
               }
               else if(s_Error_sample_re < -(1<<us_Bmax[j]))
               {
                  s_Error_sample_re = -(1<<us_Bmax[j]);
               }

               if(s_Error_sample_im > ((1<<us_Bmax[j])-1))
               {
                  s_Error_sample_im = ((1<<us_Bmax[j])-1);
               }
               else if(s_Error_sample_im < -(1<<us_Bmax[j]))
               {
                  s_Error_sample_im = -(1<<us_Bmax[j]);
               }
            }

            // Package B_M and error sample
            // This operation is for finding the most significant bit.
            {
               int16 s_TempPoint_re, s_TempPoint_im;

               s_TempPoint_re = s_Error_sample_re;
               if (s_TempPoint_re < 0)
               {
                  s_TempPoint_re = (~s_TempPoint_re);
               }

               s_TempPoint_im = s_Error_sample_im;
               if (s_TempPoint_im < 0)
               {
                  s_TempPoint_im = (~s_TempPoint_im);
               }

               // Get maximum of the two components to calculate B_M
               if(s_TempPoint_re < s_TempPoint_im)
               {
                  s_TempPoint_re = s_TempPoint_im;
               }
               // Get bit position of the sign bit
               for (us_Temp = (uint16)s_TempPoint_re, uc_S = 0; us_Temp>0 ; us_Temp>>=1)
               {
                  uc_S++;
               }
            }

            // Padding is mandatory for F_block = 1
            // There are two ways to do padding (G992.5/7.2.2.2 eq.7-2)
            // i. Zero Padding
            // ii. Sign extension

            // Zero Padding code start
//          c_B_M = uc_S;
//          c_B_L = c_B_M - us_Lw[j] + 1;
//
//          // Normalize B_L to bit position 0
//          if(c_B_L < 0)
//          {
//             s_Error_sample_re <<= -(c_B_L);
//             s_Error_sample_im <<= -(c_B_L);
//          }
//          else
//          {
//             s_Error_sample_re >>= (c_B_L);
//             s_Error_sample_im >>= (c_B_L);
//          }
            // Zero Padding code end

            // Sign extension padding code start
            {
               // B_M = max(S, Lw-1)
               c_B_M = uc_S;
               if (uc_S < (us_Lw[j]-1))
               {
                  c_B_M = (us_Lw[j]-1);
               }

               // B_L = B_M - L_w + 1
               // Note: From the above formula B_M >= (L_w-1) and therfore B_L >= 0.
               c_B_L = c_B_M - us_Lw[j] + 1;

               // B_L <= B_M and 0 <= B_M <= B_max
               if ((c_B_M > us_Bmax[j]) || (c_B_M < c_B_L))
               {
                  gsa_DebugCA[16]++;
               }

               // Shift the relevant L_w bits, so that B_L is laying on the
               // LSB, i.e. preparation to extract the L_w bits with a mask.
               s_Error_sample_re >>= (c_B_L);
               s_Error_sample_im >>= (c_B_L);
            }
            // Sign extension padding code end

            // Since padding is mandatory
            uc_WordLength = (uint8) us_Lw[j];
            // Mask the error samples, so that they contain only the relevant L_w bits.
            us_ClippedErrorMask = (1<<uc_WordLength)-1;
            s_Error_sample_re &= us_ClippedErrorMask;
            s_Error_sample_im &= us_ClippedErrorMask;

            //Package 4 bits B_M for current error sample
            us_NewBitPos = PackBitsInByteBuffer( &puca_OutputBuffer[i], c_B_M,
                                                 4, uc_CurrentPosition);
            if (us_NewBitPos & INCREMENT_BUFFER_INDEX_FLAG)
            {
               i++;
            }
            uc_CurrentPosition = (uint8) us_NewBitPos;

            // Package clipped error sample
            // Real part
            us_NewBitPos = PackBitsInByteBuffer( &puca_OutputBuffer[i], s_Error_sample_re,
                                                 uc_WordLength, uc_CurrentPosition);
            if (us_NewBitPos & INCREMENT_BUFFER_INDEX_FLAG)
            {
               i++;
            }
            uc_CurrentPosition = (uint8) us_NewBitPos;
            // Imaginary part
            us_NewBitPos = PackBitsInByteBuffer( &puca_OutputBuffer[i], s_Error_sample_im,
                                                 uc_WordLength, uc_CurrentPosition);
            if (us_NewBitPos & INCREMENT_BUFFER_INDEX_FLAG)
            {
               i++;
            }
            uc_CurrentPosition = (uint8) us_NewBitPos;

         } // for loop over tones in jth vectored band

         if(uc_CurrentPosition > 0)
         {
            i++;   // Pad
         }


//         // Read RX timer value
//         ReadRxTimer(&ul_RxTimer2);
//
//         //Compute the MIPS for this task
//         s_MIPS = (ul_RxTimer2 - ul_RxTimer1);
//
//         if(s_MIPS > gl_mipsdebug6)
//         {
//            gl_mipsdebug6=s_MIPS;
//         }

      } // else if(uc_FBlock == 1)
   } // for(j = 0; j < uc_G9935_NumBands; j++)

   // Return Byte count of created message
   return(i); // Set msg buffer length for HDLC encapsulation
}

//comment : Implementation of this code can be much more simpler if we take MSB is position 0
/*^^^
 *------------------------------------------------------------------------
 *
 *
 *  Description:  Packs arbitrary bit size value into byte array.
 *
 *  Prototype:
 *           uint16 PackBitsInByteBuffer();
 *
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *      us_NewBitPositionMarker
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
uint16 PackBitsInByteBuffer(uint8 *pt_OutputBufferCurrentIndex,  int16 s_Value, uint8 uc_WordLength,
                            uint8 uc_CurrentPosition)
{
   uint16 us_NewBitPositionMarker = 0;
   int16 s_Shift;
   uint16 us_TempValue;

   // compute Shift value
   s_Shift = (int16) uc_CurrentPosition - (int16) uc_WordLength;

   if(s_Shift<0)
   {
      s_Shift+=8;
   }

   // The s_Shift can be used in the next call as uc_CurrentPosition
   us_NewBitPositionMarker |= (uint16) s_Shift;

   us_TempValue = (uint16) s_Value<<s_Shift ;

   // Check if word is overlapping byte boundary
   if((s_Shift + uc_WordLength)>8)   // BYTE Boundary overlap
   {
      pt_OutputBufferCurrentIndex[0] |=  (uint8) (us_TempValue>>8);
      pt_OutputBufferCurrentIndex[1]  =  (uint8) us_TempValue;
      us_NewBitPositionMarker |= INCREMENT_BUFFER_INDEX_FLAG; //0x0100
   }
   else if((s_Shift + uc_WordLength)== 8)// No previous Content in location
   {
      pt_OutputBufferCurrentIndex[0] =  (uint8) us_TempValue;
   }
   else     // Use OR since previous content present
   {
      pt_OutputBufferCurrentIndex[0] |=  (uint8) us_TempValue;
   }

   if(!s_Shift)
   {
      us_NewBitPositionMarker |= INCREMENT_BUFFER_INDEX_FLAG;   //0x0100
   }

   return(us_NewBitPositionMarker);
}

/*^^^
*------------------------------------------------------------------------
*
*
*  Description:  Forms the R-ERROR-FEEDBACK message.
*
*  Prototype:
*           void FormRErrorFeedbackMsg_VDSL2(void);
*
*
*  Input Arguments:
*      None
*
*  Output Arguments:
*      None
*
*  Global Variables Used:
*
*  Notes:
*
*------------------------------------------------------------------------
*^^^
*/
void FormRErrorFeedbackMsg_VDSL2(void)
{
   int16 *pt_VectoringFFTbuffer = gsa_TrnVectoringBuffer;       // Memory address of stored Error data in training
                                                                // (int16*)0x4FEB0;
   uint8 uc_ErrorFormat = 0;
   uint8 uc_HWDecimRate = gs_IR_NPR_DECIM;                      // Error data was collected with interpolation factor 1
   uint16 us_SyncSymbolCount = (uint16)gs_RxSuperFrmCnt_ForEOC; // sync symbol count modulo 1024
   uint8 uc_SeqNr = guc_FEXTSymbolIndexk;
   uint8 uc_CorruptedFrame = 0;
   int16 s_Temp;

   //DSM_Vectoring_Debug:
   //gs_Debug7 = gs_RxFrmCnt;

   // Table 10-9/G993.5 Field1 Message descriptor (1 byte)
   gpuca_TxSocMsg[0] = VDSL2_SOC_MSG_R_ERROR_FEEDBACK;          // Msg code

   // Table 10-9/G993.5 Field2 Sync Symbol Count  (2 bytes)
   // assumption is that us_SyncSymbolCount is already modulo 1024
   gpuca_TxSocMsg[1] = (uint8) ((uc_SeqNr<<4)+ (us_SyncSymbolCount>>8));
   gpuca_TxSocMsg[2] = (uint8) (us_SyncSymbolCount);


   s_Temp = FormG9935ERB(pt_VectoringFFTbuffer, &gpuca_TxSocMsg[3], uc_ErrorFormat,
                         uc_HWDecimRate, uc_CorruptedFrame);

   gs_NumOctetsInTxHDLCMsg = s_Temp + 3;

   // Maximum payload size of a HDLC frame is 1024/2048 bytes
   {
      uint16 us_MaxSocMsgSegSize;

      us_MaxSocMsgSegSize = SOC_MAX_MSG_SEGMENT_SIZE;
      if (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK)
      {
         us_MaxSocMsgSegSize = SOC_MAX_MSG_SEGMENT_35B_SIZE;
      }

      gft_TxHDLCSegmentedAutoRepeatMode = 0;
      if (gs_NumOctetsInTxHDLCMsg > us_MaxSocMsgSegSize)
      {
         gft_TxHDLCSegmentedAutoRepeatMode = 1;      // Enable Segmented SOC
      }
   }

   gs_FormMsgFlag = TRAINING_DONE;

   //DSM_Vectoring_Debug:
   //gs_Debug8 = gs_RxFrmCnt;
}

//#endif // #ifdef MTK_VECTORING_SUPPORT
