/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;   The function for forming the CPE R-MSG message.
;
*****************************************************************************/

// ****************************************************************************************************
// FormRMsg1MSg_VDSL2.c
// History :
// 06/05/2013 Varun: Added code(Debug option) to capture raw data of all Tx(R-MSG1 in particular) and Rx-
//            training messages (G.Hs + training)
//            Grep for "XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer"
// 04/07/2013 Ram: Added bug fix for No-Connect issue seen with EVLT-F/CNXT DSLAM in VDSL2 mode. CO/DSLAM
//            wasn't supporting decoding of AMMENDMENT-5 fields (G.Inp and G.Vector related fields) in
//            R-MSG1 and was dropping the link as we were sending them by default.
//            Grep for XDSLRTFW-985 BugFix_All_All_All_NoSync_with_EVLT-F_CNXT_DSLAM (Start End)
// 27/08/2014 Fuss: No-Connect when BT-bit is set and CO indicate US0 only
//            Grep for XDSLRTFW-1975
//14/12/2018 Sriram Shastry :XDSLRTFW-4052 : Low upstream data rates in 30a profile
//           Improvement for Kl0 alogorithm estimation for  30a profile
//           Control option to use AELEM for reporting KL0
//           Control option to set  Kl0 in RMSG1
//           Control option to set AELEM method instead of  KL0 method
//           Control option to Enable/disble psdpreprocessing (inter polation) 
//           Initialize AELEM structure (gt_AELEM_UPBOInfo) 
//  Grep for XDSLRTFW-4052
//****************************************************************************************************

#include <string.h>
#include "common.h"
#include "gdata.h"
#include "socmessage.h"
#include "ghs.h"
#include "DebugBuffer.h"
#include "cmv.h"                    // ANXQ_SUPPORT

/*^^^
 *------------------------------------------------------------------------
 *
 *
 *  Description:  Forms the CPE R-MSG message.
 *
 *  Prototype:
 *           void FormRMsg1Msg_VDSL2(void);
 *
 *
 *  Input Arguments:
 *      None
 *
 *  Output Arguments:
 *      None
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

void FormRMsg1Msg_VDSL2(void)
{
   int16 i, s_NumOfPoints, s_Up_InitialPsdCeilingMask;


   // Populate R-MSG Message:
   i = 0;
   gpuca_TxSocMsg[i++] = (uint8)VDSL2_SOC_MSG_R_MSG;  // Msg code

   // XDSLRTFW-487_VR9_VRX318_VDSL2_All_AELEM_Support (START)
   // XDSLRTFW-1975 (Start_End)
   // Field2 estimate of electrical length (2 bytes)
   {
      uint16 us_Kl0EstimLocal;

      if((gul_OperationModeStatus_VDSL2 & (V2_ELE_METHOD1 << 24)) && (gt_AELEM_UPBOInfo.us_AeleMode != 0))
      {
         us_Kl0EstimLocal = gus_ELEDsMin;
      }
      else
      {
         // XDSLRTFW-487_VR9_VRX318_VDSL2_All_AELEM_Support (END)
         // Encode in 0.1 dB format
         us_Kl0EstimLocal = (uint16) gt_Kl0ElectricalLength.s_kl0_estimate;
      }

      if(us_Kl0EstimLocal > KL0_MAX_VALUE)
      {
         us_Kl0EstimLocal = KL0_MAX_VALUE;    // we cannot report more than 128dB.
      }
      // XDSLRTFW-4052(Start)
      // Debug code:
      // Overwrite kl0 estimation in R-MSG1 for debugging purpose.
      // CPE-FW still uses for internal calculations the measured kl0.
      if (gt_TxPsdControl.s_Force_kl0_estimate_in_RMSG1 > 0)
      {
          us_Kl0EstimLocal = gt_TxPsdControl.s_Force_kl0_estimate_in_RMSG1;
      }
      // XDSLRTFW-4052(End)
      gpuca_TxSocMsg[i++] = us_Kl0EstimLocal >> 8;
      gpuca_TxSocMsg[i++] = (uint8)us_Kl0EstimLocal;
   }

   // Field3
   // Initial Upstream PSD ceiling, MAXPSDus (2 bytes)
   // See 997.1 section 7.3.1.2.2
   // Case of s_Up_InitialPsdCeiling being a template level, and wanting to generate
   // s_Up_InitialPsdCeilingMask as a mask level.  Add 3.5 dB to s_Up_InitialPsdCeiling to do this conversion.
   s_Up_InitialPsdCeilingMask = gt_PwrConfigParam.s_Up_InitialPsdCeiling - 35;
   if (s_Up_InitialPsdCeilingMask < 0)
   {
      s_Up_InitialPsdCeilingMask = 0;
   }
   else if (s_Up_InitialPsdCeilingMask > 900)
   {
      s_Up_InitialPsdCeilingMask = 900;
   }
   gpuca_TxSocMsg[i++] = (s_Up_InitialPsdCeilingMask>>8);
   gpuca_TxSocMsg[i++] = (int8)s_Up_InitialPsdCeilingMask;

   // Field4
   // Channel Discovery downstream PSD mask, CDPSDus (PSD Descriptor)
   s_NumOfPoints = (int16)gt_UsREFPSDDescriptorTable.us_NumberOfTones;
   gpuca_TxSocMsg[i++] = (uint8)s_NumOfPoints;

   EncodePSDs(&i, s_NumOfPoints, (void*)&gt_UsREFPSDDescriptorTable, gt_PwrConfigParam.s_Up_MaxNomPSD, gpuca_TxSocMsg);
   // XDSLRTFW-3280 - Start - PLL improvement / pilot tone selection improvement
   // Field5 pilot tones (tone descriptor)
   {
      int8 s_NumPilotTones=0;
      int16 sa_PilotToneArray[MAX_NUM_PILOT_TONES];

      if (gft_EnableShowPllToneSwitch)
      {
         // XDSLRTFW-3654 Start [VRX518] B+V+R No connect due to repetitive low pilot tone in training
         // Only report Pilot tones which have an index !=0 and store them compressed to a temp array, exluding PTs with idx 0
         int8 c_tmpArrayIdx=0;
         for(int8 j=0;j<MAX_NUM_PILOT_TONES;j++)
         {
            if(gt_PilotConfig.ta_PilotTones[j].s_PilotToneIdx != 0)
            {
               sa_PilotToneArray[c_tmpArrayIdx] = gt_PilotConfig.ta_PilotTones[j].s_PilotToneIdx;
               c_tmpArrayIdx++;
               s_NumPilotTones++;
            }
         }
         // XDSLRTFW-3654 End [VRX518] B+V+R No connect due to repetitive low pilot tone in training
      }
      else
      {
         // XDSLRTFW-1479 Communicate the pilot tone of DS1 or DS2 band
         sa_PilotToneArray[0] = gt_PilotConfig.ta_PilotTones[PT_ARRAY_IDX_0].s_PilotToneIdx;
         sa_PilotToneArray[1] = gt_PilotConfig.ta_PilotTones[PT_ARRAY_IDX_1].s_PilotToneIdx;
         s_NumPilotTones = 2;
      }

      // Add # of pilot tones
      gpuca_TxSocMsg[i++] = s_NumPilotTones;
      // Encode pilot tone indexes
      EncodeTones(&i, s_NumPilotTones, &sa_PilotToneArray[0] , gpuca_TxSocMsg, 0);
   }
   // XDSLRTFW-3280 - End - PLL improvement / pilot tone selection improvement

   // Field6 timing advance (2 bytes)
   EncodeNumOfSamples(&i, gs_TargetTimingAdvance, gpuca_TxSocMsg);

   // Field7 O-P-PILOT (1 byte)
   // The format is one byte with the following encoding:
   //   - first MSB indicates O-P-PILOT during Channel Discovery phase (1=ON, 0=OFF);
   //   - second MSB and third MSB indicates O-P-PILOT 1, O-P-PILOT 2, respectively,
   //     during the Training phase (1=ON, 0=OFF); other bits shall be set to 0.
   gpuca_TxSocMsg[i++] = 7<<5; // set to ON all the time

   // Field8 upstream tx window length (1 byte)
   // ANXQ_SUPPORT
   if ((gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK) &&
       (gs_TxLog2IfftLength > US_LOG2_FFT_LENGTH_8192))                // US_LOG2_FFT_LENGTH_8192 = 13)
   {
      //  ... shall be expressed either in multiples of 2 samples
      //      if profile 35b is used with extended IDFT Size, or otherwise,
      //      in samples at the upstream sampling rate corresponding to the
      //      IDFT size communicated during the ITU-T G.994.1 handshake phase.
      gpuca_TxSocMsg[i++] = (uint8)(gs_TxBetaLength >> 1);
   }
   else
   {
      gpuca_TxSocMsg[i++] = (uint8)gs_TxBetaLength;
   }

   // Field9 upstream Tx CP length (2 bytes)
   EncodeNumOfSamples(&i, gs_TxCPLength, gpuca_TxSocMsg);


   //XDSLRTFW-985 BugFix_All_All_All_NoSync_with_EVLT-F_CNXT_DSLAM (Start End)
   // Note: Do not send G.INP and G.Vector fields if CO doesn't support AMMENDMENT-5 changes.
   //       Amendment5 ReTx and Vectoring octet must be transmitted in O-Signature, i.e. at
   //       least the block length field as zero (1byte for ReTx and 1byte for Vectoring). Otherwise
   //       the AELM bytes cannot be transmitted in O-Signature!
   if (gul_dbgSocMsgControl2 & (AMENDMENT7_AELM_SUPPORT | AMENDMENT5_VECTORING_SUPPORT | AMENDMENT5_RETX_SUPPORT))
   {
      // place holder for G.Inp variable length field
      gpuca_TxSocMsg[i++] = 0;                            // Skip G.Inp fileds by making Lengh = 0
   }

   if (gul_dbgSocMsgControl2 & (AMENDMENT7_AELM_SUPPORT | AMENDMENT5_VECTORING_SUPPORT))
   {
      if (gft_DSVectoringEnabled == TRUE)
      {
         // Table 10-6/G993.5 byte field 1 (Length field)
         gt_R_Msg1_G993_5.uc_MsgLength = 2;

         // Table 10-6/G993.5 byte field 2
         //XDSLRTFW-1621 DeltInVectoring (Start/End)
         if((gus_VectoringOptionsEnabled & VEC_OPTIONS_FULL_FRIENDLY_MASK)|| gft_DeltInVectoringMode )
         {
            gt_R_Msg1_G993_5.uc_MaxFEXTsymbPerSuperFrame=0; // G993.2 Annex O (Full Vectoroing Friendly): Kmax = 0
         }
         else
         {
            gt_R_Msg1_G993_5.uc_MaxFEXTsymbPerSuperFrame=1;   // G993.5 Full vectoring Mode: Kmax = 1 ( currently FW enables only this value)
         }
         // our implementation can support all K values not limited to 1

         // Table 10-6/G993.5 byte field 3 (we can support bits 0 & 1)
         //XDSLRTFW-1621 DeltInVectoring (Start/End)
         gt_R_Msg1_G993_5.uc_Optn_ParBackChannel = 0;      // Table 10-7/G993.5 : Fw does not support any optional back channel control parameters.
         // G992.3 Annex 0: 0x00 defined by the standard

         gpuca_TxSocMsg[i++] = gt_R_Msg1_G993_5.uc_MsgLength;               // Table 10-6/G993.5 byte # 1
         gpuca_TxSocMsg[i++] = gt_R_Msg1_G993_5.uc_MaxFEXTsymbPerSuperFrame;   // Table 10-6/G993.5 byte # 2
         gpuca_TxSocMsg[i++] = gt_R_Msg1_G993_5.uc_Optn_ParBackChannel;      // Table 10-6/G993.5 byte # 3
      }
      else
      {
         gpuca_TxSocMsg[i++] = 0;  //Skip G.993.5 ( G.Vectoring) in case vectoring is selected from G.hs
      }
   }
   // XDSLRTFW-487_VR9_VRX318_VDSL2_All_AELEM_Support (START)
   if (gul_dbgSocMsgControl2 & AMENDMENT7_AELM_SUPPORT)
   {
      if (gul_OperationModeStatus_VDSL2 & (V2_ELE_METHOD1 << 24))
      {
         uint8 j;
         uint16 Kl0EstimRPbLocal;
         // Field12
         guc_ELEDsBands = (uint8)gs_NumOfRxBands;
         gpuca_TxSocMsg[i++] = guc_ELEDsBands;
         for(j = 0; j<guc_ELEDsBands; j++)
         {
            Kl0EstimRPbLocal = gt_AELEM_UPBOInfo.usa_Kl0EstimRPb[j];
            if(Kl0EstimRPbLocal > KL0_MAX_VALUE)
            {
               Kl0EstimRPbLocal = KL0_MAX_VALUE;    // we cannot report more than 128dB.
               // However we still want to report to the host 2047
            }
            gpuca_TxSocMsg[i++] = (uint8)(Kl0EstimRPbLocal >> 8);
            gpuca_TxSocMsg[i++] = (uint8)Kl0EstimRPbLocal;
         }
      }
      else
      {
         gpuca_TxSocMsg[i++] = 0;
      }
   }
   // XDSLRTFW-487_VR9_VRX318_VDSL2_All_AELEM_Support (END)
#ifdef DEBUG_TRACES
   // XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer(START_END)
   LogMessages(4,(uint16)gpuca_TxSocMsg[0], (uint16)i, gpuca_TxSocMsg, DEBUG_BUFFER_DELIMITER_VDSL2);

#endif // #ifdef DEBUG_TRACES
   //Set msg buffer length for HDLC encapsulation
   gs_NumOctetsInTxHDLCMsg = i;

   memcpy(&gsa_DebugStreamBuffer[0][0],gpuca_TxSocMsg,(uint16)i);
   DSH_SendStream(DSH_R_MSG1, (uint16)i,(void *)&gsa_DebugStreamBuffer[0][0]);

   gs_FormMsgFlag = TRAINING_DONE;

#if defined(VRX518_BRINGUP_DEBUG)
   // Pause to dump the R-MSG1 SOC message.
   if (gs_PauseControl == 0x705)
   {
      gft_PauseOff = 0;
      Pause(gs_PauseControl);
   }
#endif // VRX518_BRINGUP_DEBUG

   //DSM_Vectoring_Debug:
   //if ( gs_PauseControl == 7)
   //Pause(0x7);
}
