/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 2016 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;   The function is used to form the CPE R-MSG2 message.
;
*****************************************************************************/

//****************************************************************************
// FormRMsg2MSg_VDSL2.c
//   History :
//
// 06/05/2013 Varun: Added code(Debug option) to capture raw data of all Tx(R-MSG2 in particular) and Rx-
//                    training messages (G.Hs + training)
//            Grep for "XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer"
// 15/07/2013 Varun: Incorporated the code changes to support US ReTx
//            Grep for "XDSLRTFW-1045 Feature_US_VDSL2_ALL_UsReTx"
// 13/09/2013 Varun:  supported framing type variable made configuarable (in link with CMV CNFG 84 0) in US ReTx mode
//                    Grep for  XDSLRTFW-1193 Feature_US_VDSL2_ALL_UsReTx_CMV
// 19/09/2013 Abu: Wrong coding in fct. FormRMsg2Msg_VDSL2(void) for parameter RMSG2_UsNetDataRateMax
//            Grep for XDSLRTFW-1246: Bugfix_US_VDSL2_ALL_WrongCoding
// 19/09/2013 Abu: Added code(Debug option) to check if the upstream rate gets improved
//            Grep for XDSLRTFW-1182: Bugfix_US_VDSL2_ALL_LowUsRate
// 16/10/2013 Varun : Modified the message to support ReTx amend2
//            Grep for XDSLRTFW-1284 Feature_US_VDSL2_ALL_UsReTx_TrainingMessageChanges
// 29/10/2013 Anantha Ramu: Modifications done to calculate ATTNDR with attndr_method set to 0(default),1 & 2 as per
//                          Amd 2 of G.998.4. The attndr_method is decided by CO MIB, and conveyed to CPE in O-TPS.
//                          CPE also indicates capability to calculate ATTNDR with methods 1 & 2 in R-MSG2
//                          (Field: ATTNDR method capability). In methods 1 & 2 the configured INPs used for calculation
//                          are conveyed to CO through overhead test parameters response along with ATTNDR value.
//            Grep for: XDSLRTFW-1285 Feature_US_VDSL2_ALL_UsReTxAmend2_ATTNDR
//
// 31/1/2014 Anantha Ramu: Modifications done for sending attndr_method indication only if CPE is enabled for ReTx Amd2
//                         & CO indicates support for ReTx Amd2. This modification is done to avoid the observed link drop
//                         against CNXT EVLT-F. Note: The octets of "Time Synchronization capability" & "Time Synchronization period"
//                         are also in the check for Amd2 along with "ATTNDR method capability" octet to prevent link drop.
//           Grep for: XDSLRTFW-1538 IOP_A_DS_VDSL2ReTx_ALL_ATTNDR_Amd2.
// 21/02/2014 Fuss: Reserved-net-data-rate = 0 is not allowed. Reserved must be >= Minimum-net-data-rate.
//            Grep for: XDSLRTFW-992 Bugfix_DS_All_All_ReservedNetDataRate (start_end)
// 20/10/2014 Palaksha:  "XDSLRTFW-2046: ~9%DS rate dip at NULL loop in ReTX + Vectoring enabled case"
//                 At present as a workaround octet 8 (Maximum upstream net data rate) of G.998.4 parameter field for R-MSG2
//                 set to a value of 50 mbps.
//
// 29/10/2014 Anantha Ramu: Modifications to convey CPE capabilities for Intra DTU Interleaving done.
//                          Grep for "XDSLRTFW-1617"
//
//18/11/2014 Palaksha:Workaround for VR9 CPE issue 'XDSLRTFW-2016: No connects against Huawei BDCM LC when VDSL2 RTXus enabled on VRx CPE'.
//           The CO is having problem when octet 8 (Maximum upstream net data rate) of 'G.998.4 parameter field for R-MSG2'
//           set to a value of around 50 mbps. As a workaround use Maximum upstream net data rate value of 49.2Mbps for upto
//           17a profiles against BRCM CO and for 30a profile 100 mpbs. The real root cause needs to be understood.
//       Grep for XDSLRTFW-2016
//
// 8/10/2014 Vinay: Added code to support reporting of 3 more parameters (Recieve signal, Transmit signal, SOC message) to STAT 0
//            Grep for XDSLRTFW-1901
//
// 21/05/2015 Palaksha/Vinay GR: XDSLRTFW-2368 : Enable Debug Traces in VRx318
//            Debug trace feature is enabled for VRX318 platform all modes except
//            when RTXds or RTXus or both enabled in 30a, Debug trace will be captured
//            only till Training (Until ROP_SYNCHR6) and in showtime this will be disabled
//            Grep for "XDSLRTFW-2368"
//
// 01/06/2016 Vinay: Added code to indicate available memory in case of VDSL2 35B mode in VRx518.
//          Grep for XDSLRTFW-2757
// 15/12/2017 Kannan: Update of 35B mode iDTU HQV table. This change is required to compute max DTU
//                    size and is required for memory allocation.
//          Grep for XDSLRTFW-3562
// **************************************************************************************************

#include <string.h>
#include "common.h"
#include "gdata.h"
#include "socmessage.h"
#include "DebugBuffer.h"
#include "cmv.h"
#include "zep_memmap_cnfg.h"
#include "vdsl_const.h"
#include "dsp_op.h"  //XDSLRTFW-3189 (Start_End)

extern int16 GetMaxDtuSizePerProfile(int16 s_Direction);
//XDSLRTFW-1617 (Start_End)
uint8 guc_IntraDtu_US_D = 0;
/*^^^
 *------------------------------------------------------------------------
 *
 *
 *  Description:  Forms the CPE R-MSG2 message.
 *
 *  Prototype:
 *           void FormRMsg2Msg_VDSL2(void);
 *
 *
 *  Input Arguments:
 *      None
 *
 *  Output Arguments:
 *      None
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void FormRMsg2Msg_VDSL2(void)
{
   int16 i=0;
   uint8 j,k;
   uint8 uc_MaxNumDsTpsTc[MAX_TPS_TC_TYPE];
   uint8 uc_MaxNumUsTpsTc[MAX_TPS_TC_TYPE];
   TPS_TC_Type_t *pt_TpsTcType;
   //XDSLRTFW-3189 (Start)
   uint16 us_MaxDTUSizeDS;
   uint16 us_MaxDTUSizeUS;
   int16 idx;
   int16 MulFactor;
   uint32 ul_UsReTx_Qtx_Overhead_R;
   //XDSLRTFW-3189 (End)

   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START)
   gsa_IndirectStat0[4]=VDSL2_R_P_MEDLEY;
   gsa_IndirectStat0[2]=VDSL2_R_MSG2;
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (END)

   // Populate R-MSG Message:
   gpuca_TxSocMsg[i++] = (uint8)VDSL2_SOC_MSG_R_MSG2;  // Msg code

   // Field2 : TPS-TC capabilities
   // ---------------------------------
   {
      uint8 uc_tmpmsg;

      // Maximum number of downstream TPS-TCs of each type
      // Byte format: [ssaapp00]
      gpuca_TxSocMsg[i] = 0;
      for(k=0; k < MAX_TPS_TC_TYPE_API; k++)
      {
         uc_MaxNumDsTpsTc[k] = 0;
         for (j=0; j < NUM_BEARER_CHANNELS; j++)
         {
            if (gta_DsBearerChannel[j].s_Control & gus_TpsTcType[k])
            {
               uc_MaxNumDsTpsTc[k]++;
            }
         }

         gpuca_TxSocMsg[i] |= (uc_MaxNumDsTpsTc[k] << (2+k*2));
      }
      i++;

      // Maximum number of upstream TPS-TCs of each type
      // Byte format: [ssaapp00]
      gpuca_TxSocMsg[i] = 0;
      for(k=0; k < MAX_TPS_TC_TYPE_API; k++)
      {
         uc_MaxNumUsTpsTc[k] = 0;
         for (j=0; j < NUM_BEARER_CHANNELS; j++)
         {
            if (gta_UsBearerChannel[j].s_Control & gus_TpsTcType[k])
            {
               uc_MaxNumUsTpsTc[k]++;
            }
         }

         gpuca_TxSocMsg[i] |= (uc_MaxNumUsTpsTc[k] << (2+k*2));
      }
      i++;

      // Supported combinations of downstream bearer channels and TPS-TCs
      // Byte format: [s0a0p0 0 s1a1p1 0]
      // API DS : CNFG 0 0 - Bit0 PTM : Bit1 ATM
      uc_tmpmsg = 0;

      if(gta_DsBearerChannel[BC0].s_Control & TPS_TC_TYPE_STM)
      {
         uc_tmpmsg |= TPS_TC_STM_BC0_SUPPORT;
      }
      if(gta_DsBearerChannel[BC0].s_Control & TPS_TC_TYPE_ATM)
      {
         uc_tmpmsg |= TPS_TC_ATM_BC0_SUPPORT;
      }
      if(gta_DsBearerChannel[BC0].s_Control & TPS_TC_TYPE_PTM)
      {
         uc_tmpmsg |= TPS_TC_PTM_BC0_SUPPORT;
      }
      if(gta_DsBearerChannel[BC1].s_Control & TPS_TC_TYPE_STM)
      {
         uc_tmpmsg |= TPS_TC_STM_BC1_SUPPORT;
      }
      if(gta_DsBearerChannel[BC1].s_Control & TPS_TC_TYPE_ATM)
      {
         uc_tmpmsg |= TPS_TC_ATM_BC1_SUPPORT;
      }
      if(gta_DsBearerChannel[BC1].s_Control & TPS_TC_TYPE_PTM)
      {
         uc_tmpmsg |= TPS_TC_PTM_BC1_SUPPORT;
      }
      gpuca_TxSocMsg[i++] = uc_tmpmsg;


      // Supported combinations of upstream bearer channels and TPS-TCs
      // Byte format: [s0a0p0 0 s1a1p1 0]
      // API US : CNFG 2 0 - Bit0 PTM : Bit1 ATM
      uc_tmpmsg = 0;

      if(gta_UsBearerChannel[BC0].s_Control & TPS_TC_TYPE_STM)
      {
         uc_tmpmsg |= TPS_TC_STM_BC0_SUPPORT;
      }
      if(gta_UsBearerChannel[BC0].s_Control & TPS_TC_TYPE_ATM)
      {
         uc_tmpmsg |= TPS_TC_ATM_BC0_SUPPORT;
      }
      if(gta_UsBearerChannel[BC0].s_Control & TPS_TC_TYPE_PTM)
      {
         uc_tmpmsg |= TPS_TC_PTM_BC0_SUPPORT;
      }
      if(gta_UsBearerChannel[BC1].s_Control & TPS_TC_TYPE_STM)
      {
         uc_tmpmsg |= TPS_TC_STM_BC1_SUPPORT;
      }
      if(gta_UsBearerChannel[BC1].s_Control & TPS_TC_TYPE_ATM)
      {
         uc_tmpmsg |= TPS_TC_ATM_BC1_SUPPORT;
      }
      if(gta_UsBearerChannel[BC1].s_Control & TPS_TC_TYPE_PTM)
      {
         uc_tmpmsg |= TPS_TC_PTM_BC1_SUPPORT;
      }
      gpuca_TxSocMsg[i++] = uc_tmpmsg;
   }

   // For each supported DS and US TPS-TC, the following data are specified (8 bytes):
   // Field2 bytes 5-6: Minimum Net Data Rate
   // Field2 bytes 7-8: Mamimum Net Data Rate
   // Field2 bytes 9-10: Minimum Reserved Data Rate
   // Field2 byte 11: Maximum PMS-TC latency
   // Field2 byte 12: Minimum INP
   for(k=0; k < MAX_TPS_TC_TYPE_API; k++)
   {
      for (j=0; j < NUM_BEARER_CHANNELS; j++)
      {
         if (gta_DsBearerChannel[j].s_Control & gus_TpsTcType[k])
         {
            pt_TpsTcType = &(gta_DsBearerChannel[j].ta_TpsTcType[k]);

            // According to the Hercules API, the data rates are computed as n*4 Kbps, where n is an
            // unsigned integer. The RMSG-2 units for these rates is a multiple of 8 Kbps therefore need to
            // decrease rate by a factor of 2.
            // Following constrain exists for the rates:
            //      net_min <= net_reserved <= net_max
            // XDSLRTFW-992: Bugfix_DS_All_All_ReservedNetDataRate (start_end)
            {
               gpuca_TxSocMsg[i++] = (uint8)((pt_TpsTcType->ul_MinNetDataRate >> 1) >> 8);
               gpuca_TxSocMsg[i++] = (uint8)(pt_TpsTcType->ul_MinNetDataRate >> 1);
               gpuca_TxSocMsg[i++] = (uint8)((pt_TpsTcType->ul_MaxNetDataRate >> 1) >> 8);
               gpuca_TxSocMsg[i++] = (uint8)(pt_TpsTcType->ul_MaxNetDataRate >> 1);
               if(pt_TpsTcType->ul_MinNetDataRate <= pt_TpsTcType->ul_MinResNetDataRate)
               {
                  gpuca_TxSocMsg[i++] = (uint8)((pt_TpsTcType->ul_MinResNetDataRate >> 1) >> 8);
                  gpuca_TxSocMsg[i++] = (uint8)(pt_TpsTcType->ul_MinResNetDataRate >> 1);
               }
               else
               {
                  gpuca_TxSocMsg[i++] = (uint8)((pt_TpsTcType->ul_MinNetDataRate >> 1) >> 8);
                  gpuca_TxSocMsg[i++] = (uint8)(pt_TpsTcType->ul_MinNetDataRate >> 1);
               }
            }

            gpuca_TxSocMsg[i++] = (uint8)(pt_TpsTcType->s_MaxLatency);
            gpuca_TxSocMsg[i++] = (uint8)(pt_TpsTcType->s_IMAxINP);
            gpuca_TxSocMsg[i++] = pt_TpsTcType->uc_TPSTCoptions;
         }
      }
   }

   for(k=0; k < MAX_TPS_TC_TYPE_API; k++)
   {
      for (j=0; j < NUM_BEARER_CHANNELS; j++)
      {
         if (gta_UsBearerChannel[j].s_Control & gus_TpsTcType[k])
         {
            pt_TpsTcType = &(gta_UsBearerChannel[j].ta_TpsTcType[k]);

            // According to the Hercules API, the data rates are computed as n*4 Kbps, where n is an
            // unsigned integer. The RMSG-2 units for these rates is a multiple of 8 Kbps therefore need to
            // decrease rate by a factor of 2.
            // Following constrain exists for the rates:
            //      net_min <= net_reserved <= net_max
            // XDSLRTFW-992: Bugfix_DS_All_All_ReservedNetDataRate (start_end)
            {
               gpuca_TxSocMsg[i++] = (uint8)((pt_TpsTcType->ul_MinNetDataRate >> 1) >> 8);
               gpuca_TxSocMsg[i++] = (uint8)(pt_TpsTcType->ul_MinNetDataRate >> 1);
               gpuca_TxSocMsg[i++] = (uint8)((pt_TpsTcType->ul_MaxNetDataRate >> 1) >> 8);
               gpuca_TxSocMsg[i++] = (uint8)(pt_TpsTcType->ul_MaxNetDataRate >> 1);
               if(pt_TpsTcType->ul_MinNetDataRate <= pt_TpsTcType->ul_MinResNetDataRate)
               {
                  gpuca_TxSocMsg[i++] = (uint8)((pt_TpsTcType->ul_MinResNetDataRate >> 1) >> 8);
                  gpuca_TxSocMsg[i++] = (uint8)(pt_TpsTcType->ul_MinResNetDataRate >> 1);
               }
               else
               {
                  gpuca_TxSocMsg[i++] = (uint8)((pt_TpsTcType->ul_MinNetDataRate >> 1) >> 8);
                  gpuca_TxSocMsg[i++] = (uint8)(pt_TpsTcType->ul_MinNetDataRate >> 1);
               }
            }

            gpuca_TxSocMsg[i++] = (uint8)(pt_TpsTcType->s_MaxLatency);
            gpuca_TxSocMsg[i++] = (uint8)(pt_TpsTcType->s_IMAxINP);
            gpuca_TxSocMsg[i++] = pt_TpsTcType->uc_TPSTCoptions;
         }
      }
   }

// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [Start]
   // PMS-TC capabilities (14 bytes)
   // ---------------------------------
   // Note: Before Amd1 the byte was called "Downstream dynamic interleaver"
   //       Support of dynamic change of interleaver depth in the downstream
   //       direction (see 9.4.1). A value of 0x00 indicates not supported.
   //       All other values are for further study.
   //       That means the SRA bit is only allowed to be set, if the Amd1 is supported
   //       by the CO.
   if (gul_dbgSocMsgControl2 & AMENDMENT1_OMSG1_SRA_SUPPORT)
   {
      guc_DsDynamicInlvEnable |= (gft_CapableRxAutoSRA << 2);  // see below: s = SRA_SUPPORTED_PER_AMENDMENT1 = 0x04
      guc_UsDynamicInlvEnable |= (gft_CapableTxSRA << 2);      // see below: s = SRA_SUPPORTED_PER_AMENDMENT1 = 0x04
   }
   // Field3 byte 1: DS OLR capabilities --> rrufdsii
   // ii=0, if interleaver reconfiguration (Dp change) is not supported on both paths
   // ii=01 if interleaver reconfig is supported on one of the DS paths
   // ii=10, is reserved
   // ii=11, if reconfig supported on both paths in DS
   // s=0, if DS SRA is not supported else s=1
   // f=0, if DS framin reconfiguration is not supported else f=1
   // d=0, is reserved
   // u=0, if DS SOS is not supported, else 1
   // rr=00, if ROC in DS is not supported
   // rr=01, if ROC is supported in DS but not dual latency
   // rr=11, if both ROC and dual latency are supported in DS, but only one can be enabled at a time
//   gpuca_TxSocMsg[i++] = guc_DsOlrCapabilities;
   gpuca_TxSocMsg[i++] = guc_DsDynamicInlvEnable;

   // Field3 byte 2: US OLR capabilities --> rrufdsii, same format as DS OLR capabilities
   // XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [End]
//   gpuca_TxSocMsg[i++] = guc_UsOlrCapabilities;
   gpuca_TxSocMsg[i++] = guc_UsDynamicInlvEnable;

   // Field3 byte 3: Downstream overhead datarate (rate = 1000*(N+1) bps)
   // where N is an 8 bit value. DFH: For now set min ovhd rate to 0 => 1 kbps
   gpuca_TxSocMsg[i++] = guc_DsMinMsgOHR;

   // Field3 byte 4: Upstream overhead datarate (rate = 1000*(N+1) bps)
   // where N is an 8 bit value.
   gpuca_TxSocMsg[i++] = guc_UsMinMsgOHR;

   // According to the Hercules API, the data rates are computed as m*4 Kbps, where m is
   // unsigned integer. The RMSG-2 units for these rates is a multiple of 8 Kbps therefore need to
   // decrease rate by a factor of 2.

   // Field3 bytes 5-6: Max DS rate for latency path 0
   gpuca_TxSocMsg[i++] = (uint8)((gta_DsLatencyPath[LP0].ul_MaxDataRate >> 1) >> 8);
   gpuca_TxSocMsg[i++] = (uint8)(gta_DsLatencyPath[LP0].ul_MaxDataRate >> 1);

   // Field3 bytes 7-8: Max US rate for latency path 0
   gpuca_TxSocMsg[i++] = (uint8)((gta_UsLatencyPath[LP0].ul_MaxDataRate >> 1) >> 8);
   gpuca_TxSocMsg[i++] = (uint8)(gta_UsLatencyPath[LP0].ul_MaxDataRate >> 1);

   // Field3 bytes 9-10: Max DS rate for latency path 1
   gpuca_TxSocMsg[i++] = (uint8)((gta_DsLatencyPath[LP1].ul_MaxDataRate >> 1) >> 8);
   gpuca_TxSocMsg[i++] = (uint8)(gta_DsLatencyPath[LP1].ul_MaxDataRate >> 1);

   // Field3 bytes 11-12: Max US rate for latency path 1
   gpuca_TxSocMsg[i++] = (uint8)((gta_UsLatencyPath[LP1].ul_MaxDataRate >> 1) >> 8);
   gpuca_TxSocMsg[i++] = (uint8)(gta_UsLatencyPath[LP1].ul_MaxDataRate >> 1);

   // Field3 bytes 13-14: Max DS/US 1/S
   gpuca_TxSocMsg[i++] = guc_DsOneOverSmax;
   gpuca_TxSocMsg[i++] = guc_UsOneOverSmax;

   if ((gul_dbgSocMsgControl2 & (AMENDMENT7_TIME_SYNC_SUPPORT | AMENDMENT5_VECTORING_SUPPORT |
                                 AMENDMENT5_RETX_SUPPORT | AMENDMENT3_OMSG1_SOS_ROC_SUPPORT)) ||
         (gft_EnableImprovedATTNDR == TRUE))
   {
      // hard code to skip over the 3-byte SOS field 4-6
      gpuca_TxSocMsg[i++] = 0;
      gpuca_TxSocMsg[i++] = 0;
      gpuca_TxSocMsg[i++] = 0;
   }

#ifdef DEBUG_GINP_MSGS
   gpuca_GINP_MsgBuf = gpuca_TxSocMsg;
   gl_GINP_StartIdx = i;
#endif

   // presume that ReTX params won't be sent
   gl_NoRetxMsg |= 0x10;

   // If the VTU-R does not support retransmission in either transmission direction, the number of
   // data bytes may be zero.
   // Note: The support for downstream retransmission is implied if the VTU-R includes an
   //       ITU-T G.998.4 parameter field that has a non-zero number of data bytes in it.
   if ((gul_dbgSocMsgControl2 & (AMENDMENT7_TIME_SYNC_SUPPORT | AMENDMENT5_VECTORING_SUPPORT | AMENDMENT5_RETX_SUPPORT)) ||
         (gft_EnableImprovedATTNDR == TRUE))
   {
      if ((gt_ReTXParams.uc_OMSG1_DsReTxEnabled == CO_RETX_CAPABLE) &&
          (gus_ReTxOptionsEnabled & (CPE_DS_US_RETX_CAPABLE|CPE_DS_RETX_CAPABLE)))
      {
         gl_NoRetxMsg &= ~0x10;

         //XDSLRTFW-1284 Feature_US_VDSL2_ALL_UsReTx_TrainingMessageChanges(START)
         // This Variable value transmitted in R-MSG2.G.INP.Field10.
         if (gus_ReTxOptionsEnabled & (G9984_ANNEXD_SUPPORT|US_INTRA_DTU_ILV_CAPABLE))
         {
            gpuca_TxSocMsg[i++] = 12;  //8; // Field 1: Octet 1 Parameter field length // send also total DILV/ILV buffer size
         }
         else
         {
            gpuca_TxSocMsg[i++] =  8;  //8; // Field 1: Octet 1 Parameter field length
         }
         //XDSLRTFW-1284 Feature_US_VDSL2_ALL_UsReTx_TrainingMessageChanges(END)

         // XDSLRTFW-1045 Feature_US_VDSL2_ALL_UsReTx(START)
         // Note: A value of 0 indicates that retransmission is not supported in the upstream direction.
         gpuca_TxSocMsg[i++] = ((gus_ReTxOptionsEnabled & CPE_DS_US_RETX_CAPABLE)>>1) ;

         {
            // XDSLRTFW-1545(START_END)
            // Set the US framing type supported to zero if DS ReTx only is enabled
            // Standard says: " At least one of the bits a, b or c shall be set to 1
            //                  when retransmission is supported in the upstream direction."
            if(((gus_ReTxOptionsEnabled & CPE_DS_US_RETX_CAPABLE) >> 1) == 0)
            {
               gt_UsReTx_ConfigVar.s_UsReTx_FrameType_Support = 0;
            }
            //XDSLRTFW-1193 Feature_US_VDSL2_ALL_UsReTx_CMV(START_END)
            // DTU optional framing types => framing type 1 and framing type 3
            gpuca_TxSocMsg[i++] = (gt_UsReTx_ConfigVar.s_UsReTx_FrameType_Support & 0x0007);
         }

         gt_ReTXParams.uc_RMSG2_CpeTxHalfRoundTripDelays=(((gt_UsReTx_ConfigVar.s_TxHalfRoundTripInDTUs & 0x3) << 4)|(gt_UsReTx_ConfigVar.s_TxHalfRoundTripInSymbols & 0xF));
         gt_ReTXParams.uc_RMSG2_Us1overSMax = guc_UsOneOverSmax;
         gt_ReTXParams.uc_RMSG2_Ds1overSMax = guc_DsOneOverSmax;
         //XDSLRTFW-1707_30a_RTX_DsUs (Start)
         if (gs_frame_rate_is_8khz)
         {
            gt_ReTXParams.us_RMSG2_UsNetDataRateMax= 12500; //6250*2; // 100Mbps => as multiple of 8kbps (100*1000/8)
            // XDSLRTFW-2368 (Start)
            //DebugBufferTrace
            if ( (TESTArray[TEST_Control3] & TEST_Control3_Test28_Bit7Mask_DISDEBUGTRACE) && (gus_ReTxOptionsEnabled & (CPE_DS_US_RETX_CAPABLE|CPE_DS_RETX_CAPABLE)))
            {
               gul_ItlvMemSizeReTxRMsg2 = (ILV_DILV_MEM_INDICATION_IN_R_MSG2_30A_NODEBUGTRACE << 1);//This Variable value transmitted in R-MSG2.G.INP.Field10.
            }
            else
            {
               gul_ItlvMemSizeReTxRMsg2 = (ILV_DILV_MEM_INDICATION_IN_R_MSG2_30A << 1);//This Variable value transmitted in R-MSG2.G.INP.Field10.
            }
            // XDSLRTFW-2368 (End)

            //XDSLRTFW-3189 (Start)
            idx = (MAX_HQV_IDX_DS_PROFILE_30a_WITHOUT_IDTU -1) * 3;
            //(H * Q) * DSRETX_MIN_DTUs_REQOVERQTX
            gs_MemSize_DsReTx_MinDtus_ReqOverQtx = (guca_HQV[idx] * guca_HQV[idx+1]) * DSRETX_MIN_DTUs_REQOVERQTX;

            //Memory required to keep R in Us ReTx Queue as overhead by considering 100Mbps (US) out of 200Mbps
            //(in total DS & US)and 16 Bytes as Max R out of 141 Bytes as N
            // B9 = Available memory in bytes
            // H9 = Bytes for RTXds LP1 ILV processing
            // J9 = Reservation of 3*(Q*H)ds for Qrx w/o iDTU
            //CEILING((B9-H9-J9)*100/200*16/141,1)
            //CEILING((B9-H9-J9)*1/2*16/141,1)
            //CEILING((B9-H9-J9)*8/141,1)
            //CEILING((B9-H9-J9)*(2^3)/141,1)
            ul_UsReTx_Qtx_Overhead_R = ((gul_ItlvMemSizeReTxRMsg2 >> 1) - gs_MemSize_DsReTx_MinDtus_ReqOverQtx) << 3;
            ul_UsReTx_Qtx_Overhead_R = ceil32u(ul_UsReTx_Qtx_Overhead_R, 141);

            ul_UsReTx_Qtx_Overhead_R = (ul_UsReTx_Qtx_Overhead_R + 3) & 0xFFFFFFFC; //To align 32 bit word
            gul_ItlvMemSizeReTxRMsg2 -= ((gs_MemSize_DsReTx_MinDtus_ReqOverQtx + ul_UsReTx_Qtx_Overhead_R) << 1);
            gs_MemSize_UsReTx_Qtx_Overhead_R = ul_UsReTx_Qtx_Overhead_R;
            //XDSLRTFW-3189 (End)

#ifdef ILV_DBG_BUFFER
            //If IlvDbgBuffer Enabled
            if((gs_IlvDbgBufferControl & ILV_DBG_BUF_CNTRL_ENABLE_MASK) == TRUE)
            {
               gul_ItlvMemSizeReTxRMsg2 -= (ILV_DBG_BUFFER_SIZE<<1); // reduce reported ILV/DILV size by the size of MegaBuffer
            }
#endif
         }
         else
         {
            // XDSLRTFW-2046 Restoring US MAXIMUM NET DATA RATE in R-MSG2 to 50 mbps
            //This is because if we increase to 51 then DS NDR will come down by 1 mbps and so on
            //
            // XDSLRTFW-2016 (Start)
            if (gul_fe_G994VendorID == BRCM_VENDOR_ID)
            {
               gt_ReTXParams.us_RMSG2_UsNetDataRateMax = 6150; // 49.2Mbps => as multiple of 8kbps (49200*1000/8)
            }
            else
            {
               gt_ReTXParams.us_RMSG2_UsNetDataRateMax = 6250; // 50Mbps => as multiple of 8kbps (50*1000/8)
            }
            // XDSLRTFW-2016 (End)

            // XDSLRTFW-3744: US ReTx 0m rate issue in Magyar Telekom tests (NDR: 50 instead of 60Mbps)
            //    Only for operators MT and OTE we allow a MaxNDR of 60Mbps if ReTx and
            //    vectoring is enabled.
            //    Reason to not enable it in general: Versus older DSLAMs with less CO memory this
            //    may lead to reduced DS rates.
            //    TODO: Maybe link this to a CMV bit.
            if (((gt_Dsl_Operator_Select.us_Operator_Select == MT_HUNGARY)
                  || (gt_Dsl_Operator_Select.us_Operator_Select == OTE_GREECE))
                  && (gft_DSVectoringEnabled == TRUE))
            {
               gt_ReTXParams.us_RMSG2_UsNetDataRateMax = 7500; // 60Mbps => as multiple of 8kbps (60*1000/8)
            }

            // XDSLRTFW-2757 (Start_End)
            if (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK)
            {
               gt_ReTXParams.us_RMSG2_UsNetDataRateMax = 12500;   // 100Mbps => as multiple of 8kbps (100*1000/8)
               //gul_ItlvMemSizeReTxRMsg2 = (ILV_DILV_MEM_INDICATION_IN_R_MSG2_35B << 1);  // This Variable value transmitted in R-MSG2.G.INP.Field10.
            }

            //XDSLRTFW-3189 (Start)
            //XDSLRTFW-3338 (Start)
            //For profiles <=17a without Intra DTU interleaving.
            if (gft_Intra_DTU_Ilv_DS == FALSE)
            {

               idx = (MAX_HQV_IDX_DS_PROFILE_8_12_17_WITHOUT_IDTU - 1) * 3;

               //XDSLRTFW-3322 (Start)
               if (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK)
                  idx = (MAX_HQV_IDX_DS_PROFILE_35b_WITHOUT_IDTU - 1) * 3;
               //XDSLRTFW-3322 (End)

               //(H * Q) * DSRETX_MIN_DTUs_REQOVERQTX
               gs_MemSize_DsReTx_MinDtus_ReqOverQtx = (guca_HQV[idx] * guca_HQV[idx+1]) * DSRETX_MIN_DTUs_REQOVERQTX;


               MulFactor = 3;  //For <=17a

               if (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK)
                  MulFactor = 4;

               //For profiles <= 17a - start
               //Memory required to keep R in Us ReTx Queue as overhead by considering 50Mbps (US) out of 150Mbps
               //(in total DS & US)and 16 Bytes as Max R out of 141 Bytes as N
               // B8 = Available memory in bytes
               // H8 = Bytes for RTXds LP1 ILV processing
               // J8 = Reservation of DSRETX_MIN_DTUs_REQOVERQTX*(Q*H)ds for Qrx w/o iDTU
               //CEILING((B8-H8-J8)*50/150*16/141,1)
               //CEILING((B8-H8-J8)*1/3*16/141,1)
               //CEILING((B8-H8-J8)*16/(3*141),1)
               //CEILING((B8-H8-J8)*(2^4)/(3*141),1)
               //CEILING((B8-H8-J8)*(2^4)/(423),1)
               //For profiles <= 17a - end

               //For profile 35b - start
               //Memory required to keep R in Us ReTx Queue as overhead by considering 100Mbps (US) out of 400Mbps
               //(in total DS & US)and 16 Bytes as Max R out of 141 Bytes as N
               // B12 = Available memory in bytes
               // H12 = Bytes for RTXds LP1 ILV processing
               // J12 = Reservation of DSRETX_MIN_DTUs_REQOVERQTX*(Q*H)ds for Qrx w/o iDTU
               //CEILING((B12-H12-J12)*100/150*16/141,1)
               //CEILING((B12-H12-J12)*1/4*16/141,1)
               //CEILING((B12-H12-J12)*16/(4*141),1)
               //CEILING((B12-H12-J12)*(2^4)/(4*141),1)
               //CEILING((B12-H12-J12)*(2^4)/(423),1)
               //For profiles <= 17a - end

               ul_UsReTx_Qtx_Overhead_R = ((gul_ItlvMemSizeReTxRMsg2 >> 1) - gs_MemSize_DsReTx_MinDtus_ReqOverQtx) << 4;
               ul_UsReTx_Qtx_Overhead_R = ceil32u(ul_UsReTx_Qtx_Overhead_R, (MulFactor * 141));
               ul_UsReTx_Qtx_Overhead_R = (ul_UsReTx_Qtx_Overhead_R + 3) & 0xFFFFFFFC; //To align 32 bit word
               //For profiles 35b Lite - start
//#ifdef ANXQ_35BLITE
//               //Memory required to keep R in Us ReTx Queue as overhead by considering 50Mbps (US) out of 150Mbps
//               //(in total DS & US)and 16 Bytes as Max R out of 141 Bytes as N
//               //CEILING((B8-H8-J8)*25/150*16/141,1)
//               //CEILING((B8-H8-J8)*1/6*16/141,1)
//               //CEILING((B8-H8-J8)*16/(6*141),1)
//               //CEILING((B8-H8-J8)*8/(3*141),1)
//               //CEILING((B8-H8-J8)*(2^3)/(3*141),1)
//               //CEILING((B8-H8-J8)*(2^3)/(423),1)
//#endif
               //For profiles 35b Lite - end
               gul_ItlvMemSizeReTxRMsg2 -= ((gs_MemSize_DsReTx_MinDtus_ReqOverQtx + ul_UsReTx_Qtx_Overhead_R) << 1);
               gs_MemSize_UsReTx_Qtx_Overhead_R = ul_UsReTx_Qtx_Overhead_R;
               //XDSLRTFW-3189 (End)
               //XDSLRTFW-3338(End)
            }
#ifdef ILV_DBG_BUFFER
            //If IlvDbgBuffer Enabled
            if((gs_IlvDbgBufferControl & ILV_DBG_BUF_CNTRL_ENABLE_MASK) == TRUE)
            {
               gul_ItlvMemSizeReTxRMsg2 -= (ILV_DBG_BUFFER_SIZE<<1); // reduce reported ILV/DILV size by the size of MegaBuffer
            }
#endif
         }

         // VTU-R Tx and Rx roundtrip delays
         // Field 4:Octet 4 VTU-R Half Roundtrip Tx
         gpuca_TxSocMsg[i++] = gt_ReTXParams.uc_RMSG2_CpeTxHalfRoundTripDelays;
         // Field 5:Octet 5 VTU-R Half Roundtrip Rx
         gpuca_TxSocMsg[i++] = gt_ReTXParams.uc_RMSG2_CpeRxHalfRoundTripDelays;

         //XDSLRTFW-1707_30a_RTX_DsUs (End)
         // Note: The order is switched compared to IFEC, i.e. Table 12-62 PMS-TC capabilities of VTU-R
         // Field 6:Octet 6 US(1/S)max
         gpuca_TxSocMsg[i++] = gt_ReTXParams.uc_RMSG2_Us1overSMax;
         // Field 7:Octet 7 DS(1/S)msx
         gpuca_TxSocMsg[i++] = gt_ReTXParams.uc_RMSG2_Ds1overSMax;

         // field 8 : Octet 8 and 9 : Maximum US Net Data Rate
         gpuca_TxSocMsg[i++] = (uint8)(gt_ReTXParams.us_RMSG2_UsNetDataRateMax >> 8);
         // XDSLRTFW-1246: Bugfix_US_VDSL2_ALL_WrongCoding (Start/End)
         gpuca_TxSocMsg[i++] = (uint8)(gt_ReTXParams.us_RMSG2_UsNetDataRateMax & 0xFF);
         //XDSLRTFW-1045 Feature_US_VDSL2_ALL_UsReTx(END)

         // XDSLRTFW-1182: Bugfix_US_VDSL2_ALL_LowUsRate (Start)
         // This Variable value transmitted in R-MSG2.G.INP.Field10.
         //XDSLRTFW-1284 Feature_US_VDSL2_ALL_UsReTx_TrainingMessageChanges(START)
         if (gus_ReTxOptionsEnabled & (G9984_ANNEXD_SUPPORT|US_INTRA_DTU_ILV_CAPABLE))
         {
            //XDSLRTFW-1617 (Start)
            gpuca_TxSocMsg[i] = 1;// Field 9 : Octet 10 : US D1 Value Supported
            if (gus_ReTxOptionsEnabled & US_INTRA_DTU_ILV_CAPABLE)
            {
               //The following value populated to gpuca_TxSocMsg[] indicates Max D supported by CPE in US ReTx.
               //The MSB of this value if set to 0, indicates to CO that CPE supports all values of D upto Max D
               //what is indicated. If this bit is set to 1 it indicates to CO that CPE supports only values of
               //powers of 2.
               gpuca_TxSocMsg[i] = US_MAX_INTRA_DTU_ILV_D ;  // Field 9 : Octet 10 : US D1 Value Supported
               guc_IntraDtu_US_D = gpuca_TxSocMsg[i];
            }
            i++;
            //XDSLRTFW-1617 (End)

            //XDSLRTFW-2590 (Start)
            //If INTRA DTU interleaving is enabled on both sides, account for memory requirement corresponding
            //to Ping-Pong DTU processing buffers (in both US and DS directions)
            if (gft_Intra_DTU_Ilv_DS == TRUE)
            {
               uint8 *uca_hqv_table;
               uint16 us_Den;
               int16 s_idx;
               uint8 Rp;

               uca_hqv_table = (guc_DS_ReTx_Max_D_CO_support & 0x80) ? guca_HQV_IDILV_Pow2:guca_HQV_IDILV;

               //XDSLRTFW-3189(Start)
               //XDSLRTFW-3338(Start)
               idx = (MAX_HQV_IDX_DS_PROFILE_8_12_17_WITH_IDTU - 1) * 3;

               //Required memory for Ping and Pong buffer (PPB) = (H + R) * Q
               us_MaxDTUSizeUS = MAX_DTU_SIZE_US_PROFILE_8_12_17_WITH_IDTU;
               us_Den = 18; //For <= 17a profile

               //XDSLRTFW-3322 (Start)
               if (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK)
               {
                  //XDSLRTFW-3493(Start)
                  if (TESTArray[TEST_Control4] & TEST_Control4_Enhanced_ReTx_Framing_Bit10_Mask)
                  {
                     //XDSLRTFW-3590 (Start)
                     guc_DS_ReTx_iDTU_R = 8; //Use R=8 for 35b with iDTU if Enhanced ReTx framing is used.
                     idx = MAX_HQV_IDX_DS_PROFILE_35b_WITH_IDTU_R08;
                     //XDSLRTFW-3590 (End)
                  }
                  else
                  {
                     //XDSLRTFW-3590 (Start-End)
                     guc_DS_ReTx_iDTU_R = 16; //Use R=16 for 35b with iDTU if Enhanced ReTx framing is disabled.
                     idx = MAX_HQV_IDX_DS_PROFILE_35b_WITH_IDTU;
                  }
                  //XDSLRTFW-3493(End)

                  idx = (idx - 1) * 3;

                  us_MaxDTUSizeUS = MAX_DTU_SIZE_US_PROFILE_35B_WITH_IDTU;
                  us_Den = 24; //For 35b profile
                  //XDSLRTFW-3562_DS_SRA_NOT_TRIGGERED_AT_150m_START
                  //Need to update the HQV table here to compute the
                  //Max DTU size based on the Max HQV table index.
                  Rp = guc_DS_ReTx_iDTU_R;

                  if ((Rp > 4) && (Rp < 12))
                  {
                     s_idx = 15 * 3;
                     uca_hqv_table[s_idx]     = 245; //Hp
                     uca_hqv_table[s_idx + 1] = 4;   //Qp
                     uca_hqv_table[s_idx + 2] = 3;   //Vp

                     s_idx = 30 * 3;
                     uca_hqv_table[s_idx]     = 244; //Hp
                     uca_hqv_table[s_idx + 1] = 8;   //Qp
                     uca_hqv_table[s_idx + 2] = 0;   //Vp

                     s_idx = 60 * 3;
                     uca_hqv_table[s_idx]     = 244; //Hp
                     uca_hqv_table[s_idx + 1] = 16;  //Qp
                     uca_hqv_table[s_idx + 2] = 2;   //Vp
                  }

                  if ((Rp > 4) && (Rp < 16))
                  {
                     s_idx = 59 * 3;
                     uca_hqv_table[s_idx]     = 240; //Hp
                     uca_hqv_table[s_idx + 1] = 16;  //Qp
                     uca_hqv_table[s_idx + 2] = 3;   //Vp
                  }
                  //XDSLRTFW-3562_DS_SRA_NOT_TRIGGERED_AT_150m_END
               }
               //XDSLRTFW-3322 (End)

               //(H * Q) * DSRETX_MIN_DTUs_REQOVERQTX
               gs_MemSize_DsReTx_MinDtus_ReqOverQtx = (uca_hqv_table[idx] * uca_hqv_table[idx+1]) * DSRETX_MIN_DTUs_REQOVERQTX;

               //XDSLRTFW-3493(Start)
               //Required memory for Ping and Pong buffer (PPB) = (H + R) * Q
               us_MaxDTUSizeDS = ((uca_hqv_table[idx] + guc_DS_ReTx_iDTU_R) * uca_hqv_table[idx+1]);
               //XDSLRTFW-3493(End)

               gul_ItlvMemSizeReTxRMsg2 += (DS_RETX_LP1_PROCESSING << 1); //This constant was subtracted in #define and is being initialized to  gul_ItlvMemSizeReTxRMsg2 and the subtraction is not requred for intra dtu interleaving, So we are undoing the subtraction.

               //For <=17a profiles
               //Memory required to keep R in Us ReTx Queue as overhead by considering 50Mbps (US) out of 150Mbps
               //(in total DS & US)and 16 Bytes as Max R out of 96 Bytes as N
               //B8 = Available memory in bytes
               //F8 = DS Ping-Pong-Buffer size in bytes
               //G8 = US Ping Pong Buffer size
               //I8 = Reservation of DSRETX_MIN_DTUs_REQOVERQTX*(Q*H)ds for Qrx w/ iDTU
               //CEILING((B8-F8-G8-I8)*50/150*16/96,1)
               //ceil(Available Memory - DS PPB - US PPB - Mem for DSRETX_MIN_DTUs_REQOVERQTX DTUs for DS ReTx over Qtx) * 50/150*16/96)
               //ceil(Available Memory - DS PPB - US PPB - Mem for DSRETX_MIN_DTUs_REQOVERQTX DTUs for DS ReTx over Qtx)/18)

               //For 35b profile
               //Memory required to keep R in Us ReTx Queue as overhead by considering 100Mbps (US) out of 400Mbps
               //(in total DS & US)and 16 Bytes as Max R out of 96 Bytes as N
               //B12 = Available memory in bytes
               //F12 = DS Ping-Pong-Buffer size in bytes
               //G12 = US Ping Pong Buffer size
               //I12 = Reservation of DSRETX_MIN_DTUs_REQOVERQTX*(Q*H)ds for Qrx w/ iDTU
               //CEILING((B8-F8-G8-I8)*100/400*16/96,1)
               //ceil(Available Memory - DS PPB - US PPB - Mem for DSRETX_MIN_DTUs_REQOVERQTX DTUs for DS ReTx over Qtx) * 100/400*16/96)
               //ceil(Available Memory - DS PPB - US PPB - Mem for DSRETX_MIN_DTUs_REQOVERQTX DTUs for DS ReTx over Qtx)/24)

               ul_UsReTx_Qtx_Overhead_R = ((gul_ItlvMemSizeReTxRMsg2 >> 1) - ((us_MaxDTUSizeDS + us_MaxDTUSizeUS) << 1) - gs_MemSize_DsReTx_MinDtus_ReqOverQtx);
               ul_UsReTx_Qtx_Overhead_R = ceil32u(ul_UsReTx_Qtx_Overhead_R, us_Den);
               ul_UsReTx_Qtx_Overhead_R = (ul_UsReTx_Qtx_Overhead_R + 3) & 0xFFFFFFFC; //To align 32 bit word
               gul_ItlvMemSizeReTxRMsg2 -= ((((us_MaxDTUSizeDS + us_MaxDTUSizeUS) <<1 ) + gs_MemSize_DsReTx_MinDtus_ReqOverQtx + ul_UsReTx_Qtx_Overhead_R) << 1);
               gus_MaxDTUSizeDS_iDTU = us_MaxDTUSizeDS;
               gus_MaxDTUSizeUS_iDTU = us_MaxDTUSizeUS;
               gs_MemSize_UsReTx_Qtx_Overhead_R = ul_UsReTx_Qtx_Overhead_R;
               //XDSLRTFW-3189(End)
               //XDSLRTFW-3338(End)
            }
            //XDSLRTFW-2590 (End)

            // XDSLRTFW-1693 (Start_End)
            // Field #10 extended memory is supported for [ITU-T G.993.5 and  G.993.2] operation.
            if (gus_ReTxOptionsEnabled & G9984_ANNEXD_SUPPORT)
            {
               // Field 10 : Octet 11-12-13 : Extended memory for vectoring
               gpuca_TxSocMsg[i++] = (uint8)((gul_ItlvMemSizeReTxRMsg2 >> 16) & 0xFF);   // example value 0x123456 : byte 0x12
               gpuca_TxSocMsg[i++] = (uint8)((gul_ItlvMemSizeReTxRMsg2 >>  8) & 0xFF);   // example : byte 0x34
               gpuca_TxSocMsg[i++] = (uint8)((gul_ItlvMemSizeReTxRMsg2 >>  0) & 0xFF);   // example : byte 0x56

               gus_DsUsReTxStatus |= RETX_EXTENDED_MEMORY_IN_USE;
            }
            else
            {
               // It is a 24-bit field that shall be coded as 000000
               gpuca_TxSocMsg[i++] = 0;
               gpuca_TxSocMsg[i++] = 0;
               gpuca_TxSocMsg[i++] = 0;
            }
         }
         //XDSLRTFW-1284 Feature_US_VDSL2_ALL_UsReTx_TrainingMessageChanges(END)
         // XDSLRTFW-1182: Bugfix_US_VDSL2_ALL_LowUsRate (End)
      }
      else
      {
         gpuca_TxSocMsg[i++] = 0;
      }
   }

   // Place holder for G.vector variable length field
   if ((gul_dbgSocMsgControl2 & (AMENDMENT7_TIME_SYNC_SUPPORT | AMENDMENT5_VECTORING_SUPPORT)) ||
         (gft_EnableImprovedATTNDR == TRUE))
   {
      gpuca_TxSocMsg[i++] = 0;
   }

#ifdef DEBUG_GINP_MSGS
   gl_GINP_MsgLength = i;
   if (guc_DebugReTXTrainingMsg == 0x1a)
   {
      _flag(1);
   }
#endif
   // XDSLRTFW-1877 : VDSL2 IFEC ATTNDR (Start)
//      if ((gus_ReTxOptionsEnabled & G9984_ANNEXD_SUPPORT) &&
//      (gt_ReTXParams.uc_amend2_support & CO_RETX_DS_OPT_BLK_ILV_SUPPPORT))

   //XDSLRTFW-1285/1538 Feature_US_VDSL2_ALL_UsReTxAmend2_ATTNDR(Start_End)
   if ((gul_dbgSocMsgControl2 & AMENDMENT7_TIME_SYNC_SUPPORT) || (gft_EnableImprovedATTNDR == TRUE))
   {
      gpuca_TxSocMsg[i++] = 0;//Synchronisation capability
      gpuca_TxSocMsg[i++] = 0;//Synchronisation period
   }

   if (gft_EnableImprovedATTNDR == TRUE)
   {
      // m=1 indicates the VTU-R supports the improved method of ATTNDR calculation.
      // m=0 indicates the VTU-R does not support the improved method of ATTNDR calculation.
      gpuca_TxSocMsg[i++] = gft_EnableImprovedATTNDR;
   }
   // XDSLRTFW-1877 : VDSL2 IFEC ATTNDR (End)


   //Set msg buffer length for HDLC encapsulation
   gs_NumOctetsInTxHDLCMsg = i;

#ifdef DEBUG_TRACES
   // XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer(START_END)
   LogMessages(4,(uint16)gpuca_TxSocMsg[0], (uint16)i, gpuca_TxSocMsg, DEBUG_BUFFER_DELIMITER_VDSL2);
#endif
   memcpy(&gsa_DebugStreamBuffer[2][0],gpuca_TxSocMsg,(uint16)i);
   DSH_SendStream(DSH_R_MSG2, (uint16)(i),(void *)&gsa_DebugStreamBuffer[2][0]);

   gs_FormMsgFlag = TRAINING_DONE;

}
