/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright C 2016 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;   The function for forming R-PMD message.
;
*****************************************************************************/
// ***********************************************************************************************************
// FormRPmdMsg_VDSL2.c
//
// History
//
// 25/08/2014 Prashant : Send proper "Initialization status" in R-PMD in case of bitload/framing failure.
//                       Instead of immediately failing due to exception.
//                       Initialization status in R-PMD is updated as defined in standard G.993.2 [Sec. 12.3.5.2.2.4, R-PMD]
//                       Grep for XDSLRTFW-1958
//
// ************************************************************************************************************
#include <string.h>
// "vdsl_compiler.h", "vdsl_const.h", "sys_const.h" is included in "common.h"
#include "common.h"
#include "gdata.h"
#include "socmessage.h"
#include "ToneReorder.h"
#include "dsp_op.h"
#include "decimalgain.h"
#include "cmv.h"


/*^^^
 *------------------------------------------------------------------------
 *
 *
 *  Description:  Forms the R-PMD message.
 *
 *  Prototype:
 *           void FormRPmdMsg_VDSL2(void);
 *
 *
 *  Input Arguments:
 *      None
 *
 *  Output Arguments:
 *      None
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void FormRPmdMsg_VDSL2(void)
{
   int16 i;
   int16 sa_tempPilotTones[MAX_NUM_PILOT_TONES];

   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START)
   gsa_IndirectStat0[4]=VDSL2_R_P_MEDLEY;
   gsa_IndirectStat0[2]=VDSL2_R_PMD;
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (END)
   /*****************************************************************************************************
    Note: These lines (//cc ) were optimzed by Tung - but did not change the functionality.
      and it avoided a bad compile with the 8.2 arc compiler.
      The use of  x = function(x , ... ) is suspected to have caused register confusion with r0, which held
      1 and then held an index.
   ***************************************************************************************************** */
   i = 0;
// Populate R-PMD Message:
   // Field1 Msg code
   gpuca_TxSocMsg[i++] = (uint8)VDSL2_SOC_MSG_R_PMD;  // Msg code

   // Field2 Trellis (whether trellis coding will be used)
   gpuca_TxSocMsg[i++] = gft_RxTcmFlag;

   // Field3 Bits and gains table for active sub-carriers (2*Nsc bytes
   //        where Nsc is # used carriers)
   {
      int16 j, s_channel;
      int16 s_RxFineGain;
      int32 l_InvGain;
      uint16 us_EncodedVal, us_GainScaleFactor;
      uint8 uc_NumEncodedBits;

      for (j = 0; j<gs_NumOfRxBands; j++ )
      {
         for (s_channel = gsa_RxBandLeftChannel[j]; s_channel <= gsa_RxBandRightChannel[j]; s_channel++)
         {
            uc_NumEncodedBits = ghpuca_RxBat_Inactive[s_channel] & 0xF;  // 4 bits

            // Returns gain in Q3.13 format, so round and clear the 4 LSBs
            s_RxFineGain = DecimalGain(ghpsa_RxFineGains_Inactive[s_channel]);
            s_RxFineGain = (s_RxFineGain + (1 << 3)) & 0xFFF0;

            // Convert to Q7.9 format
            us_GainScaleFactor = (s_RxFineGain >> 4);

            us_EncodedVal = (uc_NumEncodedBits<<12) | (us_GainScaleFactor & 0x0FFF);

            gpuca_TxSocMsg[i++] = us_EncodedVal>>8;
            gpuca_TxSocMsg[i++] = (uint8)us_EncodedVal;

            // Store 1/finegain in HW buffer (3.13 format):
            // Note: Use the same 12-bit fine gain value that will be sent to the far end.
            if (s_RxFineGain != 0)
            {
               l_InvGain = NormAndDivide_32by16bit(((int32)1<<30), s_RxFineGain);
               l_InvGain = round(l_InvGain, 4);
               //s_RxFineGain = (int16)l_InvGain;
               s_RxFineGain = sature16(l_InvGain);
            }
            ghpsa_RxFineGains_Inactive[s_channel] = s_RxFineGain; // store decimal form back into HW
         }
      }

   }

   // Field4 Tone ordering table for active sub-carriers
   //        (3*Nsc/2 bytes, where Nsc is # used carriers)
   {
      int16 s_SwapToneTransmission;

      s_SwapToneTransmission = FALSE;
      if (gul_dbgSocMsgControl2 & SWAP_TONE_INDEX_IN_TRT_MSG_EXCHANGE)
      {
         s_SwapToneTransmission = TRUE;
      }
      EncodeTones(&i, gs_RxNumTonesUsed, &ghpsa_RxToneOrder_Inactive[RX_NUM_OUT_BAND_ZERO_BIT_TONE],
                  gpuca_TxSocMsg, s_SwapToneTransmission);
   }

   // XDSLRTFW-1958 (Start)
   // If an initialization success/failure code is 0x81 or 0x82,
   // all values in Field #2 to 4 shall be set to 0
   if ((guc_InitSuccessFailCode == INIT_CONFIG_ERROR) || (guc_InitSuccessFailCode == INIT_CONFIG_NOT_FEASIBLE))
   {
      memset(&gpuca_TxSocMsg[1], 0, sizeof(uint8)*(i - 1));
   }
   // XDSLRTFW-1958 (End)

   // XDSLRTFW-3280 - Start - PLL improvement / pilot tone selection improvement
   {
      int8 s_NumPilotTones=0;
      // Field5 pilot tones (tone descriptor)
      //XDSLRTFW-2302 Start
      if (gft_EnableShowPllToneSwitch)
      {
         int c_tmpArrayIdx=0;
         for (int k=0; k<MAX_NUM_PILOT_TONES; k++)
         {
            // XDSLRTFW-3654 Start [VRX518] B+V+R No connect due to repetitive low pilot tone in training
            // Only report Pilot tones which have an index !=0 and store them compressed to a temp array, excluding PTs with idx 0
            if(gt_PilotConfig.ta_PilotTones[k].s_PilotToneIdx != 0)
            {
               if(!gt_PilotConfig.ta_PilotTones[k].ft_DeRotatePilot)
               {
                  // Only communicate pilot tones _without_ data-on-pilot in R-PMD
                  sa_tempPilotTones[c_tmpArrayIdx] = gt_PilotConfig.ta_PilotTones[k].s_PilotToneIdx;
                  c_tmpArrayIdx++;
                  s_NumPilotTones++;
               }
            }
            // XDSLRTFW-3654 End [VRX518] B+V+R No connect due to repetitive low pilot tone in training
         }
      }
      else
      {
         // XDSLRTFW-1479 (Start_End)
         s_NumPilotTones=1;
         sa_tempPilotTones[0]= gt_PilotConfig.ta_PilotTones[gt_PilotConfig.te_UsedPTArrayIdx].s_PilotToneIdx;
      }
      // # of pilot tones
      gpuca_TxSocMsg[i++] = s_NumPilotTones;

      // Encode Pilot tone indexes
      EncodeTones(&i, s_NumPilotTones, &sa_tempPilotTones[0], gpuca_TxSocMsg, 0);
   }
   // XDSLRTFW-3280 - End - PLL improvement / pilot tone selection improvement

   // initialization status (per amendment_1); field #6, table 12-54
   if (gul_dbgSocMsgControl2 & (AMENDMENT1_OPMD_INITIALIZATION_STAT_SUPPORT |
                                AMENDMENT1_OPMS_MAX_DELAY_OCTET_SUPPORT |
                                AMENDMENT1_OTPS_MAX_DELAY_VAR_SUPPORT |
                                AMENDMENT1_OMSG1_SRA_SUPPORT |
                                AMENDMENT5_RETX_SUPPORT |
                                AMENDMENT5_VECTORING_SUPPORT))
   {
      // XDSLRTFW-1958 (Start)
      gpuca_TxSocMsg[i++] = guc_InitSuccessFailCode;
      // XDSLRTFW-1958 (End)
   }

   if (gul_dbgSocMsgControl2 & (AMENDMENT5_VECTORING_SUPPORT | AMENDMENT5_RETX_SUPPORT))
   {
      // Place holder for G.inp variable length field
      gpuca_TxSocMsg[i++] = 0;
   }
   if (gul_dbgSocMsgControl2 & AMENDMENT5_VECTORING_SUPPORT)
   {
      // Place holder for G.vector variable length field
      gpuca_TxSocMsg[i++] = 0;
   }


   gs_NumOctetsInTxHDLCMsg = i; // Set msg buffer length for HDLC encapsulation

   DSH_SendStream(DSH_R_PMD, (uint16)(i),(void *)gpuca_TxSocMsg);

   gs_FormMsgFlag = TRAINING_DONE;
}
