/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;   The function for forming R-PMS message.
;
*****************************************************************************/

//****************************************************************************
// FormRPmsMSg_VDSL2.c
//   History :
//
//  06/05/2013 Varun : Added code(Debug option) to capture raw data of all Tx(R-PMS in particular) and Rx-
//                     training messages (G.Hs + training)
//                    Grep for "XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer"
//
// 10/09/2013 Sooraj: Added framing changes to support DS-SRA with ReTx
//                    Grep for XDSLRTFW-1028_SRAds_Support_with_DS_ReTx
// 16/10/2013 Varun : Modified the message to support ReTx amend2
//                    Grep for XDSLRTFW-1284 Feature_US_VDSL2_ALL_UsReTx_TrainingMessageChanges
// 29/10/2013 Sooraj: Added framing changes to support US-SRA with ReTx
//                    Grep for XDSLRTFW-1261_SRAus_Support_with_US_ReTx
// 09/01/2014 MAHESH: Cleaned up R-PMS retx parameter fields & corrected the implementation for Amd1/Amd2
//                    Grep for XDSLRTFW-1455
// 21/02/2014 Fuss:   For RETX the mapping-of-bearer-channels-to-latency-paths is wrong -> BC1 must be disabled
//                    and not mapped to LP0
//                    Grep for: XDSLRTFW-992 Bugfix_DS_All_All_RetxBCtoLp (start_end)
// 27/06/2014 Varun : Added US ReTx only changes to R-PMS.
//                    Note that Amend1 appends US ReTx SRA support(Type-5) message to R-PMS at the end. Therefore we should send
//                    DS ReTx bytes with zero value in case US ReTx only in use
//                    Grep for XDSLRTFW-1607
// 29/10/2014 Anantha Ramu: CPE computed ReTx DS interleaver depth conveyed to VTU-O.
//                          Grep for "XDSLRTFW-1617"
//***************************************************************************
// "vdsl_compiler.h", "vdsl_const.h" is included in "common.h"
#include <string.h>
#include "common.h"
#include "gdata.h"
#include "socmessage.h"
#include "DebugBuffer.h"
#include "cmv.h"


extern ReTX_Params_t gt_ReTXParams;


/*^^^
 *------------------------------------------------------------------------
 *
 *
 *  Description:  Forms the R-PMS message.
 *
 *  Prototype:
 *           void FormRPmsMsg_VDSL2(void);
 *
 *
 *  Input Arguments:
 *      None
 *
 *  Output Arguments:
 *      None
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void FormRPmsMsg_VDSL2(void)
{
   int16 i;
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START)
   gsa_IndirectStat0[4]=VDSL2_R_P_MEDLEY;
   gsa_IndirectStat0[2]=VDSL2_R_PMS;
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (END)

   i = 0;
// Populate R-PMS Message:
   // Field1 Msg code
   gpuca_TxSocMsg[i++] = (uint8)VDSL2_SOC_MSG_R_PMS;

   // Field 2 MSG_LP - latency path (0 or 1) in which the message-based OH
   //                 information is to be transmitted (1 byte)
   gpuca_TxSocMsg[i++] = (uint8)gt_rx_TPS_Map.s_IBITSlp;

   // Field 3 Mapping of bearers to latency paths (1 byte)
   // XDSLRTFW-992 Bugfix_DS_All_All_RetxBCtoLp (start_end)
   if (gt_ReTXParams.uc_OMSG1_DsReTxEnabled == RETX_SELECTED)
   {
      gpuca_TxSocMsg[i++] = (uint8)((gt_rx_TPS_Map.s_BCtoLP[0] << 4)| 0xF);
   }
   else
   {
      gpuca_TxSocMsg[i++] = (uint8)((gt_rx_TPS_Map.s_BCtoLP[0] << 4)| gt_rx_TPS_Map.s_BCtoLP[1]);
   }


   // Field 4 / 5 -> Bx0 Bx1- number of bytes from bearer0 bearer1, per mux data frame (2 bytes)
   {
      int16 s_bc, s_lp;

      for (s_bc=0; s_bc<NUM_BEARER_CHANNELS; s_bc++)
      {
         // Check which latency path is assigned to s_bc
         s_lp = gt_rx_TPS_Map.s_BCtoLP[s_bc];

         if (s_lp != DISABLED_LP)
         {
            gpuca_TxSocMsg[i++] = (uint8)gt_rx_config_v2.sa_Bpn[s_lp][s_bc];
         }
         else
         {
            gpuca_TxSocMsg[i++] = 0;
         }
      }
   }

   // Field 6 / 7 -> Latency path descriptor
   {
      int16 s_lp;

      for (s_lp = 0; s_lp < NUM_DATA_PATHS; s_lp++)
      {
         if ((s_lp != 0) && (gt_ReTXParams.uc_OMSG1_DsReTxEnabled == RETX_SELECTED))
         {
            // LP1
            // the number of MDF in a sub-frame (1 byte) - Tp
            gpuca_TxSocMsg[i++] = 0;
            // the total number of OH bytes in a sub-frame (1 byte) - Gp
            gpuca_TxSocMsg[i++] = 0;
            // number of OH frames in the super-frame (1 byte) - Fp
            gpuca_TxSocMsg[i++] = 0;
         }
         else
         {
            // the number of MDF in a sub-frame (1 byte)
            gpuca_TxSocMsg[i++] = (uint8)gt_rx_config_v2.s_Tp[s_lp];

            // the total number of OH bytes in a sub-frame (1 byte)
            gpuca_TxSocMsg[i++] = (uint8)gt_rx_config_v2.s_Gp[s_lp];

            // number of OH frames in the super-frame (1 byte)
            gpuca_TxSocMsg[i++] = (uint8)gt_rx_config_v2.s_Fp[s_lp];
         }

         // Number of mux frames per codeword
         gpuca_TxSocMsg[i++] = (uint8)gt_rx_config_v2.s_Mp[s_lp];

         // Lp - the value of Lp per latency path (2/3 bytes)
         {
            uint32 ul_Temp;

            ul_Temp = gt_rx_config_v2.ul_Lp[s_lp];
            // ANXQ_SUPPORT
            // Note: The "& 0xFF" was done for better readability, but
            //       it is not need. The cast "(uint8)" is doing exactly
            //       the same!
            if (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK)
            {
               gpuca_TxSocMsg[i++] = (uint8)((ul_Temp >> 16) & 0xFF);
            }
            gpuca_TxSocMsg[i++] = (uint8)((ul_Temp >> 8) & 0xFF);
            gpuca_TxSocMsg[i++] = (uint8)(ul_Temp & 0xFF);
         }

         // the value of Rp per latency path
         gpuca_TxSocMsg[i++] = (uint8)gt_rx_config_v2.s_Rp[s_lp];

         if ((s_lp != 0) && (gt_ReTXParams.uc_OMSG1_DsReTxEnabled == RETX_SELECTED))
         {
            // the value of Ip per latency path
            gpuca_TxSocMsg[i++] = 0;

            // the value of Dp per latency path
            gpuca_TxSocMsg[i++] = 0;
            gpuca_TxSocMsg[i++] = 0;
         }
         else
         {
            // the value of Ip per latency path
            gpuca_TxSocMsg[i++] = (uint8)gt_rx_config_v2.s_Ip[s_lp];

            // the value of Dp per latency path
            gpuca_TxSocMsg[i++] = (uint8)(gt_rx_config_v2.s_Dp[s_lp] >> 8);
            gpuca_TxSocMsg[i++] = (uint8)(gt_rx_config_v2.s_Dp[s_lp] & 0xFF);
         }
      }
   }

   // Field 8
   // Erasure decoding capability (1 byte)
   gpuca_TxSocMsg[i++] = (uint8)gft_DsErasureDecodingFlag;

   if (gul_dbgSocMsgControl2 & (AMENDMENT5_VECTORING_SUPPORT | AMENDMENT5_RETX_SUPPORT |
                                AMENDMENT3_OMSG1_SOS_ROC_SUPPORT))
   {
      // Field #9 Downstream SOS tone groups
      gpuca_TxSocMsg[i++] = 0;                // Skip it, until it gets be supported.

      // Field #10 Downstream ROC parameters
      // - 10 or 11 (AnxQ) bytes for ROC descriptor!
      // G.993.2: "If the ROC is not enabled in the downstream direction, the values
      //           in the ROC descriptor shall all be set to zero and shall be ignored by the receiver."
      {
         signed int j;
         uint8 uc_UnpackXBitsOctetNum;

         uc_UnpackXBitsOctetNum = 10;
         if (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK)
         {
            uc_UnpackXBitsOctetNum++;
         }

         for (j = 0; j < uc_UnpackXBitsOctetNum; j++)
         {
            gpuca_TxSocMsg[i++] = 0;            // Disable ROC descriptor.
         }
      }
   }


#ifdef DEBUG_GINP_MSGS
   gpuca_GINP_MsgBuf = gpuca_TxSocMsg;
   gl_GINP_StartIdx = i;
#endif

   // presume that ReTX params won't be sent
   gl_NoRetxMsg |= 0x20;

   if (gul_dbgSocMsgControl2 & (AMENDMENT5_VECTORING_SUPPORT | AMENDMENT5_RETX_SUPPORT))
   {
      int16 Idx = i;
      //XDSLRTFW-1607(START_END)
      //enter when DS retx in use or US retx only in use, when us retx only then Ds retx parameters will be zero
      if ((gt_ReTXParams.uc_OMSG1_DsReTxEnabled == RETX_SELECTED) || (gt_ReTXParams.uc_UsReTxStatus == US_RETX_IN_USE))
      {
         //Total number of data bytes in G.998.4 parameter field
         gpuca_TxSocMsg[i++] = 5;            // params length

         gpuca_TxSocMsg[i++] = RPMS_DTU_FRAMING_TYPE;            //  currently support type 1 only

         gpuca_TxSocMsg[i++] = gt_ReTXParams.Un_UcodeReTXParam1.t_Param1.uc_CWsPerDtu_Q;        // RS CW per DTU

         gpuca_TxSocMsg[i++] = gt_ReTXParams.Un_UcodeReTXParam1.t_Param1.uc_DtuPaddingSize_V;   // padding octets per DTU

         gpuca_TxSocMsg[i++] = gt_ReTXParams.uc_RPMS_Qtx;

         gt_ReTXParams.uc_RPMS_DsLookBackValue = MIN(31, gt_ReTXParams.uc_RPMS_Qtx);

         gpuca_TxSocMsg[i++] = gt_ReTXParams.uc_RPMS_DsLookBackValue;               // need to be initialized

         //XDSLRTFW-1455, XDSLRTFW-1612 (START)
         // XDSLRTFW-1028_SRAds_Support_with_DS_ReTx (START)
         if ((gt_ReTXParams.t_ReTXConfigCMV.uc_G_Inp_Amend1_Support & 1) && (gt_ReTXParams.uc_OPMS_G_Inp_Amend1_Support & 0x1))
         {
            // The field is coded as [0000 00us], where
            // s=1 if OLR type 5 (SRA modified for G.998.4) is supported in DS and s=0 otherwise
            // u=1 if OLR type 6 (SOS modified for G.998.4) is supported in DS and u=0 otherwise
            // @note: Always send DS SRA enable/disable
            //XDSLRTFW-1607(START_END)
            if ((gft_EnableRxAutoSRA) && (gt_ReTXParams.uc_OMSG1_DsReTxEnabled == RETX_SELECTED))
            {
               gpuca_TxSocMsg[i++] = 1;  //Is SRA/SOSds supported?
            }
            else
            {
               // @note: Should revisit here, if support for SOSds needed in future!!
               gpuca_TxSocMsg[i++] = 0;
            }
         }//DS-RETX-SRA
         else
         {
            gpuca_TxSocMsg[i++] = 0;
         }
         //Increase params length by 1 to include DS OLR capability info.
         gpuca_TxSocMsg[Idx] += 1;

         // XDSLRTFW-1261_SRAus_Support_with_US_ReTx (START)
         if (((gt_ReTXParams.t_ReTXConfigCMV.uc_G_Inp_Amend1_Support >> 4) & 1) && ((gt_ReTXParams.uc_OPMS_G_Inp_Amend1_Support >> 4) & 0x1))
         {
            if ((gft_EnableTxSRA) && (gt_ReTXParams.uc_UsReTxStatus == US_RETX_IN_USE))
               // If OLR supports in US
            {
               // The field is coded as [0000 00us], where:
               // s=1 if OLR type 5 (SRA modified for G.998.4) is supported in US and s=0 otherwise
               // u=1 if OLR type 6 (SOS modified for G.998.4) is supported in US and u=0 otherwise
               gpuca_TxSocMsg[i++] = 1;        //Is SRAus supported?
            }
            else
            {
               gpuca_TxSocMsg[i++] = 0;
            }
         }//US-RETX-SRA
         else
         {
            gpuca_TxSocMsg[i++] = 0;
         }
         //Increase params length by 1 to include US SRA support
         gpuca_TxSocMsg[Idx] += 1;
         // XDSLRTFW-1284 Feature_US_VDSL2_ALL_UsReTx_TrainingMessageChanges(START)
         // XDSLRTFW-1693 (Start_End)
         // Note: Normally the check on G9984_ANNEXD_SUPPORT is not needed and should be removed,
         //       since DS_INTRA_DTU_ILV and extened memory - G9984_ANNEXD are independent features!
         //       Because the fear is to big to run in interop problems, the implementation sticks to
         //       the old a bit confusing implementation, where no problems were seen so far!
         if ((gus_ReTxOptionsEnabled & (G9984_ANNEXD_SUPPORT|DS_INTRA_DTU_ILV_CAPABLE)) &&
               (gt_ReTXParams.uc_amend2_support & CO_RETX_DS_OPT_BLK_ILV_SUPPPORT))
         {
            // You are here, because CO supports optional block interleaving depth of Amd2!
            // "D1" indicates the block interleaving depth in the downstream direction
            // on the latency path #1. D1 shall take a value in the range from 1 to 64 (inclusive).
            // D1 shall be either equal to 1 or equal to Q.
            //XDSLRTFW-1617 (Start)
            // Note: The below commented out code is not needed since "guc_ReTx_DS_D" gets be
            //       initialized to 1 in  function void InitGlobalVarsAtLinkStart(void).
            //                   if (!(gus_ReTxOptionsEnabled & DS_INTRA_DTU_ILV_CAPABLE))
            //                   {
            //                     guc_ReTx_DS_D = 1;
            //                   }
            gpuca_TxSocMsg[i++] = guc_ReTx_DS_D; //select block interleaver depth for DS direction.
            guc_IntraDtu_DS_D = guc_ReTx_DS_D;

            //XDSLRTFW-1617 (End)
            if (guc_ReTx_DS_D > 1)
            {
               gus_DsUsReTxStatus |= RETX_DS_INTRA_DTU_ILV_IN_USE;
            }

            gpuca_TxSocMsg[Idx] += 1;
         }
         //If Amd-2 is not supported, we need not send the Amd-2 block interleaver field
         //XDSLRTFW-1284 Feature_US_VDSL2_ALL_UsReTx_TrainingMessageChanges(END)
         else if (((gt_ReTXParams.t_ReTXConfigCMV.uc_G_Inp_Amend1_Support) && (gt_ReTXParams.uc_OPMS_G_Inp_Amend1_Support)) == 0)
         {
            //If Amd-1 and Amd-2 not supported, we need not send the Amd-1 block fields also!
            gpuca_TxSocMsg[Idx] -= 2;
         }
         gl_NoRetxMsg &= ~0x20;
      }//DS-RETX
      else
      {
         //Send a single zero byte
         gpuca_TxSocMsg[i++] = 0;
      }
      //XDSLRTFW-1455, XDSLRTFW-1612 (END)
   }

   if (gul_dbgSocMsgControl2 & AMENDMENT5_VECTORING_SUPPORT)
   {
      // Place holder for G.vector variable length field
      gpuca_TxSocMsg[i++] = 0;
   }

#ifdef DEBUG_GINP_MSGS
   gl_GINP_MsgLength = i;
   if (guc_DebugReTXTrainingMsg == 0x2a)
   {
      _flag(1);
   }
#endif

   gs_NumOctetsInTxHDLCMsg = i; // Set msg buffer length for HDLC encapsulation
#ifdef DEBUG_TRACES
   // XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer(START_END)
   LogMessages(4,(uint16)gpuca_TxSocMsg[0], (uint16)i, gpuca_TxSocMsg, DEBUG_BUFFER_DELIMITER_VDSL2);
#endif //#ifdef DEBUG_TRACES
   memcpy(&gsa_DebugStreamBuffer[0][0],gpuca_TxSocMsg,(uint16)i);
   DSH_SendStream(DSH_R_PMS, (uint16)i,(void *)&gsa_DebugStreamBuffer[0][0]);

   gs_FormMsgFlag = TRAINING_DONE;
}
