/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;   The function for forming the CPE R-PRM message.
;
*****************************************************************************/

// ***********************************************************************************************************
// FormRPrmMsg_VDSL2.c
//
// History
//
// 16/05/2012 Vinjam: Code Pointers connected to Downstream Virtual Noise feature
//            Grep for XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise
//
//
// 06/05/2013 Varun : Added code(Debug option) to capture raw data of all Tx(R-PRM in particular) and Rx- training //                    messages (G.Hs + training)
//                   Grep for "XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer"
//
// 09/07/2014 Varun : R-PRM contains many information in Delt mode which DebugBuffer cann't accomodate and
//                    hence disable logging for diagnostic mode
//                    Grep for XDSLRTFW-1507
//
// 8/10/2014 Vinay: Added code to support reporting of 3 more parameters (Recieve signal, Transmit signal, SOC message) to STAT 0
//            Grep for XDSLRTFW-1901
// 2/2/2015 Palaksha: VDSL DS Hlog is using always sub-sampling of 8(not according to the standard)
//             Removed function ResampleHlog, as sub-sampling factor of HLOG is taken in the calculation
//                  of HLOG itself. No need to again resample
//         Grep for XDSLRTFW-2135
//
// 20/08/2018: Sriram Shastry : XDSLRTFW-232-Coding/decoding of US- and DS-tssi in O-PRM and R-PRM not correct
// 1. Performance optimization is done up to now only for US0 oPOTS configuration (US0-spectrum: tone 6-32)
// 2. If US oPOTS is used we force the out-of-band TSSI values for the CO TDQ training phase to: ...
//    Lower OOB tone Idx (0,4 are shaped with 6.0dB dB TxATTEN ) and  Upper OOB tone idx (36 =-0.0 dB &
//    tone idx 54 = -62.0 dB) TxATTEN is applied).
// 3. All other modes still use the old code
// 4. Added  new Tx IIR filter for  ISI optimization
// 5. Upstream performance optimization is  controlled by cmv. TEST 49 BITMASK- 9. Enabled by default
// Grep for XDSLRTFW-232
//
// ************************************************************************************************************

#include <string.h>
#include "common.h"
#include "gdata.h"
#include "socmessage.h"
#include "ghs.h"
#include "GetQlnHlogForCarrierGroup.h"
#include "DebugBuffer.h"
#include "vdsl_const.h"
#include "SharedFuncs.h"
#include "cmv.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *
 *  Description:  Forms the CPE R-PRM message.
 *
 *  Prototype:
 *           void FormRPrmMsg_VDSL2(void);
 *
 *
 *  Input Arguments:
 *      None
 *
 *  Output Arguments:
 *      None
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void FormRPrmMsg_VDSL2(void)
{
   int16 i, j, s_NumOfPoints;
   int16 s_Up_MaxNomPSD;

   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START)
   gsa_IndirectStat0[4]=VDSL2_R_P_CHANNEL_DISCOVERY2;
   gsa_IndirectStat0[2]=VDSL2_R_PRM;
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (END)
   // Populate O-PRM or O_PRM_LD Message:
   i = 0;
   if((gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG) == 0)
   {
      gpuca_TxSocMsg[i] = (uint8)VDSL2_SOC_MSG_R_PRM;
   }
   else
   {
      gpuca_TxSocMsg[i] = (uint8)VDSL2_SOC_MSG_R_PRM_LD;
   }
   i++;

   // Field2
   // Actual upstream Tx PSD (PSD Descriptor)
   // see 997.1 section 7.5.1.15
   s_NumOfPoints = (int16)gt_UsREFPSDDescriptorTable.us_NumberOfTones;
   gpuca_TxSocMsg[i++] = (uint8)s_NumOfPoints;
   EncodePSDs(&i, s_NumOfPoints, (void*)&gt_UsREFPSDDescriptorTable,
              gt_PwrConfigParam.s_Up_MaxNomPSD, gpuca_TxSocMsg);

   // Field3 actual used upstream sub-carriers (Band descriptor)
   gpuca_TxSocMsg[i++] = (uint8)gs_NumOfTxBands;
   EncodeBands(&i, gs_NumOfTxBands,
               gsa_TxBandLeftChannel, gsa_TxBandRightChannel,
               gpuca_TxSocMsg);
   // Fill band control information for status CMVs!
   // Note: gt_TxBandControl_Act could also be used later on as original MEDLEYus set!
   VDSL2_BandControlGet(BAND_CONTROL_UPDATE_US);

   // Field4
   // Upstream cyclix prefix (2 bytes)
   EncodeNumOfSamples(&i, gs_TxCPLength, gpuca_TxSocMsg);

   // Field5
   // Upstream transmit window length (1 byte)
   // ANXQ_SUPPORT
   if ((gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK) &&
       (gs_TxLog2IfftLength > US_LOG2_FFT_LENGTH_8192))                // US_LOG2_FFT_LENGTH_8192 = 13
   {
      // VR9/VR318: Upstream is always running with the small IFFT.
      // CPE send the value dependent of the upstream IFFT size:
      //  ... shall be expressed either in multiples of 2 samples
      //      if profile 35b is used with extended IDFT Size, or otherwise,
      //      in samples at the upstream sampling rate corresponding to the
      //      IDFT size communicated in Field #6 of R-PRM.
      //  Note: Profile 35b being used with extended IDFT Size is equivalent
      //        with Field #6 of R-PRM having value 14.
      gpuca_TxSocMsg[i++] = (uint8)(gs_TxBetaLength >> 1);
   }
   else
   {
      gpuca_TxSocMsg[i++] = (uint8)gs_TxBetaLength;
   }

   // Field6
   // VTU-R IDFT size (1 byte)
   gpuca_TxSocMsg[i++] = (uint8)gs_TxLog2IfftLength;

   // Field7
   // Duration of the VTU-R EC training (1 byte)
   // TODO new in VDSL2
   gpuca_TxSocMsg[i++] = guc_RtReq_EcLength;

   // Field8
   // Duration of the VTU-R TEQ training (1 byte)
   // TODO new in VDSL2
   gpuca_TxSocMsg[i++] = guc_RtReq_TeqLength;

   // Field9
   // Duration of the VTU-O TEQ training (1 byte)
   // TODO new in VDSL2
   gpuca_TxSocMsg[i++] = guc_RtReq_CoTeqLength;

   // Field10
   // Duration of periodic signal (1 byte)
   // TODO new in VDSL2
   gpuca_TxSocMsg[i++] = guc_RtReq_PeriodicLength;

   // Field11
   // Duration of the R-P-TRAINING signal (1 byte)
   // TODO new in VDSL2
   gpuca_TxSocMsg[i++] = guc_RtReq_RPTrainLength;

   // Field12
   // Upstream frequency-domain spectrum shaping (Log_tssi descriptor)
   if(gt_UsTSSIPSDDescriptorTable.us_NumberOfTones == 0)
   {
      gpuca_TxSocMsg[i++] = (uint8)0;
   }
   else
   {
      UsTssiPSDDescriptorTable_t *pt_UsTssiPsd;
      UsTssiPSDDescriptorTable_t t_UsTSSIPSDDescriptorTable_msg;
      int16 s_rightToneIdx, s_temp, k;

      //Copy the TSST PSD descriptor to a different buffer:
      // XDSLRTFW-232 (Start)
      if((gs_TxIIRFilterSelect  == OPTN_POTS_LP_Filter_Select)&& ((TESTArray[TEST_JIRA2257_CONFIG] & TEST_ENABLE_TXTSSI_SHAPE) == TEST_ENABLE_TXTSSI_SHAPE))
      {
         pt_UsTssiPsd = (void *)&gt_Shape_UsTSSIPSDDescriptorTable;
      }
      else
      {
         pt_UsTssiPsd = (void *)&gt_UsTSSIPSDDescriptorTable;
      }
      memcpy(&t_UsTSSIPSDDescriptorTable_msg,pt_UsTssiPsd,sizeof(UsTssiPSDDescriptorTable_t));
      //pt_UsTssiPsd reuse internal structure instead of pointing  to  external/global structure
      pt_UsTssiPsd = &t_UsTSSIPSDDescriptorTable_msg;

      // XDSLRTFW-232 (End)
      // remove TSSI PSD breakpoints beyond t_stop + 32 where
      // "t_stop" denotes for the highest index sub-carrier in US0 for CPE
      // "t_stop" denotes for the highest index sub-carrier in DS1 for CO
      s_NumOfPoints = pt_UsTssiPsd->us_NumberOfTones;
      s_rightToneIdx = gsa_TxBandRightChannel[0] + 32;
      j = s_NumOfPoints;
      s_temp = 0;

      for (k=1; k<s_NumOfPoints; k++)
      {
         if ((k > 0) && (pt_UsTssiPsd->ut_PSDRecord[k].us_IndexOfTone > s_rightToneIdx))
         {
            if (s_temp == 0)
            {
               // insert a breakpoint at t_stop + 32
               if (pt_UsTssiPsd->ut_PSDRecord[k-1].us_IndexOfTone != s_rightToneIdx)
               {
                  pt_UsTssiPsd->ut_PSDRecord[k].us_IndexOfTone = s_rightToneIdx;
                  pt_UsTssiPsd->ut_PSDRecord[k].s_PSDLevelOfTone = pt_UsTssiPsd->ut_PSDRecord[k-1].s_PSDLevelOfTone;
               }
               else
               {
                  pt_UsTssiPsd->ut_PSDRecord[k].us_IndexOfTone = 0;
                  pt_UsTssiPsd->ut_PSDRecord[k].s_PSDLevelOfTone = 0;
                  j--;
               }
               s_temp = 1;
            }
            else
            {
               pt_UsTssiPsd->ut_PSDRecord[k].us_IndexOfTone = 0;
               pt_UsTssiPsd->ut_PSDRecord[k].s_PSDLevelOfTone = 0;
               j--;
            }
         }
      }
      pt_UsTssiPsd->us_NumberOfTones = j;

      //Form the message field
      s_NumOfPoints = (int16)pt_UsTssiPsd->us_NumberOfTones;
      gpuca_TxSocMsg[i++] = (uint8)s_NumOfPoints;

      // Temporarily modify gt_UsREFPSDDescriptorTable and calculate a corresponding
      // MaxnomPSD, so that EncodePSDs() can be reused and will generate the message
      // field in Log_tssi descriptor format (See Table 12-23/G.993.2).

      s_Up_MaxNomPSD = 0x7FFF;
      for (j = 0; j < s_NumOfPoints; j++ )
      {
         if (pt_UsTssiPsd->ut_PSDRecord[j].s_PSDLevelOfTone < s_Up_MaxNomPSD)
         {
            s_Up_MaxNomPSD = pt_UsTssiPsd->ut_PSDRecord[j].s_PSDLevelOfTone;
         }

         pt_UsTssiPsd->ut_PSDRecord[j].s_PSDLevelOfTone = -pt_UsTssiPsd->ut_PSDRecord[j].s_PSDLevelOfTone;
      }

      s_Up_MaxNomPSD += 1400;
      EncodePSDs(&i, s_NumOfPoints, (void*)pt_UsTssiPsd, s_Up_MaxNomPSD, gpuca_TxSocMsg);

      // Restore original gt_UsREFPSDDescriptorTable
      for (j = 0; j < s_NumOfPoints; j++ )
      {
         pt_UsTssiPsd->ut_PSDRecord[j].s_PSDLevelOfTone = -pt_UsTssiPsd->ut_PSDRecord[j].s_PSDLevelOfTone;
      }
   } //if(gt_UsTSSIPSDDescriptorTable.us_NumberOfTones > 0)


   //Change G of Qln and Hlog based on the SUPPORTEDSET

   //??? Mei: The current VDSL2 spec. says that Hlog should be computed
   //based on MEDLEYSET for normal operation, but based on SUPPORTEDSET
   //for loop diagostice mode. For now, we keep them the same until
   //the standard committee clarified this
   ResampleQln(gs_Log2CarrierGroupSizeRx_Disc);

   //ResampleHlog(gs_Log2CarrierGroupSizeRx_Disc); //XDSLRTFW-2135 (Start_End) Not needed now

   //If this is in diagonistic mode, send QLN and Hlog
   if(gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG)
   {
      PackQlnHlog_VDSL2(gpuca_TxSocMsg, &i);
   }


   if (gul_dbgSocMsgControl2 & (AMENDMENT5_VECTORING_SUPPORT | AMENDMENT5_RETX_SUPPORT))
   {
      // Place holder for G.inp variable length field
      gpuca_TxSocMsg[i++] = 0;
   }
   if (gul_dbgSocMsgControl2 & AMENDMENT5_VECTORING_SUPPORT)
   {
      // Place holder for G.vector variable length field
      gpuca_TxSocMsg[i++] = 0;
   }


   gs_NumOctetsInTxHDLCMsg = i; // Set msg buffer length for HDLC encapsulation
#ifdef DEBUG_TRACES
   //XDSLRTFW-1507(START_END)
   if(!(gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG))
   {
      // XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer(START_END)
      LogMessages(4,(uint16)gpuca_TxSocMsg[0], (uint16)i, gpuca_TxSocMsg, DEBUG_BUFFER_DELIMITER_VDSL2);
   }
#endif // #ifdef DEBUG_TRACES
   if(!(gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG))
   {
      memcpy(&gsa_DebugStreamBuffer[4][0],gpuca_TxSocMsg,(uint16)i);
      DSH_SendStream(DSH_R_PRM, (uint16)i,(void *)&gsa_DebugStreamBuffer[4][0]);
   }
   else
   {
      DSH_SendStream(DSH_R_PRM_LD, (uint16)i,(void *)gpuca_TxSocMsg);
   }

   //============================================================
   //Compute the US subcarrier group size used for SNR, HLOG
   //=============================================================
//XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise (Start)
   //Added during virtual noise bringup from Vinax code base (Mercurial Tag: REL_V12_08_03_26_0_04)
   if (gs_Log2CarrierGroupSizeTx_Medley == -1)
   {
      gs_Log2CarrierGroupSizeTx_Medley = CalcCarrierGroupSize(gsa_TxBandRightChannel[gs_NumOfTxBands-1]);
   }
//XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise (End)

   gs_CarrierGroupSizeTx_Medley = 1<<gs_Log2CarrierGroupSizeTx_Medley;

   //Save all the subcarrier size information for G999.1 API interface
   SaveChannelMeasureInfo();

   gs_FormMsgFlag = TRAINING_DONE;

#if defined(VRX518_BRINGUP_DEBUG)
   // Pause to dump the R-PRM SOC message.
   if (gs_PauseControl == 0x706)
   {
      gft_PauseOff = 0;
      Pause(gs_PauseControl);
   }
#endif // VRX518_BRINGUP_DEBUG

}
