/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;   The function for forming R-TA-UPDATE message.
;
;
;
;
*****************************************************************************/
//*****************************************************************************
// FormRTAUpdateMsg_VDSL2.c
//
// History
//
// 27/11/2012 Ram: Merged IOP fix corresponding to JIRA XDSLRTFW-458.
//            XDSLRTFW-458: Loop Reach is limited with different ECI DPBO shapes
//            This is because link failures at different phases.
//            a) 2nd pilot tone selection failure, because of conditions imposed
//               on pilot selection like limit for Pilot tone selection:
//               ADD_OFFSET_FROM_BANDEDGE  ie. set the start tone index away
//               from the band edge by minimum of predefined value and 1/4 of
//               band size and minimum SNR required 15 dB
//            b) Timing Advance correction applied from O-Update message. If
//               total timing  advance value is going above 300 then observed
//               OPTrain1 SNR is completely noisy (because of Echo) hence not
//               able to detect proper band for OPSYNCHRO4 detection.
//            Work around is to limit the Maximum value of Timing Advance from
//            CPE such that Echo effect will not be seen in DS band.
//            Grep for  " XDSLRTFW-458: IOP_ALL_VDSL2_ALL_TACorrection"
//
// 06/05/2013 Varun : Added code(Debug option) to capture raw data of all Tx(R-TA-UPDATE in particular) and Rx-
//                    training   messages (G.Hs + training)
//                   Grep for "XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer"
//
// 8/10/2014 Vinay: Added code to support reporting of 3 more parameters (Receive signal, Transmit signal, SOC message) to STAT 0
//            Grep for XDSLRTFW-1901
//*****************************************************************************

#include <string.h>
#include "common.h"
#include "gdata.h"
#include "socmessage.h"
#include "cmv.h"
#include "DebugBuffer.h"
#include "vdsl_const.h"
#include "cmv.h"                    // ANXQ_SUPPORT

/*^^^
 *------------------------------------------------------------------------
 *
 *
 *  Description:  Forms the R-TA-Update message.
 *
 *  Prototype:
 *           void FormRTAUpdateMsg_VDSL2(void);
 *
 *
 *  Input Arguments:
 *      None
 *
 *  Output Arguments:
 *      None
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void FormRTAUpdateMsg_VDSL2(void)
{
   int16 i;

//XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START)
   gsa_IndirectStat0[4]=VDSL2_R_P_TRAINING2;
   gsa_IndirectStat0[2]=VDSL2_R_TA_UPDATE;
//XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (END)

   i = 0;

   // Field1 Msg code
   gpuca_TxSocMsg[i++] = VDSL2_SOC_MSG_R_TA_UPDATE;  // Msg code

   // Field2 current timing advance (2 bytes)
   EncodeNumOfSamples(&i, gs_TargetTimingAdvance, gpuca_TxSocMsg);

   // Field3 timing advance correction (2 bytes)
   // "gs_TimingAdvance" is set to zero before the fn call 'FormRTAUpdateMsg_VDSL2'
   EncodeNumOfSamples(&i, gs_TimingAdvance, gpuca_TxSocMsg);

   // Field4 Maximum value of timing advance (2 bytes)
   {
      int16 s_MaxTimingAdvance;

      //XDSLRTFW-458: IOP_ALL_VDSL2_ALL_TACorrection  (start)
      if ((gs_ForceTimingAdvanceCorrection != 0x7fff)&&(gt_CustomerIopBits.us_ECI & ECI_DPBO_TACORRECTION))
      {
         // Field4 maximum value of timing advance (2 bytes)
         s_MaxTimingAdvance = gs_TargetTimingAdvance;
      }
      else
         //XDSLRTFW-458: IOP_ALL_VDSL2_ALL_TACorrection (end)
         // Field4 maximum value of timing advance (2 bytes)
      {
         s_MaxTimingAdvance = gs_TxIfftLength - 1;
         if ((gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK) &&
             (gs_TxLog2IfftLength > US_LOG2_FFT_LENGTH_8192))                // US_LOG2_FFT_LENGTH_8192 = 13
         {
            s_MaxTimingAdvance = gs_TxIfftLength - 2;
         }
      }
      EncodeNumOfSamples(&i, s_MaxTimingAdvance, gpuca_TxSocMsg);
   }

   // Field5 Bex-ds-R: desired number of bytes per DMT symbol in downstream
   // during exchange phase (1 byte)
   gpuca_TxSocMsg[i++] = guc_ExchangePhaseRxNumBytesPerSymbol;

   // Field6 Bex-us-R: desired number of bytes per DMT symbol in upstream
   // during exchange phase (1 byte)
   gpuca_TxSocMsg[i++] = guc_ExchangePhaseTxNumBytesPerSymbol;

   if (gul_dbgSocMsgControl2 & (AMENDMENT5_VECTORING_SUPPORT | AMENDMENT5_RETX_SUPPORT))
   {
      // Place holder for G.inp variable length field
      gpuca_TxSocMsg[i++] = 0;
   }
   if (gul_dbgSocMsgControl2 & AMENDMENT5_VECTORING_SUPPORT)
   {
      // Place holder for G.vector variable length field
      gpuca_TxSocMsg[i++] = 0;
   }


   gs_NumOctetsInTxHDLCMsg = i; // Set msg buffer length for HDLC encapsulation
#ifdef DEBUG_TRACES
   // XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer(START_END)
   LogMessages(4,(uint16)gpuca_TxSocMsg[0], (uint16)i, gpuca_TxSocMsg, DEBUG_BUFFER_DELIMITER_VDSL2);
#endif //#ifdef DEBUG_TRACES
   memcpy(&gsa_DebugStreamBuffer[5][0],gpuca_TxSocMsg,(uint16)i);
   DSH_SendStream(DSH_R_TA_UPDATE, (uint16)i,(void *)&gsa_DebugStreamBuffer[5][0]);

   gs_FormMsgFlag = TRAINING_DONE;

#if defined(VRX518_BRINGUP_DEBUG)
   // Pause to dump the R-TAUPDATE SOC message.
   if (gs_PauseControl == 0x707)
   {
      gft_PauseOff = 0;
      Pause(gs_PauseControl);
   }
#endif // VRX518_BRINGUP_DEBUG

}
