/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;   File Name: FormRTpsAckMsg_VDSL2.c
;
;   The function for forming the R-TPS-ACK message.
;
*****************************************************************************/

//****************************************************************************
// FormRTpsAckMsg_VDSL2.c
//   History :
//
//  06/05/2013 Varun : Added code(Debug option) to capture raw data of all Tx(R-TPS-ACK in particular) and Rx-
//                   training messages (G.Hs + training)
//                     Grep for "XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer"
//
// 8/10/2014 Vinay: Added code to support reporting of 3 more parameters (Recieve signal, Transmit signal, SOC message) to STAT 0
//            Grep for XDSLRTFW-1901
//***************************************************************************

#include <stdio.h>
#include <string.h>
#include "common.h"
#include "vdsl_compiler.h"
#include "typedef.h"
#include "gdata.h"
#include "DebugBuffer.h"
#include "cmv.h"
#include "vdsl_const.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : FormRTpsAckMsg_VDSL2
 *
 *  Description:  Forms the R-TPS-ACK message.
 *
 *  Prototype:
 *           void FormRTpsAckMsg_VDSL2();
 *
 *
 *  Input Arguments:
 *      None
 *
 *  Output Arguments:
 *      None
 *
 *  Global Variables Used:
 *      gpuca_TxSocMsg -- (I) pointer to the TX SOC message buffer
 *      gs_SendRAckFlag -- (I) flag to indicate which one, R-ACK or R-NACK, to be formed
 *      gs_NumOctetsInTxHDLCMsg -- (O) the length of the TX SOC message payload
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void FormRTpsAckMsg_VDSL2(void)
{
   int32 i;

   i = 0;
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START)
   gsa_IndirectStat0[4]=VDSL2_R_P_MEDLEY;
   gsa_IndirectStat0[2]=VDSL2_R_TPS_ACK;
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (END)
   //Message code
   gpuca_TxSocMsg[i++] = (uint8)VDSL2_SOC_MSG_R_TPS_ACK;

   if (gul_dbgSocMsgControl2 & (AMENDMENT5_VECTORING_SUPPORT | AMENDMENT5_RETX_SUPPORT))
   {
      // Place holder for G.inp variable length field
      gpuca_TxSocMsg[i++] = 0;
   }
   if (gul_dbgSocMsgControl2 & AMENDMENT5_VECTORING_SUPPORT)
   {
      // Place holder for G.vector variable length field
      gpuca_TxSocMsg[i++] = 0;
   }

   gs_NumOctetsInTxHDLCMsg = i;       // Set msg buffer length for HDLC encapsulation
#ifdef DEBUG_TRACES
   // XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer(START_END)
   LogMessages(4,(uint16)gpuca_TxSocMsg[0], (uint16)i, gpuca_TxSocMsg, DEBUG_BUFFER_DELIMITER_VDSL2);
#endif //#ifdef DEBUG_TRACES
   memcpy(&gsa_DebugStreamBuffer[4][0],gpuca_TxSocMsg,(uint16)i);
   DSH_SendStream(DSH_R_TPS_ACK, (uint16)i,(void *)&gsa_DebugStreamBuffer[4][0]);

   gs_FormMsgFlag = TRAINING_DONE;
}
