/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;   The function for forming R-UPDATE message.
;
*****************************************************************************/

// ****************************************************************************************************
// FormRUpdateMsg_VDSL2.c
// History :
//  06/05/2013 Varun : Added code(Debug option) to capture raw data of all Tx(R-UPDATE in particular) and Rx-
//                 training messages (G.Hs + training)
//                     Grep for "XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer"
//
// 8/10/2014 Vinay: Added code to support reporting of 3 more parameters (Recieve signal, Transmit signal, SOC message) to STAT 0
//            Grep for XDSLRTFW-1901
//****************************************************************************************************

#include <string.h>
#include "common.h"
#include "gdata.h"
#include "socmessage.h"
#include "vdsl_const.h"
#include "cmv.h"
#include "DebugBuffer.h"


/*^^^
 *------------------------------------------------------------------------
 *
 *
 *  Description:  Forms the R-Update message.
 *
 *  Prototype:
 *           void FormRUpdateMsg_VDSL2(void);
 *
 *
 *  Input Arguments:
 *      None
 *
 *  Output Arguments:
 *      None
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
#define KL0_400MTS_LOOP  (110)
#define KL0_1000MTS_LOOP (272)

void FormRUpdateMsg_VDSL2(void)
{
   int16 i, s_Dn_ProposedPsdCeilingMask, s_ToneIdx;
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START)
   gsa_IndirectStat0[4]=VDSL2_R_P_CHANNEL_DISCOVERY2;
   gsa_IndirectStat0[2]=VDSL2_R_UPDATE;
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (END)
   // Populate R-UPDATE Message:
   i = 0;
   gpuca_TxSocMsg[i++] = (uint8)VDSL2_SOC_MSG_R_UPDATE;  // Msg code

   // Field2 proposed downstream PSD ceiling (2 bytes)
   // See 997.1 section 7.3.1.2.1
   // Send No Limit on DS PSD Ceil if its 17A & BRCM DSLAM - TTNet Fix 15/03/2012
   {
      // XDSLRTFW-475 PERF_DS_VDSL17A_BRCM_ALL_CEILING_OPT_17A (Start)
      // For Short Loops, enable Optimum Ceiling calculation and disable sending 0x1000
      // Overwrite value 0x1000 to use the calculated Ceil
      {
         int16 s_ForceSpecialCeilProfile;

         // Get the profile for which forcing of special ceiling value is enabled.
         s_ForceSpecialCeilProfile = (gs_ForceSpecialCeilValueDs_Cntl & gt_ProfileAct.us_ProfileSelected);
         // Debug code to disable vendor specific ceiling handling.
         if (gs_ForceSpecialCeilValueDs_Cntl & BYPASS_FORCE_SECIAL_VALUE_SELECTION)
         {
            gs_ForceSpecialCeilValueDs_Cntl &= (~BYPASS_FORCE_SECIAL_VALUE_SELECTION);
            s_ForceSpecialCeilProfile = 0;
         }
         // Do manipulation according to loop length.
         if( (!(gsa_Optn0_ModeControl[1] & OPTN_ConfigMode_IKAN)) && (s_ForceSpecialCeilProfile) )
         {
            if (s_ForceSpecialCeilProfile & (CNFG_V2_PROFILE_17A_MASK|CNFG_V2_PROFILE_12xALL_MASK|CNFG_V2_PROFILE_8xALL_MASK))
            {
               // 8x, 12x and 17a profile special value handling
               // When optimal ceiling is enabled, use always the optimal ceiling value!
               // When optimal ceiling is disabled, use the adequate ceiling value for    0m - 1400m and
               //                                           special ceiling value  for 1400m - the end.
               if (gus_SwitchingCriterionVal < (gusa_SwitchingThreshTxBands[SWITCH_TO_1BAND_IDX0]))
               {
                  s_ForceSpecialCeilProfile = 0;
               }
            }
         }
         // Use it as a mask for the global variable.
         s_ForceSpecialCeilProfile |= WRONG_DS_NOM_PSD;
         gs_ForceSpecialCeilValueDs_Cntl &= s_ForceSpecialCeilProfile;
      }
      // XDSLRTFW-475 PERF_DS_VDSL17A_BRCM_ALL_CEILING_OPT_17A (end)

      s_Dn_ProposedPsdCeilingMask = gt_PwrConfigParam.s_Dn_ProposedPsdCeiling;
      // XDSLRTFW-1836
      // Identify wrong calulated MaxNomPSD Values, i.e. "gs_ForceSpecialCeilValueDs_Cntl".
      // In such a case assign the calulated DS Ceil to no bound!
      if ((s_Dn_ProposedPsdCeilingMask > 1000) || (gs_ForceSpecialCeilValueDs_Cntl))
      {
         // if proposed ceiling is too let the CO decide which ceiling to take
         // e.g. ceiling was 1077 (-107.7dBm/Hz) with DPBO shaped masks (ADTRAN - BRCM based DSLAM)
//    To be removed if correct fix is available!!!!!
         s_Dn_ProposedPsdCeilingMask = 0x1000;
      }

      if (gs_Force_Dn_ProposedPsdCeiling != 0)
      {
         s_Dn_ProposedPsdCeilingMask = gs_Force_Dn_ProposedPsdCeiling;
      }

      if (s_Dn_ProposedPsdCeilingMask != 0x1000)
      {
         // Case of s_Dn_ProposedPsdCeiling being a template level, and wanting to generate
         // s_Dn_ProposedPsdCeilingMask as a mask level.  Add 3.5 dB to s_Dn_ProposedPsdCeiling to do this conversion.
         s_Dn_ProposedPsdCeilingMask -= 35;
      }
      gpuca_TxSocMsg[i++] = (s_Dn_ProposedPsdCeilingMask>>8);
      gpuca_TxSocMsg[i++] = (int8)s_Dn_ProposedPsdCeilingMask;
      // Write back the transmitted value for API
      // - CMV INFO2 16 (INFO 216)
      // - ACK_ActualPSD_Get, 0xD803
      gt_PwrConfigParam.s_Dn_ProposedPsdCeiling = s_Dn_ProposedPsdCeilingMask;
   }

   // Field3 proposed highest downstream tone (2 bytes)
   s_ToneIdx = gs_HighestAllowedRxTone;


//   if(gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK)
//   {
//      if ((gsa_RxBandRightChannelOSignature[gs_NumOfRxBandsOSignature-1] < 7176) &&
//           (s_ToneIdx < gsa_RxBandRightChannelOSignature[gs_NumOfRxBandsOSignature-1]))
//      {
//         gs_HighestAllowedRxTone = gsa_RxBandRightChannel[gs_NumOfRxBands-1];
//         s_ToneIdx = gsa_RxBandRightChannel[gs_NumOfRxBands-1];
//      }
//
//      gs_NumOfDsBlackoutBands = 1;
//      gsa_DsBlackoutBandLeftChannel[0] = s_ToneIdx+1;
//      gsa_DsBlackoutBandRightChannel[0] = (DS_END_IDX_35B - 1);
//   }


   // Logic to automatically decide between normal implementation, i.e.
   //  - without any constrains: interleaved tone ordering and 1-bit constellation
   //  - with BDCM constrains:   ascending tone ordering   and 2-bit constellation
   // Background: Either the DS medley set shall be constrained to 6000 DS tones,
   //             or a tone ordering constraint shall be applied by the CPE for the case of a medley set with more than 6000 DS tones.
   if (gul_35bLiteConfig & EN_BDCM_DS_TONES_GT_6000)
   {
      int32 i;
      int16 sa_RxBandLeftChannel[MAX_NUM_RX_BANDS];
      int16 sa_RxBandRightChannel[MAX_NUM_RX_BANDS];
      int16 s_RxNumTonesUsed;

      // Reset the indication, because the num DS tones must be greater than 6000.
      gul_35bLiteConfig &= ~(EN_BDCM_DS_TONES_GT_6000);

#if defined(VRX518_SINGAPORE_BRINGUP)
      if (!(TESTArray[TEST_35B_CONTROL] & TEST_35B_DISABLE_BDCM_TRT))
#endif // VRX518_SINGAPORE_BRINGUP
      {
         // Calculate the number of used DS tones.
         s_RxNumTonesUsed = 0;
         i = 0;
         for (i=0; i<gs_NumOfRxBands; i++)
         {
            sa_RxBandLeftChannel[i] = gsa_RxBandLeftChannel[i];
            sa_RxBandRightChannel[i] = gsa_RxBandRightChannel[i];
            if(sa_RxBandRightChannel[i] > s_ToneIdx)
            {
               sa_RxBandRightChannel[i] = s_ToneIdx;
            }
            s_RxNumTonesUsed += sa_RxBandRightChannel[i] - sa_RxBandLeftChannel[i] + 1;
         }

         if (s_RxNumTonesUsed > 6000)
         {
            // The CPE will inform the CO that it will apply those constraints by setting the MSB of
            // the field "Proposed highest downstream sub-carrier" to one in the R-UPDATE message.
            // If this bit is not set, the CO will limit the DS medley set to 6000 tones at most.
            s_ToneIdx |= 0x8000;

            gul_35bLiteConfig |= EN_BDCM_DS_TONES_GT_6000;
            // Note: The medley set, as communicated by the CO in O-PRM, has a number of DS tones strictly larger than 6000 tones.
            //       Only then the BDCM constrains should be set!
            //  !!!! Therefore do not set it at this place !!!!
//            gft_EnableRxIlvTrt = FALSE;
//            gt_ModemConfig.s_DsMinConstSize = RX_MIN_BITS_PER_TONE_2;
         }
      }
   }

   gpuca_TxSocMsg[i++] = (uint8)(s_ToneIdx >> 8);
   gpuca_TxSocMsg[i++] = (uint8)s_ToneIdx;


   // Field4 proposed lowest downstream tone (2 bytes)
   s_ToneIdx = MAX(gs_LowestAllowedRxTone, gsa_RxBandLeftChannel[0]);
   gpuca_TxSocMsg[i++] = (int8)(s_ToneIdx >> 8);
   gpuca_TxSocMsg[i++] = (int8)s_ToneIdx;

   // Field5 blackout carriers in downstream (Band descriptor)
   gpuca_TxSocMsg[i++] = (uint8)gs_NumOfDsBlackoutBands;
   EncodeBands(&i, gs_NumOfDsBlackoutBands,
               gsa_DsBlackoutBandLeftChannel, gsa_DsBlackoutBandRightChannel,
               gpuca_TxSocMsg);


   // Field6 suggested cyclic extension (1 byte)
   //Lce = m*N/32, solve m = Lce*32/N, N is the number of tones
   gpuca_TxSocMsg[i++] = (int8)gs_m;

   if (gul_dbgSocMsgControl2 & (AMENDMENT5_VECTORING_SUPPORT | AMENDMENT5_RETX_SUPPORT))
   {
      // Place holder for G.inp variable length field
      gpuca_TxSocMsg[i++] = 0;
   }
   if (gul_dbgSocMsgControl2 & AMENDMENT5_VECTORING_SUPPORT)
   {
      // Place holder for G.vector variable length field
      gpuca_TxSocMsg[i++] = 0;
   }

   gs_NumOctetsInTxHDLCMsg = i; // Set msg buffer length for HDLC encapsulation
#ifdef DEBUG_TRACES
   // XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer(START_END)
   LogMessages(4,(uint16)gpuca_TxSocMsg[0], (uint16)i, gpuca_TxSocMsg, DEBUG_BUFFER_DELIMITER_VDSL2);
#endif //#ifdef DEBUG_TRACES
   memcpy(&gsa_DebugStreamBuffer[2][0],gpuca_TxSocMsg,(uint16)i);
   DSH_SendStream(DSH_R_UPDATE, (uint16)i,(void *)&gsa_DebugStreamBuffer[2][0]);

   gs_FormMsgFlag = TRAINING_DONE;
}

