/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;   InterpMsgLD_VDSL2Diag.c
;
;   The function for interpreting O/R-MSG-LD message.
;
*****************************************************************************/
// ***********************************************************************************************************
// InterpMsgLD_VDSL2Diag.c
//
// History

// 10/10/2017 Abu Rahman
// XDSLRTFW-3071: US & DS ATP reporting is swapped
//     Variables contains the DS ActATP and US ActATP were wrongly (swapped) populated.
//     - Fixed the variable initialization.
//     - Fixed variables population for DS ActATP and US ActATP
//     - Fixed HDLC messages relating to these variables both for Showtime and diag mode
//     - Changed two structure names
//       1. old name: gt_G997_NeSignalAndMarginParams, new name: gt_LineStatusDS
//       2. old name: gt_G997_FeSignalAndMarginParams, new name: gt_LineStatusUS
//     Grep for XDSLRTFW-3071
// ************************************************************************************************************

#include <string.h>
#include "common.h"
#include "gdata.h"
#include "socmessage.h"
#include "TxPSDCOntrol.h"
#include "SharedFuncs.h"
#include "ghs.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *
 *  Description:  The function for interpreting O/R-MSG-LD message
 *
 *  Prototype:
 *           int16 InterpMsgLD_VDSL2(void);
 *
 *
 *  Input Arguments:
 *      None
 *
 *  Output Arguments:
 *
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

extern void RemoveHlinSc(uint16 *pusa_HlinBu);

int16 InterpMsgLD_VDSL2(void)
{

   uint8 *puca_OctetBuffer;
   int16 j, s_idx;
   uint16 us_x, *pusa_buf;
   DSH_SendStream(DSH_O_MSG_LD, (uint16)gs_RxWholeMsgLength,(void *)gpuca_RxHDLCMsgBuf);
   // Field1 is the message code (1 byte)

   // Field2
   // Hlin 6x512 bytes, TBD
   puca_OctetBuffer = gpuca_RxHDLCMsgBuf+1;
   pusa_buf = gpusa_HlinBuf_FE;
   for(j=0; j<512*3; j++)
   {
      us_x = (*puca_OctetBuffer++)<<8;
      us_x |= *puca_OctetBuffer++;
      *pusa_buf++ = us_x;
   }

   //Save the Hlin scale to CMV structure
   gt_ChannelMeasurement_FE.us_HlinSC = *gpusa_HlinBuf_FE;

   //Remove "scale" from the Hlin table since it is required by the external interface
   RemoveHlinSc(gpusa_HlinBuf_FE);

   // Filed3
   // SNR, 512 byte
   // XDSLRTFW-3606 (Start_End)
   memcpy(gt_FEParams.uc_Snr, puca_OctetBuffer, 512);
   puca_OctetBuffer += 512;

   //Decode Field4
   // LATN-pb (2*5) bytes
   for(j=0; j<5; j++)
   {
      gt_AttenSnrMPerRxBand_FE.t_AttenSnrM[j].s_LATN = (*puca_OctetBuffer++)<<8;
      gt_AttenSnrMPerRxBand_FE.t_AttenSnrM[j].s_LATN |= (*puca_OctetBuffer++);
   }

   // Field5
   // SATN-pb (2*5) bytes
   for(j=0; j<5; j++)
   {
      gt_AttenSnrMPerRxBand_FE.t_AttenSnrM[j].s_SATN = (*puca_OctetBuffer++)<<8;
      gt_AttenSnrMPerRxBand_FE.t_AttenSnrM[j].s_SATN |= (*puca_OctetBuffer++);
   }

   // Field6
   // SNRM and SNRM-pb (2+2*5) bytes
   gt_LineStatusUS.s_SnrMargin = (*puca_OctetBuffer++)<<8;
   gt_LineStatusUS.s_SnrMargin |= (*puca_OctetBuffer++);

   for(j=0; j<5; j++)
   {
      gt_AttenSnrMPerRxBand_FE.t_AttenSnrM[j].s_SNRM = (*puca_OctetBuffer++)<<8;
      gt_AttenSnrMPerRxBand_FE.t_AttenSnrM[j].s_SNRM |= (*puca_OctetBuffer++);
   }

   // Field7
   // ATTNDR 4 bytes
   gt_LineStatusUS.ul_AttainableDataRate = (*puca_OctetBuffer++)<<24;
   gt_LineStatusUS.ul_AttainableDataRate |= (*puca_OctetBuffer++)<<16;
   gt_LineStatusUS.ul_AttainableDataRate |= (*puca_OctetBuffer++)<<8;
   gt_LineStatusUS.ul_AttainableDataRate |= (*puca_OctetBuffer++);

   // XDSLRTFW-3071 US & DS ATP reporting is swapped (Start)
   // Field8
   // ACTATP 2 bytes
   // US ActATP
    gt_LineStatusUS.s_ActualAggregateXmtPwr = (*puca_OctetBuffer++)<<8;
   gt_LineStatusUS.s_ActualAggregateXmtPwr |= (*puca_OctetBuffer++);
   // XDSLRTFW-3071 US & DS ATP reporting is swapped (End)

   s_idx = puca_OctetBuffer - gpuca_RxHDLCMsgBuf;

   return(UnpackedMsgLengthCheck(s_idx, gs_RxWholeMsgLength));

}
