/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;   File Name: InterpMsg_RT.c
;
;   Interpret Special Operation Channel Messages by RT
;
'
*****************************************************************************/

#include "gdata.h"
#include "socmessage.h"
#include "vdsl_xception.h"


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : InterpMsg_RT_VDSL2
 *
 *  Description:  This function decides which function to call to interpret
 *  the RX message, based on the input message code
 *
 *  Prototype:
 *      void InterpMsg_RT_VDSL2(uint8 uc_MsgCode)
 *
 *  Input Arguments:
 *      uc_MsgCode  --   message code to be interpreted
 *
 *  Output Arguments:
 *
 *  Return:
 *    either TRUE (no error) or FALSE
 *
 *  Global Variables Used:
 *      gs_RxMsgErrorCode -- (O) the RX message decoder error code
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
int16 InterpMsg_RT_VDSL2(uint8 uc_MsgCode)
{

   switch(uc_MsgCode)
   {

   case SOC_MSG_O_SIGNATURE:

      if(InterpOSignatureMsg_VDSL2() == FALSE)
      {
         gs_RxMsgErrorCode = E_CODE_O_SIGNATURE_ERROR_VDSL2;
         return(FALSE);
      }
      break;

   case VDSL2_SOC_MSG_O_UPDATE:

      if(InterpOUpdateMsg_VDSL2() == FALSE)
      {
         gs_RxMsgErrorCode = E_CODE_O_UPDATE_ERROR_VDSL2;
         return(FALSE);
      }
      break;

   case VDSL2_SOC_MSG_O_PRM:
   case VDSL2_SOC_MSG_O_PRM_LD:

      if(InterpOPrmMsg_VDSL2() == FALSE)
      {
         gs_RxMsgErrorCode = E_CODE_O_PRM_ERROR_VDSL2;
         return(FALSE);
      }
      break;

   case VDSL2_SOC_MSG_O_TA_UPDATE:
      if(InterpOTAUpdateMsg_VDSL2() == FALSE)
      {
         gs_RxMsgErrorCode = E_CODE_OTA_UPDATE_ERROR_VDSL2;
         return(FALSE);
      }
      break;

   case VDSL2_SOC_MSG_O_MSG1:
      if(InterpOMsg1Msg_VDSL2() == FALSE)
      {
         gs_RxMsgErrorCode = E_CODE_O_MSG1_ERROR_VDSL2;
         return(FALSE);
      }
      break;

   case VDSL2_SOC_MSG_O_TPS:
      if(InterpOTpsMsg_VDSL2() == FALSE)
      {
         gs_RxMsgErrorCode = E_CODE_O_TPS_ERROR_VDSL2;
         return(FALSE);
      }
      break;

   case VDSL2_SOC_MSG_O_PMS:
      if(InterpOPmsMsg_VDSL2() == FALSE)
      {
         gs_RxMsgErrorCode = E_CODE_O_PMS_ERROR_VDSL2;
         return(FALSE);
      }
      break;

   case VDSL2_SOC_MSG_O_PMD:
      if(InterpOPmdMsg_VDSL2() == FALSE)
      {
         gs_RxMsgErrorCode = E_CODE_O_PMD_ERROR_VDSL2;
         return(FALSE);
      }
      break;

   case VDSL2_SOC_MSG_O_MSG_LD:

      if(InterpMsgLD_VDSL2() == TRUE)
      {
         return(TRUE);
      }
      else
      {
         gs_RxMsgErrorCode = E_CODE_O_MSG_LD_ERROR_VDSL2;
         return(FALSE);
      }

      break;


   default:
      return(FALSE);

   }

   return(TRUE);
}

