/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 2016 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;   Functions for interpreting O-MSG1 message
;
'
*****************************************************************************/
#include "common.h"
#include "gdata.h"
#include "socmessage.h"
#include "DebugBuffer.h"
#include "string.h"
#include "cmv_Data.h"
#include "ppe_memmap.h"
#include "LL_IOf.h"
#include "vdsl_state.h"
#include "vdsl_xception.h"
#include "Cri_iof.h"

// ***********************************************************************************************************
// InitShowTimeTx.c
//
// History
//
// 05/12/2012 Ram: Aligning to Msg Spec 1.8:- INFO 68, Bit '1' of Parameter 10 ==> NTR Status DS
//                 Grep for 'XDSLRTFW-466: Indicate NTR Status'
//
// 06/05/2013 Varun : Added code(Debug option) to capture raw data of all Tx and Rx(O-MSG1 in particular) training
//                    messages (G.Hs + training)
//                  Grep for "XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer"
// 15/07/2013 Varun : Incorporated the code changes to support US ReTx
//                     Grep for "XDSLRTFW-1046 Feature_US_VDSL2_ALL_UsReTx"
// // 16/10/2013 Varun : Modified the message to support ReTx amend2
//                       Grep for XDSLRTFW-1284 Feature_US_VDSL2_ALL_UsReTx_TrainingMessageChanges
//
// 30/10/2014 Anantha Ramu: Flag added to indicate DS Intra DTU interleaving support.
//                          Grep for "XDSLRTFW-1617"
//
// 21/01/2015 Anantha Ramu: Avinax was sending interleaver depth of max value of 1 in the octet 8 of g.998.4 parameter field
//                          of O-MSG1, when Intra DTU Interleaving was enabled. Changes done such that Intra DTU interleaving
//                          is active only for D > 1.
//                          Grep for "XDSLRTFW-2153"
//
// 26/11/2015 Anantha Ramu: Added modifications for SRA with DS Intra DTU Interleaving.
//                          Grep for "XDSLRTFW-2162".
// ************************************************************************************************************

/*^^^
 *------------------------------------------------------------------------
 *
 *
 *  Description:  Interpret the received O-MSG1 message.
 *
 *  Prototype:
 *           int16 InterpOMsg1Msg_VDSL2(void);
 *
 *
 *  Input Arguments:
 *      None
 *
 *  Output Arguments:
 *      None
 *
 *   Return:
 *      TRUE if interpretation is ok, FALSE otherwise
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

int16 InterpOMsg1Msg_VDSL2(void)
{
   int16 s_idx;
   uint8 j,k;
   TPS_TC_Type_SOC_t *pt_TpsTcType;

   #ifdef DEBUG_TRACES
   // XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer(START_END)
   LogMessages(4,(uint16)gpuca_RxHDLCMsgBuf[0], (uint16)gs_RxWholeMsgLength, gpuca_RxHDLCMsgBuf, DEBUG_BUFFER_DELIMITER_VDSL2);
#endif //#ifdef DEBUG_TRACES
   memcpy(&gsa_DebugStreamBuffer[1][0],gpuca_RxHDLCMsgBuf,(uint16)gs_RxWholeMsgLength);
   DSH_SendStream(DSH_O_MSG1, (uint16)gs_RxWholeMsgLength,(void *)&gsa_DebugStreamBuffer[1][0]);

   // Field1 - Message descriptor
   s_idx = 1;                          // gets be skipped!

   // Field2 target noise margin for DS transmission (2 bytes)
   gt_SnrMgnConfig.s_TARSNRMds = gpuca_RxHDLCMsgBuf[s_idx++]<<8;
   gt_SnrMgnConfig.s_TARSNRMds |= gpuca_RxHDLCMsgBuf[s_idx++];

   // Field3 minimum noise margin for DS transmission (2 bytes)
   gt_SnrMgnConfig.s_MINSNRMds = gpuca_RxHDLCMsgBuf[s_idx++]<<8;
   gt_SnrMgnConfig.s_MINSNRMds |= gpuca_RxHDLCMsgBuf[s_idx++];

   // Field4 maximum noise margin for DS transmission (2 bytes)
   gt_SnrMgnConfig.s_MAXSNRMds = gpuca_RxHDLCMsgBuf[s_idx++]<<8;
   gt_SnrMgnConfig.s_MAXSNRMds |= gpuca_RxHDLCMsgBuf[s_idx++];

   // Field5 RA-Mode- rate adaptive mode (1 byte)
   gt_DecMsg_O_Msg1_VDSL2.uc_RAMode = gpuca_RxHDLCMsgBuf[s_idx++];

// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [Start]
   gus_DsRAMode = gt_DecMsg_O_Msg1_VDSL2.uc_RAMode;
// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [End]

   // Field6 NTR- the capability to transport NTR in the ds direction (1 byte)
   // NTR is network timing reference
   gt_DecMsg_O_Msg1_VDSL2.uc_NTRCap = gpuca_RxHDLCMsgBuf[s_idx++];

   // XDSLRTFW-466: Indicate NTR Status (Start)
   if ((gt_DecMsg_O_Msg1_VDSL2.uc_NTRCap == 1) && (gft_EnableNTR == 1))
   {
      // Refer Msg Spec 1.8, INFO 68 (ACK_LineStatusDS_Get):
      // Bit '1' of parameter 10 ==> NTRstatus_ds
      // Value 1 = NTR_ENABLE, Value 0 = NTR_DISABLE
      gt_LineStatusDS.us_LineStatus |= 0x2;
   }
   // XDSLRTFW-466: Indicate NTR Status (End)

   // Field9 TPS-TC capabilities
   // Field9 byte1 Maximum number of downstream TPS-TCs of each type (1 byte)
   gt_DecMsg_O_Msg1_VDSL2.uc_MaxNumDsTpsTcs = gpuca_RxHDLCMsgBuf[s_idx++];

   // Field9 byte2 Maximum number of upstream TPS-TCs of each type (1 byte)
   gt_DecMsg_O_Msg1_VDSL2.uc_MaxNumUsTpsTcs = gpuca_RxHDLCMsgBuf[s_idx++];

   // Field9 byte3 [s0a0p0 0 s1a1p1 0]
   // Supported combinations of downstream bearer channels and TPS-TCs
   gt_DecMsg_O_Msg1_VDSL2.uc_DsBcAndTpsTcs = gpuca_RxHDLCMsgBuf[s_idx++];

   gt_DecMsg_O_Msg1_VDSL2.ta_DsBC[BC0].s_Control = 0;
   if(gt_DecMsg_O_Msg1_VDSL2.uc_DsBcAndTpsTcs & TPS_TC_STM_BC0_SUPPORT)
   {
      gt_DecMsg_O_Msg1_VDSL2.ta_DsBC[BC0].s_Control |= TPS_TC_TYPE_STM;
   }

   if(gt_DecMsg_O_Msg1_VDSL2.uc_DsBcAndTpsTcs & TPS_TC_ATM_BC0_SUPPORT)
   {
      gt_DecMsg_O_Msg1_VDSL2.ta_DsBC[BC0].s_Control |= TPS_TC_TYPE_ATM;
   }

   if(gt_DecMsg_O_Msg1_VDSL2.uc_DsBcAndTpsTcs & TPS_TC_PTM_BC0_SUPPORT)
   {
      gt_DecMsg_O_Msg1_VDSL2.ta_DsBC[BC0].s_Control |= TPS_TC_TYPE_PTM;
   }

   gt_DecMsg_O_Msg1_VDSL2.ta_DsBC[BC1].s_Control = 0;
   if(gt_DecMsg_O_Msg1_VDSL2.uc_DsBcAndTpsTcs & TPS_TC_STM_BC1_SUPPORT)
   {
      gt_DecMsg_O_Msg1_VDSL2.ta_DsBC[BC1].s_Control |= TPS_TC_TYPE_STM;
   }

   if(gt_DecMsg_O_Msg1_VDSL2.uc_DsBcAndTpsTcs & TPS_TC_ATM_BC1_SUPPORT)
   {
      gt_DecMsg_O_Msg1_VDSL2.ta_DsBC[BC1].s_Control |= TPS_TC_TYPE_ATM;
   }

   if(gt_DecMsg_O_Msg1_VDSL2.uc_DsBcAndTpsTcs & TPS_TC_PTM_BC1_SUPPORT)
   {
      gt_DecMsg_O_Msg1_VDSL2.ta_DsBC[BC1].s_Control |= TPS_TC_TYPE_PTM;
   }

   // Field9 byte4 [s0a0p0 0 s1a1p1 0]
   // Supported combinations of upstream bearer channels and TPS-TCs
   gt_DecMsg_O_Msg1_VDSL2.uc_UsBcAndTpsTcs = gpuca_RxHDLCMsgBuf[s_idx++];

   gt_DecMsg_O_Msg1_VDSL2.ta_UsBC[BC0].s_Control = 0;
   if(gt_DecMsg_O_Msg1_VDSL2.uc_UsBcAndTpsTcs & TPS_TC_STM_BC0_SUPPORT)
   {
      gt_DecMsg_O_Msg1_VDSL2.ta_UsBC[BC0].s_Control |= TPS_TC_TYPE_STM;
   }

   if(gt_DecMsg_O_Msg1_VDSL2.uc_UsBcAndTpsTcs & TPS_TC_ATM_BC0_SUPPORT)
   {
      gt_DecMsg_O_Msg1_VDSL2.ta_UsBC[BC0].s_Control |= TPS_TC_TYPE_ATM;
   }

   if(gt_DecMsg_O_Msg1_VDSL2.uc_UsBcAndTpsTcs & TPS_TC_PTM_BC0_SUPPORT)
   {
      gt_DecMsg_O_Msg1_VDSL2.ta_UsBC[BC0].s_Control |= TPS_TC_TYPE_PTM;
   }

   gt_DecMsg_O_Msg1_VDSL2.ta_UsBC[BC1].s_Control = 0;
   if(gt_DecMsg_O_Msg1_VDSL2.uc_UsBcAndTpsTcs & TPS_TC_STM_BC1_SUPPORT)
   {
      gt_DecMsg_O_Msg1_VDSL2.ta_UsBC[BC1].s_Control |= TPS_TC_TYPE_STM;
   }

   if(gt_DecMsg_O_Msg1_VDSL2.uc_UsBcAndTpsTcs & TPS_TC_ATM_BC1_SUPPORT)
   {
      gt_DecMsg_O_Msg1_VDSL2.ta_UsBC[BC1].s_Control |= TPS_TC_TYPE_ATM;
   }

   if(gt_DecMsg_O_Msg1_VDSL2.uc_UsBcAndTpsTcs & TPS_TC_PTM_BC1_SUPPORT)
   {
      gt_DecMsg_O_Msg1_VDSL2.ta_UsBC[BC1].s_Control |= TPS_TC_TYPE_PTM;
   }

   // For each supported DS and US TPS-TC, the following data are specified (8 bytes):
   // Field9 bytes 5-6: Minimum Net Data Rate
   // Field9 bytes 7-8: Mamimum Net Data Rate
   // Field9 bytes 9-10: Minimum Reserved Data Rate
   // Field9 byte 11: Maximum PMS-TC latency
   // Field9 byte 12: Minimum INP
   for(k=0; k < MAX_TPS_TC_TYPE; k++)
   {
      for (j=0; j < NUM_BEARER_CHANNELS; j++)
      {
         if (gt_DecMsg_O_Msg1_VDSL2.ta_DsBC[j].s_Control & gus_TpsTcType[k])
         {
            pt_TpsTcType = &(gt_DecMsg_O_Msg1_VDSL2.ta_DsBC[j].ta_TpsTcType[k]);

            pt_TpsTcType->us_MinNetDataRate = gpuca_RxHDLCMsgBuf[s_idx++] << 8;
            pt_TpsTcType->us_MinNetDataRate |= gpuca_RxHDLCMsgBuf[s_idx++];

            pt_TpsTcType->us_MaxNetDataRate = gpuca_RxHDLCMsgBuf[s_idx++] << 8;
            pt_TpsTcType->us_MaxNetDataRate |= gpuca_RxHDLCMsgBuf[s_idx++];

            pt_TpsTcType->us_MinResNetDataRate = gpuca_RxHDLCMsgBuf[s_idx++] << 8;
            pt_TpsTcType->us_MinResNetDataRate |= gpuca_RxHDLCMsgBuf[s_idx++];

            pt_TpsTcType->s_MaxLatency = gpuca_RxHDLCMsgBuf[s_idx++];
            pt_TpsTcType->uc_IMAxINP = gpuca_RxHDLCMsgBuf[s_idx++];

            pt_TpsTcType->uc_TPSTCoptions = gpuca_RxHDLCMsgBuf[s_idx++];
         }
      }
   }

   for(k=0; k < MAX_TPS_TC_TYPE; k++)
   {
      for (j=0; j < NUM_BEARER_CHANNELS; j++)
      {
         if (gt_DecMsg_O_Msg1_VDSL2.ta_UsBC[j].s_Control & gus_TpsTcType[k])
         {
            pt_TpsTcType = &(gt_DecMsg_O_Msg1_VDSL2.ta_UsBC[j].ta_TpsTcType[k]);

            pt_TpsTcType->us_MinNetDataRate = gpuca_RxHDLCMsgBuf[s_idx++] << 8;
            pt_TpsTcType->us_MinNetDataRate |= gpuca_RxHDLCMsgBuf[s_idx++];

            pt_TpsTcType->us_MaxNetDataRate = gpuca_RxHDLCMsgBuf[s_idx++] << 8;
            pt_TpsTcType->us_MaxNetDataRate |= gpuca_RxHDLCMsgBuf[s_idx++];

            pt_TpsTcType->us_MinResNetDataRate = gpuca_RxHDLCMsgBuf[s_idx++] << 8;
            pt_TpsTcType->us_MinResNetDataRate |= gpuca_RxHDLCMsgBuf[s_idx++];

            pt_TpsTcType->s_MaxLatency = gpuca_RxHDLCMsgBuf[s_idx++];
            pt_TpsTcType->uc_IMAxINP = gpuca_RxHDLCMsgBuf[s_idx++];

            pt_TpsTcType->uc_TPSTCoptions = gpuca_RxHDLCMsgBuf[s_idx++];
         }
      }
   }

   // Field10 PMS-TC capabilities (12 bytes)
   // Field10 byte 1: Downstream dynamic interleaver
   gt_DecMsg_O_Msg1_VDSL2.uc_DsDynamicIlv = gpuca_RxHDLCMsgBuf[s_idx++];

   // Field10 byte 2: Upstream dynamic interleaver
   gt_DecMsg_O_Msg1_VDSL2.uc_UsDynamicIlv = gpuca_RxHDLCMsgBuf[s_idx++];

   // Field10 byte 3: Downstream overhead datarate (rate = 1000*(N+1) bps)
   // where N is an 8 bit value.
   gt_DecMsg_O_Msg1_VDSL2.uc_DsOvhdRate = gpuca_RxHDLCMsgBuf[s_idx++];

   // Field10 byte 4: Upstream overhead datarate (rate = 1000*(N+1) bps)
   // where N is an 8 bit value.
   gt_DecMsg_O_Msg1_VDSL2.uc_UsOvhdRate = gpuca_RxHDLCMsgBuf[s_idx++];

   // Field10 bytes 5-6: Max DS rate for latency path 0
   // Field10 bytes 7-8: Max US rate for latency path 0
   // Field10 bytes 9-10: Max DS rate for latency path 1
   // Field10 bytes 11-12: Max US rate for latency path 1
   for (j=0; j < NUM_DATA_PATHS; j++)
   {
      gt_DecMsg_O_Msg1_VDSL2.s_DsMaxDataRate[j] = gpuca_RxHDLCMsgBuf[s_idx++] << 8;
      gt_DecMsg_O_Msg1_VDSL2.s_DsMaxDataRate[j] |= gpuca_RxHDLCMsgBuf[s_idx++];

      gt_DecMsg_O_Msg1_VDSL2.s_UsMaxDataRate[j] = gpuca_RxHDLCMsgBuf[s_idx++] << 8;
      gt_DecMsg_O_Msg1_VDSL2.s_UsMaxDataRate[j] |= gpuca_RxHDLCMsgBuf[s_idx++];
   }

   gt_DecMsg_O_Msg1_VDSL2.uc_DS1byS = gpuca_RxHDLCMsgBuf[s_idx++];
   gt_DecMsg_O_Msg1_VDSL2.uc_US1byS = gpuca_RxHDLCMsgBuf[s_idx++];

   // presume that there's not enough bytes in msg buffer for GINP feature
   gl_NoRetxMsg = 1;

   if (s_idx + 8 <= gs_RxWholeMsgLength)
   {
      //Field9 Downstream Rate Adaptation: downshift SNR margin
      gt_RxAutoSRA_Ctrl.us_RA_DSNRM = gpuca_RxHDLCMsgBuf[s_idx++]<<8;
      gt_RxAutoSRA_Ctrl.us_RA_DSNRM |= gpuca_RxHDLCMsgBuf[s_idx++];

      //Field10 Downstream Rate Adaptation: downshift time interval
      gt_RxAutoSRA_Ctrl.us_RA_DTIME = gpuca_RxHDLCMsgBuf[s_idx++]<<8;
      gt_RxAutoSRA_Ctrl.us_RA_DTIME |= gpuca_RxHDLCMsgBuf[s_idx++];

      //Field11 Downstream Rate Adaptation: upshift SNR margin
      gt_RxAutoSRA_Ctrl.us_RA_USNRM = gpuca_RxHDLCMsgBuf[s_idx++]<<8;
      gt_RxAutoSRA_Ctrl.us_RA_USNRM |= gpuca_RxHDLCMsgBuf[s_idx++];

      //Field12 Downstream Rate Adaptation: upshift time interval
      gt_RxAutoSRA_Ctrl.us_RA_UTIME = gpuca_RxHDLCMsgBuf[s_idx++]<<8;
      gt_RxAutoSRA_Ctrl.us_RA_UTIME |= gpuca_RxHDLCMsgBuf[s_idx++];

      // Set bit to indicate these fields are included
      gul_dbgSocMsgControl2 |= AMENDMENT1_OMSG1_SRA_SUPPORT;
   }
   else
   {
      gul_SocMsgNotCompliedAmends |= AMEND1_NOT_COMPLIED_IN_OMsg1;
      goto EndOf_OMsg1_Interp;
   }


   // Note: The check with " + 15" is necessary, because otherwise the fkt.
   //       UnpackedMsgLengthCheck() will throw an error!
   if ((s_idx + 15) <= gs_RxWholeMsgLength)
   {
      // skip 15 bytes for SOS
      s_idx += 15;

      // Set bit to indicate these fields are included
      gul_dbgSocMsgControl2 |= AMENDMENT3_OMSG1_SOS_ROC_SUPPORT;
   }
   else
   {
      gul_SocMsgNotCompliedAmends |= AMEND3_NOT_COMPLIED_IN_OMsg1;
      goto EndOf_OMsg1_Interp;
   }



#ifdef DEBUG_GINP_MSGS
   gpuca_GINP_MsgBuf = gpuca_RxHDLCMsgBuf;
   gl_GINP_StartIdx = s_idx;
   gl_GINP_MsgLength = gs_RxWholeMsgLength;
#endif

   // if DS_RETX enabled, the params list will be at least 2 bytes long
   gt_ReTXParams.uc_OMSG1_DsReTxEnabled = CO_RETX_INCAPABLE;

   // Field 24: ITU-T G.998.4 parameter field
   if (s_idx < gs_RxWholeMsgLength)
   {
      uint8 uc_Len, uc_Temp;

      // Set bit to indicate these fields are included
      gul_dbgSocMsgControl2 |= AMENDMENT5_RETX_SUPPORT;

      uc_Len = gpuca_RxHDLCMsgBuf[s_idx++];

      if ((s_idx + uc_Len) <= gs_RxWholeMsgLength)
      {
         if (uc_Len > 0)
         {
            // XDSLRTFW-711: BugFix_DS_VDSL2_All_SkipUnknownPara (Start)
            // Note: The fix was done at this place to ignore an additional byte at the end of
            //       the O-Msg1 message. Otherwise UnpackedMsgLengthCheck() kicks in!
            int16 s_IdxTemp;

            // Standard can always be exdended for block with variable length, i.e. parameter can be added.
            // To be future proofen not jet known parameters have to be skipped.
            s_IdxTemp = s_idx;
            s_idx += uc_Len;
            // implication that CO is DS_RETX capable
            gt_ReTXParams.uc_OMSG1_DsReTxEnabled = CO_RETX_CAPABLE;


            //XDSLRTFW-1046 Feature_US_VDSL2_ALL_UsReTx(START_END)
            //gt_ReTXParams.uc_UsReTxStatus is 1 if enabled
            gt_ReTXParams.uc_UsReTxStatus = gpuca_RxHDLCMsgBuf[s_IdxTemp++];


            // framing type
            gt_ReTXParams.uc_OMSG1_DsFramingType = gpuca_RxHDLCMsgBuf[s_IdxTemp++];

            // VTU-O Tx and Rx roundtrip delays
            // CO Tx (transmitter), i.e. CPE downstream
            uc_Temp = gpuca_RxHDLCMsgBuf[s_IdxTemp++];
            gt_ReTXParams.uc_OMSG1_DsHalfRoundTripInDTUS = uc_Temp >> 4;
            gt_ReTXParams.uc_OMSG1_DsHalfRoundTripInSyms = uc_Temp & 0xF;
            // CO Rx (receiver), i.e. CPE upstream
            uc_Temp = gpuca_RxHDLCMsgBuf[s_IdxTemp++];
            gt_ReTXParams.uc_OMSG1_UsHalfRoundTripInDTUS = uc_Temp >> 4;
            gt_ReTXParams.uc_OMSG1_UsHalfRoundTripInSyms = uc_Temp & 0xF;

            // DS 1_over_S
            gt_ReTXParams.uc_OMSG1_Ds1overSMax = gpuca_RxHDLCMsgBuf[s_IdxTemp++];

            // US 1_over_S
            gt_ReTXParams.uc_OMSG1_Us1overSMax = gpuca_RxHDLCMsgBuf[s_IdxTemp++];

            // Downstream D1 values supported
            if (s_idx > s_IdxTemp)
            {
               // Indicates the optional block interleaving depth values supported by the VTU-O transmitter
               gt_ReTXParams.uc_amend2_support = CO_RETX_DS_OPT_BLK_ILV_SUPPPORT;
               //XDSLRTFW-2153 (Start)
               //XDSLRTFW-1617 (Start)
               //XDSLRTFW-2162 (Start - End)
               gft_Intra_DTU_Ilv_DS = FALSE;
               gt_ReTXParams.uc_OMSG1_DsIntDepthsupported = gpuca_RxHDLCMsgBuf[s_IdxTemp++];
               guc_DS_ReTx_Max_D_CO_support =   gpuca_RxHDLCMsgBuf[s_IdxTemp - 1] ;
               if ((gus_ReTxOptionsEnabled & DS_INTRA_DTU_ILV_CAPABLE) && (guc_DS_ReTx_Max_D_CO_support > 1))
               {
                  //XDSLRTFW-2162 (Start - End)
                  gft_Intra_DTU_Ilv_DS = TRUE;
               }
               //XDSLRTFW-1617 (End)
               //XDSLRTFW-2153 (End)
            }

            // for debug; ReTX field does exist
            gl_NoRetxMsg = 0;
            // XDSLRTFW-711: BugFix_DS_VDSL2_All_SkipUnknownPara (End)
         }
      }
      else
      {
         goto EndOf_OMsg1_Interp_Amend5_not_complied;
      }
   }
   else
   {
      goto EndOf_OMsg1_Interp_Amend5_not_complied;
   }

   // Field 25: ITU-T G.993.5 parameter field
   if (s_idx < gs_RxWholeMsgLength)
   {
      uint8 uc_Len;

      // Skip G.Vector
      uc_Len = gpuca_RxHDLCMsgBuf[s_idx++];

      // Note: The if-case was done to ignore an additional byte at the end of
      //       the O-Msg1 message. Otherwise UnpackedMsgLengthCheck() kicks in!
      if ((s_idx + uc_Len) <= gs_RxWholeMsgLength)
      {
         s_idx += uc_Len;
      }
      else
      {
         goto EndOf_OMsg1_Interp_Amend5_not_complied;
      }
      // Set bit to indicate these fields are included
// Note: Not needed, because no Vectoring information gets transmitted here!
//       Further the O-Signature has already enabled the flag!
//      gul_dbgSocMsgControl2 |= AMENDMENT5_VECTORING_SUPPORT;
   }
   else
   {
      goto EndOf_OMsg1_Interp_Amend5_not_complied;
   }

   // Field #26:  Control parameter "REINIT_TIME_THRESHOLDds"
   if (s_idx < gs_RxWholeMsgLength)
   {
      // Skip the parameter until it is supported!
      s_idx++;
   }
   // Field #27: Parameter "Time Synchronization capability"
   if (s_idx < gs_RxWholeMsgLength)
   {
      // Skip the parameter until it is supported!
      s_idx++;
      // Set bit to indicate these fields are included
      gul_dbgSocMsgControl2 |= AMENDMENT7_TIME_SYNC_SUPPORT;
   }


   goto EndOf_OMsg1_Interp;

EndOf_OMsg1_Interp_Amend5_not_complied:
   gul_SocMsgNotCompliedAmends |= AMEND5_NOT_COMPLIED_IN_OMsg1;

EndOf_OMsg1_Interp:

#ifdef DEBUG_GINP_MSGS
   if (guc_DebugReTXTrainingMsg == 1)
   {
      _flag(1);
   }
#endif

   // INTEROP against IFX version 9.4.x
   if (gft_IfxAtmPtmFix)
   {
      // RT sends both ATM & PTM capability lists if PTM mode is selected
      // DS
      if ((gta_DsBearerChannel[BC0].s_Control & 0x7) == TPS_TC_TYPE_PTM)
      {
         gta_DsBearerChannel[BC0].s_Control |= TPS_TC_TYPE_ATM;
         memcpy(&gta_DsBearerChannel[BC0].ta_TpsTcType[(TPS_TC_TYPE_ATM >> 1)], &gta_DsBearerChannel[BC0].ta_TpsTcType[(TPS_TC_TYPE_PTM >> 1)], sizeof(TPS_TC_Type_t));
      }
      // US
      if ((gta_UsBearerChannel[BC0].s_Control & 0x7) == TPS_TC_TYPE_PTM)
      {
         gta_UsBearerChannel[BC0].s_Control |= TPS_TC_TYPE_ATM;
         memcpy(&gta_UsBearerChannel[BC0].ta_TpsTcType[(TPS_TC_TYPE_ATM >> 1)], &gta_UsBearerChannel[BC0].ta_TpsTcType[(TPS_TC_TYPE_PTM >> 1)], sizeof(TPS_TC_Type_t));
      }
   }

   // To read the TC loaded if PPA is 3.2 or above
   {
      uint16 us_TC_required;     // Variable used to determine the TC loaded
                                 // in the system and the required TC

      // The TC required to be loaded based on CO or CPE capability
      us_TC_required = TPS_TC_TYPE_ATM_PTM;     // Initialize to cannot be concluded at this point of time.
                                                // Have to wait till O-TPS message

      if (gta_DsBearerChannel[BC0].s_Control & gt_DecMsg_O_Msg1_VDSL2.ta_UsBC[BC0].s_Control == 0)
      {
         us_TC_required = TPS_TC_DISABLED;
         EnterFailStates(E_CODE_TC_NOT_SUPPORTED);
      }
      else if (gta_DsBearerChannel[BC0].s_Control & gt_DecMsg_O_Msg1_VDSL2.ta_UsBC[BC0].s_Control == TPS_TC_TYPE_PTM)
      {
         us_TC_required = TPS_TC_TYPE_PTM;
      }
      else if (gta_DsBearerChannel[BC0].s_Control & gt_DecMsg_O_Msg1_VDSL2.ta_UsBC[BC0].s_Control == TPS_TC_TYPE_ATM)
      {
         us_TC_required = TPS_TC_TYPE_ATM;
      }

      // XDSLRTFW-3008 - EVT_TC_StatusGet
      // Send following autonomous message to DSL-API
      // TC information:
      // EVT_TC_StatusGet                 0x0E22
      // DSL_TC_STATUS                    DSL 14      DSL_14
      //
      // Reports the used TC-Mode.
      // Supported settings:
      //    0x1 EFM_TC EFM TC
      //    0x2 ATM_TC ATM TC
      // XDSLRTFW-3325 (Start_End)
      if (((us_TC_required == TPS_TC_TYPE_ATM) || (us_TC_required == TPS_TC_TYPE_PTM)) && (gft_bonding_TC_autonomous_sent == FALSE))
      {
         // XDSLRTFW-3711 (Start)
         // The PPE clock frequency needs to be configured based on the profile selected, bonding capability and TC mode.
         // The PPE frequency which needs to be configured is indicated to the PPE driver by configuring the DREG register 0x7DCE (DREG_MISCRAM14_ADDR)
         // before sending out the autonomous message.
         Ppe_clockChange(us_TC_required, gt_ProfileAct.us_ProfileSelected);
         // XDSLRTFW-3711 (End)
         gt_Bonding_TC_Info.s_TC_Type = us_TC_required;
         gft_autonomous_msg_flag = TRUE;
      }
   }

   return(UnpackedMsgLengthCheck(s_idx, gs_RxWholeMsgLength));
}
