/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;   The function for O-PMD message.
;
*****************************************************************************/
// ***********************************************************************************************************
// InterpPmdMsg_VDSL2.c
//
// History
//
// 08/08/2012 Vinjam: Added a CMV (TEST 40 0 Bit-0) to force upstream fine gains to unity (0x2000).
//                    CMV is disabled by default. It is added for testing purpose only to validate CPE Tx PSD as per Standard.
//                    If the CMV is enabled, it disables the upstream bitswap to avoid change in forced upstream Tx finegains for PSD measurement.
//                    Grep for XDSLRTFW-503 Task_All_US_All_All_ForceFineGainsToUnityForPSDmeasurement
//
// 29/8/2012 Vinjam: Changed CMV (from "TEST 40 0 0x1" to "TEST 28 0 0x2") to force upstream fine gains to unity
//                    CMV is changed to keep it same across ARx & VRx platforms.
//                    CMV is disabled by default. It is added for testing purpose only to validate CPE Tx PSD as per Standard.
//                    If the CMV is enabled, it disables the upstream bitswap to avoid change in forced upstream Tx finegains for PSD measurement.
//                    Grep for XDSLRTFW-503 Task_All_US_All_All_ForceFineGainsToUnityForPSDmeasurement
// 11/10/2012 Vinjam: Corrected the problem in forcing upstream fine gains.
//                    Upstream fine gains can be forced using TEST 28 0 0x2. If this TEST CMV is enabled, then it also disables upstream bitswap
//                    to make sure the upstream fine gains are not modified during show time.
//                    Grep for XDSLRTFW-503 Task_All_US_All_All_ForceFineGainsToUnityForPSDmeasurement
// ************************************************************************************************************

#include "common.h"
#include "gdata.h"
#include "socmessage.h"

#include "ToneReorder.h"
#include "cmv.h"


static int16 InterpPmdMsg_Fields2_5_VDSL2(int16 s_idx, int16 s_NumBands, uint8 *puca_OctetBuffer);

/*^^^
 *------------------------------------------------------------------------
 *
 *
 *  Description:  O-PMD message.
 *
 *  Prototype:
 *           int16 InterpOPmdMsg_VDSL2(void);
 *
 *
 *  Input Arguments:
 *      None
 *
 *  Output Arguments:
 *
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
int16 InterpOPmdMsg_VDSL2(void)
{
   uint8 *puca_OctetBuffer;
   int16 s_idx;

   puca_OctetBuffer = gpuca_RxHDLCMsgBuf;

   DSH_SendStream(DSH_O_PMD, (uint16)gs_RxWholeMsgLength,(void *)gpuca_RxHDLCMsgBuf);

   // Field1 - Message descriptor
   s_idx = 1;                          // gets be skipped!

   // Field2 Trellis (whether trellis coding will be used) (1 byte)
   gft_TxTcmFlag = puca_OctetBuffer[s_idx++];

   // Field3 Bits and gains table for active sub-carriers (2*Nsc bytes where Nsc
   //        is # used carriers)
   {
      uint16 j, us_EncodedVal, s_gi;
      int16 s_channel;
      int16 *psa_BandLeftChannel = &gsa_TxBandLeftChannel[0];
      int16 *psa_BandRightChannel = &gsa_TxBandRightChannel[0];
      int32 l_temp;

      gus_Tx_Tcm_Num1bits = 0;
      gs_TxNumTonesUsed = 0;

      for (j = 0; j<gs_NumOfTxBands; j++ )
      {
         for (s_channel = psa_BandLeftChannel[j]; s_channel <= psa_BandRightChannel[j]; s_channel++)
         {
            us_EncodedVal = puca_OctetBuffer[s_idx++]<<8;
            us_EncodedVal |= puca_OctetBuffer[s_idx++];

            ghpuca_TxBat_Inactive[s_channel] = us_EncodedVal>>12;

            // Convert to Q3.13 format
            s_gi = (us_EncodedVal & 0x0FFF) << 4;
            //XDSLRTFW-503 Task_All_US_All_All_ForceFineGainsToUnityForPSDmeasurement (Start)
            if(TESTArray[TEST_Control3] & TEST_ForceUpStreamFineGainsToUnity)
            {
               //Set TX gain to unity
               s_gi = 512 << 4;
            }
            //XDSLRTFW-503 Task_All_US_All_All_ForceFineGainsToUnityForPSDmeasurement (End)
            //multiply current TxFineGains settings, which define the PSD shaping,
            //with the Fine Gains received from the far end.
            //both are in 3.13 format at this point, so the result is 6.26
            l_temp = (int32)ghpsa_TxFineGains_Inactive[s_channel] * (int32)s_gi;

            // add 1 bit for rounding purposes
            l_temp = (l_temp + (1 << 12));

            // shift to get 19.13 format purposes
            l_temp = (l_temp >> 13);

            // use the lower 16 bits, now in 3.13 format
            ghpsa_TxFineGains_Inactive[s_channel] = (int16)l_temp;

            //Count the number of 1-bit tone
            if(ghpuca_TxBat_Inactive[s_channel] == 1)
            {
               gus_Tx_Tcm_Num1bits++;
            }
         }

         // Keep a count of used Tx tones
         gs_TxNumTonesUsed += psa_BandRightChannel[j] - psa_BandLeftChannel[j] + 1;
      }

      //XDSLRTFW-503 Task_All_US_All_All_ForceFineGainsToUnityForPSDmeasurement (Start)
      if(TESTArray[TEST_Control3] & TEST_ForceUpStreamFineGainsToUnity)
      {
         gft_EnableTxBitSwap = FALSE; //Added here for testing purpose only - Vinjam
      }
   }

   // Field4 Tone ordering table for active sub-carriers (3*Nsc/2 bytes where Nsc
   //        is # used carriers)
   s_idx = InterpPmdMsg_Fields2_5_VDSL2(s_idx, gs_NumOfTxBands, puca_OctetBuffer);


   // Field 5: Initialization status
   if (s_idx < gs_RxWholeMsgLength)
   {
      //Skip "initialization status"
      s_idx++;

      // Set bit to indicate these fields are included
      gul_dbgSocMsgControl2 |= AMENDMENT1_OPMD_INITIALIZATION_STAT_SUPPORT;
   }
   else
   {
      gul_SocMsgNotCompliedAmends |= AMEND1_NOT_COMPLIED_IN_OPmd;
   }

   // Field 6: ITU-T G.998.4 parameter field
   // Field 7: ITU-T G.993.5 parameter field
   if ((s_idx + 2) <= gs_RxWholeMsgLength)
   {
      uint8 uc_Len;

      // Skip field 6 (G.INP)
      uc_Len = puca_OctetBuffer[s_idx++];
      s_idx += uc_Len;

      if (s_idx < gs_RxWholeMsgLength)
      {
         // skip field 7 (G.vec)
         uc_Len = puca_OctetBuffer[s_idx++];
         s_idx += uc_Len;
      }

      if (s_idx > gs_RxWholeMsgLength)
      {
         // note that CO doesn't seem to comply to Amend5
         gul_SocMsgNotCompliedAmends |= AMEND5_NOT_COMPLIED_IN_OPmd;
      }
   }


   return(UnpackedMsgLengthCheck(s_idx, gs_RxWholeMsgLength));
}


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : InterpPmdMsg_Fields2_5_VDSL2
 *
 *  Description:  Unpacks Pmd Message Fields 2 through 5
 *
 *  Prototype:
 *    int16 InterpPmdMsg_Fields2_5_VDSL2(int16 s_idx,
 *                                DecMsg_PMS_VDSL2_t *pt_DecMsg,
 *                                       int16 s_NumBands,
 *                                uint8 *puca_OctetBuffer)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
int16 InterpPmdMsg_Fields2_5_VDSL2(int16 s_idx, int16 s_NumBands, uint8 *puca_OctetBuffer)
{
   uint16 j;

   int16 s_TxNumTones;

   if (gs_RxNumTones > gs_TxNumTones)
      s_TxNumTones = gs_RxNumTones;
   else
      s_TxNumTones = gs_TxNumTones;


//   uint16 us_EncodedVal, s_gi;
//   int16 *psa_BandLeftChannel = &gsa_TxBandLeftChannel[0];
//   int16 *psa_BandRightChannel = &gsa_TxBandRightChannel[0];
//   int16 s_channel;
//
//   int32 l_temp;
//
//   // Field2 Trellis (whether trellis coding will be used) (1 byte)
//   gft_TxTcmFlag = puca_OctetBuffer[s_idx++];
//
//   gs_TxNumTonesUsed = 0;
//   gus_Tx_Tcm_Num1bits = 0;
//
//   // Field3 Bits and gains table for active sub-carriers (2*Nsc bytes where Nsc
//   // is # used carriers)
//   for (j = 0; j<s_NumBands; j++ )
//   {
//      for (s_channel = psa_BandLeftChannel[j]; s_channel <= psa_BandRightChannel[j]; s_channel++)
//      {
//         us_EncodedVal = puca_OctetBuffer[s_idx++]<<8;
//         us_EncodedVal |= puca_OctetBuffer[s_idx++];
//
//         ghpuca_TxBat_Inactive[s_channel] = us_EncodedVal>>12;
//
//         // Convert to Q3.13 format
//         s_gi = (us_EncodedVal & 0x0FFF) << 4;
//         //XDSLRTFW-503 Task_All_US_All_All_ForceFineGainsToUnityForPSDmeasurement (Start)
//         if(TESTArray[TEST_Control3] & TEST_ForceUpStreamFineGainsToUnity)
//         {
//            //Set TX gain to unity
//            s_gi = 512 << 4;
//         }
//         //XDSLRTFW-503 Task_All_US_All_All_ForceFineGainsToUnityForPSDmeasurement (End)
//         //multiply current TxFineGains settings, which define the PSD shaping,
//         //with the Fine Gains received from the far end.
//         //both are in 3.13 format at this point, so the result is 6.26
//         l_temp = (int32)ghpsa_TxFineGains_Inactive[s_channel] * (int32)s_gi;
//
//         // add 1 bit for rounding purposes
//         l_temp = (l_temp + (1 << 12));
//
//         // shift to get 19.13 format purposes
//         l_temp = (l_temp >> 13);
//
//         // use the lower 16 bits, now in 3.13 format
//         ghpsa_TxFineGains_Inactive[s_channel] = (int16)l_temp;
//
//         //Count the number of 1-bit tone
//         if(ghpuca_TxBat_Inactive[s_channel] == 1)
//         {
//            gus_Tx_Tcm_Num1bits++;
//         }
//      }
//
//      // Keep a count of used Tx tones
//      gs_TxNumTonesUsed += psa_BandRightChannel[j] - psa_BandLeftChannel[j] + 1;
//   }
//
//   //XDSLRTFW-503 Task_All_US_All_All_ForceFineGainsToUnityForPSDmeasurement (Start)
//   if(TESTArray[TEST_Control3] & TEST_ForceUpStreamFineGainsToUnity)
//   {
//      gft_EnableTxBitSwap = FALSE; //Added here for testing purpose only - Vinjam
//   }
   //XDSLRTFW-503 Task_All_US_All_All_ForceFineGainsToUnityForPSDmeasurement (End)
   // Field4 Tone ordering table for active sub-carriers (3*Nsc/2 bytes where Nsc
   // is # used carriers)
   {
      int16 s_TxNumTonesUsedTemp;
      int16 s_LSBword, s_MSBword, us_word;
      int16 *psa_TRT;

      psa_TRT = &ghpsa_TxToneOrder_Inactive[s_TxNumTones - gs_TxNumTonesUsed];

      // If the number of subcarriers in the MEDLEYus set is odd, the last 12 bits
      // of the field shall be set to ZERO (and ignored by the receiver).
      s_TxNumTonesUsedTemp = gs_TxNumTonesUsed;
      if(s_TxNumTonesUsedTemp & 1)
      {
         s_TxNumTonesUsedTemp--;
      }

      // ANXQ_SUPPORT
      if (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK)
      {
         for (j = 0; j < s_TxNumTonesUsedTemp; j=j+2)
         {
            // Get next 4 bytes
            s_MSBword  = (puca_OctetBuffer[s_idx++] << 8); // byte 1
            s_MSBword |= puca_OctetBuffer[s_idx++];        // byte 2
            s_LSBword  = (puca_OctetBuffer[s_idx++] << 8); // byte 3
            s_LSBword |= puca_OctetBuffer[s_idx++];        // byte 4

            if (gul_dbgSocMsgControl2 & SWAP_TONE_INDEX_IN_TRT_MSG_EXCHANGE)
            {
               // Ikanos way
               us_word = s_LSBword;
               s_LSBword = s_MSBword;
               s_MSBword = us_word;
            }

            *psa_TRT++ = s_LSBword;
            *psa_TRT++ = s_MSBword;
         }
      }
      else
      {
         for (j = 0; j < s_TxNumTonesUsedTemp; j=j+2)
         {
            // Get next 3 bytes
            us_word = puca_OctetBuffer[s_idx++];         // byte 1
            us_word <<= 8;
            us_word |= puca_OctetBuffer[s_idx++];        // byte 2
            s_MSBword = (us_word >> 4) & 0x0FFF;
            us_word <<= 8;
            us_word |= puca_OctetBuffer[s_idx++];        // byte 3
            s_LSBword = (us_word & 0x0FFF);

            if (gul_dbgSocMsgControl2 & SWAP_TONE_INDEX_IN_TRT_MSG_EXCHANGE)
            {
               // Ikanos way
               us_word = s_LSBword;
               s_LSBword = s_MSBword;
               s_MSBword = us_word;
            }

            *psa_TRT++ = s_LSBword;
            *psa_TRT++ = s_MSBword;
         }
      }

      // Note: This was done to safe cycles.
      //       But for sure more code is needed!
      // If the number of subcarriers in the MEDLEYus set is odd,
      // the last 12 bits of the field shall be set to ZERO (and ignored by the
      // receiver).
      if(gs_TxNumTonesUsed & 1)
      {
         // ANXQ_SUPPORT
         if (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK)
         {
            s_MSBword  = (puca_OctetBuffer[s_idx++] << 8); // byte 1
            s_MSBword |= puca_OctetBuffer[s_idx++];        // byte 2
            s_LSBword  = (puca_OctetBuffer[s_idx++] << 8); // byte 3
            s_LSBword |= puca_OctetBuffer[s_idx++];        // byte 4
         }
         else
         {
            us_word = puca_OctetBuffer[s_idx++];           // byte 1
            us_word <<= 8;
            us_word |= puca_OctetBuffer[s_idx++];          // byte 2
            s_MSBword = (us_word >> 4) & 0x0FFF;
            us_word <<= 8;
            us_word |= puca_OctetBuffer[s_idx++];          // byte 3
            s_LSBword = (us_word & 0x0FFF);
         }

         if (gul_dbgSocMsgControl2 & SWAP_TONE_INDEX_IN_TRT_MSG_EXCHANGE)
         {
            // Ikanos way
            s_LSBword = s_MSBword;
         }

         *psa_TRT = s_LSBword;
      }
   }

   return(s_idx);
}
