/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;   The function for O-PMS message.
;
*****************************************************************************/

// ****************************************************************************************************
// InterpOPmsMsg_VDSL2.c
// History :
//  06/05/2013 Varun : Added code(Debug option) to capture raw data of all Tx and Rx(O-PMS in particular) training
//                     messages (G.Hs + training)
//                     Grep for "XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer"
//  22/07/2013 Varun : Incorporated the code changes to support US ReTx
//                     Grep for "XDSLRTFW-1078 Feature_US_VDSL2_ALL_UsReTx"
//  10/09/2013 Sooraj: Added framing changes to support DS-SRA with ReTx
//                     Grep for XDSLRTFW-1028_SRAds_Support_with_DS_ReTx
//  29/10/2013 Sooraj: Added framing changes to support US-SRA with ReTx
//                     Grep for XDSLRTFW-1261_SRAus_Support_with_US_ReTx
// 30/10/2014 Anantha Ramu: Modifications to receive US ReTx D sent by VTU-O.
//                     Grep for "XDSLRTFW-1617"
//****************************************************************************************************
#include <string.h>
#include "common.h"
#include "gdata.h"
#include "socmessage.h"
#include "DebugBuffer.h"
#include "vdsl_xception.h"
#include "cmv.h"

#include "Framing_VDSL2.h"


/*^^^
 *------------------------------------------------------------------------
 *
 *
 *  Description:  O-PMS message.
 *
 *  Prototype:
 *           int16 InterpOPmsMsg_VDSL2(void);
 *
 *
 *  Input Arguments:
 *      None
 *
 *  Output Arguments:
 *
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
int16 InterpOPmsMsg_VDSL2(void)
{
   uint8 *puca_OctetBuffer;

   int16 s_lp;
   int16 s_idx;
   uint32 ul_Temp;
   VDSL2Config_t *pt_Config;
   uint32 Nom, Den;

   puca_OctetBuffer = gpuca_RxHDLCMsgBuf;

#ifdef DEBUG_TRACES
   // XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer(START_END)
   LogMessages(4,(uint16)gpuca_RxHDLCMsgBuf[0], (uint16)gs_RxWholeMsgLength, gpuca_RxHDLCMsgBuf, DEBUG_BUFFER_DELIMITER_VDSL2);
#endif //#ifdef DEBUG_TRACES
   memcpy(&gsa_DebugStreamBuffer[5][0],gpuca_RxHDLCMsgBuf,(uint16)gs_RxWholeMsgLength);
   DSH_SendStream(DSH_O_PMS, (uint16)gs_RxWholeMsgLength,(void *)&gsa_DebugStreamBuffer[5][0]);

   // Clear the config structure, which gets populated with message Fields 4/5/6/7
   pt_Config = &gt_tx_config_v2;
   memset(pt_Config, 0, sizeof(VDSL2Config_t));

   // Field1 - Message descriptor
   s_idx = 1;                          // gets be skipped!

   // Field 2 MSG_LP - latency path (0 or 1) in which the message-based OH
   //                  information is to be transmitted (1 byte)
   // Note: If the ROC is enabled, MSGLP shall be equal to 0.
   gt_tx_TPS_Map.s_IBITSlp = puca_OctetBuffer[s_idx];
   guc_ohmsg_path_tx = puca_OctetBuffer[s_idx++];

   // Field 3 Mapping of bearers to latency paths (1 byte)
   {
      uint8 uc_temp;

      uc_temp = puca_OctetBuffer[s_idx++];
      gt_tx_TPS_Map.s_BCtoLP[BC0] = (uc_temp >> 4);
      gt_tx_TPS_Map.s_BCtoLP[BC1] = (uc_temp & 0xF);
   }

   // Field 4 / 5 - Bx0, Bx1
   {
      int16 s_bc;

      for (s_bc=0; s_bc<NUM_BEARER_CHANNELS; s_bc++)
      {
         // Check which latency path is assigned to s_bc
         s_lp = gt_tx_TPS_Map.s_BCtoLP[s_bc];

         // Bx0 - number of bytes from bearer0, per mux data frame (1 byte)
         if (s_lp != DISABLED_LP)
         {
            pt_Config->sa_Bpn[s_lp][s_bc] = puca_OctetBuffer[s_idx++];
         }
         else
         {
            s_idx++;
         }
      }
   }

   // Field 6 / 7 - Latency path descriptor
   // Note: If the ROC is enabled, the framing parameters for latency path #0 shall be
   //       contained in the ROC descriptor.
   {
      for (s_lp = 0; s_lp < NUM_DATA_PATHS; s_lp++)
      {
         // Tp - the number of MDF in a sub-frame (1 byte)
         pt_Config->s_Tp[s_lp] = puca_OctetBuffer[s_idx++];

         // Gp - the total number of OH bytes in a sub-frame (1 byte)
         pt_Config->s_Gp[s_lp] = puca_OctetBuffer[s_idx++];

         // Fp - number of OH frames in the super-frame (1 byte)
         pt_Config->s_Fp[s_lp] = puca_OctetBuffer[s_idx++];

         // Mp - the value of Mp for latency path (1 byte)
         pt_Config->s_Mp[s_lp] = puca_OctetBuffer[s_idx++];

         // Lp - the value of Lp for latency path (2/3 bytes)
         {
            uint32 ul_temp;

            ul_temp = 0;
            // ANXQ_SUPPORT
            if (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK)
            {
               ul_temp = (puca_OctetBuffer[s_idx++] << 16);
            }
            ul_temp |= puca_OctetBuffer[s_idx++] << 8;         // "OR" can be done always, because the variable
            ul_temp |= puca_OctetBuffer[s_idx++];              // "ul_temp" gets be cleared at the begin.
            pt_Config->ul_Lp[s_lp] = ul_temp;
         }

         // the value of Rp for latency path (1 byte)
         pt_Config->s_Rp[s_lp] = puca_OctetBuffer[s_idx++];

         // the value of Ip for latency path (1 byte)
         pt_Config->s_Ip[s_lp] = puca_OctetBuffer[s_idx++];

         // Dp - interleaver depth Dp for latency path (2 bytes)
         pt_Config->s_Dp[s_lp] = puca_OctetBuffer[s_idx++] << 8;
         pt_Config->s_Dp[s_lp] |= puca_OctetBuffer[s_idx++];
      }

      //XDSLRTFW-1078 Feature_US_VDSL2_ALL_UsReTx(START)
      //if ReTx selected in US =>  just initialize the Values of Fp,Dp and Ip to 1 to avoid any problems with hardware (as varibles are irrelavant)
      if((gt_ReTXParams.uc_UsReTxStatus==US_RETX_IN_USE) &&
            ((gus_ReTxOptionsEnabled & (CPE_DS_US_RETX_CAPABLE|CPE_DS_RETX_CAPABLE)) == CPE_DS_US_RETX_CAPABLE))
      {
         // Fp - number of OH frames in the super-frame (1 byte)
         pt_Config->s_Fp[1] = 1;

         // the value of Ip for latency path (1 byte)
         //pt_Config->s_Ip[1] = 1;
         pt_Config->s_Ip[1] = ComputeCWSize(&gt_tx_config_v2, LP1);

         //Dp - interleaver depth Dp
         pt_Config->s_Dp[1] = 1;
      }
      //XDSLRTFW-1078 Feature_US_VDSL2_ALL_UsReTx(END)

      // compute the VDSL2 derived framing parameters
      Compute_VDSL2Framing(pt_Config, &gt_tx_TPS_Map, &gs_PMDFramesPerTxIBStructure);
   }

   // Field 8,9; MaxD0 - maximal interleaver delay in DS direction (3 bytes)
   for (s_lp=0; s_lp < NUM_DATA_PATHS; s_lp++)
   {
      ul_Temp = puca_OctetBuffer[s_idx++] << 16;
      ul_Temp |= puca_OctetBuffer[s_idx++] << 8;
      ul_Temp |= puca_OctetBuffer[s_idx++];

      gla_MaxInlvDelay[s_lp] = ul_Temp;
   }


   // presume there won't be enough bytes in the msg buffer for ReTX params
   gl_NoRetxMsg |= 0x8;


   // Field 10, 11: max_delay_octetUS,0/1 - maximal interleaver delay in US direction (3 bytes)
   // New fields added in G.993.2 Amendment 1
   if(s_idx + 6 <= gs_RxWholeMsgLength)
   {
      for (s_lp=0; s_lp < NUM_DATA_PATHS; s_lp++)
      {
         ul_Temp = puca_OctetBuffer[s_idx++] << 16;
         ul_Temp |= puca_OctetBuffer[s_idx++] << 8;
         ul_Temp |= puca_OctetBuffer[s_idx++];

         gla_MaxInlvDelayUs[s_lp] = ul_Temp;
      }

      // Set bit to indicate these fields are included
      gul_dbgSocMsgControl2 |= AMENDMENT1_OPMS_MAX_DELAY_OCTET_SUPPORT;
   }
   else
   {

      gul_SocMsgNotCompliedAmends |= AMEND1_NOT_COMPLIED_IN_OPms;
      goto EndOf_OPms_Interp;
   }


   // Skip over SOS and ROC fields
   // Note: This block of code should be changed when SOS/ROC should be implemented!

   // At least 1 byte for SOS band descriptor!
   if (s_idx < gs_RxWholeMsgLength)
   {
      uint16 us_NumOfDescriptorElements;

      // Field 12: US SOS tone groups
      // skip over the SOS band descriptor
      us_NumOfDescriptorElements = puca_OctetBuffer[s_idx++];    // Num of US SOS Tone groups.
      if (us_NumOfDescriptorElements > MAX_SOS_TONE_GROUPS)
      {
         goto EndOf_OPms_Interp;
      }
      Skip12Or16BitPairDescriptors(&s_idx, us_NumOfDescriptorElements);
   }

   // Extract 10 or 11 (AnxQ) bytes for ROC descriptor!
   // G.993.2: "If the ROC is not enabled in the upstream direction, the values
   //           in the ROC descriptor shall all be set to zero and shall be ignored by the receiver."
   // ANXQ_SUPPORT
   {
      uint8 uc_UnpackXBitsOctetNum;

      uc_UnpackXBitsOctetNum = 10;
      if (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK)
      {
         uc_UnpackXBitsOctetNum++;
      }

      if((s_idx + uc_UnpackXBitsOctetNum) <= gs_RxWholeMsgLength)
      {
         // Field 13: US ROC parameters (ROC Descriptor), 10 or 11 (AnxQ) bytes
         s_idx += uc_UnpackXBitsOctetNum;
      }
      else
      {
         gul_SocMsgNotCompliedAmends |= AMEND3_NOT_COMPLIED_IN_OPms;
         goto EndOf_OPms_Interp;
      }
   }



#ifdef DEBUG_GINP_MSGS
   gpuca_GINP_MsgBuf = puca_OctetBuffer;
   gl_GINP_StartIdx = s_idx;
   gl_GINP_MsgLength = gs_RxWholeMsgLength;
#endif

   // Field 14: ITU-T G.998.4 parameter field (Retransmission)
   if (s_idx < gs_RxWholeMsgLength)
   {
      uint8 uc_Len;

      //Handle G.Inp
      uc_Len = puca_OctetBuffer[s_idx++];

      if ((s_idx + uc_Len) <= gs_RxWholeMsgLength)
      {
         if (uc_Len > 0)
         {
            // XDSLRTFW-711: BugFix_DS_VDSL2_All_SkipUnknownPara (Start)
            // Note: The fix was done at this place to ignore an additional byte at the end of
            //       the O-Pms message. Otherwise UnpackedMsgLengthCheck() kicks in!
            int16 s_IdxTemp;

            // Standard can always be exdended for block with variable length, i.e. parameter can be added.
            // To be future proofen not jet known parameters have to be skipped.
            s_IdxTemp = s_idx;
            s_idx += uc_Len;

            gt_ReTXParams.us_OPMS_UsFramingType = puca_OctetBuffer[s_IdxTemp++] & 0x3;
            gt_ReTXParams.us_OPMS_UsCodeWordPerDtu_Q = puca_OctetBuffer[s_IdxTemp++];
            gt_ReTXParams.us_OPMS_UsPaddingPerDtu_V = puca_OctetBuffer[s_IdxTemp++];
            gt_ReTXParams.us_OPMS_UsQtx = puca_OctetBuffer[s_IdxTemp++];
            gt_ReTXParams.us_OPMS_UsLookBackValue = puca_OctetBuffer[s_IdxTemp++];

            //if framing type selected is not 1 or 3 then fail here
            // check if the received Qtx is within the valid range: 1 <= Qtx <= 63
            // also check if the received lb is valid: lb <= min(31, Qtx)
            // Check the support for G.Inp Ammend - 1
            gt_ReTXParams.uc_OPMS_G_Inp_Amend1_Support = 0;
            // XDSLRTFW-1028_SRAds_Support_with_DS_ReTx (START)
            if (s_idx > s_IdxTemp)  // (uc_Len > 5)
            {
               // The field is coded as [0000 00us], where
               // s=1 if OLR type 5 (SRA modified for G.998.4) is supported in DS and s=0 otherwise
               // u=1 if OLR type 6 (SOS modified for G.998.4) is supported in DS and u=0 otherwise
               gt_ReTXParams.uc_OPMS_G_Inp_Amend1_Support = (puca_OctetBuffer[s_IdxTemp++] & 3);
            }
            // XDSLRTFW-1028_SRAds_Support_with_DS_ReTx (END)
            // XDSLRTFW-1261_SRAus_Support_with_US_ReTx (START)
            if (s_idx > s_IdxTemp)  // (uc_Len > 6)
            {
               // The field is coded as [0000 00us], where
               // s=1 if OLR type 5 (SRA modified for G.998.4) is supported in US and s=0 otherwise
               // u=1 if OLR type 6 (SOS modified for G.998.4) is supported in US and u=0 otherwise
               gt_ReTXParams.uc_OPMS_G_Inp_Amend1_Support |= ((puca_OctetBuffer[s_IdxTemp++] & 3) << 4);
            }
            // XDSLRTFW-1261_SRAus_Support_with_US_ReTx (END)

            if (s_idx > s_IdxTemp)
            {
               gt_ReTXParams.uc_OPMS_US_BlkILV_Depth_selected=(puca_OctetBuffer[s_IdxTemp++]);
               //XDSLRTFW-1617 (Start)
               guc_ReTx_US_D = gt_ReTXParams.uc_OPMS_US_BlkILV_Depth_selected;
               gt_tx_config_v2.s_Dp[LP1] = gt_ReTXParams.uc_OPMS_US_BlkILV_Depth_selected;
               //XDSLRTFW-1617 (End)
               if(gt_ReTXParams.uc_OPMS_US_BlkILV_Depth_selected > 1)
               {
                  //US Intra DTU interleaving active
                  gus_DsUsReTxStatus |= RETX_US_INTRA_DTU_ILV_IN_USE;
               }
            }
            gl_NoRetxMsg &= ~0x8;
            // XDSLRTFW-711: BugFix_DS_VDSL2_All_SkipUnknownPara (end)
         }
      }
      else
      {
         // note that CO doesn't seem to comply to Amend5
         goto EndOf_OPms_Interp_Amend5_not_complied;
      }
   }
   else
   {
      // note that CO doesn't seem to comply to Amend5
      goto EndOf_OPms_Interp_Amend5_not_complied;
   }

   // Field 15:  ITU-T G.993.5 parameter field (Vectoring)
   if (s_idx < gs_RxWholeMsgLength)
   {
      uint8 uc_Len;

      // Handle G.Vector (G.993.5  - Table 10-10)
      uc_Len = puca_OctetBuffer[s_idx++];

      if ((s_idx + uc_Len) <= gs_RxWholeMsgLength)
      {
         if (uc_Len > 0)
         {
            // XDSLRTFW-711: BugFix_DS_VDSL2_All_SkipUnknownPara (Start)
            // Note: The fix was done at this place to ignore an additional byte at the end of
            //       the O-Pms message. Otherwise UnpackedMsgLengthCheck() kicks in!
            int16 s_IdxTemp;

            // Standard can always be exdended for block with variable length, i.e. parameter can be added.
            // To be future proofen not jet known parameters have to be skipped.
            s_IdxTemp = s_idx;
            s_idx += uc_Len;

            //Table10-10 G.993.5 Field#2 : 1 byte
            gt_DecMsg_O_PMS_G9935.uc_ShowtimeBackChannelEncapsulation =puca_OctetBuffer[s_IdxTemp++];

            // XDSLRTFW-3581 (Start)
            if (gt_DecMsg_O_PMS_G9935.uc_ShowtimeBackChannelEncapsulation != SHOWTIME_BACKCHANNEL_L2_ENCAPSULATION)
            {
               EnterFailStates(E_CODE_ERB_ENCAPSULATION_NOT_SUPPORTED);
            }
            // XDSLRTFW-3581 (End)

            //Table10-10 G.993.5 Field#3   :6 bytes
            gt_DecMsg_O_PMS_G9935.uc_L2VceMacAddress[0] = puca_OctetBuffer[s_IdxTemp++];
            gt_DecMsg_O_PMS_G9935.uc_L2VceMacAddress[1] = puca_OctetBuffer[s_IdxTemp++];
            gt_DecMsg_O_PMS_G9935.uc_L2VceMacAddress[2] = puca_OctetBuffer[s_IdxTemp++];
            gt_DecMsg_O_PMS_G9935.uc_L2VceMacAddress[3] = puca_OctetBuffer[s_IdxTemp++];
            gt_DecMsg_O_PMS_G9935.uc_L2VceMacAddress[4] = puca_OctetBuffer[s_IdxTemp++];
            gt_DecMsg_O_PMS_G9935.uc_L2VceMacAddress[5] = puca_OctetBuffer[s_IdxTemp++];
            //Table10-10 G.993.5 Field#3 :2 bytes
            gt_DecMsg_O_PMS_G9935.us_L2LineID = puca_OctetBuffer[s_IdxTemp++]<<8;
            gt_DecMsg_O_PMS_G9935.us_L2LineID |= puca_OctetBuffer[s_IdxTemp++];
            // XDSLRTFW-711: BugFix_DS_VDSL2_All_SkipUnknownPara (end)
         }
      }
      else
      {
         // note that CO doesn't seem to comply to Amend5
         goto EndOf_OPms_Interp_Amend5_not_complied;
      }
   }
   else
   {
      // note that CO doesn't seem to comply to Amend5
      goto EndOf_OPms_Interp_Amend5_not_complied;
   }

   // XDSLRTFW-1877 : VDSL2 IFEC ATTNDR (Start)
   // Field 16:
   if ((s_idx + 3) <= gs_RxWholeMsgLength)
   {
      uint32 ul_Temp;
      ul_Temp = puca_OctetBuffer[s_idx++] << 16;
      ul_Temp |= puca_OctetBuffer[s_idx++] << 8;
      ul_Temp |= puca_OctetBuffer[s_idx++];
      //XDSLRTFW-1522 (Start_End)
      gul_ATTNDR_max_delay_octets = (ul_Temp & 0xFFFFFF); // >> 1; //Divide by 2 taken care in BgGenFramingATTNDR_VDSL2()
   }
   else
   {
      // note that CO doesn't seem to comply to Amend5
      goto EndOf_OPms_Interp_Amend5_not_complied;
   }
   // XDSLRTFW-1877 : VDSL2 IFEC ATTNDR (End)

   goto EndOf_OPms_Interp;

   //DSM_Vectoring_Debug:
   //if ( gs_PauseControl == 0x5D)
   //Pause(gs_PauseControl);
EndOf_OPms_Interp_Amend5_not_complied:
   gul_SocMsgNotCompliedAmends |= AMEND5_NOT_COMPLIED_IN_OPms;

EndOf_OPms_Interp:

#ifdef DEBUG_GINP_MSGS
   if (guc_DebugReTXTrainingMsg == 3)
   {
      _flag(1);
   }
#endif
   if (gt_ReTXParams.uc_UsReTxStatus == US_RETX_IN_USE)
   {
      //if framing type selected is not 1 or 3 then fail here
      if (!((gt_ReTXParams.us_OPMS_UsFramingType == (US_RETX_FRAMING_TYPE_1))))
      {
         EnterFailStates(E_CODE_RETX_FRAMING_TYPE_NOT_SUPPORTED);
      }
      // check if the received Qtx is within the valid range: 1 <= Qtx <= 63
      if ((gt_ReTXParams.us_OPMS_UsQtx > 63) || (gt_ReTXParams.us_OPMS_UsQtx < 1))
      {
         EnterFailStates(E_CODE_RETX_QTX_OUT_OF_RANGE);
      }
      // also check if the received lb is valid: lb <= min(31, Qtx)
      if (!((gt_ReTXParams.us_OPMS_UsLookBackValue <= gt_ReTXParams.us_OPMS_UsQtx) && (gt_ReTXParams.us_OPMS_UsLookBackValue <= 31)))
      {
         EnterFailStates(E_CODE_RETX_LOOKBACK_OUT_OF_RANGE);
      }

      // XDSLRTFW- 3311 (Start)
      if (pt_Config->s_Rp[LP1] > 16)
      {
         EnterFailStates(E_CODE_RETX_RP_OUT_OF_RANGE);
      }

      if (gt_ReTXParams.us_OPMS_UsPaddingPerDtu_V > 15)
      {
         EnterFailStates(E_CODE_RETX_V_OUT_OF_RANGE);
      }

      if ((pt_Config->sa_Bpn[LP1][BC0] < 1) || (pt_Config->sa_Bpn[LP1][BC0] > 254))
      {
         EnterFailStates(E_CODE_RETX_BP_OUT_OF_RANGE);
      }

      if (pt_Config->s_Mp[LP1] != 1)
      {
         EnterFailStates(E_CODE_RETX_MP_OUT_OF_RANGE);
      }

      if ((pt_Config->s_Nfecp[LP1] < 1) || (pt_Config->s_Nfecp[LP1] > 255))
      {
         EnterFailStates(E_CODE_RETX_NFEC_OUT_OF_RANGE);
      }
      /*0.5 <= Tdtu <= 4, Tdtu=S1*Q=8*Nfec*Q/L1, i.e.  0.5*L1 <= 8*Nfec*Q <= 4*L1*/
      Nom = (uint32)(8 * (pt_Config->s_Nfecp[LP1]) * (gt_ReTXParams.us_OPMS_UsCodeWordPerDtu_Q));
      Den = pt_Config->ul_Lp[LP1];
      if ((Nom < (Den >> 1))||(Nom > (Den << 2)))
      {
         EnterFailStates(E_CODE_INVALID_NUM_OF_DTU_US);
      }
      // XDSLRTFW- 3311 (End)
   }
   return(UnpackedMsgLengthCheck(s_idx, gs_RxWholeMsgLength));
}
