/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright C 2016 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;   The function for O-PRM message.
;
*****************************************************************************/

// ****************************************************************************************************
// InterpOPrmMsg_VDSL2.c
// History :
//  06/05/2013 Varun : Added code(Debug option) to capture raw data of all Tx and Rx(O-PRM in particular) training
//                    messages (G.Hs + training)
//                     Grep for "XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer"
// 09/07/2014 Varun : O-PRM contains many information in Delt mode which DebugBuffer cann't accomodate and
//                    hence disable logging for diagnostic mode
//                    Grep for XDSLRTFW-1507
//****************************************************************************************************

#include <string.h>
#include "common.h"
#include "gdata.h"
#include "socmessage.h"
#include "TxPSDCOntrol.h"
#include "SharedFuncs.h"
#include "ghs.h"
#include "GetQlnHlogForCarrierGroup.h"
#include "CheckForUS0Enable.h"
#include "DebugBuffer.h"
#include "cmv.h"


/*^^^
 *------------------------------------------------------------------------
 *
 *
 *  Description:  O-PRM message.
 *
 *  Prototype:
 *           int16 InterpOPrmMsg_VDSL2(void);
 *
 *
 *  Input Arguments:
 *      None
 *
 *  Output Arguments:
 *
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
int16 InterpOPrmMsg_VDSL2(void)
{
   uint8 *puca_OctetBuffer;
   int16 s_m, s_idx;
   uint16 us_NumOfDescriptorElements;


   puca_OctetBuffer = gpuca_RxHDLCMsgBuf;

#ifdef DEBUG_TRACES
   //XDSLRTFW-1507(START_END)
   if(!(gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG))
   {
      // XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer(START_END)
      LogMessages(4,(uint16)gpuca_RxHDLCMsgBuf[0], (uint16)gs_RxWholeMsgLength, gpuca_RxHDLCMsgBuf, DEBUG_BUFFER_DELIMITER_VDSL2);
   }
#endif //#ifdef DEBUG_TRACES
   if(!(gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG))
   {
      memcpy(&gsa_DebugStreamBuffer[3][0],gpuca_RxHDLCMsgBuf,(uint16)gs_RxWholeMsgLength);
      DSH_SendStream(DSH_O_PRM, (uint16)gs_RxWholeMsgLength,(void *)&gsa_DebugStreamBuffer[3][0]);
   }
   else
   {
      DSH_SendStream(DSH_O_PRM_LD, (uint16)gs_RxWholeMsgLength,(void *)gpuca_RxHDLCMsgBuf);
   }

   // Field1 - Message descriptor
   s_idx = 1;                          // gets be skipped!

   // Decode Field3 before Field2 because we need the
   // info in Field3 to decode Field2
   // ------------------------------------------------
   {
      int16 s_IdxTemp;

      s_IdxTemp = s_idx;

      // Skip Field2
      // Note: Standard contains - The only valid PSD values obtained by the receiver
      //       using the interpolation procedure specified are those for subcarriers
      //       that belong to the MEDLEYds set (communicated in Field #3 of O-PRM)
      us_NumOfDescriptorElements = puca_OctetBuffer[s_IdxTemp++];
      Skip12Or16BitPairDescriptors(&s_IdxTemp, us_NumOfDescriptorElements);

      // Field3 actual used downstream sub-carriers (Band descriptor), MEDLEYds set
      us_NumOfDescriptorElements = puca_OctetBuffer[s_IdxTemp++];
      if (us_NumOfDescriptorElements > MAX_NUM_DS_BANDS)
      {
         return(FALSE);
      }
      else if(us_NumOfDescriptorElements > 0)
      {
         gs_NumOfRxBands = us_NumOfDescriptorElements;
         DecodeBands(&s_IdxTemp, us_NumOfDescriptorElements, puca_OctetBuffer,
                     gsa_RxBandLeftChannel, gsa_RxBandRightChannel);

         // Fill band control information for status CMVs!
         // Note: gt_RxBandControl_Act could also be used later on as original MEDLEYds set!
         VDSL2_BandControlGet(BAND_CONTROL_UPDATE_DS);

         // Save O-PRM RX bandplan, i.e. DS medley set.
         {
            signed int i;

            // For reporting the original bands descriptor array should be used. Therefore it
            // gets be saved in second right/left channel array containing the unfaked info.
            gs_NumOfRxBandsOPrm = gs_NumOfRxBands;
            for(i = 0; i < gs_NumOfRxBands; i++)
            {
               gsa_RxBandLeftChannelOPrm[i] = gsa_RxBandLeftChannel[i];
               gsa_RxBandRightChannelOPrm[i] = gsa_RxBandRightChannel[i];
            }
         }

         if (!CheckForBandOverlap())
         {
            return(FALSE);
         }
      }

      // Field2 - MEDLEY Reference downstream PSD (REFPSDds)
      // Clear the PSD Descriptor table before populating
      memset(&gt_DsREFPSDDescriptorTable, 0, sizeof(DsRefPSDDescriptorTable_t));

      us_NumOfDescriptorElements = puca_OctetBuffer[s_idx++];
      if (us_NumOfDescriptorElements > MAX_NUM_DS_REFPSD_POINTS)
      {
         return(FALSE);
      }
      else if (us_NumOfDescriptorElements > 0)
      {
         gt_DsREFPSDDescriptorTable.us_NumberOfTones = us_NumOfDescriptorElements; // Ds
         UnpackPSD(&s_idx, us_NumOfDescriptorElements, puca_OctetBuffer,
                   NULL,
                   gt_PwrConfigParam.s_Dn_MaxNomPSD,
                   (PSDDescriptorTable_t*)(void *)&gt_DsREFPSDDescriptorTable);    // Ds

         // Sort the MaxDs PSD Descriptor table so that the Masks are in ascending order
         quick_PSDsort((PSDDescriptorTable_t *)(void *)&gt_DsREFPSDDescriptorTable, 0, (int16)(gt_DsREFPSDDescriptorTable.us_NumberOfTones-1));

      }
      else // if (us_NumOfDescriptorElements == 0)
      {
         memcpy(&gt_DsREFPSDDescriptorTable, &gt_MaxDsPSDDescriptorTable,
                MIN(sizeof(DsRefPSDDescriptorTable_t),sizeof(DsPSDDescriptorTable_t)));
      }

      // Update Idx to skip Field3 since we have already decoded this
      s_idx = s_IdxTemp;


      GetMaxNomPSDPerBand(gsa_Dn_MaxNomPSD, (PSDDescriptorTable_t*)(void *)&gt_DsREFPSDDescriptorTable, gt_PwrConfigParam.s_Dn_MaxNomPSD,
                          &gsa_RxBandRightChannelOPrm[0], gs_NumOfRxBandsOPrm);
   }

   // Field4
   // Cyclic extension (1 byte)
   s_m = puca_OctetBuffer[s_idx++];

   // Field5 - Downstream cyclic prefix (2 bytes)
   // Note: Expressed in samples of the downstream sampling rate corresponding to the IDFT size
   //       communicated in Field #7.
   gt_DecMsg_O_Prm_VDSL2.s_DsCpLength = puca_OctetBuffer[s_idx++]<<8;
   gt_DecMsg_O_Prm_VDSL2.s_DsCpLength |= puca_OctetBuffer[s_idx++];

   // Field6 - Downstream transmit window length (1 byte)
   // Note: Expressed in samples of the downstream sampling rate corresponding to the IDFT size
   //       communicated in Field #7.
   gt_DecMsg_O_Prm_VDSL2.s_DsBetaLength = puca_OctetBuffer[s_idx++];

   // Field7 - VTU-O IDFT size (1 byte)
   // Note: This value may be different from the initial value that
   //       was exchanged during the ITU-T G.994.1 handshake phase.
   {
      gs_FeModemLog2IfftSize = puca_OctetBuffer[s_idx];
      gt_DecMsg_O_Prm_VDSL2.s_VTUO_IDFTSize = puca_OctetBuffer[s_idx++];


      if (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK)
      {
         // G.993.2 AnxQ says: "The value shall be expressed in multiples of 2 samples ..."
         // That means independent of the IFFT size the CO has to send the value devided by two (value/2).
         gt_DecMsg_O_Prm_VDSL2.s_DsCpLength = (gt_DecMsg_O_Prm_VDSL2.s_DsCpLength << 1);
         gt_DecMsg_O_Prm_VDSL2.s_DsBetaLength = (gt_DecMsg_O_Prm_VDSL2.s_DsBetaLength << 1);
      }
   }

   //Compute CELength = m*N/32, where N is the number of DS tones
   gt_DecMsg_O_Prm_VDSL2.s_CELength = ((s_m*(1<<gs_FeModemLog2IfftSize))>>6);

   //Process the remote CP and beta length
   if (guc_dbgFeModemLog2IfftSize)
   {
      gs_FeModemLog2IfftSize = (int16)guc_dbgFeModemLog2IfftSize;
   }
   ProcessCpBeta(gt_DecMsg_O_Prm_VDSL2.s_DsCpLength, gt_DecMsg_O_Prm_VDSL2.s_DsBetaLength);

   // Field8
   // Duration of the VTU-O EC training (1 byte)
   gt_DecMsg_O_Prm_VDSL2.uc_Duration_VTUO_ECTraining = puca_OctetBuffer[s_idx++];

   // Field9
   // Duration of the VTU-O TEQ training (1 byte)
   gt_DecMsg_O_Prm_VDSL2.uc_Duration_VTUO_TEQTraining = puca_OctetBuffer[s_idx++];

   // Field10
   // Duration of the VTU-R TEQ training (1 byte)
   gt_DecMsg_O_Prm_VDSL2.uc_Duration_VTUR_TEQTraining = puca_OctetBuffer[s_idx++];

   // Field11
   // Duration of periodic signal (1 byte)
   gt_DecMsg_O_Prm_VDSL2.uc_DurationPeriodicSignal = puca_OctetBuffer[s_idx++];
   if (gul_dbgSocMsgControl & FORCE_PERIODIC2_DISABLE)
   {
      gt_DecMsg_O_Prm_VDSL2.uc_DurationPeriodicSignal = 0;
   }

   // Field12
   // Downstream frequency-domain spectrum shaping (Log_tssi descriptor)
   us_NumOfDescriptorElements = puca_OctetBuffer[s_idx++];
   if (us_NumOfDescriptorElements > MAX_NUM_DS_TSSI_PSD_POINTS)
   {
      return(FALSE);
   }
   else if (us_NumOfDescriptorElements > 0)
   {
      // ANXQ_SUPPORT
      // Why the index range was increased for "Table 12-31 - Log_tssi descriptor" is not clear!
      // As discussed with concept engineering, it is not forbidden to set additional breakpoints beside DS1.
      // But for time being nothing will be done for G.993.2 AnxQ.
      // Note: The G.993.2 standard defines the range only for DS1.
      //       The VTU-O shall provide non-zero tssi values for all out-of-band subcarriers with
      //       indices from 1 to t_DS1_stop+32, where t_DS1_stop is the highest-index subcarrier in DS1.
      //       The out-of-band tssi values shall only be used during O-P-TEQ, as described in clause 12.3.4.3.1.4.
      gt_DecMsg_O_Prm_VDSL2.t_DS_fdSpectrumShaping.uc_NumTones = (uint8)us_NumOfDescriptorElements;
      DecodeBands(&s_idx, us_NumOfDescriptorElements, puca_OctetBuffer,
                  &gt_DecMsg_O_Prm_VDSL2.t_DS_fdSpectrumShaping.sa_ToneIndex[0],
                  &gt_DecMsg_O_Prm_VDSL2.t_DS_fdSpectrumShaping.sa_LogTssiVal[0]);
   }
   else // if (us_NumOfDescriptorElements == 0)
   {
      // Default DS_fdSpectrumShaping must be added here!
      // Note: Standard contains "The first octet of the descriptor shall contain the number of breakpoints
      //       being specified. This number can be zero. In that case, there shall be no further octets in
      //       the descriptor, and the field shall be interpreted as all log_tss i=0 for all transmitted subcarriers.
   }

   //If this is in diagonistic mode, unpack QLN and Hlog
   if(gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG)
   {
      UnpackQlnHlog_VDSL2(puca_OctetBuffer, &s_idx);
   }

   //============================================================
   //Compute the DS subcarrier group size used for SNR, HLOG
   //=============================================================
   gs_Log2CarrierGroupSizeRx_Medley = CalcCarrierGroupSize(gsa_RxBandRightChannel[gs_NumOfRxBands-1]);
   gs_CarrierGroupSizeRx_Medley = 1<<gs_Log2CarrierGroupSizeRx_Medley;

   // check if US0 is enabled
   gft_US0BandUsed = CheckForUS0Enable();


   // Field 13: ITU-T G.998.4 parameter field
   // Field 14: ITU-T G.993.5 parameter field
   if ((s_idx + 2) <= gs_RxWholeMsgLength)
   {
      uint8 uc_Len;

      // skip field 13 (G.INP)
      uc_Len = puca_OctetBuffer[s_idx++];
      s_idx += uc_Len;

      if (s_idx < gs_RxWholeMsgLength)
      {
         // skip field 14 (G.vec)
         uc_Len = puca_OctetBuffer[s_idx++];
         s_idx += uc_Len;
      }

      if (s_idx > gs_RxWholeMsgLength)
      {
         // note that CO doesn't seem to comply to Amend5
         gul_SocMsgNotCompliedAmends |= AMEND5_NOT_COMPLIED_IN_OPrm;
      }
   }

   return(UnpackedMsgLengthCheck(s_idx, gs_RxWholeMsgLength));

}

