/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 2015, 2016: Lantiq Beteiligungs-GmbH & Co. KG
    Copyright C 2016 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
*******************************************************************************
*******************************************************************************
;
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;   Functions for interpreting O-Signature message
;
;
*****************************************************************************/

// ***********************************************************************************************************
// InterpOSignatureMsg_VDSL2.c
//
// History
//
// 16/05/2012 Vinjam: Code Pointers connected to Downstream Virtual Noise feature
//            Grep for XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise
//
// 09/07/2012 Vinjam: Added code to support SNRM_mode = 4
//         SNRM_Mode = 2  ==> Field#17 = 0x0001
//         SNRM_Mode = 4  ==> Field#17 = 0x0031
//         CPE, when it sees SNRM_Mode = 4, it should behave like SNRM_Mode = 2, clarification from Uwe
//         Grep for XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise
//
// 08/08/2012 Vinjam: CMV INFO 68 8 Bit-8 is populated based on enable/disable of virtual noise feature
//          Valid for Normal Intialization Mode & DELT mode.
//          Grep for XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise
//
//  Venkatesh (9/11/2012)
//   XDSLRTFW-565 IOP_US_ALL_HaweVDMF_UPBO_FEXT_WITHOUT_CO_GHS_SUPPORT
//   Allow UPBO FEXT if there are break points transmitted without GHS Support
//   Issue with Netgear Hauwai DSLAM where UPBO FEXT is supported but not indicated in GHS
//
// 06/05/2013 Varun : Added code(Debug option) to capture raw data of all Tx and Rx(O-SIGNATURE in particular)
//                    training messages (G.Hs + training)
//                    Grep for "XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer"
// 08/11/2013 Venkatesh: Workaround for VN issue with NVLT-C
//                       With 17A profile and if the Breakpoints are above 4096
//                       Ikanos seems to wrap around to 0,1,2..etc
//                       This workaround would add 4096 to the Bins above or equal to value 0
//                       Grep for XDSLRTFW-1327
// 03/02/2014 Prashant:  Make the following change enabled by default.
//                         1. Enable UPBO-FEXT when O-Signature message has UPBO-FEXT points but not mentioned in GHS (XDSLRTFW-565)
//                       Grep for XDSLRTFW-1553
// 05/03/2015 Fuss: IOP fix - Broadcom is sending the TransceiverId with opposite byte order, i.e. not according to the standard
//                  Grep for XDSLRTFW-2242
//
// 14/09/2017 Hanyu/Venkatesh: Merged IOP fixes against EVLT-F/CNXT in A8D profile
//   1. Changed US0 PSD level and MASK for CNXT CO if CO or CPE decides to force US0-only on 4kft or longer loops to improve US data rate.
//   2. Used original estimated KL0 value for CPE to determine US0-only.
//      Grep for XDSLRTFW-3470 XDSLRTFW-735 IOP_A_US_VDSL2_EVLT_F_CNXT_USdatarate
//
// ************************************************************************************************************


#include <string.h>
#include "common.h"
#include "gdata.h"
#include "socmessage.h"
#include "TxPSDCOntrol.h"
#include "dsp_op.h"
#include "SharedFuncs.h"
#include "GetQlnHlogForCarrierGroup.h"
#include "CheckForUS0Enable.h"
#include "ghs.h"
#include "cmv.h"
#include "DebugBuffer.h"

#include "ApplyBandLimit.h"

// Debug TransceiverId (start_end)
// Debug code for testing the feature, which can be later removed!!!
extern uint8 guc_DestroyTransId;


/*^^^
 *------------------------------------------------------------------------
 *
 *
 *  Description:  Unpack the received O-SIGNATURE message.
 *
 *  Prototype:
 *           void UnpackOSignatureMsg_VDSL2(void);
 *
 *
 *  Input Arguments:
 *      None
 *
 *  Output Arguments:
 *      None
 *
 *   Return:
 *      TRUE -- unpacking is ok
 *      FALSE -- otherwise
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
int16 UnpackOSignatureMsg_VDSL2(void)
{
   DecMsg_O_Signature_VDSL2_t *pt_DecMsg;
   uint8 *puca_OctetBuffer;
   int16 s_NumOfPoints, s_idx;
   unsigned int i;

   gus_OSignatureErrorCode = 0;
   pt_DecMsg = &gt_DecMsg_O_Signature_VDSL2;
   puca_OctetBuffer = gpuca_RxHDLCMsgBuf;

#ifdef DEBUG_TRACES
   // XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer(START_END)
   LogMessages(4,(uint16)gpuca_RxHDLCMsgBuf[0], (uint16)gs_RxWholeMsgLength, gpuca_RxHDLCMsgBuf, DEBUG_BUFFER_DELIMITER_VDSL2);
#endif //#ifdef DEBUG_TRACES
   DSH_SendStream(DSH_O_SIGNATURE, (uint16)gs_RxWholeMsgLength,(void *)gpuca_RxHDLCMsgBuf);

   // Field1 - Message descriptor
   s_idx = 1;                          // gets be skipped!

   //Field2
   {
      //Get the used DS bands
      gs_NumOfRxBands = puca_OctetBuffer[s_idx++];
      if((gs_NumOfRxBands > 0) && (gs_NumOfRxBands <= MAX_NUM_DS_BANDS))
      {
         DecodeBands(&s_idx, gs_NumOfRxBands, puca_OctetBuffer,
                     gsa_RxBandLeftChannel, gsa_RxBandRightChannel);
      }
      else
      {
         gus_OSignatureErrorCode = O_SIG_FIELD2_BANDS_DS;
         return(FALSE);
      }

      // Save info in a different struct for showtime OHC.
      gs_NumOfRxBandsOSignature = gs_NumOfRxBands;
      for(i = 0; i < gs_NumOfRxBands; i++)
      {
         gsa_RxBandLeftChannelOSignature[i] = gsa_RxBandLeftChannel[i];
         gsa_RxBandRightChannelOSignature[i] = gsa_RxBandRightChannel[i];
      }
   }

   //Field3
   {
      //Get the used US bands
      gs_NumOfTxBands = puca_OctetBuffer[s_idx++];
      if((gs_NumOfTxBands > 0) && (gs_NumOfTxBands <= MAX_NUM_US_BANDS))
      {
         DecodeBands(&s_idx, gs_NumOfTxBands, puca_OctetBuffer,
                     gsa_TxBandLeftChannel, gsa_TxBandRightChannel);
      }
      else
      {
         gus_OSignatureErrorCode = O_SIG_FIELD3_BANDS_US;
         return(FALSE);
      }

      // Fill band control information for status CMVs!
      VDSL2_BandControlGet((BAND_CONTROL_UPDATE_US|BAND_CONTROL_UPDATE_DS));

      // Fake Downstream band
      // Note: This is a secure code for profiles < 35b profile, if the O-Signature bandplan is
      //       for 35b and 17a, 12x or 8x is selected!
      // Note: The original bands descriptor gets be stored above in the variables
      //       (gsa_RxBandLeftChannelOSignature, gsa_RxBandRightChannelOSignature)
      LimitBandPlanToHighestTone(&gsa_RxBandLeftChannel[0], &gsa_RxBandRightChannel[0], &gs_NumOfRxBands, (gs_RxNumTones-1));

      // Debug code to remove the US0 band
      if ((gus_DebugControlVRX518 & US0_TRANSMISSION_DIS) &&
          (gsa_TxBandRightChannel[0] <= (US0_ISDNDOUBLE_POTSQUAD_MAX_TONE +1)))
      {
         //Limit the TX band plan according to the lowest and highest allowed US tones.
         ApplyBandLimit(gsa_TxBandLeftChannel[1], gsa_TxBandRightChannel[gs_NumOfTxBands-1]);
      }

      gs_NumOfTxBandsOSignature = gs_NumOfTxBands;
      for(i = 0; i < gs_NumOfTxBands; i++)
      {
         gsa_TxBandLeftChannelOSignature[i] = gsa_TxBandLeftChannel[i];
         gsa_TxBandRightChannelOSignature[i] = gsa_TxBandRightChannel[i];
      }
   }

   if (!CheckForBandOverlap())
   {
      gus_OSignatureErrorCode = O_SIG_BAND_OVERLAP;
      return(FALSE);
   }

   // Field4
   // Downstream PSD mask, PSDMASKds (PSD Descriptor)
   s_NumOfPoints = (int16)puca_OctetBuffer[s_idx++];

   /* Clear the PSD Descriptor table */
   memset(&gt_MaxDsPSDDescriptorTable, 0, sizeof(DsPSDDescriptorTable_t));
   /* Populate the PSD Descriptor table */
   if((s_NumOfPoints > 0) && (s_NumOfPoints <= MAX_NUM_DS_PSD_POINTS))
   {
      gt_MaxDsPSDDescriptorTable.us_NumberOfTones = (uint16)s_NumOfPoints;    // Ds

      UnpackPSD(&s_idx, s_NumOfPoints, puca_OctetBuffer,
                &gt_PwrConfigParam.s_Dn_MaxNomPSD,
                0,
                (PSDDescriptorTable_t*)(void *)&gt_MaxDsPSDDescriptorTable);  // Ds

      // Case where gt_PwrConfigParam.s_Dn_MaxNomPSD is a mask
      // and we want to determine s_Dn_MaxNomPSD as a template.
      // Take 3.5 dB off of gt_PwrConfigParam.s_Dn_MaxNomPSD to do this conversion.
      gt_PwrConfigParam.s_Dn_MaxNomPSD += 35;

      // Sort the MaxDs PSD Descriptor table so that the Masks are in ascending order
      quick_PSDsort((PSDDescriptorTable_t *)(void *)&gt_MaxDsPSDDescriptorTable, 0, (int16)(gt_MaxDsPSDDescriptorTable.us_NumberOfTones-1));
   }
   else
   {
      gus_OSignatureErrorCode = O_SIG_FIELD4_PSD_DS;
      return(FALSE);
   }

   GetMaxNomPSDPerBand(gsa_Dn_MaxNomPSD, (PSDDescriptorTable_t*)(void *)&gt_MaxDsPSDDescriptorTable, gt_PwrConfigParam.s_Dn_MaxNomPSD,
                       &gsa_RxBandRightChannelOSignature[0], gs_NumOfRxBandsOSignature);

   // save PSDMASKds at CMV since CPE does not use this CMV
   memcpy(&gt_MaxDsPSDDescriptorTableCMV, &gt_MaxDsPSDDescriptorTable, sizeof(DsPSDDescriptorTable_t));


   // Field5
   // Upstream PSD mask, PSDMASKus (PSD Descriptor)
   /* Clear the PSD Descriptor table */
   memset(&gt_MaxUsPSDDescriptorTable, 0, sizeof(UsPSDDescriptorTable_t));

   s_NumOfPoints = (int16)puca_OctetBuffer[s_idx++];
   if((s_NumOfPoints > 0) && (s_NumOfPoints <= MAX_NUM_US_PSD_POINTS))
   {
      gt_MaxUsPSDDescriptorTable.us_NumberOfTones = (uint16)s_NumOfPoints;    // Us
      UnpackPSD(&s_idx, s_NumOfPoints, puca_OctetBuffer,
                &(gt_PwrConfigParam.s_Up_MaxNomPSD),
                0,
                (PSDDescriptorTable_t*)(void *)&gt_MaxUsPSDDescriptorTable);  // Us

      // Case where gt_PwrConfigParam.s_Up_MaxNomPSD is a mask
      // and we want to determine s_Up_MaxNomPSD as a template.
      // Take 3.5 dB off of gt_PwrConfigParam.s_Up_MaxNomPSD to do this conversion.
      gt_PwrConfigParam.s_Up_MaxNomPSD += 35;
      //XDSLRTFW-1836
      //Identify the wrong MaxNomPSD Values Calulated
      //If wrong, assign default MaxNomPSD to DS & US
      if (gt_CustomerIopBits.us_Generic_IOP_Fixes & GENERIC_HANDLE_WRONG_PROFILE)
      {
         //Identify the wrong MaxNomPSD Values Calulated
         //If wrong, assign default MaxNomPSD to DS & US
         if(gt_PwrConfigParam.s_Dn_MaxNomPSD < STD_MAXNOMPSD_DS)
         {
            gt_PwrConfigParam.s_Dn_MaxNomPSD = STD_MAXNOMPSD_DS;
            gs_ForceSpecialCeilValueDs_Cntl |= WRONG_DS_NOM_PSD;
         }
         if(gt_PwrConfigParam.s_Up_MaxNomPSD < STD_MAXNOMPSD_US)
         {
            gt_PwrConfigParam.s_Up_MaxNomPSD = gt_PwrConfigParam.s_Up_InitialPsdCeiling;
         }
      } //FIBER HOME
      //XDSLRTFW-1836

      // Sort the MaxUs PSD Descriptor table so that the Masks are in ascending order
      quick_PSDsort((PSDDescriptorTable_t *)(void *)&gt_MaxUsPSDDescriptorTable, 0, (int16)(gt_MaxUsPSDDescriptorTable.us_NumberOfTones-1));

    //XDSLRTFW-3470 XDSLRTFW-735 IOP_A_US_VDSL2_EVLT_F_CNXT_USdatarate (START)
    if ( (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_8xALL_MASK) &&
         (gft_EVLT_IOPtuning) )// Only for CNXT CO in A8x at AT&T/CTL
   {
       // Fine-tune US0 PSD level and shape to improve US data rate
       gt_PwrConfigParam.s_Up_MaxNomPSD = 450; //380;
       gt_MaxUsPSDDescriptorTable.ut_PSDRecord[1].us_IndexOfTone = 2;
       gt_MaxUsPSDDescriptorTable.ut_PSDRecord[1].s_PSDLevelOfTone = 0;
       gt_RefUsPSDDescriptorTable.ut_PSDRecord[1].s_PSDLevelOfTone = 0;
       gt_MaxUsPSDDescriptorTable.ut_PSDRecord[2].us_IndexOfTone = 6;
       gt_MaxUsPSDDescriptorTable.ut_PSDRecord[2].s_PSDLevelOfTone = 0;
       gt_RefUsPSDDescriptorTable.ut_PSDRecord[2].s_PSDLevelOfTone = 0;
       gt_MaxUsPSDDescriptorTable.ut_PSDRecord[3].us_IndexOfTone = 35;
       gt_MaxUsPSDDescriptorTable.ut_PSDRecord[3].s_PSDLevelOfTone = 0;
       gt_RefUsPSDDescriptorTable.ut_PSDRecord[3].s_PSDLevelOfTone = 0;
       gt_MaxUsPSDDescriptorTable.ut_PSDRecord[4].us_IndexOfTone = 36;
       gt_MaxUsPSDDescriptorTable.ut_PSDRecord[4].s_PSDLevelOfTone = 0;
       gt_RefUsPSDDescriptorTable.ut_PSDRecord[4].s_PSDLevelOfTone = 0;
   }
   //XDSLRTFW-3470 XDSLRTFW-735 IOP_A_US_VDSL2_EVLT_F_CNXT_USdatarate (END)

      gt_PwrConfigParam.s_Up_MaxNomPSD = MAX(gt_PwrConfigParam.s_Up_MaxNomPSD, gs_dbgLimitUsMaxNomPsd);
   }
   else
   {
      gus_OSignatureErrorCode = O_SIG_FIELD5_PSD_US;
      return(FALSE);
   }

   // save PSDMASKus at CMV since CPE does not use this CMV
   memcpy(&gt_MaxUsPSDDescriptorTableCMV, &gt_MaxUsPSDDescriptorTable, sizeof(UsPSDDescriptorTable_t));

   // Field6
   // Channel Discovery downstream PSD mask, CDPSDds (PSD Descriptor)
   /* Clear the PSD Descriptor table */
   memset(&gt_DsREFPSDDescriptorTable, 0, sizeof(DsRefPSDDescriptorTable_t));

   s_NumOfPoints = (int16)puca_OctetBuffer[s_idx++];
   if (s_NumOfPoints > MAX_NUM_DS_REFPSD_POINTS)
   {
      gus_OSignatureErrorCode = O_SIG_FIELD6_1;
      return(FALSE);
   }
   else if (s_NumOfPoints > 0)
   {
      gt_DsREFPSDDescriptorTable.us_NumberOfTones = (uint16)s_NumOfPoints;    // Ds
      UnpackPSD(&s_idx, s_NumOfPoints, puca_OctetBuffer,
                NULL,
                gt_PwrConfigParam.s_Dn_MaxNomPSD,
                (PSDDescriptorTable_t*)(void *)&gt_DsREFPSDDescriptorTable);  // Ds

      // Sort the RefDs PSD Descriptor table so that the breakpoints are in ascending order
      quick_PSDsort((PSDDescriptorTable_t *)(void *)&gt_DsREFPSDDescriptorTable, 0, (int16)(gt_DsREFPSDDescriptorTable.us_NumberOfTones-1));
   }
   else
   {
      memcpy(&gt_DsREFPSDDescriptorTable, &gt_MaxDsPSDDescriptorTable,
             MIN(sizeof(DsRefPSDDescriptorTable_t),sizeof(DsPSDDescriptorTable_t)));
   }

#if defined(VR9_SAVE_CDPSD)
   // Save for prinitng in Cocomo
   memcpy(&gt_DsCDPSDDescriptorTable, &gt_DsREFPSDDescriptorTable, sizeof(DsRefPSDDescriptorTable_t));
#endif



   // Field7
   // "Initial downstream PSD ceiling (CDMAXMASKds)" (2 bytes)
   {
      int16 s_Dn_InitialPsdCeilingMask;

      s_Dn_InitialPsdCeilingMask = puca_OctetBuffer[s_idx++]<<8;
      s_Dn_InitialPsdCeilingMask |= puca_OctetBuffer[s_idx++];

      if (s_Dn_InitialPsdCeilingMask < 0 || s_Dn_InitialPsdCeilingMask > 900)
      {
         gus_OSignatureErrorCode = O_SIG_FIELD7_1;
         return(FALSE);
      }

      // Case where s_Dn_InitialPsdCeilingMask is a mask
      // and we want to determine s_Dn_InitialPsdCeiling as a template.
      // Take 3.5 dB off of Maximum s_Dn_InitialPsdCeilingMask to do this conversion.
      gt_PwrConfigParam.s_Dn_InitialPsdCeiling = s_Dn_InitialPsdCeilingMask + 35;
   }

   // Field8
   // Downstream nominal max aggregate Tx power, MAXNOMATPds (2 bytes)
   // See 997.1 section 7.3.1.2.3
   gt_PwrConfigParam.s_Dn_MaxNomAggrPwr = puca_OctetBuffer[s_idx++]<<8;
   gt_PwrConfigParam.s_Dn_MaxNomAggrPwr |= puca_OctetBuffer[s_idx++];


   // Field9
   // Upstream reference PSD Mask, UPBOPSD (UPBOPSD Descriptor)
   /* Clear the UPBOPSD Descriptor table */
   memset(&gt_UPBOPSDDescriptorTable, 0, sizeof(UPBOPSDDescriptorTable_t));

   s_NumOfPoints = (int16)puca_OctetBuffer[s_idx++];
   if (s_NumOfPoints > MAX_NUM_US_BANDS)
   {
      gus_OSignatureErrorCode = O_SIG_FIELD9_1;
      return(FALSE);
   }
   else if(s_NumOfPoints > 0)
   {
      int16 sa_a[MAX_NUM_US_BANDS], sa_b[MAX_NUM_US_BANDS];

      Unpack12BitsPair(&s_idx,
                       s_NumOfPoints,
                       puca_OctetBuffer,
                       sa_a,
                       sa_b);

      // Populate gt_UPBOPSDDescriptorTable
      gt_UPBOPSDDescriptorTable.us_NumberOfBands = (uint16)s_NumOfPoints;
      for (i = 0; i < gt_UPBOPSDDescriptorTable.us_NumberOfBands; i++)
      {
         //UPBO
         gt_UPBOPSDDescriptorTable.ut_UPBOPSDRecord[i].s_a = sa_a[i]+4000;   //sa_a is abolute psd value offset by 40 dB
         gt_UPBOPSDDescriptorTable.ut_UPBOPSDRecord[i].s_b = sa_b[i];

         if (gt_UPBOPSDDescriptorTable.ut_UPBOPSDRecord[i].s_a == 4000 && gt_UPBOPSDDescriptorTable.ut_UPBOPSDRecord[i].s_b == 0)
         {
            //NO UPBO
            s_NumOfPoints--;
         }
         //XDSLRTFW-2040: Check for UPBO Min Values and enable only US0
         if (gt_UPBOPSDDescriptorTable.ut_UPBOPSDRecord[i].s_a >= 7900 && gt_UPBOPSDDescriptorTable.ut_UPBOPSDRecord[i].s_b == 4000)
            gft_USx_Disable = 1;
         else
            gft_USx_Disable = 0;
         //XDSLRTFW-2040: Check for UPBO Min Values and enable only US0
      }
      if (s_NumOfPoints == 0)
      {
         // Incase none of the bands have UPBO applied
         gt_UPBOPSDDescriptorTable.us_NumberOfBands = 0;
      }
      else
      {
         gft_UPBO_is_enabled = TRUE;
      }
   }


   // Field10
   // Maximum Target Line Rate
   // "Maximum target line rate" is the VTU-O's estimate of the maximum downstream
   // line rate that will be required during the operation of the modem. The VTU-R
   // may use this information to determine the amount of downstream power cut-back
   // (the downstream PSD ceiling) and the spectrum to be used for downstream
   // (highest downstream sub-carrier) that can be applied during the Channel Discovery phase.
   // For now, ignore this parameter
   pt_DecMsg->us_MaxTargetLineRate = puca_OctetBuffer[s_idx++]<<8;
   pt_DecMsg->us_MaxTargetLineRate |= puca_OctetBuffer[s_idx++];

   // Field11
   // Maximum downstream margin (2 bytes)
   // See 997.1 section 7.3.1.3.3
   gt_SnrMgnConfig.s_MAXSNRMds = puca_OctetBuffer[s_idx++]<<8;
   gt_SnrMgnConfig.s_MAXSNRMds |= puca_OctetBuffer[s_idx++];

   // Field12
   // Target downstream margin (2 bytes)
   // See 997.1 section 7.3.1.3.1
   gt_SnrMgnConfig.s_TARSNRMds = puca_OctetBuffer[s_idx++]<<8;
   gt_SnrMgnConfig.s_TARSNRMds |= puca_OctetBuffer[s_idx++];

   // Field13 - Downstream transmit window length (1 byte)
   // Note: Expressed in samples at the DOWNstream sampling rate corresponding to the
   //       IDFT size communicated during the ITU-T G.994.1 handshake phase.
   pt_DecMsg->us_DS_TxWinLen = (uint8)puca_OctetBuffer[s_idx++];

   // Field14 - Downstream cyclic prefix (2 bytes)
   // Note: Expressed in samples at the DOWNstream sampling rate corresponding to the
   //       IDFT size communicated during the ITU-T G.994.1 handshake phase.
   pt_DecMsg->s_DS_CyclicPrefix = puca_OctetBuffer[s_idx++]<<8;
   pt_DecMsg->s_DS_CyclicPrefix |= puca_OctetBuffer[s_idx++];

   // Field15 - Initial value of timing advance (2 bytes)
   // Note: Expressed in samples at the UPstream sampling rate corresponding to the IDFT size communicated
   //       during the ITU-T G.994.1 handshake phase.
   {
      pt_DecMsg->s_InitValTimingAdv = puca_OctetBuffer[s_idx++]<<8;
      pt_DecMsg->s_InitValTimingAdv |= puca_OctetBuffer[s_idx++];
      if (gul_dbgSocMsgControl & WORKAROUND_IKANOS_CO_INIT_TIMING_ADVANCE)
      {
         pt_DecMsg->s_InitValTimingAdv = 0x7fff;
         s_idx++;
      }
      // gs_TargetTimingAdvance should be set to the value from O-Signature
      // message in VDSL2 message decoding
      // The special value of 0x7FFF indicates that the VTU-R shall select
      // the initial setting of the timing advance
      if(pt_DecMsg->s_InitValTimingAdv != 0x7FFF)
      {
         gs_TargetTimingAdvance = pt_DecMsg->s_InitValTimingAdv;
         // When the target timing advance is indicating a long loop then this must be reduced.
         // The Rx/Tx symbol alignment is so bad that no DS1 SNR can be measured anymore.
         if (gs_TargetTimingAdvance == (int16)532)
         {
            gs_TimingAdvanceOffset = (int16)(-132);
         }
      }
   }

   // Manipulation for 35B and calculation of Cycle suffix (CS).
   if (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK)
   {
      // G.993.2 AnxQ says: "The value shall be expressed in multiples of 2 samples ..."
      // That means independent of the IFFT size the CO has to send the value devided by two (value/2).
      {
         pt_DecMsg->s_DS_CyclicPrefix = (pt_DecMsg->s_DS_CyclicPrefix << 1);
         pt_DecMsg->us_DS_TxWinLen = (pt_DecMsg->us_DS_TxWinLen << 1);
      }

      if((pt_DecMsg->s_InitValTimingAdv != 0x7FFF) &&
         (gs_TxLog2IfftLength > US_LOG2_FFT_LENGTH_8192))                // US_LOG2_FFT_LENGTH_8192 = 13
      {
         // VR9/VR318: Upstream is always running with the small IFFT.
         // CO send the value dependent of the upstream IFFT size:
         //  ... shall be expressed either in multiples of 2 samples
         //      if profile 35b is used with extended IDFT Size, or otherwise,
         //      in samples at the upstream sampling rate corresponding to the
         //      IDFT size communicated during the ITU-T G.994.1 handshake phase.
         pt_DecMsg->s_InitValTimingAdv = (pt_DecMsg->s_InitValTimingAdv << 1);
         gs_TargetTimingAdvance = pt_DecMsg->s_InitValTimingAdv;
      }
   }
   //Process the remote CP and beta length
   ProcessCpBeta(pt_DecMsg->s_DS_CyclicPrefix, pt_DecMsg->us_DS_TxWinLen);

   //XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise (Start)

   // Field16
   // Downstream transmitter referred virtual noise level, TXREFVNds (PSD Descriptor)
   // "Downstream Transmitter Referred Virtual Noise PSD" indicates the PSD of the
   // virtual noise in the downstream direction. This information shall be taken into
   // account when determining the SNR margin (for optional SNRM mode = 2), which in
   // turn shall be taken into account in determining the possible power cutback during
   // the Channel Discovery phase, and for performing the bit loading later in initialization.
   // When SNRM MODE = 1, the PSD descriptor field shall contain zero breakpoints (only 1 byte with a value of zero).
   memset(&gt_DS_RefVirtNoiseLevel_VDSL2, 0, sizeof(DsVnPSDDescriptorTable_t));

   s_NumOfPoints = (int16)puca_OctetBuffer[s_idx++];
   /* Populate the PSD Descriptor table */
   if ((s_NumOfPoints > 0) && (s_NumOfPoints <= MAX_NUM_VN_DS_PSD_POINTS))
   {
      gt_DS_RefVirtNoiseLevel_VDSL2.us_NumberOfTones = (uint16)s_NumOfPoints;       // Ds

      UnpackVNPSD(&s_idx, s_NumOfPoints,
                  puca_OctetBuffer,
                  (PSDDescriptorTable_t *)(void *)&gt_DS_RefVirtNoiseLevel_VDSL2);  // Ds

      //XDSLRTFW-1327 : NVLT-C sends wrong Virtual noise points for DS3
      //With 17A profile and if the Breakpoints are above 4096
      //Ikanos seems to wrap around to 0,1,2..etc
      //This workaround would add 4096 to the Bins above or equal to value 0
      if (!(gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK))
      {
         PSDRecord_t *pt_PSDRec; //XDSLRTFW-1327

         pt_PSDRec = &gt_DS_RefVirtNoiseLevel_VDSL2.ut_PSDRecord[0];
         if((gs_NumOfRxBands == 3) && (gul_fe_G994VendorID == IKNS_VENDOR_ID) )
         {
            if((pt_PSDRec[s_NumOfPoints - 1].us_IndexOfTone < gsa_RxBandRightChannel[gs_NumOfRxBands-1]) &&
                  (pt_PSDRec[s_NumOfPoints - 1].us_IndexOfTone < gsa_RxBandLeftChannel[0]))
            {
               pt_PSDRec[s_NumOfPoints - 1].us_IndexOfTone += 4096;
            }

            if((pt_PSDRec[s_NumOfPoints - 2].us_IndexOfTone < gsa_RxBandRightChannel[gs_NumOfRxBands-1]) &&
                  (pt_PSDRec[s_NumOfPoints - 2].us_IndexOfTone < gsa_RxBandLeftChannel[0]))
            {
               pt_PSDRec[s_NumOfPoints - 2].us_IndexOfTone += 4096;
            }
         }
      }
      //XDSLRTFW-1327 : NVLT-C sends wrong Virtual noise points for DS3
   }

   // Field17
   // SNRM_MODE (SNR Margin Mode) (1 byte)
   pt_DecMsg->uc_SnrMode = puca_OctetBuffer[s_idx++];
   // INTEROP against IFX CO(version 9.4.x and 9.5.x)
   if (gft_SNRM_MODE_workaround == TRUE)
   {
      pt_DecMsg->uc_SnrMode = 0;
   }

   //XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise (Start_End)
   //SNRM_Mode = 2  ==> Field#17 = 0x0001
   //SNRM_Mode = 4  ==> Field#17 = 0x0031
   //CPE, when it sees SNRM_Mode = 4, it should behave like SNRM_Mode = 2, clarification from Uwe
   //set DS virtual noise status finally
   if(((((pt_DecMsg->uc_SnrMode & 0x31) == 0x31) || (pt_DecMsg->uc_SnrMode & 0x1)) && (s_NumOfPoints > 0) ) && gft_DSVirtualNoiseStatus )
   {
      gft_DSVirtualNoiseStatus=1;
   }
   else
   {
      gft_DSVirtualNoiseStatus=0;
   }


   //XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise (Start)
   //Conveying Downstream Virtual Noise feature control status is moved from RATE 1 12 to
   //CMV INFO 68 8, as per VR9 Message Specifications (1.6.1)
   if(gft_DSVirtualNoiseStatus)
   {
      gt_LineStatusDS.us_LineStatus |= (uint16)0x100;
      //XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise (Start_End)
      //t_DSRateInfo.s_TcmParityInfo[0] |= (uint16)0x200;
   }
   else
   {
      gt_LineStatusDS.us_LineStatus &= (uint16)0xfeff;
   }
   //XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise (End)

   //Added during virtual noise bringup from Vinax code base (Mercurial Tag: REL_V12_08_03_26_0_04)
   // Check for SNRM mode to be consistent with the number of breakpoints for
   // virtual noise downstream
   //if ((((pt_DecMsg->uc_SnrMode & 0x01)==0) && (s_NumOfPoints > 0)) ||
   //   (s_NumOfPoints > MAX_NUM_VN_DS_PSD_POINTS))
   //{
   //   gus_OSignatureErrorCode |= O_SIG_FIELD16_1;
   //   return(FALSE);
   //}

   // Wolfgang: This strict consistency check causes a failure with Ikanos CO which sends SnrMode == 0
   // but virtual noise breakpoints.
   // (The check is not removed, but only the gus_OSignatureErrorCode is set and the parser proceeds).
   if (((pt_DecMsg->uc_SnrMode & 0x01)==0) && (s_NumOfPoints > 0))
   {
      gus_OSignatureErrorCode |= O_SIG_FIELD16_1;
   }

   // Check if the number of received virtual noise DS breakpoints exceeds the maximum number
   if (s_NumOfPoints > MAX_NUM_VN_DS_PSD_POINTS)
   {
      gus_OSignatureErrorCode = O_SIG_FIELD16_1;
      return(FALSE);
   }

   // Field18
   // Upstream transmitter referred virtual noise level, TXREFVNus (PSD Descriptor)
   // Upstream transmitter referred virtual noise level, TXREFVNus (PSD Descriptor)
   // "Upstream Transmitter Referred Virtual Noise PSD" indicates the PSD of the
   // virtual noise in the Upstream direction. This information shall be taken into
   // account when determining the SNR margin (for optional SNRM mode = 2), which in
   // turn shall be taken into account in determining the possible power cutback during
   // the Channel Discovery phase, and for performing the bit loading later in initialization.
   // When SNRM MODE = 1, the PSD descriptor field shall contain zero breakpoints (only 1 byte with a value of zero).
   s_NumOfPoints = (int16)puca_OctetBuffer[s_idx++];
   memset(&gt_US_RefVirtNoiseLevel_VDSL2, 0, sizeof(UsVnPSDDescriptorTable_t));

   //set US virtual noise status flag; the flag is used to set the US virtual noise status bit in Rate 0 12.
   if((pt_DecMsg->uc_SnrMode & 0x10) && s_NumOfPoints>0)
   {
      gft_USVirtualNoiseStatus=1;
   }
   else
   {
      gft_USVirtualNoiseStatus=0;
   }

   /* Populate the PSD Descriptor table */
   if ((s_NumOfPoints > 0) && (s_NumOfPoints <= MAX_NUM_VN_US_PSD_POINTS))
   {
      gt_US_RefVirtNoiseLevel_VDSL2.us_NumberOfTones = (uint16)s_NumOfPoints;       // Us

      UnpackVNPSD(&s_idx, s_NumOfPoints,
                  puca_OctetBuffer,
                  (PSDDescriptorTable_t *)(void *)&gt_US_RefVirtNoiseLevel_VDSL2);  // Us
   }

   //Code picked up during virtual noise bringup from Vinax code base (Mercurial Tag: REL_V12_08_03_26_0_04)
   // Check for SNRM mode to be consistent with the number of breakpoints for
   // virtual noise upstream
   // if ((((pt_DecMsg->uc_SnrMode & 0x10) == 0) && (s_NumOfPoints > 0)) ||
   //    (s_NumOfPoints > MAX_NUM_VN_US_PSD_POINTS))
   // {
   //    gus_OSignatureErrorCode = O_SIG_FIELD18_1;
   //    return(FALSE);
   // }

   // Wolfgang: This strict consistency check causes a failure with Ikanos CO which sends SnrMode == 0
   // but virtual noise breakpoints.
   // (The check is not removed, but only the gus_OSignatureErrorCode is set and the parser proceeds).
   if (((pt_DecMsg->uc_SnrMode & 0x10) == 0) && (s_NumOfPoints > 0))
   {
      gus_OSignatureErrorCode |= O_SIG_FIELD18_1;
   }

   // Check if the number of received virtual noise US breakpoints exceeds maximum number
   if (s_NumOfPoints > MAX_NUM_VN_US_PSD_POINTS)
   {
      gus_OSignatureErrorCode = O_SIG_FIELD18_1;
      return(FALSE);
   }
   //XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise (End)


   // Field 19. UPBO Ref Electrical Length.
   if (s_idx < gs_RxWholeMsgLength)
   {
      unsigned int us_NumOfUsBands;

      us_NumOfUsBands = puca_OctetBuffer[s_idx++];

      if (us_NumOfUsBands)
      {
         if((s_idx + (us_NumOfUsBands<<1)) <= gs_RxWholeMsgLength)
         {
            if (us_NumOfUsBands <= MAX_NUM_UPBO_BANDS)
            {
               for (i = 0; i < us_NumOfUsBands; i++)
               {
                  gt_UPBOPSDDescriptorTable.usa_kl0_REF[i]  = puca_OctetBuffer[s_idx++]<<8;
                  gt_UPBOPSDDescriptorTable.usa_kl0_REF[i] |= puca_OctetBuffer[s_idx++];
               }
            }
            else
            {
               gus_OSignatureErrorCode = O_SIG_FIELD19_1;
               return(FALSE);
            }

            // Set bit to indicate these fields are included
            gul_dbgSocMsgControl2 |= AMENDMENT2_OSIG_UPBO_SUPPORT;

            //XDSLRTFW-565 IOP_US_ALL_HuaweiVDMF_UPBO_FEXT_WITHOUT_CO_GHS_SUPPORT (Start)
            // Issue against Hauwei DSLAM where UPBO FEXT is supported but not indicated in GHS
            // if OperationMode is not set, set this bit for further processing UPBO FEXT
            // We have decoded the KL0 ref already
            // Workaround is based on CMV [INFO 232 0 1]
            if( (gft_IOP_UPBO_FEXT) && ((gul_OperationModeStatus_VDSL2 & V2_EQ_FEXT_UPBO) == 0) )
            {
               gul_OperationModeStatus_VDSL2 |= V2_EQ_FEXT_UPBO;
            }
            //XDSLRTFW-565 IOP_US_ALL_HaweVDMF_UPBO_FEXT_WITHOUT_CO_GHS_SUPPORT (End)
         }
         else
         {
            gus_OSignatureErrorCode = O_SIG_FIELD19_1;
            return(FALSE);
         }
      }
   }
   else
   {
      gul_SocMsgNotCompliedAmends |= AMEND2_NOT_COMPLIED_IN_OSignature;
      // Note: The rest of the code has to be executed to get also the indication
      //       that AMD5 is not supported!
   }


   // Field 20. ITU-T G.998.4 parameter field (Retransmission).
   if (s_idx < gs_RxWholeMsgLength)
   {
      uint8 uc_Len;

      // skip G.INP
      uc_Len = puca_OctetBuffer[s_idx++];
      s_idx += uc_Len;

      // Set bit to indicate these fields are included
      // Note: Normally not needed, because ReTx information gets transmitted from CO side first time
      //       in the O-MSG1! But perhaps the CO is looking into previous messages from CPE, if
      //       the place holder length field byte gets transmitting.
      //       But some COs have an additional byte at the end of O-Signature, i.e.
      //       not belonging to the real message content). This would lead to wrong parameters, if the correct length
      //       gets not be checked and/or would lead to a false indication of the Amendment support!
      //       Therefore the code is changed to the old implementation, which is not according to the standard!
      //       All previous CPE messages before O-MSG1 should contain the place holder length field byte, like
      //       R-MSG1, R-UPDATE etc., which is not the case for our implementation.
      //       When two bytes are available, i.e. also vectoring then RetX gets enabled!
      //       This is to overcome the dummy byte problem at the end of messages.
//      gul_dbgSocMsgControl2 |= AMENDMENT5_RETX_SUPPORT;
   }
   else
   {
      // note that CO doesn't seem to comply to Amd5
      gul_SocMsgNotCompliedAmends |= AMEND5_NOT_COMPLIED_IN_OSignature;
   }

   // Field 21. ITU-T G.993.5 parameter field (Vectoring).
   if (s_idx < gs_RxWholeMsgLength)
   {
      uint8 uc_Len;

      // Not correct implementation, but equal to the old one (see explanation above in G.INP section).
      gul_dbgSocMsgControl2 |= AMENDMENT5_RETX_SUPPORT;
      if (gul_fe_G994VendorID == IFX_VENDOR_ID)
      {
         // The CO FW has a bug in decoding the R-MSG1.
         // Problem is that the Retx octets were not considered independent of the vectoring octets.
         // The clean implementation will not be used for LTQ to be backwards compatible. But
         // will stay for all other vendors until we are facing problems.
         // The new implementation will lead to a better interoperability against old DSLAMs.
         gul_dbgSocMsgControl2 |= AMENDMENT5_VECTORING_SUPPORT;
      }

      // Handle G.Vector
      uc_Len = puca_OctetBuffer[s_idx++];

      if ((s_idx + uc_Len) <= gs_RxWholeMsgLength)
      {
         if(uc_Len > 0)
         {
            // Set bit to indicate these fields are included
            // Note: Vectoring octet transmission gets only be enabled, if the O-Signature
            //       block length is != 0. Otherwise it is the filling octet from CO to transmit AELEM!
            gul_dbgSocMsgControl2 |= AMENDMENT5_VECTORING_SUPPORT;

            // XDSLRTFW-711: BugFix_DS_VDSL2_All_SkipUnknownPara (Start)
            // Note: The fix was done at this place to ignore an additional byte at the end of
            //       the O-Signature message. Otherwise UnpackedMsgLengthCheck() kicks in!
            int16 s_IdxTemp;

            // Standard can always be extended for block with variable length, i.e. parameter can be added.
            // To be future proofed not jet known parameters have to be skipped.
            s_IdxTemp = s_idx;
            s_idx += uc_Len;

            //Get the used DS bands
            {
               gs_NumOfVecRxBands = puca_OctetBuffer[s_IdxTemp++];

               // MAX_NUM_DS_BANDS should be per standard not greater than 8
               if((gs_NumOfVecRxBands > 0) && (gs_NumOfVecRxBands < MAX_NUM_DS_BANDS))
               {
                  DecodeBands(&s_IdxTemp, gs_NumOfVecRxBands, puca_OctetBuffer,
                              gsa_RxVecBandLeftChannel, gsa_RxVecBandRightChannel);
               }
               else
               {
                  gus_OSignatureErrorCode = O_SIG_FIELD21_VEC_BANDS_DS;
                  return(FALSE);
               }
            }

            // Upstream Pilot Sequence, i.e. Length + Sequence
            // Upstream Pilot Sequence Length
            gs_VecNPilotLength_US = puca_OctetBuffer[s_IdxTemp++]<<8;
            gs_VecNPilotLength_US |= puca_OctetBuffer[s_IdxTemp++];

            if((gs_VecNPilotLength_US < 8) || (gs_VecNPilotLength_US > 512))
            {
               gus_OSignatureErrorCode = O_SIG_FIELD21_VEC_PILOT_SEQ_US;
               return(FALSE);
            }

            // Upstream Pilot Sequence
            for (i=0; i< (gs_VecNPilotLength_US>>3); i++)  //Div by 8, because sequence length is bits
            {
               gpuca_FDPSActive[i] = puca_OctetBuffer[s_IdxTemp++]; // XDSLRTFW-1800 Store FDPS data, this  data is common both for FDPS and non FDPS pilot sequence
            }

            // Upstream Sync Symbol Offset
            // Abu : Upstream Sync Symbol Offset is a signed char contains value from -127 to +127 in 2's complement
            gc_VecUSSyncOffset = puca_OctetBuffer[s_IdxTemp++];

            // Upstream R-P-Vector 1 PSD Cutback
            // BUG: Note: not implemented and used yet
            gs_VecRPVector1PSDCutback = puca_OctetBuffer[s_IdxTemp++];

            // DownStream Sync Symbol Counter Modulo (N_SSC)
            // this value should be used in DS Sync Frame count increments
            gs_DSVec_N_SSC = puca_OctetBuffer[s_IdxTemp++]<<8;
            gs_DSVec_N_SSC |= puca_OctetBuffer[s_IdxTemp++];


            // VCE vendor ID and version number (10bytes)
            // Note: Field 8 of Table 10-1 - ITU-T G.993.5 parameter field A (Amd3)
            // G993.5(2010) VCE Vendor ID and Version Number
            if((s_IdxTemp + O_SIG_FIELD21_G9935_VCE_INFO_BLOCKFIELD8_NUMBYTES) <= s_idx)
            {
               uint32 ul_Temp;

               // Skip VCE info field 8
//               s_IdxTemp += O_SIG_FIELD21_G9935_VCE_INFO_BLOCKFIELD8_NUMBYTES;

               // VCE T.35 Country Code
               gus_VceT35CountryCode  = (puca_OctetBuffer[s_IdxTemp++] << 8);
               gus_VceT35CountryCode |= puca_OctetBuffer[s_IdxTemp++];
               // VCE Provider Code
               ul_Temp = puca_OctetBuffer[s_IdxTemp++];
               for (i = 0; i < (4-1); i++)
               {
                  ul_Temp <<= 8;
                  ul_Temp |= puca_OctetBuffer[s_IdxTemp++];
               }
               gul_VceProviderCode = ul_Temp;

               // VCE Version Number
               ul_Temp = puca_OctetBuffer[s_IdxTemp++];
               for (i = 0; i < (4-1); i++)
               {
                  ul_Temp <<= 8;
                  ul_Temp |= puca_OctetBuffer[s_IdxTemp++];
               }
               gul_VceVersionNumber = ul_Temp;
            }

            // VTU-R ID (TransceiverId) (4bytes)
            // Note: Field 9 of Table 10-1 - ITU-T G.993.5 parameter field A (Amd5)
            //       The VTU-R Transceiver ID is included in O-SIGNATURE to avoid false detection
            //       in the case a VTU-O decides to interrupt the communication during O-P-VECTOR1.
            if((s_IdxTemp + O_SIG_FIELD21_G9935_VTUR_ID_BLOCKFIELD9_NUMBYTES) <= s_idx)
            {
               uint32 ul_CpeTransId, ul_CpeTransIdReversed;

               // G.992.3, 12.2.3  Mapping of SOC data
               // An SOC message shall contain an integer number of octets. All octets shall be sent LSB first. An
               // SOC  message  may  be subdivided into fields. A field can contain parameter values expressed in
               // more than one byte. In this case, the field shall be split into bytes with the byte containing the MSBs
               // of the parameter value sent first. For example, a field carrying a 16-bit value m15...m0 shall be
               // split into a first byte B0 = m15...m8 and a second byte B1 = m7...m0.
               //       |31 to 24|23 to 16|15 to 8|7 to 0|
               //          1st      2nd      3rd    4th       octet

               // XDSLRTFW-2242 (Start_End)
               // Broadcom confirmed that they have a bug and are sending the opposite byte order as defined per standard!
               // Further it was mentioned that it will not be fixed from Broadcom side, because
               // it is already released. Reason is that the CO should have always the same behavior to avoid FW version
               // checks.
               // Broadcom is sending the opposite byte order:
               //       |31 to 24|23 to 16|15 to 8|7 to 0|
               //          4th      3rd      2nd    1st       octet
               //
               {
                  uint8 uc_Temp;

                  uc_Temp = puca_OctetBuffer[s_IdxTemp++];
                  ul_CpeTransId = uc_Temp;
                  ul_CpeTransIdReversed = uc_Temp;
                  for(i = 0; i < (O_SIG_FIELD21_G9935_VTUR_ID_BLOCKFIELD9_NUMBYTES-1); i++)
                  {
                     uc_Temp = puca_OctetBuffer[s_IdxTemp++];
                     ul_CpeTransId <<= 8;
                     ul_CpeTransId |= uc_Temp;

                     ul_CpeTransIdReversed |= (uc_Temp << (8*(i+1)));
                  }
               }
               // XDSLRTFW-2242 (Start_End)
               // A fix must be done, to cover the corner case coming from our Avinax implementation,
               // i.e. handshake disabled, but O-Signature enabled.
               // G.993.5, Amd5: Field #9 "VTU R ID", contains the 30-bit transceiver ID of the VTU-R
               //                (with the 2 MSBs of this field set to 00). If the VTU-O has received
               //                the VTU-R ID during the last previous G.994.1 session, then this field
               //                shall contain that VTU-R ID, otherwise this field shall be set to 0x00000000.
               if((gus_VectoringOptionsEnabled & VEC_OPTIONS_TRANSCEIVER_ID_MASK) ||
                     ((ul_CpeTransId > 0) && (TESTArray[TEST_XDSLRTFW_CONFIG] & TEST_XDSLRTFW_CONFIG_XTALK_CONNECT)))
               {
                  // Note: Even if communication has been be established only among transceivers with acknowledged
                  //       Transceiver IDs, the resulting communication may be over a crosstalk path (i.e. not
                  //       the direct path). If this should occur, the integrity of the upstream channel matrix
                  //       is not compromised during the R-P-VECTOR-1 phase of Channel Discovery, since the VCE
                  //       will see unique upstream pilot sequences on each initializing line.
                  gus_VectoringOptionsEnabled |= VEC_OPTIONS_TRANSCEIVER_ID_MASK;

                  // Debug TransceiverId (start)
                  // Debug code for testing the feature, which can be later removed!!!
                  if(guc_DestroyTransId != 0)
                  {
                     ul_CpeTransId |= (guc_DestroyTransId << 24);
                  }
                  // Debug TransceiverId (end)

                  if(!((ul_CpeTransId == gul_CpeTransId) || (ul_CpeTransIdReversed == gul_CpeTransId)))
                  {
                     gus_OSignatureErrorCode = O_SIG_FIELD21_VEC_XTALK_LINK;
                     return(FALSE);
                  }
               }
            }
            // XDSLRTFW-711: BugFix_DS_VDSL2_All_SkipUnknownPara (End)
         }
      }
      else
      {
         // note that CO doesn't seem to comply to Amd5
         gul_SocMsgNotCompliedAmends |= AMEND5_NOT_COMPLIED_IN_OSignature;
         goto EndOf_OSignature_Interp;
      }
   }
   else
   {
      // note that CO doesn't seem to comply to Amd5
      gul_SocMsgNotCompliedAmends |= AMEND5_NOT_COMPLIED_IN_OSignature;
   }

   // XDSLRTFW-487_VR9_VRX318_VDSL2_All_AELEM_Support (START)
   // Field 22. AELEM (Alternative Electrical Length Estimation Mode)
   // Note: +1 is a fix for IKANOS to ignore additional byte at the end of
   // O-signature. Otherwise UnpackedMsgLengthCheck() kicks in!
   if ((s_idx + 2) <= gs_RxWholeMsgLength)
   {
      // Set bit to indicate these fields are included
      gul_dbgSocMsgControl2 |= AMENDMENT7_AELM_SUPPORT;

      if(gul_OperationModeStatus_VDSL2 & (V2_ELE_METHOD1 << 24))
      {
         // Field 22 - AELEM support
         // XDSLRTFW-4052(Start)
         // AELE-MODE = 0 kl0[band] = ELE-M0 VTU-O kl0 estimate
         // AELE-MODE = 1 kl0[band] = ELEDS [dB], band ? {upbo_bands}
         // AELE-MODE = 2 kl0[band] = ELE[band] [dB], band ? {upbo_bands}
         // AELE-MODE = 3 kl0[band] = MIN(ELEUS, ELEDS) [dB], band ? {upbo_bands}
         // Info:
         //    If AELE-MODE = 1, 2, or 3, UPBO shall be performed according to
         //    AELE-MODE=1 until final kl0 values are provided in the O-UPDATE message. 

         // UPBOELEMT values expressed as 4-bits unsigned integer in percent
         //  The only valid value of UPBOELEMT is 10. Other values are reserved for future use.

         // If the minimum received signal plus noise power during loss estimation is less
         // than rx_threshold (dBm/Hz) for the particular band the LOSS shall be set to
         // a special value 307.1dB
         // RXTHRSHDS parameter coded as an eight bit signed integer n, with valid values being all
         // integers in the range from -64 to 0, representing an offset from -100 dBm/Hz as
         // RXTHRSHDS = (-100 + n) dBm/Hz
         // The maximum values for rx_threshold(band) are: -130 dBm/Hz in the downstream bands,
         // and -115 dBm/Hz in the upstream bands.
         // 1st octet
         // bits 0..3 UPBOELEMT
         // bits 4..5 0
         // bits 6..7 AELEM-MODE
         gt_AELEM_UPBOInfo.us_UpboElmt = (uint16)(puca_OctetBuffer[s_idx] & 0x000F);
         gt_AELEM_UPBOInfo.us_AeleMode = (uint16)((puca_OctetBuffer[s_idx++]>>6) & 0x0003);
         // 2nd octet RXTHRSHDS
         gt_AELEM_UPBOInfo.s_RxThreshDs = (int16)((int8)puca_OctetBuffer[s_idx++]);
      }
      else
      {
         // skip the AELEM bytes
         s_idx += 2;
      }
   }
   else
   {
      // note that CO doesn't seem to comply to Amd6
      gul_SocMsgNotCompliedAmends |= AMEND6_NOT_COMPLIED_IN_OSignature;
   }
   // XDSLRTFW-487_VR9_VRX318_VDSL2_All_AELEM_Support (END)
   // XDSLRTFW-1696 (Start)
   if (gus_VectoringOptionsEnabled & VEC_OPTIONS_FDPS_US_MASK )
   {
      // Field 23 / G993.2 Amd2 (12/2012) : Reserved for operation according to Annex X (1 byte)
      s_idx += 1; // Skip

      // Field 24 / G993.2 Amd2(12/2012): ITU-T G.993.5 Parameter Field B
      if (s_idx+1 < gs_RxWholeMsgLength)
      {
         uint16 us_Len;
         us_Len  = puca_OctetBuffer[s_idx++]<<8;
         us_Len |= puca_OctetBuffer[s_idx++];


         if(us_Len > 0)
         {
            // XDSLRTFW-711: BugFix_DS_VDSL2_All_SkipUnknownPara (Start)
            // Note: The fix was done at this place to ignore an additional byte at the end of
            //       the O-Signature message. Otherwise UnpackedMsgLengthCheck() kicks in!
            int16 s_IdxTemp;

            // Standard can always be exdended for block with variable length, i.e. parameter can be added.
            // To be future proofen not jet known parameters have to be skipped.
            s_IdxTemp = s_idx;
            s_idx += us_Len;

            // Field 1 Table 10-1b/ B993.5 Amd2: Unpack the index of the associated independent pilot sequence
            Unpack3Bits8Data(&(puca_OctetBuffer[s_IdxTemp]), &(guca_IndexIndependentPSActive[0]));
            s_IdxTemp += 3;

            // Field 2 Table 10-1b/ B993.5 Amd2: Sign of the sequence relatively to the associated independent sequence
            guc_SignOfSeqActive = puca_OctetBuffer[s_IdxTemp++];

            // Field 3 Table 10-1b/ B993.5 Amd2: Cyclical shift of the sequence relative to the associated independent sequence
            Unpack3Bits8Data(&(puca_OctetBuffer[s_IdxTemp]), &(guca_CyclicalShiftOfSeqActive[0]));
            s_IdxTemp += 3;

            // Field 4 Table 10-1b/ B993.5 Amd2: Number of additional independent pilot sequence
            guc_NoOfAdditionalIPSActive = puca_OctetBuffer[s_IdxTemp++];

            // Field 5 Table 10-1b/ B993.5 Amd2: bits of independent pilot sequence
            for (i = 1 ; i <= guc_NoOfAdditionalIPSActive; i++ )
            {
               for (int16 j =0; j < (gs_VecNPilotLength_US>>3); j++)  //Div by 8, because sequence length is bits
               {
                  gpuca_FDPSActive[i*64 + j] = puca_OctetBuffer[s_IdxTemp++];  // use pointer
               }
            }
//            gs_Debug0 = s_idx;
         }
         else
         {
//            gs_Debug0 = 0x1;
            //CO does not use US FDPS, according to standard it is allowed to not use FDPS feature
            //even though it is indicated in Ghs
            gus_OSignatureErrorCode = O_SIG_FIELD24_VEC_FDPS_NOT_SUPPORTED;

         }
      }
      else
      {
         // note that CO doesn't comply to G993.5 Amendment 2 (12/2012)
//         gs_Debug0 = 0x2;
         gul_SocMsgNotCompliedAmends |= O_SIG_FIELD24_NOT_COMPILED_IN_OSignature;
         return(FALSE);
      }
   }
   // XDSLRTFW-1696 (end)



EndOf_OSignature_Interp:

   return(UnpackedMsgLengthCheck(s_idx, gs_RxWholeMsgLength));
}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : InterpOSignatureMsg_VDSL2
 *
 *  Description:  Interpret the CO O-SIG message.
 *
 *  Prototype:
 *           void InterpOSignatureMsg_VDSL2(void);
 *
 *
 *  Input Arguments:
 *      None
 *
 *  Output Arguments:
 *      None
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
int16 InterpOSignatureMsg_VDSL2(void)
{

   //Unpack the byte array to the message parameters
   if(UnpackOSignatureMsg_VDSL2() == FALSE)
   {
      return(FALSE);
   }

   // check if US0 is enabled
   gft_US0BandUsed = CheckForUS0Enable();
   gft_US0BandUsedInCD = gft_US0BandUsed;

   //============================================================
   //Compute the subcarrier group size used for sending QLN, HLOG
   //=============================================================

//XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise (Start)
   //Added during virtual noise bringup from Vinax code base (Mercurial Tag: REL_V12_08_03_26_0_04)
   if (gs_Log2CarrierGroupSizeTx_Disc == -1)
   {
      gs_Log2CarrierGroupSizeTx_Disc = CalcCarrierGroupSize(gsa_TxBandRightChannel[gs_NumOfTxBands-1]);
   }
//XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise (End)
   gs_CarrierGroupSizeTx_Disc = 1<<gs_Log2CarrierGroupSizeTx_Disc;

   gs_Log2CarrierGroupSizeRx_Disc = CalcCarrierGroupSize(gsa_RxBandRightChannel[gs_NumOfRxBands-1]);
   gs_CarrierGroupSizeRx_Disc = 1<<gs_Log2CarrierGroupSizeRx_Disc;

   return(TRUE);
}

//XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise (Start)
/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : UnpackVNPSD
 *
 *  Description:  Unpack the virtual noise PSD
 *
 *  Prototype:
 *           void UnpackVNPSD(int16 *ps_PtrMsgIndex, int16 s_NumOfPoints,
 *                            uint8 *puca_OctetBuffer,
 *                            void *pt_PSDDesc)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Note: Initially the last parameter was of type PSDDescriptorTable_t but to suppress/remove
 *         a warning it has been changed to type void. And suitable changes are made in the function
 *         and wherever it is being employed.
 *
 *------------------------------------------------------------------------
 *^^^
 */
void UnpackVNPSD(int16 *ps_PtrMsgIndex,
                 int16 s_NumOfPoints,
                 uint8 *puca_OctetBuffer,
                 PSDDescriptorTable_t *pt_PSDDesc)
{
   DecPSD_Descriptor_t  t_TempPSDDesc;
   int16 j, s_PSDLevel;

   // Unpack message into temp PSD buffer:
   // ANXQ_SUPPORT
   if (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK)
   {
      Unpack16BitsPair(ps_PtrMsgIndex, s_NumOfPoints, puca_OctetBuffer,
                       &(t_TempPSDDesc.sa_ToneIndex[0]),
                       &(t_TempPSDDesc.sa_PSDLevel[0]));
   }
   else
   {
      Unpack12BitsPair(ps_PtrMsgIndex, s_NumOfPoints, puca_OctetBuffer,
                       &(t_TempPSDDesc.sa_ToneIndex[0]),
                       &(t_TempPSDDesc.sa_PSDLevel[0]));
   }

   for (j = 0; j < s_NumOfPoints; j++ )
   {
      pt_PSDDesc->ut_PSDRecord[j].us_IndexOfTone = t_TempPSDDesc.sa_ToneIndex[j];

      // Convert PSD level from VDSL message format to PSD descriptor format:
      s_PSDLevel  = t_TempPSDDesc.sa_PSDLevel[j];

      if (gft_OldVNPsdFormat == TRUE)
      {
         s_PSDLevel = s_PSDLevel + 80;
      }
      else
      {
         s_PSDLevel = (1400 - s_PSDLevel)/5;
      }

      // VN level should be between -40dBm/Hz and -140dBm/Hz
      // API defined VN PSD level as offset from 0dBm/Hz with step size of 0.5dB
      if (s_PSDLevel < 80)
      {
         s_PSDLevel = 80;
      }
      else if (s_PSDLevel > 280)
      {
         s_PSDLevel = 280;
      }

      pt_PSDDesc->ut_PSDRecord[j].s_PSDLevelOfTone = s_PSDLevel;
   }
}
//XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise (End)

