/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;   The function for O-TA-UPDATE message.
;
*****************************************************************************/

// ****************************************************************************************************
// InterpOTAUpdateMsg_VDSL2.c
// History :
//   06/05/2013 Varun : Added code(Debug option) to capture raw data of all Tx and Rx(O-TA-UPDATE in particular)
//                    training messages (G.Hs + training)
//                    Grep for "XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer"
//
//
//****************************************************************************************************
#include <string.h>
#include "common.h"
#include "gdata.h"
#include "socmessage.h"
#include "cmv.h"
#include "DebugBuffer.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *
 *  Description:  Unpacks the O-TA-Update message.
 *
 *  Prototype:
 *           int16 InterpOTAUpdateMsg_VDSL2(void);
 *
 *
 *  Input Arguments:
 *      None
 *
 *  Output Arguments:
 *      None
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
int16 InterpOTAUpdateMsg_VDSL2(void)
{
   uint8 *puca_OctetBuffer;
   int16 s_idx;

   puca_OctetBuffer = gpuca_RxHDLCMsgBuf;
#ifdef DEBUG_TRACES
   // XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer(START_END)
   LogMessages(4,(uint16)gpuca_RxHDLCMsgBuf[0], (uint16)gs_RxWholeMsgLength, gpuca_RxHDLCMsgBuf, DEBUG_BUFFER_DELIMITER_VDSL2);
#endif //#ifdef DEBUG_TRACES
   memcpy(&gsa_DebugStreamBuffer[0][0],gpuca_RxHDLCMsgBuf,(uint16)gs_RxWholeMsgLength);
   DSH_SendStream(DSH_O_TA_UPDATE, (uint16)gs_RxWholeMsgLength,(void *)&gsa_DebugStreamBuffer[0][0]);

   // Field1 - Message descriptor
   s_idx = 1;                          // gets be skipped!

   // Field 2: timing advance correction (2 bytes)
   // Note: It shall be expressed in samples at the UPstream sampling rate
   //       corresponding to the IDFT size communicated in Field #6 of R-PRM.
   gt_DecMsg_O_TA_Update.s_TimeAdv = puca_OctetBuffer[s_idx++]<<8;
   gt_DecMsg_O_TA_Update.s_TimeAdv |= puca_OctetBuffer[s_idx++];
   if ((gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK) &&
       (gs_TxLog2IfftLength > US_LOG2_FFT_LENGTH_8192))                // US_LOG2_FFT_LENGTH_8192 = 13
   {
      // VR9/VR318: Upstream is always running with the small IFFT.
      // CO send the value dependent of the upstream IFFT size:
      //  ... shall be expressed either in multiples of 2 samples
      //      if profile 35b is used with extended IDFT Size, or otherwise,
      //      in samples at the upstream sampling rate corresponding to the
      //      IDFT size communicated in Field #6 of R-PRM.
      //  Note: Profile 35b being used with extended IDFT Size is equivalent
      //        with Field #6 of R-PRM having value 14.
      gt_DecMsg_O_TA_Update.s_TimeAdv = (gt_DecMsg_O_TA_Update.s_TimeAdv << 1);
   }

   // Field 3: Bex-ds-o: desired number of bytes per DMT symbol in downstream
   // during exchange phase (1 byte)
   gt_DecMsg_O_TA_Update.uc_Bex_ds_O = gpuca_RxHDLCMsgBuf[s_idx++];

   // Field 4: Bex-us-o: desired number of bytes per DMT symbol in upstream
   // during exchange phase (1 byte)
   gt_DecMsg_O_TA_Update.uc_Bex_us_O = gpuca_RxHDLCMsgBuf[s_idx++];

   // Field 5: ITU-T G.998.4 parameter field
   if (s_idx < gs_RxWholeMsgLength)
   {
      uint8 uc_Len;

      // Skip G.INP
      uc_Len = gpuca_RxHDLCMsgBuf[s_idx++];
      s_idx += uc_Len;
   }
   else
   {
      // note that CO doesn't seem to comply to Amd5
      gul_SocMsgNotCompliedAmends |= AMEND5_NOT_COMPLIED_IN_OTaUpdate;
   }

   // Field 6: ITU-T G.993.5 parameter field
   if (s_idx < gs_RxWholeMsgLength)
   {
      uint8 uc_Len;

      //Handle G.Vector
      uc_Len = gpuca_RxHDLCMsgBuf[s_idx++];

      if (((s_idx + uc_Len) <= gs_RxWholeMsgLength) && (uc_Len > 0))
      {
         uint8 uc_Temp;
         uint8 uc_G9935_NumBands;
         int16 i;
         // XDSLRTFW-711: BugFix_DS_VDSL2_All_SkipUnknownPara (Start)
         int16 s_IdxTemp;

         // Standard can always be exdended for block with variable length, i.e. parameter can be added.
         // To be future proofen not jet known parameters have to be skipped.
         s_IdxTemp = s_idx;
         s_idx += uc_Len;

         uc_Temp = gpuca_RxHDLCMsgBuf[s_IdxTemp++];
         uc_G9935_NumBands = uc_Temp >> 4; // this variable will be used in for loop

         gt_DecMsg_O_TA_Update.t_G9935_O_TA_Update_Prm.uc_Nband   = uc_G9935_NumBands;
         gt_DecMsg_O_TA_Update.t_G9935_O_TA_Update_Prm.uc_Padding = (uc_Temp>>3)&0x1;
         gt_DecMsg_O_TA_Update.t_G9935_O_TA_Update_Prm.uc_Fblock  = (uc_Temp&0x3);   // 0 ---> ceil(N_carrier/F_sub)
         // 1 ---> 1
         // 2 ---> 32
         // Store Control parameters for Vectored bands
         for(i = 0; i < uc_G9935_NumBands; i++)
         {
            // VB Control Parameter Formatting
            // Value       Bits
            // --------------------
            // F_sub        [15:12]
            // L_w        [11:8]
            // B_min      [7:4]
            // B_max      [3:0]
            uc_Temp = gpuca_RxHDLCMsgBuf[s_IdxTemp++];
            gt_DecMsg_O_TA_Update.t_G9935_O_TA_Update_Prm.usa_VectoredBandParams[i]  = (uint16)uc_Temp<<8;
            uc_Temp = gpuca_RxHDLCMsgBuf[s_IdxTemp++];
            gt_DecMsg_O_TA_Update.t_G9935_O_TA_Update_Prm.usa_VectoredBandParams[i] += (uint16)uc_Temp;
         }
         gt_DecMsg_O_TA_Update.t_G9935_O_TA_Update_Prm.uc_SOCRepetitionFactor = gpuca_RxHDLCMsgBuf[s_IdxTemp++];
         gt_DecMsg_O_TA_Update.t_G9935_O_TA_Update_Prm.uc_FEXTSymbolsPerSF = gpuca_RxHDLCMsgBuf[s_IdxTemp++];

         //XDSLRTFW-1621 DeltInVectoring (Start/End)
         if ((gus_VectoringOptionsEnabled & VEC_OPTIONS_FULL_FRIENDLY_MASK) || gft_DeltInVectoringMode)
         {
            //According to standard, no other values are allowed than SOCRep = 10 and SymbolsPerSF = 0
            gt_DecMsg_O_TA_Update.t_G9935_O_TA_Update_Prm.uc_SOCRepetitionFactor = 10;
            gt_DecMsg_O_TA_Update.t_G9935_O_TA_Update_Prm.uc_FEXTSymbolsPerSF = 0;
         }
      }
      // XDSLRTFW-711: BugFix_DS_VDSL2_All_SkipUnknownPara (End)
   }
   else
   {
      // note that CO doesn't seem to comply to Amd5
      gul_SocMsgNotCompliedAmends |= AMEND5_NOT_COMPLIED_IN_OTaUpdate;
   }

   //DSM_Vectoring_Debug:
   //if ( gs_PauseControl == 0x20)
   //Pause(gs_PauseControl);

   return(UnpackedMsgLengthCheck(s_idx, gs_RxWholeMsgLength));
}
