/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;   This function is used to interpret the O-TPS message.
;
*****************************************************************************/

// ***********************************************************************************************************
// InterpOTpsMsg_VDSL2.c
//
// History
//
// 18/09/2012 Ram: 1. Added code to support ReTx CMV - INFO 229 (to check if DS showtime is in ReTx mode or not)
//                 Grep for: "XDSLRTFW-443: Feature_DS_VDSL2_All_ReTx_CMV_INFO_229"
// 06/05/2013 Varun : Added code(Debug option) to capture raw data of all Tx and Rx(O-TPS in particular) training
//                messages (G.Hs + training)
//                Grep for "XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer"
// 15/07/2013 Varun : Incorporated the code changes to support US ReTx
//                     Grep for "XDSLRTFW-1046 Feature_US_VDSL2_ALL_UsReTx"
//19/07/2013 Kannan: Changes to set the Tx Data pump setup
//Grep for "XDSLRTFW-1079 Feature_US_VDSL2_ALL_UsReTx"
//
//01-08-2013 Varun/Palaksha: "XDSLRTFW-1055 VDSL2 US ReTx: Overhead message changes for US ReTx Transmit"
//       Calculation or(and)  sending of below things
//     (i) In  response  to  a  Test Parameter Single  Read  command  if US retransmission is enabled
//      - INP_act_SHINE (Far-end RTX Transmitter Actual Impulse Noise protection against SHINE)
//      - INP_act_REIN (Far-end RTX Transmitter Actual Impulse Noise protection against REIN)
//    (ii)In Response to Management counter Single  Read  command  if US retransmission is enabled send Counter of rtx-tx
//    (iii)Upon reception of the Enter RTX_TESTMODE command, the VTU-R shall acknowledge it with an
//         ACK response. Afterwards, the VTU-R shall acknowledge all received DTUs if retransmission is
//         enabled  in  the  DS  direction  and  shall  stop  retransmitting  any  DTU  if  retransmission  is
//         enabled in upstream. Upon  reception  of  the  Leave  RTX_TESTMODE  command,  the  VTU-R  shall  resume
//         the  normal behaviour of retransmission in the direction where it is enabled
//    grep for XDSLRTFW-1055 Feature_US_VDSL2_ALL_UsReTx_TxOvhdTestMgmtDiag
//
// 29/10/2013 Anantha Ramu: Modifications done to calculate ATTNDR with attndr_method set to 0(default),1 & 2 as per
//                          Amd 2 of G.998.4. The attndr_method is decided by CO MIB, and conveyed to CPE in O-TPS.
//                          CPE also indicates capability to calculate ATTNDR with methods 1 & 2 in R-MSG2
//                         (Field: ATTNDR method capability). In methods 1 & 2 the configured INPs used for calculation
//                          are conveyed to CO through overhead test parameters response along with ATTNDR value.
//                          Grep for: XDSLRTFW-1285 Feature_US_VDSL2_ALL_UsReTxAmend2_ATTNDR
// 30/10/2013 Varun : CPE reporting wrong test parameter values of Actual INP shine and rein .This was because Delay max for DS was taken
//                    instead of US Delay Max which resulted in wrong caluculation of NRET.
//                    Grep for XDSLRTFW-1361 Feature_US_VDSL2_ALL_UsReTx_ActualINPcalculation
// 29/07/2016 Fuss: Data rate limitation with CMD_BearerCh0_DS_Set (CNFG 0/1) or CNFG 5/6 not possible for ReTx.
//                  Grep for XDSLRTFW-2854
//
//07/02/2018 Sriram shastry: VRX518: VDSL2 35b Vect. Sync Prob. with ADTRAN IUVDSL:48:SVM:F
//         No sync issue is seen when the maxETR is higher than maxNDR. Due to  CO Mis configuration
//         CPE fail with E_CODE_RX_LOW_PILOT_TONE_POWER.So the solution is cap max ETR to max NDR if maxETR > maxNDR
//         cmv description : TEST 55 0 1
//         (Default:ON)
//         Search  pattern : XDSLRTFW-3677
//
// ************************************************************************************************************

#include <stdio.h>
#include <string.h>
#include "common.h"
#include "gdata.h"
#include "socmessage.h"
#include "vdsl_xception.h"
#include "DebugBuffer.h"
#include "cmv.h"
#include "cmv_Data.h"
#include "ppe_memmap.h"
#include "LL_IOf.h"
#include "vdsl_state.h"
#include "Cri_iof.h"

void ReinitZepIlvHwVariablesForReTX(void);
void SetupDTBForReTX(void);
void SetupDTBForUsDsReTX(void);    //XDSLRTFW-1079 Feature_US_VDSL2_ALL_UsReTx(START_END)
void SetupDTBForUsReTxOnly(void);

extern uint32 gul_SocMsgNotCompliedAmends;
extern int16 SelectActualPmsParms(void);
/*^^^
 *------------------------------------------------------------------------
 *
 *
 *  Description:  O-TPS message.
 *
 *  Prototype:
 *           int16 InterpOTpsMsg_VDSL2(void);
 *
 *
 *  Input Arguments:
 *      None
 *
 *  Output Arguments:
 *
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
int16 InterpOTpsMsg_VDSL2(void)
{
   int16 s_idx;
   int16 s_bc;
   int16 s_preferredTpsTcType;
   uint16 us_TC_required;     // Variable used to determine the TC loaded
   // in the system and the required TC
#ifdef DEBUG_TRACES
   // XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer(START_END)
   LogMessages(4,(uint16)gpuca_RxHDLCMsgBuf[0], (uint16)gs_RxWholeMsgLength, gpuca_RxHDLCMsgBuf, DEBUG_BUFFER_DELIMITER_VDSL2);
#endif // #ifdef DEBUG_TRACES
   memcpy(&gsa_DebugStreamBuffer[3][0],gpuca_RxHDLCMsgBuf,(uint16)gs_RxWholeMsgLength);
   DSH_SendStream(DSH_O_TPS, (uint16)gs_RxWholeMsgLength,(void *)&gsa_DebugStreamBuffer[3][0]);

   // Field1 - Message descriptor
   s_idx = 1;                          // gets be skipped!

   // TPS-TC configuration
   // Mapped configurations of DS frame bearers and TPS-TC types
   // Field2 byte1
   gt_DecMsg_O_TPS_VDSL2.uc_Mapped_DS_FrameBearers_TPSTCs = gpuca_RxHDLCMsgBuf[s_idx++];

   // Mapped configurations of US frame bearers and TPS-TC types
   // Field2 byte2
   gt_DecMsg_O_TPS_VDSL2.uc_Mapped_US_FrameBearers_TPSTCs = gpuca_RxHDLCMsgBuf[s_idx++];

   // DS rate adaption ratio
   // Field2 byte3
   gt_DecMsg_O_TPS_VDSL2.uc_DS_RateAdaptRatio = gpuca_RxHDLCMsgBuf[s_idx++];

   // For each supported DS and US TPS-TC, the following data are specified (8 bytes):
   // Field2 bytes 4-5: Minimum Net Data Rate
   // Field2 bytes 3-4: Mamimum Net Data Rate
   // Field2 bytes 5-6: Minimum Reserved Data Rate
   // Field2 byte 7: Maximum PMS-TC latency
   // Field2 byte 8: Minimum INP
   for (s_bc=0; s_bc<NUM_BEARER_CHANNELS; s_bc++)
   {
      s_preferredTpsTcType = (gt_DecMsg_O_TPS_VDSL2.uc_Mapped_DS_FrameBearers_TPSTCs >> ((4*(1-s_bc)) + 1)) & 0x7;
      gta_DsBearerChanAct[s_bc].s_TypeEnabled = s_preferredTpsTcType;

      if(s_preferredTpsTcType)
      {
         gta_DsBearerChanAct[s_bc].ta_TpsTcType.us_MinNetDataRate = gpuca_RxHDLCMsgBuf[s_idx++] << 8;
         gta_DsBearerChanAct[s_bc].ta_TpsTcType.us_MinNetDataRate |= gpuca_RxHDLCMsgBuf[s_idx++];

         gta_DsBearerChanAct[s_bc].ta_TpsTcType.us_MaxNetDataRate = gpuca_RxHDLCMsgBuf[s_idx++] << 8;
         gta_DsBearerChanAct[s_bc].ta_TpsTcType.us_MaxNetDataRate |= gpuca_RxHDLCMsgBuf[s_idx++];

         // XDSLRTFW-2854 (Start_End)
         // Select the TPS-TC parameters based on the O-TPS and local settings, i.e.
         // limit the BearerChannel Min/Max rate to the CPE configured rate.
         // Note: The rate granularity is different between SOC message and API configuration:
         //       SOC - multiple of 8kbps
         //       API - multiple of 4kbps
         //       Therefore the API value must be devided by 2, i.e. ">> 1".
         // Note: The BDCM CO is not following the values, which gets be send in the SOC messages (R-MSG2) for ReTx!
         //       For IFEC mode the BDCM is following.
         //       Therefore we can do it always to overcome the BDCM bug for ReTx, i.e. has no impact for IFEC mode at all.
         //       The fix could be done also fct. "GetFramingParamsInput()" to populate only the array "gt_FormFramingParamsInputs_v2".
         //       But doing it at this place has the benefit that the gta_DsBearerChanAct struct from which everything gets dereived,
         //       contains directly the correct data (Same concept as for gta_DsLpAct - PMS-TC data see fct. SelectActualPmsParms()).
         {
            int16 s_ConfigBearerIdx;

            s_ConfigBearerIdx = MAX((s_preferredTpsTcType - 1), 0);
            gta_DsBearerChanAct[s_bc].ta_TpsTcType.us_MinNetDataRate = MAX((gta_DsBearerChanAct[s_bc].ta_TpsTcType.us_MinNetDataRate),
                                                                           (gta_DsBearerChannel[s_bc].ta_TpsTcType[s_ConfigBearerIdx].ul_MinNetDataRate >> 1));
            gta_DsBearerChanAct[s_bc].ta_TpsTcType.us_MaxNetDataRate = MIN((gta_DsBearerChanAct[s_bc].ta_TpsTcType.us_MaxNetDataRate),
                                                                           (gta_DsBearerChannel[s_bc].ta_TpsTcType[s_ConfigBearerIdx].ul_MaxNetDataRate >> 1));
      }

         gta_DsBearerChanAct[s_bc].ta_TpsTcType.us_MinResNetDataRate = gpuca_RxHDLCMsgBuf[s_idx++] << 8;
         gta_DsBearerChanAct[s_bc].ta_TpsTcType.us_MinResNetDataRate |= gpuca_RxHDLCMsgBuf[s_idx++];

         gta_DsBearerChanAct[s_bc].ta_TpsTcType.s_MaxLatency = gpuca_RxHDLCMsgBuf[s_idx++];
         gta_DsBearerChanAct[s_bc].ta_TpsTcType.uc_IMAxINP = gpuca_RxHDLCMsgBuf[s_idx++];

         gta_DsBearerChanAct[s_bc].ta_TpsTcType.uc_TPSTCoptions = gpuca_RxHDLCMsgBuf[s_idx++];

         if ((s_bc == BC0) &&
               (gus_ReTxOptionsEnabled & (CPE_DS_US_RETX_CAPABLE|CPE_DS_RETX_CAPABLE)))
         {
            gt_ReTXParams.t_ReTXConfigCMV.us_OTPS_DelayMax = (uint8)gta_DsBearerChanAct[s_bc].ta_TpsTcType.s_MaxLatency;
            gt_ReTXParams.t_ReTXConfigCMV.us_OTPS_INP_min = gta_DsBearerChanAct[s_bc].ta_TpsTcType.uc_IMAxINP & 0x7F;
            gt_ReTXParams.t_ReTXConfigCMV.us_OTPS_MaxNetDataRate = gta_DsBearerChanAct[s_bc].ta_TpsTcType.us_MaxNetDataRate;
         }
      }
   }


   for (s_bc=0; s_bc<NUM_BEARER_CHANNELS; s_bc++)
   {
      s_preferredTpsTcType = (gt_DecMsg_O_TPS_VDSL2.uc_Mapped_US_FrameBearers_TPSTCs >> ((4*(1-s_bc)) + 1)) & 0x7;
      gta_UsBearerChanAct[s_bc].s_TypeEnabled = s_preferredTpsTcType;

      if(s_preferredTpsTcType)
      {
         gta_UsBearerChanAct[s_bc].ta_TpsTcType.us_MinNetDataRate = gpuca_RxHDLCMsgBuf[s_idx++] << 8;
         gta_UsBearerChanAct[s_bc].ta_TpsTcType.us_MinNetDataRate |= gpuca_RxHDLCMsgBuf[s_idx++];

         gta_UsBearerChanAct[s_bc].ta_TpsTcType.us_MaxNetDataRate = gpuca_RxHDLCMsgBuf[s_idx++] << 8;
         gta_UsBearerChanAct[s_bc].ta_TpsTcType.us_MaxNetDataRate |= gpuca_RxHDLCMsgBuf[s_idx++];

         gta_UsBearerChanAct[s_bc].ta_TpsTcType.us_MinResNetDataRate = gpuca_RxHDLCMsgBuf[s_idx++] << 8;
         gta_UsBearerChanAct[s_bc].ta_TpsTcType.us_MinResNetDataRate |= gpuca_RxHDLCMsgBuf[s_idx++];

         gta_UsBearerChanAct[s_bc].ta_TpsTcType.s_MaxLatency = gpuca_RxHDLCMsgBuf[s_idx++];
         gta_UsBearerChanAct[s_bc].ta_TpsTcType.uc_IMAxINP = gpuca_RxHDLCMsgBuf[s_idx++];

         gta_UsBearerChanAct[s_bc].ta_TpsTcType.uc_TPSTCoptions = gpuca_RxHDLCMsgBuf[s_idx++];

         if (s_bc == BC0)
         {
            gt_ReTXParams.t_ReTXConfigCMV.us_OTPS_US_INP_min = gta_UsBearerChanAct[s_bc].ta_TpsTcType.uc_IMAxINP & 0x7F;
            //XDSLRTFW-1361 Feature_US_VDSL2_ALL_UsReTx_ActualINPcalculation(START_END)
            gt_ReTXParams.t_ReTXConfigCMV.us_US_DelayMax=gta_UsBearerChanAct[s_bc].ta_TpsTcType.s_MaxLatency;
         }
      }
   }


   // presume that there's not ReTX params in this message
   gl_NoRetxMsg |= 0x2;

   // table 12-45.1
   if (gta_DsBearerChanAct[BC0].s_TypeEnabled)
   {
      if (s_idx  + 1 <= gs_RxWholeMsgLength)
      {
         //guca_RxMaxDV[BC0] = gpuca_RxHDLCMsgBuf[s_idx++];
         s_idx++;
      }
      else
      {
         goto EndOf_OTps_Interp_Amend1_not_complied;
      }
   }

   if (gta_DsBearerChanAct[BC1].s_TypeEnabled)
   {
      if (s_idx  + 1 <= gs_RxWholeMsgLength)
      {
         //guca_RxMaxDV[BC1] = gpuca_RxHDLCMsgBuf[s_idx++];
         s_idx++;

         // Set bit to indicate these fields are included
         gul_dbgSocMsgControl2 |= AMENDMENT1_OTPS_MAX_DELAY_VAR_SUPPORT;
      }
      else
      {
         goto EndOf_OTps_Interp_Amend1_not_complied;
      }
   }


   if(s_idx < gs_RxWholeMsgLength)     // amend3
   {
      // Field #4 indicates whether the ROC and SOS are enabled.
      // It is a one byte value [ssss rrrr].
      // Note: When ROC and SOS are supported this information is
      //       needed for R-PMS.

      // skip over uc_SOS_ROC_enable
      s_idx++;
   }
   else
   {
      goto EndOf_OTps_Interp;
   }



#ifdef DEBUG_GINP_MSGS
   gpuca_GINP_MsgBuf = gpuca_RxHDLCMsgBuf;
   gl_GINP_StartIdx = s_idx;
   gl_GINP_MsgLength = gs_RxWholeMsgLength;
#endif

   // Field 5: ITU-T G.998.4 parameter field
   if (s_idx < gs_RxWholeMsgLength)
   {
      uint8 uc_Len;

      //Handle G.Inp
      uc_Len = gpuca_RxHDLCMsgBuf[s_idx++];

      if ((s_idx + uc_Len) <= gs_RxWholeMsgLength)
      {
         if (uc_Len > 0)
         {
            // XDSLRTFW-711: BugFix_DS_VDSL2_All_SkipUnknownPara (Start)
            int16 s_IdxTemp;

            // Standard can always be exdended for block with variable length, i.e. parameter can be added.
            // To be future proofen not jet known parameters have to be skipped.
            s_IdxTemp = s_idx;
            s_idx += uc_Len;

            if (gus_ReTxOptionsEnabled & (CPE_DS_US_RETX_CAPABLE|CPE_DS_RETX_CAPABLE))
            {
               int16 s_temp;

               // for debug; we do get ReTX params
               gl_NoRetxMsg &= ~(0x2);

               s_temp = gpuca_RxHDLCMsgBuf[s_IdxTemp++];
               if (s_temp & 0x1)
               {
                  gt_ReTXParams.uc_OMSG1_DsReTxEnabled = RETX_SELECTED;
//XDSLRTFW-443: Feature_DS_VDSL2_All_ReTx_CMV_INFO_229 (Start)
                  gus_DsUsReTxStatus |= RETX_DS_IN_USE;
//XDSLRTFW-443: Feature_DS_VDSL2_All_ReTx_CMV_INFO_229 (End)
                  ReinitZepIlvHwVariablesForReTX();
                  SetupDTBForReTX();

                  // make sure that dual latency is enabled
                  gt_rx_TPS_Map.s_BCtoLP[BC0] = 1;                            // cw cnfg 20 0 1
                  gt_rx_TPS_Map.s_BCtoLP[BC1] = 0;                            // cw cnfg 20 1 0
               }
               else
               {
                  // error case
                  gt_ReTXParams.uc_OMSG1_DsReTxEnabled = CO_RETX_CAPABLE_BUT_NOT_SELECTED;
               }

               if (s_temp & 0x2)
               {
                  //XDSLRTFW-1193 Feature_US_VDSL2_ALL_UsReTx_CMV(START)
                  //XDSLRTFW-1046 Feature_US_VDSL2_ALL_UsReTx(START)
                  gt_ReTXParams.uc_UsReTxStatus = US_RETX_IN_USE;
                  gus_DsUsReTxStatus |= US_RETX_IN_USE;
                  //XDSLRTFW-1193 Feature_US_VDSL2_ALL_UsReTx_CMV(END)


                  if(gt_ReTXParams.uc_OMSG1_DsReTxEnabled == RETX_SELECTED)
                  {
                     //XDSLRTFW-1079 Feature_US_VDSL2_ALL_UsReTx(START)
                     SetupDTBForUsDsReTX();//set up DTB for US+Ds ReTx
                     //XDSLRTFW-1079 Feature_US_VDSL2_ALL_UsReTx(END)
                  }
                  else
                  {
                     SetupDTBForUsReTxOnly();//set up DTB for US ReTx only
                  }


                  //if US ReTx enabled then make the number of lantency path=2
                  guc_NumLantencyPath=2;
                  //XDSLRTFW-1046 Feature_US_VDSL2_ALL_UsReTx(END)
               }

               // DS ETR_max
               s_temp = gpuca_RxHDLCMsgBuf[s_IdxTemp++] << 8;
               s_temp |= gpuca_RxHDLCMsgBuf[s_IdxTemp++];
               gt_ReTXParams.t_ReTXConfigCMV.us_OTPS_ETR_max = s_temp;

               // DS ETR_min
               s_temp = gpuca_RxHDLCMsgBuf[s_IdxTemp++] << 8;
               s_temp |= gpuca_RxHDLCMsgBuf[s_IdxTemp++];
               gt_ReTXParams.t_ReTXConfigCMV.us_OTPS_ETR_min = s_temp;

               // DS Min Delay
               gt_ReTXParams.t_ReTXConfigCMV.us_OTPS_DelayMin = gpuca_RxHDLCMsgBuf[s_IdxTemp++];

               // XDSLRTFW-2689 (Start)
               //VDSL FW does not support DelayMin higher than 0. Framer algo and ReTx
               //queue management does not support DelayMin higher than 0.
               //Hence over ruling CO configuration as a workaround
               if (gt_ReTXParams.t_ReTXConfigCMV.us_OTPS_DelayMin > 0)
               {
                  gt_ReTXParams.t_ReTXConfigCMV.us_OTPS_DelayMin = 0;
               }
               // XDSLRTFW-2689 (End)

               // INP_min_REIN. In VDSL Bit7 is the iat_REIN_flag. Use 0 by default
               gt_ReTXParams.t_ReTXConfigCMV.us_OTPS_INP_min_REIN = gpuca_RxHDLCMsgBuf[s_IdxTemp++];

            //XDSLRTFW-2547(Start)
               if ((gt_ReTXParams.t_ReTXConfigCMV.us_OTPS_INP_min == 41) && (gt_ReTXParams.t_ReTXConfigCMV.us_OTPS_INP_min_REIN == 0))
               {
                    gus_SelectedFramingParam = ReTx_SHINE_INP_41_REIN_INP_0;
               }
            //XDSLRTFW-2547(End)



               // DS Shine Ratio
               gt_ReTXParams.t_ReTXConfigCMV.us_OTPS_SHINE_ratio = gpuca_RxHDLCMsgBuf[s_IdxTemp++];

               //XDSLRTFW-1055 Feature_US_VDSL2_ALL_UsReTx_TxOvhdTestMgmtDiag (Start)
               // US_min_delay
               gt_ReTXParams.t_ReTXConfigCMV.us_OTPS_US_DelayMin = gpuca_RxHDLCMsgBuf[s_IdxTemp++];
               //US INP_min_REIN. In VDSL Bit7 is the iat_REIN_flag. Use 0 by default
               gt_ReTXParams.t_ReTXConfigCMV.us_OTPS_US_INP_min_REIN= gpuca_RxHDLCMsgBuf[s_IdxTemp++];
               //XDSLRTFW-1055 Feature_US_VDSL2_ALL_UsReTx_TxOvhdTestMgmtDiag (End)

               // DS leftr_thresh
               gt_ReTXParams.t_ReTXConfigCMV.us_OTPS_DS_LEFTR_thresh = gpuca_RxHDLCMsgBuf[s_IdxTemp++] & 0x7F;

               //XDSLRTFW-1909 (Start)
               //According to sec 11.3.3 of G.998.4, If leftr_thresh is set to a special value '0'
               //leftr defect occurs when EFTR < (0.998*NDR). Otherwise leftr defect would occur when
               //EFTR < max((leftr_thresh/100)*NDR, ETR/2)
               if (gt_ReTXParams.t_ReTXConfigCMV.us_OTPS_DS_LEFTR_thresh == 0)
               {
                  gt_ReTXParams.t_ReTXConfigCMV.us_OTPS_DS_LEFTR_thresh = 998;
               }
               else
               {
                  //We shall divide by 1000 instead of 100 in G997_1sec_Task() (file g997.c)
                  gt_ReTXParams.t_ReTXConfigCMV.us_OTPS_DS_LEFTR_thresh *= 10;
               }
               //XDSLRTFW-1909 (End)

               // CI Policy
               gt_ReTXParams.t_ReTXConfigCMV.us_OTPS_CI_policy = gpuca_RxHDLCMsgBuf[s_IdxTemp++] & 0x1;
            }
            // XDSLRTFW-711: BugFix_DS_VDSL2_All_SkipUnknownPara (End)
         }
      }
      else
      {
         // note that CO doesn't seem to comply to Amend5
         goto EndOf_OTps_Interp_Amend5_not_complied;
      }
   }
   else
   {
      // note that CO doesn't seem to comply to Amend5
      goto EndOf_OTps_Interp_Amend5_not_complied;
   }

   // XDSLRTFW-3677(Start)
   // cap  Max ETR to Max NDR, [we fail to sync due to Low Pilot power (E_CODE_RX_LOW_PILOT_TONE_POWER)]
   //ETR>NDR = no-sync
   /*
   |TEST-NUM |MAX_ETR*8[kbps] |MAX_NDR*8[kbps] |SYNC-STATE|
   +---------+----------------+----------------+----------+
   |1        |31250           |18750           |FAIL      |
   +---------+----------------+----------------+----------+
   |2        |31250           |31250           |PASS      |
   +---------+----------------+----------------+----------+
   */
   if((gt_ReTXParams.t_ReTXConfigCMV.us_OTPS_ETR_max) > (gt_ReTXParams.t_ReTXConfigCMV.us_OTPS_MaxNetDataRate))
   {
      if((TESTArray[TEST_CO_ERR_CONF_CONTROL] & TEST_OVER_WRITE_MAXETR_WITHMAXNDR) == TEST_OVER_WRITE_MAXETR_WITHMAXNDR)
      {
         gt_ReTXParams.t_ReTXConfigCMV.us_OTPS_ETR_max = gt_ReTXParams.t_ReTXConfigCMV.us_OTPS_MaxNetDataRate;
      }
      else
      {
         uint32 ul_ExceptionCode;
         ul_ExceptionCode = (E_CODE_INVALID_CO_CONFIGURATION_MAXETRMAXNDR);                          // (612)
         EnterFailStates(ul_ExceptionCode);
      }
   }
   // XDSLRTFW-3677(End)

   // Field #6: ITU-T G.993.5 parameter field (Vectoring)
   if (s_idx < gs_RxWholeMsgLength)
   {
      uint8 uc_Len;

      // Skip G.Vector
      uc_Len = gpuca_RxHDLCMsgBuf[s_idx++];
      // Note: The if-case was done to ignore an additional byte at the end of
      //       the O-TPS message. Otherwise UnpackedMsgLengthCheck() kicks in!
      if ((s_idx + uc_Len) <= gs_RxWholeMsgLength)
      {
         s_idx += uc_Len;
      }
      else
      {
         // note that CO doesn't seem to comply to Amend5
         goto EndOf_OTps_Interp_Amend5_not_complied;
      }
   }
   else
   {
      // note that CO doesn't seem to comply to Amend5
      goto EndOf_OTps_Interp_Amend5_not_complied;
   }

   //XDSLRTFW-1285 Feature_US_VDSL2_ALL_UsReTxAmend2_ATTNDR(Start)
   // Field #7: Time synchronization enable
   if (s_idx < gs_RxWholeMsgLength)
   {
      s_idx++; //Time sync enable
   }

   // Field #8: attndr_method (1 byte)
   if (s_idx < gs_RxWholeMsgLength)
   {
      guc_attndr_method = gpuca_RxHDLCMsgBuf[s_idx++];
      guc_attndr_method &= 0x3; //Coded in [0000 00mm] style]
      guc_attndr_method_from_co = guc_attndr_method; // store the method sent by CO.
   }
//XDSLRTFW-1285 Feature_US_VDSL2_ALL_UsReTxAmend2_ATTNDR(End)

   goto EndOf_OTps_Interp;


EndOf_OTps_Interp_Amend1_not_complied:
   gul_SocMsgNotCompliedAmends |= AMEND1_NOT_COMPLIED_IN_OTps;
   goto EndOf_OTps_Interp;


EndOf_OTps_Interp_Amend5_not_complied:
   gul_SocMsgNotCompliedAmends |= AMEND5_NOT_COMPLIED_IN_OTps;
   goto EndOf_OTps_Interp;


EndOf_OTps_Interp:

#ifdef DEBUG_GINP_MSGS
   if (guc_DebugReTXTrainingMsg == 2)
   {
      _flag(1);
   }
#endif
   // INTEROP against IFX version 9.4.x
   if (gft_IfxAtmPtmFix)
   {
      // CO's message is always interpreted as PTM
      gta_DsBearerChanAct[BC0].s_TypeEnabled = TPS_TC_TYPE_PTM;
      gta_UsBearerChanAct[BC0].s_TypeEnabled = TPS_TC_TYPE_PTM;
   }

   // The TC required to be loaded
   if (((gt_DecMsg_O_TPS_VDSL2.uc_Mapped_DS_FrameBearers_TPSTCs >> 5) == (TPS_TC_TYPE_ATM)) && ((gt_DecMsg_O_TPS_VDSL2.uc_Mapped_US_FrameBearers_TPSTCs >> 5) == (TPS_TC_TYPE_ATM)))
   {
      us_TC_required = TPS_TC_TYPE_ATM;
   }
   else
   {
      us_TC_required = TPS_TC_TYPE_PTM;
   }

   // XDSLRTFW-3008 - EVT_TC_StatusGet
   // Send following autonomous message to DSL-API
   // TC information:
   // EVT_TC_StatusGet                 0x0E22
   // DSL_TC_STATUS                    DSL 14      DSL_14
   //
   // When the required TC is not loaded i.e, TC used is different, then an autonomous
   // message has to be sent(until required TC gets loaded).
   //
   // Reports the used TC-Mode.
   // Supported settings:
   //    0x1 EFM_TC EFM TC
   //    0x2 ATM_TC ATM TC
   if (gft_bonding_TC_autonomous_sent == FALSE)
   {
      // XDSLRTFW-3711 (Start)
      // The PPE clock frequency needs to be configured based on the profile selected, bonding capability and TC mode.
      // The PPE frequency which needs to be configured is indicated to the PPE driver by configuring the DREG register 0x7DCE (DREG_MISCRAM14_ADDR)
      // before sending out the autonomous message.
      Ppe_clockChange(us_TC_required, gt_ProfileAct.us_ProfileSelected);
      // XDSLRTFW-3711 (End)
      gt_Bonding_TC_Info.s_TC_Type = us_TC_required;
      gft_autonomous_msg_flag = TRUE;
   }
   if(UnpackedMsgLengthCheck(s_idx, gs_RxWholeMsgLength) == FALSE)
   {
      return(FALSE);
   }
   else
   {
      //Select the PMS parameters based the O-MSG1 and local settings
      if(SelectActualPmsParms() == FALSE)
      {
         EnterFailStates(E_CODE_FORM_PMS_FAIL);
      }

      return(TRUE);
   }
}

