/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 2016 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*******************************************************************************
;
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;   Functions for interpreting O-Update message
;
'
*******************************************************************************/
//******************************************************************************
// InterpOUpdateMsg_VDSL2.c
//
// History
//
// 27/11/2012 Ram: Merged IOP fix related to JIRA XDSLRTFW-458
//            XDSLRTFW-458:Loop Reach is limited with different ECI
//            DPBO shapes. This is because link failures at different phases.
//            a) 2nd pilot tone selection failure, because of conditions
//               imposed on pilot selection like limit for Pilot tone selection:
//               ADD_OFFSET_FROM_BANDEDGE, i.e. set the start tone index away
//               from the band edge by minimum of predefined value and 1/4 of
//               band size and minimum SNR required 15 dB
//            b) Timing Advance correction applied from O-Update message. If
//               total timing advance value is going above 300 then observed
//               OPTrain1 SNR is completely noisy (because of Echo) hence not
//               able to detect proper band for OPSYNCHRO4 detection.
//               Work around is to limit the Maximum value of Timing Advance
//               from CPE such that Echo effect will not be seen in DS band.
//                 Grep for: "XDSLRTFW-458: IOP_ALL_VDSL2_ALL_TACorrection"
//
// 06/05/2013 Varun: Added code(Debug option) to capture raw data of all Tx and
//                   Rx(O-Update in particular) training messages (G.Hs + training)
//                   Grep for "XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer"
//
// 27/11/2017 Stefan: Upstream performance dip on short loops (KPN)
//            - kl0 measurements with calibrated setup showed that our loop length estimation is
//              resulting in too high kl0 estimations
//            - add BRCM-like PSD boost on short loops (for UPBO and non-UPBO configurations)
//            Grep for XDSLRTFW-3212 : Upstream performance dip on short loops
//
//*****************************************************************************

#include <string.h>
#include "common.h"
#include "gdata.h"
#include "socmessage.h"
#include "ApplyBandLimit.h"
#include "ghs.h"
#include "TimingAdvanceHandler.h"
#include "cmv.h"
#include "DebugBuffer.h"


/*^^^
 *------------------------------------------------------------------------
 *
 *
 *  Description:  Interpret the received O-UPDATE message.
 *
 *  Prototype:
 *           int16 InterpOUpdateMsg_VDSL2(void);
 *
 *
 *  Input Arguments:
 *      None
 *
 *  Output Arguments:
 *      None
 *
 *   Return:
 *      TRUE if interpretation is ok, FALSE otherwise
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
int16 InterpOUpdateMsg_VDSL2(void)
{
   uint8 *puca_OctetBuffer;

   uint16 us_platform;
   int16 s_idx;
   int16 s_return;


   puca_OctetBuffer = gpuca_RxHDLCMsgBuf;
#ifdef DEBUG_TRACES
   // XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer(START_END)
   LogMessages(4,(uint16)gpuca_RxHDLCMsgBuf[0], (uint16)gs_RxWholeMsgLength, gpuca_RxHDLCMsgBuf, DEBUG_BUFFER_DELIMITER_VDSL2);
#endif // #ifdef DEBUG_TRACES
   memcpy(&gsa_DebugStreamBuffer[1][0],gpuca_RxHDLCMsgBuf,(uint16)gs_RxWholeMsgLength);
   DSH_SendStream(DSH_O_UPDATE, (uint16)gs_RxWholeMsgLength,(void *)&gsa_DebugStreamBuffer[1][0]);

   // Field1 - Message descriptor
   s_idx = 1;                          // gets be skipped!

   // Field2 final electrical length (2 bytes)
   gt_DecMsg_O_Update_VDSL2.s_FinalElecLen = puca_OctetBuffer[s_idx++]<<8;
   gt_DecMsg_O_Update_VDSL2.s_FinalElecLen |= puca_OctetBuffer[s_idx++];
   // The valid range of values is from 0 dB to 128 dB with a 0.1 dB step
   if (gt_DecMsg_O_Update_VDSL2.s_FinalElecLen < 0 ||
         gt_DecMsg_O_Update_VDSL2.s_FinalElecLen > 1280)
   {
      return(FALSE);
   }
   //XDSLRTFW-1521
   //For Avinax Platform = 13, cap of 1.8dB if the CO is sending below 1.8
   us_platform = (gus_fe_G994VendorSpecific >> 12) & 0x000F;
   if( (gul_fe_G994VendorID == IFX_VENDOR_ID) || (us_platform == AVINAX_PLATFORM) )
   {
      if (gt_DecMsg_O_Update_VDSL2.s_FinalElecLen < 18)
      {
         gt_DecMsg_O_Update_VDSL2.s_FinalElecLen = 18;
      }
   }
   gt_Kl0ElectricalLength.s_kl0_final = gt_DecMsg_O_Update_VDSL2.s_FinalElecLen;

   // XDSLRTFW-3212 : Upstream performance dip on short loops (Start)
   // Debug option to force the final kl0 setting
   // Option 1 (default): Disable forcing by setting gt_TxPsdControl.s_Force_kl0_final to "0"
   // Option 2:           Enable  forcing by setting gt_TxPsdControl.s_Force_kl0_final to the
   //                     desired kl0 (e.g. set to "84" to force a kl0 of 8.4dB
   if (gt_TxPsdControl.s_Force_kl0_final > 0)
      gt_Kl0ElectricalLength.s_kl0_final = gt_TxPsdControl.s_Force_kl0_final;

   // XDSLRTFW-3212 : Upstream performance dip on short loops
   // initialize US PSD boost array for Transceiver Training
   // Initialization for Transceiver Training is only a Debug option in case we would like
   // to force different US-PSDs for CD and TRTR.
   // FW settings will be overruled by gt_TxPsdControl.s_US_PSD_Boost_TRTR_0dB1
   //    if US0 setting for TrTr is not equal 0 (gt_TxPsdControl.s_US_PSD_Boost_TRTR_0dB1[0] != 0)
   if (gt_TxPsdControl.s_US_PSD_Boost_TRTR_0dB1[0] != 0)
   {
      gt_TxPsdControl.s_US_PSD_Boost_0dB1[0] = gt_TxPsdControl.s_US_PSD_Boost_TRTR_0dB1[0];    // US PSD boost for US0 [0.1dB] => 8 means 0.8dB
      gt_TxPsdControl.s_US_PSD_Boost_0dB1[1] = gt_TxPsdControl.s_US_PSD_Boost_TRTR_0dB1[1];    // US PSD boost for US1 [0.1dB] => 8 means 0.8dB
      gt_TxPsdControl.s_US_PSD_Boost_0dB1[2] = gt_TxPsdControl.s_US_PSD_Boost_TRTR_0dB1[2];    // US PSD boost for US2 [0.1dB] => 8 means 0.8dB
      gt_TxPsdControl.s_US_PSD_Boost_0dB1[3] = gt_TxPsdControl.s_US_PSD_Boost_TRTR_0dB1[3];    // US PSD boost for US3 [0.1dB] => 8 means 0.8dB
      gt_TxPsdControl.s_US_PSD_Boost_0dB1[4] = gt_TxPsdControl.s_US_PSD_Boost_TRTR_0dB1[4];    // US PSD boost for US4 [0.1dB] => 8 means 0.8dB
   }

   // Field3 proposed upstream PSD ceiling (2 bytes)
   gt_DecMsg_O_Update_VDSL2.s_Proposed_US_PSDCeiling = puca_OctetBuffer[s_idx++]<<8;
   gt_DecMsg_O_Update_VDSL2.s_Proposed_US_PSDCeiling |= puca_OctetBuffer[s_idx++];
   gt_PwrConfigParam.s_Up_ProposedPsdCeiling = gt_DecMsg_O_Update_VDSL2.s_Proposed_US_PSDCeiling;
   if (gt_PwrConfigParam.s_Up_ProposedPsdCeiling != 0x1000)
   {
      // Case where s_Proposed_US_PSDCeiling is a mask
      // and we want to determine s_Up_ProposedPsdCeiling as a template.
      // Take 3.5 dB off of Maximum s_Proposed_US_PSDCeiling to do this conversion.
      gt_PwrConfigParam.s_Up_ProposedPsdCeiling += 35;
   }

   // XDSLRTFW-3212 : Upstream performance dip on short loops (Start)
   // Debug option to force the US PSD ceiling
   // Option 1 (default): Disable forcing by setting gt_TxPsdControl.s_Force_US_PSD_Ceiling_TRTR_0dB1 to "0"
   // Option 2:           Enable  forcing by setting gt_TxPsdControl.s_Force_US_PSD_Ceiling_TRTR_0dB1 to the
   //                     desired kl0 (e.g. set to "84" to force a kl0 of 8.4dB
   if (gt_TxPsdControl.s_Force_US_PSD_Ceiling_TRTR_0dB1 > 0)
      gt_PwrConfigParam.s_Up_ProposedPsdCeiling = gt_TxPsdControl.s_Force_US_PSD_Ceiling_TRTR_0dB1;

   // Field4 highest allowed upstream tone (2 bytes)
   gt_DecMsg_O_Update_VDSL2.us_HighestAllowed_US_Tone = puca_OctetBuffer[s_idx++]<<8;
   gt_DecMsg_O_Update_VDSL2.us_HighestAllowed_US_Tone |= puca_OctetBuffer[s_idx++];

   // Field5 lowest allowed upstream tone (2 bytes)
   gt_DecMsg_O_Update_VDSL2.us_LowestAllowed_US_Tone = puca_OctetBuffer[s_idx++]<<8;
   gt_DecMsg_O_Update_VDSL2.us_LowestAllowed_US_Tone |= puca_OctetBuffer[s_idx++];

   if ((gul_fe_G994VendorID == IFX_VENDOR_ID) && (gt_DecMsg_O_Update_VDSL2.us_LowestAllowed_US_Tone < 24))
   {
      //Lowest allowed upstream tone is returned as 10 in O-Update message, change it to use tones lower than 10
      if (gt_DecMsg_O_Update_VDSL2.us_LowestAllowed_US_Tone > gsa_TxBandLeftChannelOSignature[0])
      {
         gt_DecMsg_O_Update_VDSL2.us_LowestAllowed_US_Tone = gsa_TxBandLeftChannelOSignature[0];
      }
   }

   // Field6 blackout carriers in upstream (Band descriptor)
   gs_NumOfUsBlackoutBands = puca_OctetBuffer[s_idx++];
   if (gs_NumOfUsBlackoutBands <= MAX_NUM_BLACKOUT_BANDS)
   {
      DecodeBands(&s_idx, gs_NumOfUsBlackoutBands, puca_OctetBuffer,
                  gsa_UsBlackoutBandLeftChannel, gsa_UsBlackoutBandRightChannel);

      //Set the flag to blackout the blackout carriers in SetTransmitGains()
      gus_VdslStatusFlag |= BITMAP_TX_APPLY_BLACKOUT;
   }
   else
   {
      return (FALSE);
   }

   // Field7 timing advance correction (2 bytes)
   // Note: Expressed in samples at the UPstream sampling rate corresponding to
   //       the IDFT size communicated during the ITU-T G.994.1 handshake phase.
   gt_DecMsg_O_Update_VDSL2.s_TimingAdvanceCorrection = puca_OctetBuffer[s_idx++]<<8;
   gt_DecMsg_O_Update_VDSL2.s_TimingAdvanceCorrection |= puca_OctetBuffer[s_idx++];
   if ((gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK) &&
       (gs_TxLog2IfftLength > US_LOG2_FFT_LENGTH_8192))                // US_LOG2_FFT_LENGTH_8192 = 13
   {
      // VR9/VR318: Upstream is always running with the small IFFT.
      // CO send the value dependent of the upstream IFFT size:
      //  ... shall be expressed either in multiples of 2 samples
      //      if profile 35b is used with extended IDFT Size, or otherwise,
      //      in samples at the upstream sampling rate corresponding to the
      //      IDFT size communicated during the ITU-T G.994.1 handshake phase.
      gt_DecMsg_O_Update_VDSL2.s_TimingAdvanceCorrection = (gt_DecMsg_O_Update_VDSL2.s_TimingAdvanceCorrection << 1);
   }


   //XDSLRTFW-458: IOP_ALL_VDSL2_ALL_TACorrection (start)
   if(gt_CustomerIopBits.us_ECI & ECI_DPBO_TACORRECTION)
   {
      int16 s_Cap_MaxTimeAdvance;

      s_Cap_MaxTimeAdvance = TIMING_ADVANCE_MAX_CAP;
      if(gs_MaxCapTAValue != 0)
      {
         s_Cap_MaxTimeAdvance = gs_MaxCapTAValue;
      }

      if((gs_TargetTimingAdvance + gt_DecMsg_O_Update_VDSL2.s_TimingAdvanceCorrection) > s_Cap_MaxTimeAdvance)
      {
         //gs_ForceTimingAdvanceCorrection = (TIMING_ADVANCE_MAX_CAP - gs_TargetTimingAdvance);
         gs_ForceTimingAdvanceCorrection = (s_Cap_MaxTimeAdvance - gs_TargetTimingAdvance);
      }

//   35b lite - check if something is needed here!
// Why the check for special value is needed?
      if (gs_ForceTimingAdvanceCorrection != 0x7fff)
      {
         gs_O_UpdateTAC_backup = gt_DecMsg_O_Update_VDSL2.s_TimingAdvanceCorrection;
         gt_DecMsg_O_Update_VDSL2.s_TimingAdvanceCorrection = gs_ForceTimingAdvanceCorrection;
      }
   }
   //XDSLRTFW-458: IOP_ALL_VDSL2_ALL_TACorrection (end)

   // Field 8: ITU-T G.998.4 parameter field
   // Field 9: ITU-T G.993.5 parameter field
   if ((s_idx + 2) <= gs_RxWholeMsgLength)
   {
      uint8 uc_Len;

      // skip field 8 (G.INP)
      uc_Len = puca_OctetBuffer[s_idx++];
      s_idx += uc_Len;

      if (s_idx < gs_RxWholeMsgLength)
      {
         // skip field 9 (G.vec)
         uc_Len = puca_OctetBuffer[s_idx++];
         s_idx += uc_Len;
      }

      if (s_idx > gs_RxWholeMsgLength)
      {
         // note that CO doesn't seem to comply to Amend5
         gul_SocMsgNotCompliedAmends |= AMEND5_NOT_COMPLIED_IN_OUpdate;
         goto EndOf_OUpdate_Interp;
      }
   }

   // XDSLRTFW-487_VR9_VRX318_VDSL2_All_AELEM_Support (START)
   // Field 10 - AELEM support
   if (s_idx < gs_RxWholeMsgLength)
   {
      guc_ELEUsBands = puca_OctetBuffer[s_idx++];

      if (guc_ELEUsBands)
      {
         unsigned int k;

         for(k = 0; k<guc_ELEUsBands; k++)
         {
            gt_AELEM_UPBOInfo.usa_Kl0EstimOPb[k] = puca_OctetBuffer[s_idx++]<<8;
            gt_AELEM_UPBOInfo.usa_Kl0EstimOPb[k] |= puca_OctetBuffer[s_idx++];
            // If the estimated value of kl0 is smaller than 1.8 dB, the VTU shall be allowed to perform power
            // back-off as if kl0 were equal to 1.8 dB
            if((int16)gt_AELEM_UPBOInfo.usa_Kl0EstimOPb[k] < 18)
            {
               gt_AELEM_UPBOInfo.usa_Kl0EstimOPb[k] = 18;
            }
         }
         // Clear not used bands
         for(k = guc_ELEUsBands; k < 4; k++)
         {
            gt_AELEM_UPBOInfo.usa_Kl0EstimOPb[k] = KL0_UNUSED_BAND;
         }
      }
   }
   // XDSLRTFW-487_VR9_VRX318_VDSL2_All_AELEM_Support (END)

EndOf_OUpdate_Interp:


   if(UnpackedMsgLengthCheck(s_idx, gs_RxWholeMsgLength) == FALSE)
   {
      return(FALSE);
   }

   if(gt_DecMsg_O_Update_VDSL2.us_LowestAllowed_US_Tone < gt_DecMsg_O_Update_VDSL2.us_HighestAllowed_US_Tone)
   {
      //Limit the TX band plan according to the lowest and highest allowed US tones.
      s_return = ApplyBandLimit(gt_DecMsg_O_Update_VDSL2.us_LowestAllowed_US_Tone,
                                gt_DecMsg_O_Update_VDSL2.us_HighestAllowed_US_Tone);
   }
   else

   {
      s_return = TRUE;
   }

   return(s_return);
}
