/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1432 USA
 * TELEPHONE:        (781) 276-4000
 * FAX:              (781) 276-4001
 * WEB:              http://www.aware.com
 *
 * FILE:             ModulateSocMessagesDiag.c
 * DESCRIPTION:      Encodes and decodes SOC Messages in diagnostic mode.
 *
 **********************************************************************/
#include "common.h"
#include "gdata.h"
#include "ghs.h"
#include "ModulateSocMessages.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : ModulateSocMsgForDiagMode
 *
 *  Description:  In the loop diagnostic mode, all SOC messages shall be sent using
 *  1 information bit per DMT symbol, where each bit is sent 5 times in 5 consecutive symbols.
 *  For the information bit value of 1, the value 11 shall be mapped to all the allowed tones
 *  using 4-QAM. For the information bit value of 0, the value 00 shall be mapped to all
 *  the allowed tones using 4-QAM.
 *
 *  This function takes the next bit to be sent and forms it in the proper format which
 *  is loaded to Iridia core register IT_PRBS_DATA for transmission.
 *
 *  Prototype:
 *      void ModulateSocMsgForDiagMode(void)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *  Return:
 *
 *  Global Variables Used:
 *
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void ModulateSocMsgForDiagMode(void)
{
   int16 s_bit;

   //Resent HDLC flag if no new SOC message is sent
   if((gs_NumOfTxSocBits == 0) && (gft_SocRepeatFlag == TRUE))
   {
      gs_NumOfTxSocBits = 8;
      gs_TxSocMsgBitPosition = 0;
      gs_NumOfTxSocBitRepeat = 0;
   }

   //Get the next bit to transmit
   if(gs_NumOfTxSocBits > 0)
   {
      //Since each bit is repeated for 5 symbol, so we only need to generate the PRBS data
      //for the first symbol
      if(gs_NumOfTxSocBitRepeat == 0)
      {
         s_bit = (gus_TxSocMsgBitBuf >> gs_TxSocMsgBitPosition) & 0x1;

         if(s_bit == 0)
         {
            gl_SocTxDataForPrbs = 0;
         }
         else //set the value to binary: 00001100110011001100
         {
            gl_SocTxDataForPrbs = 0x0CCCC;
         }
      }

      //Increase the repeat count
      gs_NumOfTxSocBitRepeat++;

      //Each bit has to be sent for 5 times
      if(gs_NumOfTxSocBitRepeat == gus_NumSymbolsPerBit)
      {
         //Decrease the bit count
         gs_NumOfTxSocBits--;

         //Update bit position
         gs_TxSocMsgBitPosition++;

         gs_NumOfTxSocBitRepeat = 0;
      }
   } //if(gs_NumOfTxSocBits > 0)
}
