/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   Name:   HDLC.c
*
*   VDSL HDLC messages handling code.
*
*-------------------------------------------------------------------------
*/

#include <stdio.h>
#include <string.h>

#include "typedef.h"
#include "gdata.h"


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : OctetTransparency
 *
 *  Description:  This function performs the octet transparency operation by
 *  inserting the HDLC control byte 0x7D in front of each 0x7E, and 0x7D
 *  and then xor 0x7E or 0x7D with 0x20.
 *
 *  Prototype:
 *      int16 OctetTransparency(uint8 *puca_InBuf, int16 s_NumOfInBytes, uint8 *puca_OutBuf)
 *
 *
 *  Input Arguments:
 *      puca_InBuf -- pointer to the input buffer containing the bytes to be processed
 *      s_NumOfInBytes -- number of bytes in the input buffer
 *
 *  Output Arguments:
 *      puca_OutBuf -- pointer to the output buffer containg the bytes after being processed
 *
 *   Return:
 *      the number of bytes in the output buffer
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
//Applying the HDLC octet transparency
int16 OctetTransparency(uint8 *puca_InBuf, int16 s_NumOfInBytes, uint8 *puca_OutBuf)
{
   int16 i, j;


   //==== Octet transparency ====
   j = 0;   //index of buffer output buffer

   for ( i = 0; i < s_NumOfInBytes; i++ )
   {

      switch (puca_InBuf[i])
      {

      case HDLC_FLAG:
      case 0x7D:
         puca_OutBuf[j++] = 0x7D;
         puca_OutBuf[j++] = puca_InBuf[i] ^ 0x20;
         break;

      default:
         puca_OutBuf[j++] = puca_InBuf[i];
         break;

      } // switch

   }

   //Return the total number of octets in the output buffer
   return(j);
}

