/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;   File Name: PackUnpackQlnHlog_VDSL2.c
;
;   The functions are used for pack or unpack QLN and Hlog in O-PRM-LD or R-PRM-LD message.
;
*****************************************************************************/
#include "common.h"
#include "gdata.h"
#include "GetQlnHlogForCarrierGroup.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *
 *  Description:  The function for packing QLN and Hlogs in O-PRM-LD or R-PRM-LD message
 *                used in the diagnostic mode.
 *
 *  Prototype:
 *           int16 PackQlnHlog_VDSL2(uint8 *puca_OctetBuffer, int16 *ps_idx)
 *
 *
 *  Input Arguments:
 *      puca_OctetBuffer -- pointer to the TX SOC message buffer
 *      ps_idx -- pointer to the current index of SOC message buffer
 *
 *  Output Arguments:
 *      ps_idx -- pointer to the updated index of SOC message buffer
 *
 *  Global Variables Used:
 *      guca_QLN -- (I) pointer to the buffer for storing QLN
 *      gsa_RxHlog -- (I) pointer to the buffer for storing Hlog
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

void PackQlnHlog_VDSL2(uint8 *puca_OctetBuffer, int16 *ps_idx)
{
   int16 j, s_idx;
   uint8 *puca_TxSocMsg;
   uint16 us_Hlog;

   s_idx = *ps_idx;

   //Pack QLN to the TX message buffer
   puca_TxSocMsg = &(puca_OctetBuffer[s_idx]);

   for(j=0; j<512; j++)
   {
      *puca_TxSocMsg++ = guca_QLN[j];
   }
   s_idx += 512;

   //Pack Hlog to the TX message buffer
   for(j=0; j<512; j++)
   {
      us_Hlog = gsa_RxHlog[j];
      *puca_TxSocMsg++ = (us_Hlog>>8);
      *puca_TxSocMsg++ = (uint8)(us_Hlog);
   }
   s_idx += 1024;

   *ps_idx = s_idx;
}

/*^^^
 *------------------------------------------------------------------------
 *
 *
 *  Description:  The function for unpacking QLN and Hlogs in O-PRM-LD or R-PRM-LD
 *                message used in the diagnostic mode.
 *
 *  Prototype:
 *           int16 UnpackQlnHlog_VDSL2(uint8 *puca_OctetBuffer, int16 *ps_idx)
 *
 *
 *  Input Arguments:
 *      puca_OctetBuffer -- pointer to the received SOC message buffer
 *      ps_idx -- pointer to the current index of SOC message buffer
 *
 *  Output Arguments:
 *      ps_idx -- pointer to the updated index of SOC message buffer
 *
 *  Global Variables Used:
 *      gpuca_QLNBuf_FE -- (O) pointer to the buffer for storing QLN
 *      gpusa_HlogBuf_FE -- (O) pointer to the buffer for storing Hlog
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

void UnpackQlnHlog_VDSL2(uint8 *puca_OctetBuffer, int16 *ps_idx)
{
   int16 j, s_idx;
   uint8 *puca_QLN, *puca_RxSocMsg;
   uint16 *pusa_Hlog, us_data;

   s_idx = *ps_idx;

   //Unpack QLN to the TX message buffer
   puca_RxSocMsg = &(puca_OctetBuffer[s_idx]);
   puca_QLN = &gt_FEParams.uc_Qln[0];     // XDSLRTFW-3606 (Start_End)

   for(j=0; j<512; j++)
   {
      *puca_QLN++ = *puca_RxSocMsg++;
   }
   s_idx += 512;

   //Pack Hlog to the TX message buffer
   puca_RxSocMsg = &(puca_OctetBuffer[s_idx]);
   pusa_Hlog = &gt_FEParams.us_Hlog[0];   // XDSLRTFW-3606 (Start_End)

   for(j=0; j<512; j++)
   {
      us_data = *puca_RxSocMsg++ << 8;
      us_data |= *puca_RxSocMsg++;
      *pusa_Hlog++ = us_data;
   }
   s_idx += 1024;

   *ps_idx = s_idx;
}

/*^^^
 *------------------------------------------------------------------------
 *
 *
 *  Description:  The function for unpacking QLN and Hlogs in O-PRM-LD or R-PRM-LD
 *                message used in the diagnostic mode.
 *
 *  Prototype:
 *           int16 UnpackQlnHlog_VDSL2(uint8 *puca_OctetBuffer, int16 *ps_idx)
 *
 *
 *  Input Arguments:
 *      puca_OctetBuffer -- pointer to the received SOC message buffer
 *      ps_idx -- pointer to the current index of SOC message buffer
 *
 *  Output Arguments:
 *      ps_idx -- pointer to the updated index of SOC message buffer
 *
 *  Global Variables Used:
 *      gpuca_QLNBuf_FE -- (O) pointer to the buffer for storing QLN
 *      gpusa_HlogBuf_FE -- (O) pointer to the buffer for storing Hlog
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void SaveChannelMeasureInfo(void)
{
   //----------------------------------------------------------
   //Store the near-end (NE) subcarrier group size (G)
   //----------------------------------------------------------

   //G for Qln
   gt_ChannelMeasurement_NE.us_QlnG = gs_CarrierGroupSizeRx_Disc;

   //G for Hlog
   gt_ChannelMeasurement_NE.us_HlogG = gs_CarrierGroupSizeRx_Disc;

   //G for Hlin
   gt_ChannelMeasurement_NE.us_HlinG = gs_CarrierGroupSizeRx_Medley;

   //G for Snr
   gt_ChannelMeasurement_NE.us_SnrG = gs_CarrierGroupSizeRx_Medley;

   //----------------------------------------------------------
   //Store the near-end (FE) subcarrier group size (G)
   //----------------------------------------------------------

   //G for Qln
   gt_ChannelMeasurement_FE.us_QlnG = gs_CarrierGroupSizeTx_Disc;

   //G for Hlog
   gt_ChannelMeasurement_FE.us_HlogG = gs_CarrierGroupSizeTx_Disc;

   //G for Hlin
   gt_ChannelMeasurement_FE.us_HlinG = gs_CarrierGroupSizeTx_Medley;

   //G for Snr
   gt_ChannelMeasurement_FE.us_SnrG = gs_CarrierGroupSizeTx_Medley;

}

