/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;   This function is used for forming the O-TPS message.
;
*****************************************************************************/
#include "common.h"
#include "gdata.h"
#include "socmessage.h"
#include "vdsl_xception.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *
 *  Description:  Find the actual PMS parameters supported by both CO and CPE.
 *
 *  Prototype:
 *           int16 SelectActualPmsParms(void);
 *
 *  Input Arguments:
 *      None
 *
 *  Output Arguments:
 *      None
 *
 *  Return:
 *      TRUE: the parameters are found; FALSE: the parameters are not found.
 *
 *  Global Variables Used:
 *      gt_DecMsg_R_Msg2_VDSL2 -- (I) the structure of the received R-MSG2 message (remote modem's capabilities)
 *      gt_DecMsg_O_Msg1_VDSL2 -- (I) the structure of the received O-MSG1 message (remote modem's capabilities)
 *      guc_DsDynamicInlvEnable -- (I) Indicator of local modem DS dynamic interlever capability
 *      guc_UsDynamicInlvEnable -- (I) Indicator of local modem US dynamic interlever capability
 *      guc_DsMinMsgOHR -- (I) local modem DS minimum overhead message rate
 *      guc_UsMinMsgOHR -- (I) local modem US minimum overhead message rate
 *      guc_DsOneOverSmax -- (I) local modem DS maximum 1/S
 *      guc_UsOneOverSmax -- (I) local modem US maximum 1/S
 *      gta_DsLatencyPath[] -- (I) the structure containing local modem DS latency path maximum rate
 *      gta_UsLatencyPath[] -- (I) the structure containing local modem US latency path maximum rate
 *
 *      guc_DsDynamicInlvEnableAct -- (O) Indicator of local modem DS dynamic interlever capability
 *      guc_UsDynamicInlvEnableAct -- (O) Indicator of local modem US dynamic interlever capability
 *      guc_DsMinMsgOHRAct -- (O) local modem DS minimum overhead message rate
 *      guc_UsMinMsgOHRAct -- (O) local modem US minimum overhead message rate
 *      guc_DsOneOverSmaxAct -- (O) local modem DS maximum 1/S
 *      guc_UsOneOverSmaxAct -- (O) local modem US maximum 1/S
 *      gta_DsLatencyPathAct[] -- (O) local modem DS latency path maximum rate
 *      gta_UsLatencyPathAct[] -- (O) local modem US latency path maximum rate
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */


int16 SelectActualPmsParms(void)
{
   DecMsg_O_Msg1_VDSL2_t *pt_RemoteModemPmsCap;

   int16 s_lp;
   uint16 us_rate;

   //=============================================================================
   //Decide the DS common PMS capabilities for LP0
   //=============================================================================
   pt_RemoteModemPmsCap = &gt_DecMsg_O_Msg1_VDSL2;

   // XDSRTFW-511: Feature_All_All_All_BRCM_Bitswap[Start_END]
   // If both CO and CPE support the dynamic interleaver, enable it, otherwise disable it
   // According to standard the selected mode shall fall back to "SRA" mode if one side supports "SRA and SOS" while the other supports "SRA" only
   if (((pt_RemoteModemPmsCap->uc_DsDynamicIlv & SRA_SUPPORTED_PER_AMENDMENT1) &&
         (guc_DsDynamicInlvEnable & SRA_SUPPORTED_PER_AMENDMENT1)) &&
      (pt_RemoteModemPmsCap->uc_RAMode == INFO2_RA_Mode_DYNAMIC || pt_RemoteModemPmsCap->uc_RAMode == INFO2_RA_Mode_SOS_DYNAMIC))   // XDSLRTFW-2903 (Start_End)
   {
      guc_DsDynamicInlvEnableAct = 1;
      gft_EnableRxAutoSRA = 1;        // RX SRA enabled if both NE and FE are capable.
   }
   else
   {
      guc_DsDynamicInlvEnableAct = 0;
   }

   if((pt_RemoteModemPmsCap->uc_UsDynamicIlv & SRA_SUPPORTED_PER_AMENDMENT1) && (guc_UsDynamicInlvEnable & SRA_SUPPORTED_PER_AMENDMENT1))
   {
      guc_UsDynamicInlvEnableAct = 1;
      gft_EnableTxSRA = 1;            // TX SRA enabled if both NE and FE are capable.
   }
   else
   {
      guc_UsDynamicInlvEnableAct = 0;
   }
// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [Start]

   //Populate US RA-Mode for the CPE
   if (gta_UsBearerChanAct[BC0].ta_TpsTcType.us_MinNetDataRate == gta_UsBearerChanAct[BC0].ta_TpsTcType.us_MaxNetDataRate)
   {
      gus_UsActRAMode = (uint16)(INFO2_RA_Mode_MANUAL);       // Fixed rate
      gft_EnableTxSRA = 0;
   }
   else
   {
      if (gft_EnableTxSRA)
      {
         gus_UsActRAMode = (uint16)(INFO2_RA_Mode_DYNAMIC);   // DYNAMIC, SRA no SOS
      }
      else
      {
         gus_UsActRAMode = (uint16)(INFO2_RA_Mode_AT_INIT);   // Min rate < Max rate; no SRA
      }
   }

// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [End]

   //Choose the minimum overhead rate to be the maximum of two min rates supported by CO and CPE
   guc_DsMinMsgOHRAct = MAX((pt_RemoteModemPmsCap->uc_DsOvhdRate), guc_DsMinMsgOHR);

   guc_UsMinMsgOHRAct = MAX((pt_RemoteModemPmsCap->uc_UsOvhdRate), guc_UsMinMsgOHR);

   for(s_lp=0; s_lp<NUM_DATA_PATHS; s_lp++)
   {
      //=================================
      //DS
      //=================================
      //Set the maximum R to the local modem's choice
      gta_DsLpAct[s_lp].s_MaxR = gta_DsLatencyPath[s_lp].s_MaxR;

      //Set the maximum D to the local modem's choice
      gta_DsLpAct[s_lp].s_MaxD = gta_DsLatencyPath[s_lp].s_MaxD;

      //Set the max. rate to the smallest one selected by local and remote modem
      //First convert the local modem rate from the unit of 4kbps to the unit of 8kbps
      //to match that of the message
      us_rate = gta_DsLatencyPath[s_lp].ul_MaxDataRate >> 1;
      gta_DsLpAct[s_lp].us_MaxDataRate = MIN(us_rate, (uint16)(pt_RemoteModemPmsCap->s_DsMaxDataRate[s_lp]));

      //=================================
      //US
      //=================================
      //Set the maximum R to the local modem's choice
      gta_UsLpAct[s_lp].s_MaxR = gta_UsLatencyPath[s_lp].s_MaxR;

      //Set the maximum D to the local modem's choice
      gta_UsLpAct[s_lp].s_MaxD = gta_UsLatencyPath[s_lp].s_MaxD;

      //Set the max. rate to the smallest one selected by local and remote modem
      //First convert the local modem rate from the unit of 4kbps to the unit of 8kbps
      //to match that of the message
      us_rate = gta_UsLatencyPath[s_lp].ul_MaxDataRate >> 1;
      gta_UsLpAct[s_lp].us_MaxDataRate = MIN(us_rate, (uint16)(pt_RemoteModemPmsCap->s_UsMaxDataRate[s_lp]));
   }

   //Choose the maximum 1/S to be the mininum one indicated by CO and CPE
   guc_DsOneOverSmaxAct = MIN((pt_RemoteModemPmsCap->uc_DS1byS), guc_DsOneOverSmax);

   guc_UsOneOverSmaxAct = MIN((pt_RemoteModemPmsCap->uc_US1byS), guc_UsOneOverSmax);

   return(TRUE);
}


