/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;   File Name: SocMsgsInit.c
;
;   Functions to initializa variables used by SOC message functions
;
'
*****************************************************************************/

#include "common.h"
#include "gdata.h"
#include "cmv.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : InitSocMsgs
 *
 *  Description:  Initialize the variables used by the messaging functions.
 *
 *  Prototype:  void InitSocMsgs(void)
 *
 *  Input Arguments:
 *      NONE
 *
 *  Output Arguments:
 *      NONE
 *
 *  Return:
 *
 *  Global Variables Used:
 *      guc_TxHDLCMsgIndex       - (O) TX message index
 *      gs_UpdateTxMsgIdxFlag   - (O) TX message index update flag
 *      gs_MsgReceiveFlag      - (O) Message receiving flag
 *      guc_ExpectedMsgIdx      - (O) Expected received message index
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

void InitSocMsgs(void)
{
   //Initialized the TX/RX HDSL message buffer pointer
   gpuca_TxSocMsg = (uint8 *)(void *)gpsa_CommonMemoryBlock0;

   //In VDSL2 CPE, transmitting and receiving SOC message does not happen at the same time
   //so we can use the same message buffer for TX and RX
   gpuca_RxHDLCMsgBuf = gpuca_TxSocMsg;

   //Initialize TX message index
   guc_TxHDLCMsgIndex = 1;

   //set this flag so message index will not be increased initially
   gs_UpdateTxMsgIdxFlag = FALSE;

   //set to FALSE to indicate no message is received yet
   gs_MsgReceiveFlag = FALSE;

   //set to 0 to indicate the message index doesn't matter
   guc_ExpectedMsgIdx = 0;

   //Reset this flag to indicate no message error
   gs_RxMsgErrorCode = 0;

   //Set the number of times to retransmit O-UPDATE message count to 0
   gs_NumRxRepeatRequest = 0;

   //index n of O-CONTACTn
   gs_OContractIdx = 0;

   //Set jmax for B&G
   guc_jmax = JMAX;

   //------------------------------------------------------------------------
   //Used in loop diagnostic mode
   //------------------------------------------------------------------------
   gs_NumOfTxSocBits = 0;
   gus_TxSocMsgBitBuf = 0;
   gs_TxSocMsgBitPosition = 0;
   gs_NumOfTxSocBitRepeat = 0;
   gft_SocRepeatFlag = FALSE;
   gft_RunTxStateFuncFlag = FALSE;
   gft_RxSocMsgDemodFlag = DISABLE_LD_DEMOD_SOC_MSG;
   gft_TxSocMsgModFlag = FALSE;
   gft_DisableTxDiagModulation = FALSE;
}
