/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   fcs.c
*
*   Function for computing CRCs
*
*-------------------------------------------------------------------------
*/
#include "typedef.h"
#include "fcs.h"
#include "gdata.h"

/**
    calcCrc16 does a byte(octet)-wise CRC calculation for
    an initial CRC and the generator polynomial of 0x8408.

    @note calcCrc16 has been optimized for maximum speed, therefore
    it uses a hard-coded generator polynom. There is no looping involved
    as in other implementations where the generator polynom is selectable
    as a run-time parameter.
    An even faster code can be made available when a 256byte
    look-up table is used.

    @param      c octet to be processed
    @param      crc current CRC16

    @return     updated CRC16 for the input octet
*/
uint16 calcCrc16(uint16 crc, uint8 c)
{
   // CCITT 16 bit (X^16 + X^12 + X^5 + x^0).
   crc ^= c;
   crc ^= ((crc & 0x000f) << 4);
   crc  = (uint16) (((crc >> 8) & 0x00ff) | (crc << 8));
   crc ^= (crc >> 12);
   crc ^= ((crc & 0xff00) >> 5);
   return (crc);
}
/*
 *------------------------------------------------------------------------
 *
 *  Name: CalcCRC_Byte
 *
 *  Description:
 *      CalcCRC_Byte() - Byte(Octet)-wise CRC calculation for an initial CRC
 *      and a given generator polynomial.
 *
 *  Input Arguments:
 *      uc_Octet   -  Octet to be processed
 *      us_CRC     -  current CRC
 *      us_GenPoly -  generator polynomial
 *
 *  Returns:
 *      Updated CRC for the input octet
 *
 *  Global Variables Used:
 *
 *------------------------------------------------------------------------
 */
uint16 CalcCRC_Byte( uint8 uc_Octet, uint16 us_CRC, uint16 us_GenPoly )
{

   int16 j;
   uint16 us_InfoBit;
   uint16 us_CRClsb;
   uint16 us_C;

   for ( j = 0; j < 8; j++ )
   {

      us_CRClsb = us_CRC & FCS_LSB_MASK;
      us_CRC >>= 1;
      us_InfoBit = ( (int16) uc_Octet ) & FCS_LSB_MASK;
      uc_Octet >>= 1;

      us_C = us_CRClsb ^ us_InfoBit;
      if (us_C != 0)
      {
         us_CRC ^= us_GenPoly;
      }

   }   /*  for j */

   return (us_CRC);

}




/*  CalcCRC_Byte */

