/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   DiagDoneStateFunc_VDSL2Diag.c
*
*   This file contains the state function to handle the diagnotic complete
*   state operation.
*
*-------------------------------------------------------------------------
*/

#include "gdata.h"
#include "vdsl_state.h"
#include "cmv_Data.h"
#include "cmv.h"
#include "vdsl_xception.h"

/* =============================================== */
/* substates                              */
/* =============================================== */
#define DIAG_DONE_INIT         (0)
#define DIAG_DONE_EXIT         (1)

int16 gs_DiagDoneStateLength = -1;
int16 gs_DiagDoneExceptionCode = 533;

void DiagDoneStateFunc(void)
{
   switch(gs_TxSubState)
   {
   case DIAG_DONE_INIT:

      //If both TX and RX enter DONE state,
      //enter the state to perform the soft reset
      if((gs_TxState == VDSL2_R_DIAG_DONE_TX) && (gs_RxState == VDSL2_R_O_DIAG_DONE_RX))

      {
         //set the modem status to complete
         gsa_IndirectStat0[0] = STAT_DiagModeComplete;
         gusa_MONI_ModemStat_Status[0] = MONI_STAT_DIAG_COMPLETE;

         gs_TxSubStateCnt = 0;
         gs_TxSubState = DIAG_DONE_EXIT;

         // On CPE, if autorestart is enabled and LDM is initiated by CO, perform a soft-reset after DIAG_COMPLETE
         if (((gs_MONI_AutoRestart & MONI_RESTART_AT_FAIL) == 1) &&
               ((gs_MONI_AutoRestart & MONI_EnableDiagMode) == 0))
         {
            gs_DiagDoneStateLength = 10;
         }
         else
         {
            gs_DiagDoneStateLength = -1;
         }

      }

      break;

   case DIAG_DONE_EXIT:
      if(gs_DiagDoneStateLength >= 0)
      {
         if(gs_TxSubStateCnt == gs_DiagDoneStateLength)
         {

            //Enter the state to perform the soft reset
            EnterFailStates(E_CODE_MODEM_RESET);
            gft_IssueSoftReset = 1;
            //EnterFailStates(gs_DiagDoneExceptionCode);
         }

         gs_TxSubStateCnt++;
      }

      break;
   } //switch

}




