/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   InitTrainState.c
*
*   This file contains functions to initialize the CPE training state
*
*-------------------------------------------------------------------------
*/
// ***********************************************************************************************************
// InitTrainState.c
//
// History
//
// 13/01/2015 Fuss: Glitch at the CPE side maybe happening when CPE is configuring the US-path
//            Grep for XDSLRTFW-2155
// ************************************************************************************************************

#include "common.h"
#include "gdata.h"
#include "fifo.h"
#include "IRI_Iof.h"
#include "V_STR_IOf.h"
#include "DSLEngin.h"

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void InitTrainTxF(void)
*
*   This function initialize HW at the beginning of the initialization state for TX direction.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void InitTrainTxF(void)
{
   gft_UpdateVRegShadowFifo = TRUE;

   InsertTxCE();
   InsertRxCE();

   // Clear Tx Variable gain since according to the standard, the RT should send silence
   // until O-SIGNATURE is correctly received.
   gs_TxVarGain = 0;
   gs_TxVarGainExp = 0;
   SetTxVarGain();

   // XDSLRTFW-2155 (START_END)
   // Switch off the Tx signal by enabling the REF_Gain and setting it's value to zero. In this way,
   // the frequency domain data in BUFFDD is all zeros and matches with the signal on the line which is also zero.
   gus_RefGain = 0x0 ;                 // 0x2000 = Unity Gain in 2.13 format, 0 = Zero Gain
   gft_IT_MISC_RefGainEna = TRUE;
   IridiaTxGainScaleDataPathControl();

   //Disable direct copy
   DisableDCI();
   gft_UpdateVRegShadowFifo = FALSE;
}


/*
*-------------------------------------------------------------------------------
*
*   Prototype: void InitTrainRxF(void)
*
*   This function initialize HW at the beginning of the initialization state for RX direction.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void InitTrainRxF(void)
{
   // Enable Rx PRBS Descrambling
   EnableRxDescrambling();

}
