/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   MedleyMsgCheckRxTimer.c
*
*   This file contains the function to check the RX timer in the Medley state.
*
*-------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"
#include "states.h"
#include "fifo.h"
#include "vdsl_state.h"
#include "OTrainingTxF.h"
#include "RTrainingTxF.h"
#include "vdsl_xception.h"


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : MedleyMsgCheckRxTimer
 *
 *  Prototype:  void MedleyMsgCheckRxTimer(void)
 *
 *   This functions checks if the RX timer has expired or if the TX message should be repeated again.
 *  This function is shared by all the RX message states during the Medley phase message exchange.
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *      gul_RxTimer -- (I) the RX timer
 *      gs_NumTxRepeatRequest -- (I/O) the number of Repeat Request message has been sent so far
 *      gs_TxNextState -- (O) next TX state
 *      gpF_TxStateFunc -- (O) next TX state function
 *      gl_TxSymbolCount -- (O) next TX symbol count
 *      gs_TxSubState -- (O) next TX substate
 *      gs_TxSubStateCnt -- (O) next TX substate count
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void MedleyMsgCheckRxTimer(void)
{

   if((gul_RxTimer != 0xFFFFFFFF) && (gul_RxTimer >= TIMEOUT_CNT_TWO_SECONDS))
   {
      //Send the repeat request if the number of repeat-request sent so far
      //has not exceeded the pre-defined limit
      if(gs_NumTxRepeatRequest < NUM_TX_REPEAT_REQUEST)
      {
         gs_NumTxRepeatRequest++;

         //go to the next TX state to send REPEAT_REQUEST

         gs_TxNextState = VDSL2_R_REPEAT_REQUEST_TX;

         if (gs_TxState == VDSL2_R_PMD_TX)
            // Anal5 page and show 1 pages loaded in, use the wrapper function here
         {
            gpF_TxStateFunc = (PtrToFunc)RMedleyMsg2TxF_VDSL2;
         }
         else
         {
            gpF_TxStateFunc = (PtrToFunc)RMedleyMsgTxF_VDSL2;
         }

         // In the case of gs_TxNextState = gs_TxState, we need to do the following reset here

      }
      else //Check timeout
      {
         //go to fail state
         CheckTimeout(gul_RxTimer, (TIMEOUT_CNT_RX_MEDLEY<<gs_frame_rate_is_8khz), E_CODE_RX_MEDLEY_MSG_TIMEOUT);
      }
   }
}
