/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 2015, 2016: Lantiq Beteiligungs-GmbH & Co. KG
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*******************************************************************************
*******************************************************************************
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   MedleyTrainingRxF.c
*
*   This file contains RX Medley training function used by both CO and CPE
*
*-------------------------------------------------------------------------
*/
// ***********************************************************************************************************
// gdata.c
//
// History
//
// 19/09/2013 Fuss: Addded if-case to skip FrameAlignment
//            Grep for XDSLRTFW-1181: BugFix_DS_VDSL2_All_VecDSRateRunToRunVariation
// 19/02/2015 Fuss: XDSLRTFW-2112 - Fix for NMS (Noise Margin Separation), i.e. Fix for AGC1_PRG_ROUT2,
//                                  Config NMS algorithm and clean-up.
//            Grep for XDSLRTFW-2112
// 19/02/2015 Fuss: XDSLRTFW-2269 : CLONE - NMS is not working in case gs_MedleyFrameSynchEnableFlag = FALSE
//            Grep for XDSLRTFW-2269
// ************************************************************************************************************

#include <string.h>
#include "common.h"
#include "gdata.h"     // contains: #include "afe.h" , "socmessage.h"
#include "states.h"
#include "fifo.h"
#include "vdsl_state.h"
#include "FdqHandler.h"
#include "SnrHandler.h"
#include "BitloadHandler.h"
#include "SnrFrameAlignHandler.h"
#include "SharedFuncs.h"
#include "Bitload.h"
#include "codeswap.h"
#include "MfdqHandler.h"
#include "ToneReorder.h"
#include "vdsl_xception.h"
#include "MfdqAdjust.h"
#include "IRI_IOf_mfdq.h"
#include "mul.h"
#include "ghs.h"
#include "HlinHandler.h"
#include "IRI_Iof.h"
#include "cmv.h"

#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"


uint16 gus_MedleyStateLog = 0;

#define MedleyStateLogFrameAlignment                   0x0001  // 0 = MedleyStateLogFrameAlignmentNo
#define MedleyStateLogFrameAlignmentSkip1StFDQ         0x0002
#define MedleyStateLogFrameAlignmentNoFinalFDQ         0x0004  // 0 = MedleyStateLogFrameAlignmentNoFinalFDQNo
#define MedleyStateLogFrameAlignmentNoFinalSNR         0x0008
#define MedleyStateLogFrameAlignmentFinalFDQ           0x0010  // 0 = MedleyStateLogFrameAlignmentFinalFDQNo
#define MedleyStateLogFrameAlignmentFinalSNR           0x0020  // 0 = MedleyStateLogFrameAlignmentFinalSNRNo
#define MedleyStateLogNoiseMarginFinalFDQ              0x0040
#define MedleyStateLogNoiseMarginPll                   0x0080
#define MedleyStateLogFdqFinal                         0x0100
#define MedleyStateLogSnrFinal                         0x0200

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : MedleyTrainRxF
 *
 *  This is the state machine function which performs IR estimation, TDQ training,
 *  frame alignment, FDQ training, and SNR calculation and Bitloading in the Medley state.
 *   This function is shared by both CO and CPE.
 *
 *  Prototype:  void MedleyTrainRxF(void)
 *
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *      gs_RxSubState -- (I/O) substate number
 *      gsa_SnrBuf[] -- (O) Medley SNR buffer
 *      gpsa_MeasuredSnrBuf -- (I/O) pointer to SNR buffer
 *      gs_AlgHandlerState -- (I/O) the substate number of algorithm handler
 *      gs_RxBkgdProcessFlag -- (I/O) flag to indicate if the background process is finished or not
 *      gs_RxProcessFlag -- (O) flag to indicate if this process is done or not
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
#define MEDLEY_TRAIN_RX_INITIALIZE                    (0)
//#define MEDLEY_TRAIN_RX_CODESWAP_WAIT               (1)
#define MEDLEY_TRAIN_RX_TRAIN_FIRST_FDQ               (2)
#define MEDLEY_TRAIN_RX_FRAME_ALIGNMENT               (3)
#define MEDLEY_TRAIN_RX_TRAIN_FINAL_FDQ               (4)
#define MEDLEY_TRAIN_RX_SNR_CALC_BEFORE_MFDQ          (5)
#define MEDLEY_TRAIN_RX_TRAIN_MFDQ                    (6)
#define MEDLEY_TRAIN_RX_CALCULATE_FINAL_SNR           (7)
#define MEDLEY_TRAIN_RX_WAIT_FOR_CODESWAP_BITLOAD     (8)
#define MEDLEY_TRAIN_RX_CALC_HLIN                     (9)
#define MEDLEY_TRAIN_RX_BITLOAD                      (10)
#define MEDLEY_TRAIN_RX_WAIT_FOR_CODESWAP_TRAINMAIN  (11)
#define MEDLEY_TRAIN_RX_SELECT_MSG_TONES             (12)
#define MEDLEY_TRAIN_RX_DONE                         (13)

#define MEDLEY_TRAIN_RX_MFDQ_CODESWAP                (23)
#define MEDLEY_TRAIN_RX_MFDQ_CODESWAP_WAIT           (24)

#define MEDLEY_TRAIN_RX_COMPUTE_NOISE_MARGIN         (25)
#define MEDLEY_TRAIN_RX_NOISE_MARGIN_PGA_WAIT        (26)
#define MEDLEY_TRAIN_RX_NOISE_MARGIN_PLL_RELOCK      (27)
#define MEDLEY_TRAIN_RX_NOISE_MARGIN_PLL_WAIT        (28)


void MedleyTrainRxF(void)
{
   int16 i;
   int32 l_temp;

//#ifdef MTK_VECTORING_SUPPORT
   int16 s_temp;
//#endif


   switch (gs_RxSubState)
   {

   case MEDLEY_TRAIN_RX_INITIALIZE:

      gs_RxProcessFlag = TRAINING_IN_PROGRESS;

      gus_MedleyStateLog = 0;

      // Do not initiate the codeswap until the TX side
      // enters Medley state since some functions (such as RPSynchro5TxF_VDSL2())
      // in the page TRAIN_3_V2 is still been used.
      if(gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG)
      {
         if(gs_TxState != VDSL2_R_P_MEDLEY_TX)
         {
            break;
         }
      }

      // XDSLRTFW-2393 : Added fix for margin verification test fail
      //                 NMS Lower threshold based on DS Ceiling.
// Todo XDSLRTFW-4216: This if-case must be checked, because the gs_ceil_adequate variable is
//                     populated different to VR9, i.e. fct. + logic was changed!
      if( (gs_ceil_adequate == gt_PwrConfigParam.s_Dn_MaxNomPSD) ||
          (gs_ceil_adequate == 0x1000) ||
          (gs_ceil_adequate < (gt_PwrConfigParam.s_Dn_InitialPsdCeiling + 10)) )
      {
         gt_NoiseMarginChange.s_min_Used_NMS_Gain = gt_NoiseMarginChange.s_min_NMS_Gain_ToBe_considered;
      }

      // XDSLRTFW-954 - Noise Margin Separation to Improve DS performance (START)
      // XDSLRTFW-2112 (Start_End)
      guc_NMS_AlgHandler = NOISE_MARGIN_SEP_DISABLED;
      if (gt_NoiseMarginChange.s_NM_Ctrl & OPTN_NoiseMarginChange_NM_Ctrl_NMS_EN)
      {
         gs_MedleyFrameSynchEnableFlag &= (~EN_MEDLEY_SKIP_FINAL_FDQSNR);
         // No NMS for 30M profiles, due to memory limitations!
         if (gs_frame_rate_is_8khz == 0)
         {
            guc_NMS_AlgHandler = CALCULATE_SNR_3DB_AGC_GAIN;
//            memset(guca_NMS, 0, RX_MAX_NUM_TONES);
         }
      }
      // XDSLRTFW-954 - Noise Margin Separation to Improve DS performance (END)

      // restore algorithm training lengths
      gt_FdqConfig.s_AlgLog2NumFramesToAccum = LOG2_NUM_FDQ_TRAINING_SYMBOLS;
      gt_SnrConfig.s_AlgLog2NumFramesToAccum = LOG2_NUM_SNR_TRAINING_SYMBOLS;
      gt_PsdConfig.s_AlgLog2NumFramesToAccum = LOG2_NUM_PSD_TRAINING_SYMBOLS;

      // Store the near-end (NE) SNR measurement time
      gt_ChannelMeasurement_NE.us_SnrMT = (1<<gt_SnrConfig.s_AlgLog2NumFramesToAccum);

      // Set this flag to TRUE to indicate the Medley state starts
      // Note: Indication for FdqHandler() only!
      gs_RxMedleyStateFlag = TRUE;

      // Don't enable one-pass Medley FDQ for diagmode.
      if ((gus_VdslCntlFlag & BITMAP_ENABLE_ONEPASS_MEDLEY_FDQ) &&
            ((gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG) == 0))
      {
         gs_FDQTrainTypeCntrlFlag = FDQ_TRAIN_TYPE_MEDLEY_ONEPASS;
      }

      /* intentional fall through */
      /* no break                 */

   case MEDLEY_TRAIN_RX_MFDQ_CODESWAP:
      // request MFDQ swap page
      FreeSwapHandle(&guc_PrimPageHandle);

      guc_RxSwapActivity = CODESWAP_LOAD(VDSL_ALGHD_3_V2_PM_SWAPPAGE);

      gs_RxSubState = MEDLEY_TRAIN_RX_MFDQ_CODESWAP_WAIT;

      break;


   case MEDLEY_TRAIN_RX_MFDQ_CODESWAP_WAIT:
      if (guc_RxSwapActivity == CODESWAP_DO_NOTHING)
      {
         // Perform SNR based RX frame realignment
         // XDSLRTFW-2269 (Start_End)
         if (gs_MedleyFrameSynchEnableFlag & EN_MEDLEY_SNR_FRAMEALIGNMENT)
         {
            gus_MedleyStateLog = MedleyStateLogFrameAlignment;

            // Train first set of Medley FDQ
            gs_AlgHandlerState = FDQ_TRAIN_INIT;
            if (gs_MedleyFrameSynchEnableFlag & EN_MEDLEY_SKIP_FIRST_FDQ)
            {
               gs_AlgHandlerState = FDQ_TRAIN_DONE;
               gus_MedleyStateLog |= MedleyStateLogFrameAlignmentSkip1StFDQ;
            }
            gs_RxSubState = MEDLEY_TRAIN_RX_TRAIN_FIRST_FDQ;

#ifdef ANXQ_35BLITE_PAUSE_DEBUG
            // Before FDQ Handler in MedleyTraining
            if (gs_PauseControl == 0x401)
            {
               gft_PauseOff = 0;
               Pause(gs_PauseControl);
            }
#endif // ANXQ_35BLITE_PAUSE_DEBUG
         }
         else
         {
            // Skipped SNR based RX frame realignment
            if (guc_NMS_AlgHandler == NOISE_MARGIN_SEP_DISABLED)
            {
               if ((gs_MedleyFrameSynchEnableFlag & EN_MEDLEY_SKIP_FINAL_FDQSNR) &&
                   (gs_MedleyFrameSynchEnableFlag & (EN_TTRAINING_FDQ_END|EN_TTRAINING_FDQ_AFTER_PERIODIC)))
               {
                  gus_MedleyStateLog |= MedleyStateLogFrameAlignmentNoFinalSNR;
                  // Directly go to final SNR training state, i.e. skipped FDQ because it was done
                  // at the end of TrancseiverTraining. But SNR calculation is needed, because
                  // SnrFrameAlignment gets be skipped.
                  gpsa_MeasuredSnrBuf = gsa_SnrBuf;
                  gs_AlgHandlerState = SNR_INIT;
                  gs_RxSubState = MEDLEY_TRAIN_RX_CALCULATE_FINAL_SNR;

               }
               else
               {
                  // Directly go to final FDQ/SNR training
                  gus_MedleyStateLog |= MedleyStateLogFrameAlignmentNoFinalFDQ;
                  gs_AlgHandlerState = FDQ_TRAIN_INIT;
                  gs_RxSubState = MEDLEY_TRAIN_RX_TRAIN_FINAL_FDQ;
               }
            }
            else
            {
               gs_RxSubState = MEDLEY_TRAIN_RX_COMPUTE_NOISE_MARGIN;
               gft_EnablePLL = FALSE;                                 // turn off PLL
            }
#ifdef LOG_FA_DEBUG_INFO
            gs_CumulativeAlignmentOffset_Medley = 0;
#endif // LOG_FA_DEBUG_INFO
         }
      }
      break;


   case MEDLEY_TRAIN_RX_TRAIN_FIRST_FDQ:
      if (gs_AlgHandlerState != FDQ_TRAIN_DONE)
      {
         FdqHandler();
      }
      else
      {
#ifdef ANXQ_35BLITE_PAUSE_DEBUG
         // After FDQ Handler and before SnrFrameAlignHandler in MedleyTraining
         if (gs_PauseControl == 0x402)
         {
            gft_PauseOff = 0;
            Pause(gs_PauseControl);
         }
#endif // ANXQ_35BLITE_PAUSE_DEBUG

         gt_SnrFrameAlignConfig.s_AlgHandlerState = SNR_BASED_FRAME_ALIGN_INIT;
         gs_RxSubState = MEDLEY_TRAIN_RX_FRAME_ALIGNMENT;
      }
      break;

   case MEDLEY_TRAIN_RX_FRAME_ALIGNMENT:

      if(gt_SnrFrameAlignConfig.s_AlgHandlerState != SNR_BASED_FRAME_ALIGN_DONE)
      {
         SnrFrameAlignHandler();
      }
      else
      {
#ifdef LOG_FA_DEBUG_INFO
         // save frame alignment debug info
         MULS16(l_temp, gs_BestSynchPointIdx, gt_SnrFrameAlignConfig.s_MedleyAlignOffsetStep);
         gs_CumulativeAlignmentOffset_Medley = (int16)l_temp - gs_MaxMedleyAlignOffset;
#endif // LOG_FA_DEBUG_INFO

         // XDSLRTFW-2269 (Start_End)
         if (guc_NMS_AlgHandler == NOISE_MARGIN_SEP_DISABLED)
         {
            if (gs_MedleyFrameSynchEnableFlag & EN_MEDLEY_SKIP_FINAL_FDQSNR)
            {
               // Directly go to final SNR training state, but skip the SNR measurement.
               gs_AlgHandlerState = SNR_CALC_DONE;
               if (gs_MedleyFrameSynchEnableFlag & EN_MEDLEY_FINAL_SNR)
               {
                  gus_MedleyStateLog |= MedleyStateLogFrameAlignmentFinalSNR;
                  gs_AlgHandlerState = SNR_INIT;
                  gpsa_MeasuredSnrBuf = gsa_SnrBuf;
               }
               gs_RxSubState = MEDLEY_TRAIN_RX_CALCULATE_FINAL_SNR;
            }
            else
            {
               gus_MedleyStateLog |= MedleyStateLogFrameAlignmentFinalFDQ;

               // Directly go to final FDQ/SNR training
               gs_AlgHandlerState = FDQ_TRAIN_INIT;
               gs_RxSubState = MEDLEY_TRAIN_RX_TRAIN_FINAL_FDQ;
            }
         }
         else
         {
            gs_RxSubState = MEDLEY_TRAIN_RX_COMPUTE_NOISE_MARGIN;
            gft_EnablePLL = FALSE;                                 // turn off PLL
         }
      }
      break;

      // XDSLRTFW-954 - Noise Margin Separation to Improve DS performance (START)
      // XDSLRTFW-2112 / XDSLRTFW-2269 (Start_End)
      // Measure Medley SNR with 3dB higher AGC gains
      // Measure Medley SNR with default AGC settings
      // NMS per tone (in dB) = (Medley-SNR with 3dB higher gain)  (default Medley-SNR)
   case MEDLEY_TRAIN_RX_COMPUTE_NOISE_MARGIN:

      // Set AGC1 gain to "actual+3dB" or "actual+XdB" and back to "actual"
      if (gt_NoiseMarginChange.s_NM_Ctrl & OPTN_NoiseMarginChange_NM_Ctrl_NMS_HW_EN)
      {
         // Note: The check is needed, because the state gets be executed multiple times!
         if (guc_NMS_AlgHandler == CALCULATE_SNR_3DB_AGC_GAIN)
         {
            // Save values for default SNR measurement after NMS run with AGC1 gain to "actual+3dB"
            // XDSLRTFW-3280 - Start - PLL improvement / pilot tone selection improvement
            gsa_NMS_ResetPllRefToneInput_Re_Save[0] = (gt_PilotConfig.ta_PilotTones[0].s_PllRefTone_Re / gt_PilotConfig.ta_PilotTones[0].s_PilotToneScale);
            gsa_NMS_ResetPllRefToneInput_Im_Save[0] = (gt_PilotConfig.ta_PilotTones[0].s_PllRefTone_Im / gt_PilotConfig.ta_PilotTones[0].s_PilotToneScale);
            gsa_NMS_ResetPllRefToneInput_Re_Save[1] = (gt_PilotConfig.ta_PilotTones[1].s_PllRefTone_Re / gt_PilotConfig.ta_PilotTones[1].s_PilotToneScale);
            gsa_NMS_ResetPllRefToneInput_Im_Save[1] = (gt_PilotConfig.ta_PilotTones[1].s_PllRefTone_Im / gt_PilotConfig.ta_PilotTones[1].s_PilotToneScale);
            gsa_NMS_ResetPllRefToneInput_Re_Save[2] = (gt_PilotConfig.ta_PilotTones[2].s_PllRefTone_Re / gt_PilotConfig.ta_PilotTones[2].s_PilotToneScale);
            gsa_NMS_ResetPllRefToneInput_Im_Save[2] = (gt_PilotConfig.ta_PilotTones[2].s_PllRefTone_Im / gt_PilotConfig.ta_PilotTones[2].s_PilotToneScale);


            // XDSLRTFW-3280 - End - PLL improvement / pilot tone selection improvement
            gs_NMS_AGC1_Gain_Save = (gs_AGC1_Gain_Set << 8);  // 8.8 format

            // XDSLRTFW-4216 :CTL, VDSL: Downstream low perf in mid range loops from 2000ft to 3000ft (NMS) (Start)
            // changes below are generic for NMS
            gs_PGA_required =  (gs_AGC1_Gain_Set << 8);   // 8.8 format

            // Measure Medley SNR with xdB higher AGC gain i.e. default value of gt_NoiseMarginChange.s_max_Used_NMS_Gain = 0x300, i.e. 3dB.
            // Note: gs_PGA_required is input for AFED_BgSetNmsPGAMedley().
            gs_PGA_required += gt_NoiseMarginChange.s_max_Used_NMS_Gain;
            // XDSLRTFW-4216 :CTL, VDSL: Downstream low perf in mid range loops from 2000ft to 3000ft (NMS) (End)
         }

         if(gs_PauseControl == 0x69)
            Pause(gs_PauseControl);
         guc_PgaState = TRAINING_IN_PROGRESS;
         // Todo XDSLRTFW-4216:  It must be checked, if the full xdB could be used in HW and that
         //                         gt_NoiseMarginChange.s_max_Used_NMS_Gain reflect the real applied AGC1_Gain.
         AddFunctionToBkgdFifo((PtrToBkgdFunc)AFED_BgSetNmsPGAMedley);

         gs_RxSubStateCnt = 0;
         gs_RxSubState = MEDLEY_TRAIN_RX_NOISE_MARGIN_PGA_WAIT;
      }
      else
      {
         gus_MedleyStateLog |= MedleyStateLogNoiseMarginFinalFDQ;

         //Initialize the states to perform FDQ training
         gs_AlgHandlerState = FDQ_TRAIN_INIT;
         gs_RxSubState = MEDLEY_TRAIN_RX_TRAIN_FINAL_FDQ;
      }
      break;

      // XDSLRTFW-2112 (Start_END)
   case MEDLEY_TRAIN_RX_NOISE_MARGIN_PGA_WAIT:

      if (guc_PgaState == TRAINING_DONE)
      {
         gs_RxSubStateCnt++;
         if (gs_RxSubStateCnt >= 4)
         {
            guc_PgaState = TRAINING_IN_PROGRESS;
            gs_AlgHandlerCount = 0;

            gs_RxSubStateCnt = 0;
            gs_RxSubState = MEDLEY_TRAIN_RX_NOISE_MARGIN_PLL_RELOCK;
         }
      }
      break;

   case MEDLEY_TRAIN_RX_NOISE_MARGIN_PLL_RELOCK:
   // XDSLRTFW-3280 - Start - PLL improvement / pilot tone selection improvement
#if defined(DEBUG_TRAIL)
      if (guc_PgaState != TRAINING_DONE)
      {
         gsa_StatesTrail[gsa_StatesTrailIndex++] = gt_PilotConfig.ta_PilotTones[gt_PilotConfig.te_UsedPTArrayIdx].s_PilotTone_Re;
         gsa_StatesTrail[gsa_StatesTrailIndex++] = gt_PilotConfig.ta_PilotTones[gt_PilotConfig.te_UsedPTArrayIdx].s_PilotTone_Im ;

         gs_AlgHandlerCount++;
         if (gs_AlgHandlerCount >= 16)
         {
            guc_PgaState = TRAINING_DONE;
            gs_AlgHandlerCount = 0;
         }
      }
      else
#endif // DEBUG_TRAIL
      {
         int16 sa_ResetPllRefToneInput_Re[MAX_NUM_PILOT_TONES];
         int16 sa_ResetPllRefToneInput_Im[MAX_NUM_PILOT_TONES];

         if ((guc_NMS_AlgHandler == CALCULATE_SNR_DEFAULT_AGC_GAIN) ||
             (gt_NoiseMarginChange.s_NM_Ctrl & OPTN_NoiseMarginChange_NM_Ctrl_NMS_PllRef))
         {
            gus_MedleyStateLog |= MedleyStateLogNoiseMarginPll;

            sa_ResetPllRefToneInput_Re[0] = gsa_NMS_ResetPllRefToneInput_Re_Save[0];
            sa_ResetPllRefToneInput_Im[0] = gsa_NMS_ResetPllRefToneInput_Im_Save[0];
            sa_ResetPllRefToneInput_Re[1] = gsa_NMS_ResetPllRefToneInput_Re_Save[1];
            sa_ResetPllRefToneInput_Im[1] = gsa_NMS_ResetPllRefToneInput_Im_Save[1];
            sa_ResetPllRefToneInput_Re[2] = gsa_NMS_ResetPllRefToneInput_Re_Save[2];
            sa_ResetPllRefToneInput_Im[2] = gsa_NMS_ResetPllRefToneInput_Im_Save[2];
         }
         else
         {
            sa_ResetPllRefToneInput_Re[0] = gt_PilotConfig.ta_PilotTones[0].s_PilotTone_Re;
            sa_ResetPllRefToneInput_Im[0] = gt_PilotConfig.ta_PilotTones[0].s_PilotTone_Im;
            sa_ResetPllRefToneInput_Re[1] = gt_PilotConfig.ta_PilotTones[1].s_PilotTone_Re;
            sa_ResetPllRefToneInput_Im[1] = gt_PilotConfig.ta_PilotTones[1].s_PilotTone_Im ;
            sa_ResetPllRefToneInput_Re[2] = gt_PilotConfig.ta_PilotTones[2].s_PilotTone_Re;
            sa_ResetPllRefToneInput_Im[2] = gt_PilotConfig.ta_PilotTones[2].s_PilotTone_Im ;
         }

#if defined(DEBUG_TRAIL)
         // XDSLRTFW-3725 (Start)
         // Earlier we had only one pilot tone and we were capturing the data for only 1 tone.
         // But now we have 3 pilot tones and we are capturing the pilot tone data for all the 3 tones.
         gsa_StatesTrail[gsa_StatesTrailIndex++] = sa_ResetPllRefToneInput_Re[0];
         gsa_StatesTrail[gsa_StatesTrailIndex++] = sa_ResetPllRefToneInput_Im[0];
         gsa_StatesTrail[gsa_StatesTrailIndex++] = sa_ResetPllRefToneInput_Re[1];
         gsa_StatesTrail[gsa_StatesTrailIndex++] = sa_ResetPllRefToneInput_Im[1];
         gsa_StatesTrail[gsa_StatesTrailIndex++] = sa_ResetPllRefToneInput_Re[2];
         gsa_StatesTrail[gsa_StatesTrailIndex++] = sa_ResetPllRefToneInput_Im[2];
         // XDSLRTFW-3725 (End)
#endif // DEBUG_TRAIL

         // Set new Pll Reference for all 3 supported pilot tones.
         ResetPllRefTone(PT_ARRAY_IDX_0, NULL, &sa_ResetPllRefToneInput_Re[0], &sa_ResetPllRefToneInput_Im[0], (int16)3);
         // XDSLRTFW-3280 - End - PLL improvement / pilot tone selection improvement

         // Turn on PLL
         gft_EnablePLL = TRUE;

         gs_RxSubState = MEDLEY_TRAIN_RX_NOISE_MARGIN_PLL_WAIT;
      }
      break;

   case MEDLEY_TRAIN_RX_NOISE_MARGIN_PLL_WAIT:

      gs_RxSubStateCnt++;
      if (gs_RxSubStateCnt > gs_PllWaitMedley)
      {
         gs_RxSubStateCnt = 0;

         //Initialize the states to perform FDQ training
         gs_AlgHandlerState = FDQ_TRAIN_INIT;
         gs_RxSubState = MEDLEY_TRAIN_RX_TRAIN_FINAL_FDQ;
      }
      break;
      // XDSLRTFW-954 - Noise Margin Separation to Improve DS performance (END)


   case MEDLEY_TRAIN_RX_TRAIN_FINAL_FDQ:
      if(gs_PauseControl == 0x70)
         Pause(gs_PauseControl);
      if (gs_AlgHandlerState != FDQ_TRAIN_DONE)
      {
         FdqHandler();
      }
      else
      {

         gus_MedleyStateLog |= MedleyStateLogFdqFinal;

#ifdef SAVE_MEDLEY_FDQ
         // save Medley FDQ coefficients
         ReadFdqMant(gsa_MedleyFdqMantissa, 0, gs_RxNumTones);
         ReadFdqExp(guca_MedleyFdqExponent, 0, gs_RxNumTones);
#endif // SAVE_MEDLEY_FDQ

         //go to substate to compute SNR
         gpsa_MeasuredSnrBuf = gsa_SnrBuf;
         gs_AlgHandlerState = SNR_INIT;
         gs_RxSubStateCnt = 0;
         // Enable MFDQ only if using US0 only (or if force flag is set)
         if ((gft_ForceMfdq == 1) ||
               ((gft_EnableMfdq) &&
                (gft_US0BandUsed) &&
                (gs_NumOfRxBands == 1)))
         {
            gft_EnableMfdq = 1; // This is needed to indicate that MFDQ is actually enabled (otherwise ForceMfdq will not work)!!!
            gs_RxSubState = MEDLEY_TRAIN_RX_SNR_CALC_BEFORE_MFDQ;
         }
         else
         {
            gft_EnableMfdq = 0; // This is needed to indicate that MFDQ is actually disabled!!!
            // Note: TRT mode is set in ConfigTaskLayerForPostGhs.
            // Here we switch TRT to ILV_TRT if this feature is enabled & TCM is enabled,
            // because we know that MFDQ is really off (even if it was enabled in the CMV).
            if ((gft_EnableRxIlvTrt) && (gft_RxTcmFlag))
            {
               gs_RxToneOrderType = ILV_TONE_ORDER;
            }
            gs_RxSubStateCnt = 0;
            gs_RxSubState = MEDLEY_TRAIN_RX_CALCULATE_FINAL_SNR;
         }
      }
      break;

   case MEDLEY_TRAIN_RX_SNR_CALC_BEFORE_MFDQ:
      if (gs_AlgHandlerState != SNR_CALC_DONE)
      {
         SnrHandler();
      }
      else
      {
         gt_MfdqConfig.s_AlgHandlerState = MFDQ_TRAIN_INIT;
         gs_RxSubState = MEDLEY_TRAIN_RX_TRAIN_MFDQ;
      }
      break;


   case MEDLEY_TRAIN_RX_TRAIN_MFDQ:

      if (gt_MfdqConfig.s_AlgHandlerState != MFDQ_TRAIN_DONE)
      {
         MfdqHandler();
      }
      else
      {
#ifdef SAVE_MEDLEY_FDQ
         // save Medley FDQ coefficients
         ReadFdqMant(gsa_MedleyFdqMantissa, 0, gs_RxNumTones);
         ReadFdqExp(guca_MedleyFdqExponent, 0, gs_RxNumTones);
#endif // SAVE_MEDLEY_FDQ

         // go to substate to compute SNR
         gpsa_MeasuredSnrBuf = gsa_SnrBuf;
         gs_AlgHandlerState = SNR_INIT;
         gs_RxSubStateCnt = 0;
         gs_RxSubState = MEDLEY_TRAIN_RX_CALCULATE_FINAL_SNR;
      }

      break;


   case MEDLEY_TRAIN_RX_CALCULATE_FINAL_SNR:

      //XDSLRTFW-3823 (start)
      if (gs_AlgHandlerState == SNR_INIT)
      {

         // Validate NoOf Tone groups
         // atleast one start idx,(in this case end indx will be 8192) from startidx to end idx constant SNR offset will be added.
         // gta_SNROffset.s_NoOfToneGroups = 0 will disable SNR offset (by writing "0" value)
         if(gta_SNROffset.s_NoOfToneGroups >= 1)
         {
            if(gta_SNROffset.s_NoOfToneGroups > SNR_OFFSET_TONEGROUPS)
            {
               gta_SNROffset.s_NoOfToneGroups = SNR_OFFSET_TONEGROUPS;
            }
            // Copy to FW variable to be used for SNR manipulation
            int16 s_idx;
            for(s_idx = 0;s_idx < gta_SNROffset.s_NoOfToneGroups;s_idx++)
            {
               gt_SNROffsetBitLoad[s_idx+1].s_ToneGroupStartIdx = gta_SNROffset.ta_SNROffset[s_idx].s_ToneGroupStartIdx;
               gt_SNROffsetBitLoad[s_idx+1].s_ToneGroupSNROffset  = gta_SNROffset.ta_SNROffset[s_idx].s_ToneGroupSNROffset;
            }
          }
          gt_SNROffsetBitLoad[0].s_ToneGroupStartIdx = 0;
          gt_SNROffsetBitLoad[0].s_ToneGroupSNROffset  = 0;
          gt_SNROffsetBitLoad[gta_SNROffset.s_NoOfToneGroups+1].s_ToneGroupStartIdx = RX_MAX_NUM_TONES;
          gt_SNROffsetBitLoad[gta_SNROffset.s_NoOfToneGroups+1].s_ToneGroupSNROffset  = 0;
          gs_ToneGroupIdx = 0; //XDSLRTFW-3823 (end)
      }
      if (gs_AlgHandlerState != SNR_CALC_DONE)
      {
         SnrHandler();
      }
      else
      {
         gus_MedleyStateLog |= MedleyStateLogSnrFinal;

         if(TESTArray[TEST_StoreSramControl] & TEST_SAVE_MEDLEY_SNR_ENABLE)
         {
            if ((((gt_NoiseMarginChange.s_NM_Ctrl & (OPTN_NoiseMarginChange_NM_Ctrl_NMS_EN|OPTN_NoiseMarginChange_NM_Ctrl_NMS_SNRLOG)) == OPTN_NoiseMarginChange_NM_Ctrl_NMS_EN) &&
                 (guc_NMS_AlgHandler == CALCULATE_SNR_DEFAULT_AGC_GAIN)) ||
                (((gt_NoiseMarginChange.s_NM_Ctrl & (OPTN_NoiseMarginChange_NM_Ctrl_NMS_EN|OPTN_NoiseMarginChange_NM_Ctrl_NMS_SNRLOG)) == (OPTN_NoiseMarginChange_NM_Ctrl_NMS_EN|OPTN_NoiseMarginChange_NM_Ctrl_NMS_SNRLOG)) &&
                 (guc_NMS_AlgHandler == CALCULATE_SNR_3DB_AGC_GAIN)) ||
                ((gt_NoiseMarginChange.s_NM_Ctrl & OPTN_NoiseMarginChange_NM_Ctrl_NMS_EN) == 0))
            {
               if(PollForCodeSwapDone(VDSL_WRITE_DATA_TO_SRAM_DM_SWAPPAGE, guc_OffChipRequestHandle) != SWAP_DONE)
               {
                  break;
               }

               gta_BAR15LookUpTable[OFF_CHIP_MEDLEY_SNR][OFF_CHIP_SOURCE_INDEX] = (int32)gpsa_MeasuredSnrBuf;   // update source address
               gta_BAR15LookUpTable[OFF_CHIP_MEDLEY_SNR][OFF_CHIP_DEST_INDEX] = (int32)&gsa_MedleySnrBuf[gs_RxNumTones*guc_ch_id];    // destination;
               gta_BAR15LookUpTable[OFF_CHIP_MEDLEY_SNR][OFF_CHIP_LENGTH_INDEX] = ((gs_RxNumTones + 1)/2)*4;    // size in bytes; make sure length is multiple of 4-bytes

               // Free handle for PSD offchip request
               FreeSwapHandle(&guc_OffChipRequestHandle);
               guc_OffChipRequestHandle = RequestSwapOffChip(VDSL_WRITE_DATA_TO_SRAM_DM_SWAPPAGE, SWAP_TIMING_OFF, OFF_CHIP_MEDLEY_SNR);
            }
         }

         // XDSLRTFW-3837 (Start_End)
         // Tracee debug info
         DSH_SendStream(DSH_VDSL2_MEDLEY_SNR,gs_RxNumTones*sizeof(int16),(void*)gpsa_MeasuredSnrBuf);

         // XDSLRTFW-954 - Noise Margin Separation to Improve DS performance (START)
         // XDSLRTFW-2112 (Start_END)
         if (guc_NMS_AlgHandler == CALCULATE_SNR_3DB_AGC_GAIN)
         {
            // Store Medley SNR with default+3dB AGC settings
            memcpy(&gsa_PsdAnalysis_out[0], gpsa_MeasuredSnrBuf, sizeof(int16)*gs_RxNumTones);

            if(gs_PauseControl == 0x71)
               Pause(gs_PauseControl);
            // Measure Medley SNR with default AGC settings
            guc_NMS_AlgHandler = CALCULATE_SNR_DEFAULT_AGC_GAIN;
            gs_PGA_required = gs_NMS_AGC1_Gain_Save;

            gs_RxSubState = MEDLEY_TRAIN_RX_COMPUTE_NOISE_MARGIN;
            break;
         }
         else if (guc_NMS_AlgHandler == CALCULATE_SNR_DEFAULT_AGC_GAIN)
         {
            if (!(gt_NoiseMarginChange.s_NM_Ctrl & OPTN_NoiseMarginChange_NM_Ctrl_NMS_NoSnr))
            {
               guc_NMS_AlgHandler = NOISE_MARGIN_SEP_DONE;
            }
            else
            {
               guc_NMS_AlgHandler = NOISE_MARGIN_SEP_NO_SNR_UPDATE;
            }

            // XDSLRTFW-4216 :CTL, VDSL: Downstream low perf in mid range loops from 2000ft to 3000ft (NS = NoiseSeparation) (Start_End)
            {
               int16 s_NM_TargetMargin_Dependent_Gain_dB;    // 8.8 dB format

               // Requirements of setting up NMS boundaries:
               // Lower bound
               // L1. SNR shall not get smaller because of NMS measurement (s_NmsGain_dB >= 0dB)
               // L2. NMS-gain shall not be considered if the gain is lower than "gt_NoiseMarginChange.s_min_Used_NMS_Gain".
               //     Note: gt_NoiseMarginChange.s_min_Used_NMS_Gain = 0 or = gt_NoiseMarginChange.s_min_NMS_Gain_ToBe_considered.
               // Since gt_NoiseMarginChange.s_min_Used_NMS_Gain is greater or equal to zero so L1 & L2 can be combined together.
               //
               // Upper bound
               // U1. Final SNR margin shall be at least 3dB (s_NmsGain_dB < TargetMargin-3dB)
               // U2. NMS-gain shall not be higher than AGC-boost during measurement
               // U3. NMS-gain shall not be higher than gt_NoiseMarginChange.s_max_NMS_Gain_ToBe_considered

               // Setting Lower bound
               // Not needed, because "gt_NoiseMarginChange.s_min_Used_NMS_Gain" contains the correct value
               // and is checked in fct. "SnrCalc()".

               // Setting Upper bound
               // U1. Final SNR margin shall be at least 3dB (s_NmsGain_dB < TargetMargin-3dB)
// Todo XDSLRTFW-4216: Where is gt_NoiseMarginChange.s_NM_Delta considered?
               s_NM_TargetMargin_Dependent_Gain_dB = (((gt_SnrMgnConfig.s_TARSNRMds<<8)/10) - 0x300);
               if (s_NM_TargetMargin_Dependent_Gain_dB < 0)
               {
                  s_NM_TargetMargin_Dependent_Gain_dB = 0; // Gain can not be negative!
               }
               if (s_NM_TargetMargin_Dependent_Gain_dB < gt_NoiseMarginChange.s_max_Used_NMS_Gain)
               {
                  gt_NoiseMarginChange.s_max_Used_NMS_Gain = s_NM_TargetMargin_Dependent_Gain_dB;
               }

               // U2. NMS-gain shall not be higher than AGC-boost during measurement
               // This is automatically fulfilled due to that the s_max_Used_NMS_Gain is the AGC-boost during medley measurement

               // U3. NMS-gain shall not be higher than gt_NoiseMarginChange.s_max_NMS_Gain_ToBe_cosidered
               if (gt_NoiseMarginChange.s_max_NMS_Gain_ToBe_considered < gt_NoiseMarginChange.s_max_Used_NMS_Gain)
               {
                  gt_NoiseMarginChange.s_max_Used_NMS_Gain = gt_NoiseMarginChange.s_max_NMS_Gain_ToBe_considered;
               }
            }
         }
         if(gs_PauseControl == 0x72)
            Pause(gs_PauseControl);
         // XDSLRTFW-954 - Noise Margin Separation to Improve DS performance (END)



#if defined(ANXQ_35BLITE_PAUSE_DEBUG) || defined(VRX518_BRINGUP_DEBUG)
         //At the end of SNR Handler in MedleyTraining
         if (gs_PauseControl == 0x403)
         {
            gft_PauseOff = 0;
            Pause(gs_PauseControl);
         }
#endif // ANXQ_35BLITE_PAUSE_DEBUG

         // save pilot tone index and other debug info
         // XDSLRTFW-3280 - Start - PLL improvement / pilot tone selection improvement
         gs_PilotToneIdx_Medley = gt_PilotConfig.ta_PilotTones[gt_PilotConfig.te_UsedPTArrayIdx].s_PilotToneIdx;
         for (i=0; i<MAX_NUM_PILOT_TONES; i++)
         {
            memcpy(&gsa_SnrOfPilotTone_Medley[i], &gpsa_MeasuredSnrBuf[gt_PilotConfig.ta_PilotTones[i].s_PilotToneIdx-2], sizeof(int16)*5);
         }
         // XDSLRTFW-3280 - End - PLL improvement / pilot tone selection improvement

         //------------------------------------------------------
         // For loop diagnostic mode compute Hlin and Bitloading.
         // Note: For normal VDSL2 link bitloading is done later in state ROPmsRxF_VDSL2!
         //------------------------------------------------------
         if (gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG)
         {
            // request bitload swap page
            FreeSwapHandle(&guc_PrimPageHandle);
            guc_RxSwapActivity = CODESWAP_LOAD(VDSL_ALGHD_4_V2_PM_SWAPPAGE);

            gs_RxSubStateCnt = 0;
            gs_RxSubState = MEDLEY_TRAIN_RX_WAIT_FOR_CODESWAP_BITLOAD;
         }
         else
         {
            // restore TRAIN_MAIN page
            FreeSwapHandle(&guc_PrimPageHandle);
            guc_RxSwapActivity = CODESWAP_LOAD(VDSL_TRAIN_MAIN_PM_SWAPPAGE);
            gs_RxSubState = MEDLEY_TRAIN_RX_WAIT_FOR_CODESWAP_TRAINMAIN;
         }
      }

      break;

      //-------------------------------------------------start
      // Loop diagnostic mode
      // - bring in Bit Load Swap Page
      // - compute Hlin and Bitloading.
      //------------------------------------------------------
   case MEDLEY_TRAIN_RX_WAIT_FOR_CODESWAP_BITLOAD:
      if (guc_RxSwapActivity == CODESWAP_DO_NOTHING)
      {
         if((gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG) &&
               (gft_DisableHlinCalc == FALSE))
         {
            gs_AlgHandlerState = HLIN_INIT;
            gs_RxSubState = MEDLEY_TRAIN_RX_CALC_HLIN;
         }
         else
         {
            gs_AlgHandlerState = BITLOAD_INIT;
            gs_RxSubState = MEDLEY_TRAIN_RX_BITLOAD;
         }
      }
      break;

   case MEDLEY_TRAIN_RX_CALC_HLIN:
      if(gs_AlgHandlerState != HLIN_DONE)
      {
         HlinHandler();
      }
      else
      {
         gs_AlgHandlerState = BITLOAD_INIT;
         gs_RxSubState = MEDLEY_TRAIN_RX_BITLOAD;
      }
      break;

   case MEDLEY_TRAIN_RX_BITLOAD:
      if (gs_AlgHandlerState != BITLOAD_DONE)
      {
         BitloadHandler();
      }
      else
      {
         // restore TRAIN_MAIN page
         FreeSwapHandle(&guc_PrimPageHandle);
         guc_RxSwapActivity = CODESWAP_LOAD(VDSL_TRAIN_MAIN_PM_SWAPPAGE);

         gs_RxSubState = MEDLEY_TRAIN_RX_WAIT_FOR_CODESWAP_TRAINMAIN;

      }
      break;
      //------------------------------------------------------
      // Loop diagnostic mode
      //---------------------------------------------------end


   case MEDLEY_TRAIN_RX_WAIT_FOR_CODESWAP_TRAINMAIN:
      if (guc_RxSwapActivity == CODESWAP_DO_NOTHING)
      {
         gs_RxSubState = MEDLEY_TRAIN_RX_SELECT_MSG_TONES;
      }
      break;


      //---------------------------------------------------------------------
      // Select Rx Message Tone based on SNR
      //---------------------------------------------------------------------
   case MEDLEY_TRAIN_RX_SELECT_MSG_TONES:
      //Call the following function to select the tones for message decoding
      gs_RxBkgdProcessFlag = TRAINING_IN_PROGRESS;
      AddFunctionToBkgdFifo((PtrToBkgdFunc)BgSelectRxMsgDecodeTones);

      gs_RxSubStateCnt = 0;
      gs_RxSubState = MEDLEY_TRAIN_RX_DONE;
      break;

   case MEDLEY_TRAIN_RX_DONE:
      if (gs_RxBkgdProcessFlag == TRAINING_DONE)
      {
         // save tone selection
         gs_ToneSelect_Msg_AnaExc = gs_SelectBandStart;
         gs_NumCluster_Msg_AnaExc = gs_NumOfToneClustersForMsgDecode;

         gs_RxSynchFrameOffset = gs_SelectBandStart; // offset into RTV buffer
//#ifdef MTK_VECTORING_SUPPORT
         //DSM_Vectoring_Check: Following code to be reviewed.
         // To make the gs_RxSynchFrameOffset a member of the set 10n+1, where n is the set of positive integers
         // This is necessary since the Sync signalling will be limited to flag tones only which are
         // 10n+1, 10n+7
         // This portion of the code modifies the original SynchFrameOffset to the next 10n+1 th tone
         if (gft_DSVectoringEnabled == TRUE)
         {
            s_temp = gs_RxSynchFrameOffset % 10;
            if(!s_temp)
            {
               gs_RxSynchFrameOffset += 1;
            }
            else if(s_temp>1)
            {
               gs_RxSynchFrameOffset += (11-s_temp);
            }
         }
//#endif
         gs_RxSynchFrameNumTones = gs_RxNumChannelsForMsgDecode; // # of tones to read from RTV buffer for sync frame processing
         //Limit the number of synch symbol tones to 32 to avoid excessive processing time
         if(gs_RxSynchFrameNumTones > 32)
         {
            gs_RxSynchFrameNumTones = 32;
         }

         // check the result and enter fail state if no band was found
         if (gs_SelectBandStart == -1)
         {
            EnterFailStates(E_CODE_ZERO_TONE_CLUSTERS_MEDLEY);
         }
         else
         {
            gs_RxProcessFlag = TRAINING_DONE;
         }
      }

      break;

   } // switch


   //---------------------------------------------------------------------
   // Code Swap State Machine
   //---------------------------------------------------------------------
   switch (guc_RxSwapActivity)
   {
      //-------------------------------------------------------
      // VDSL2 Pages
      //-------------------------------------------------------
   case CODESWAP_LOAD(VDSL_ALGHD_3_V2_PM_SWAPPAGE):
      if ((guc_PrimPageHandle = RequestSwap(VDSL_ALGHD_3_V2_PM_SWAPPAGE)) != INVALID_CODESWAP_HANDLE)
      {
         guc_RxSwapActivity = CODESWAP_CHECK(VDSL_ALGHD_3_V2_PM_SWAPPAGE);
      }
      break;

   case CODESWAP_CHECK(VDSL_ALGHD_3_V2_PM_SWAPPAGE):
      if (PollForCodeSwapDone(VDSL_ALGHD_3_V2_PM_SWAPPAGE, guc_PrimPageHandle) == SWAP_DONE)
      {
         guc_RxSwapActivity = CODESWAP_DO_NOTHING;
      }
      break;

   case CODESWAP_LOAD(VDSL_ALGHD_4_V2_PM_SWAPPAGE):
      if ((guc_PrimPageHandle = RequestSwap(VDSL_ALGHD_4_V2_PM_SWAPPAGE)) != INVALID_CODESWAP_HANDLE)
      {
         guc_RxSwapActivity = CODESWAP_CHECK(VDSL_ALGHD_4_V2_PM_SWAPPAGE);
      }
      break;

   case CODESWAP_CHECK(VDSL_ALGHD_4_V2_PM_SWAPPAGE):
      if (PollForCodeSwapDone(VDSL_ALGHD_4_V2_PM_SWAPPAGE, guc_PrimPageHandle) == SWAP_DONE)
      {
         guc_RxSwapActivity = CODESWAP_DO_NOTHING;
      }
      break;


      //-------------------------------------------------------
      // TRAIN MAIN page
      //-------------------------------------------------------
   case CODESWAP_LOAD(VDSL_TRAIN_MAIN_PM_SWAPPAGE):
      if ((guc_PrimPageHandle = RequestSwap(VDSL_TRAIN_MAIN_PM_SWAPPAGE)) != INVALID_CODESWAP_HANDLE)
      {
         guc_RxSwapActivity = CODESWAP_CHECK(VDSL_TRAIN_MAIN_PM_SWAPPAGE);
      }
      break;

   case CODESWAP_CHECK(VDSL_TRAIN_MAIN_PM_SWAPPAGE):
      if (PollForCodeSwapDone(VDSL_TRAIN_MAIN_PM_SWAPPAGE, guc_PrimPageHandle) == SWAP_DONE)
      {
         guc_RxSwapActivity = CODESWAP_DO_NOTHING;
      }
      break;

   }
}

//CO HW build should use FdqHandler() loaded to the swappage ALGHD_3_V2
