/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   TxPeriodicStateHandler.c
*
*   This file contains functions to handle the TX periodic state
*   specific processings.
*
*-------------------------------------------------------------------------
*/

#include "gdata.h"
#include "ModulateSocMessages.h"
#include "vdsl_state.h"
#include "states.h"
#include "OTrainingTxF.h"
#include "fifo.h"
#include "DSLEngin.h"
#include "ghs.h"
#include "IRI_Iof.h"
#include "IRI_sync.h"
#include "vdsl_xception.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : HandleTxCE_PeriodicStateStart
 *
 *   This function handles the TX CE changes at the start of the periodic state
 *
 *  Prototype:  void HandleTxCE_PeriodicStateStart(void)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

//Due to the HW and FW task scheduling difference between the 5.0 and 6.2 HW implementation
//the start time to change the TX extention register should be different by 1.
//See the explanation below:

//In the 5.0 task scheduling, if both QT and FT core reconfiguration are done at the same TC task,
//then the FT will use the new configuration one symbol earlier than the QT (refering to the 5.0
//task scheduling diagram). Therefore, for both the QT and FT new configuration to take place
//at the same symbol, we configure the FT one symbol later than the time configuring QT.
//That is why TX_SYM_START_CNT is set to 1 for the 5.0 build.
//For the 6.2 build, this problem does not exist so we configure

void HandleTxCE_PeriodicStateStart(void)
{
   static int16 s_count = 0;

   if (gul_dbgMiscControl & DISABLE_TX_PERIODIC_TRANSITION)
   {
      gus_VdslStatusFlag |= BITMAP_DISABLE_TX_CE_VDSL2;
      return;
   }

   if((gus_VdslStatusFlag & BITMAP_DISABLE_TX_CE_VDSL2) == 0)
   {
      if(s_count == 0)
      {
         //Configure the HW to send the first symbol of the periodic state
         AddFunctionToFifo(gp_TxLoadingFunctionFifo, ChangeTxCE_ForFirstSym);
         s_count++;
      }
      else if(s_count == 1)
      {

         //For the second symbol, turn CP, CS and window off
         AddFunctionToFifo(gp_TxLoadingFunctionFifo, DisableTxCE);

         gus_VdslStatusFlag |= BITMAP_DISABLE_TX_CE_VDSL2;

         s_count = 0;
      }
   }
} //void HandleTxCE_PeriodicStateStart(void)

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : HandleTxCE_PeriodicStateEnd
 *
 *   This function handles the TX CE changes at the end of the periodic state
 *
 *  Prototype:  void HandleTxCE_PeriodicStateEnd(void)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void HandleTxCE_PeriodicStateEnd(void)
{
   int16 static s_count = 0;

   if (gul_dbgMiscControl & DISABLE_TX_PERIODIC_TRANSITION)
   {
      return;
   }

   if((gus_VdslStatusFlag & BITMAP_DISABLE_TX_CE_VDSL2) != 0)
   {
      if(s_count == 0)
      {
         //queue the TC task for programing the HW core for sending the last symbol of the periodic state
         //The last symbol should have FSIZE=2N-beta-2, and CS length of beta+2, window length of beta
         //Note1: -2 is due to HW restriction what requires the CS length to be at least 2 samples larger than
         //window length

         //Note1: In 5.0 implementation,
         //reconfiguring the FT core takes effect one symbol before reconfig the QT core. That's why
         //the function ChangeTxCE_ForLastSym() was not done in at the last symbol of the previous state

         //Note2: In 6.2 implementation, ChangeTxCE_ForLastSym() is actually configuring
         //the first symbol of the non periodic state. To minimize the code change (from the 5.0 version),
         //we still use the same function name, though it is misleading
         //Here beta length is subtracted from the CP length of the first symbol of non-periodic state
         //since it is not allowed to have FSIZE to be less than the normal IFFT size in the 6.2 HW
         AddFunctionToFifo(gp_TxLoadingFunctionFifo, ChangeTxCE_ForLastSym);
         s_count++;
      }
      else if(s_count == 1)
      {
         //queue the TC task for programing the HW core to insert
         //cyclic extension
         AddFunctionToFifo(gp_TxLoadingFunctionFifo, InsertTxCE);

         //programing the HW core to restore the original frame length
         AddFunctionToFifo(gp_TxLoadingFunctionFifo, ConfigTxFrameSize);

         //clear the flag bit
         gus_VdslStatusFlag &= ~BITMAP_DISABLE_TX_CE_VDSL2;

         s_count = 0;
      }
   }
}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : HandleRxCE_PeriodicStateStart
 *
 *   This function handles the RX CE changes at the start of the periodic state
 *
 *  Prototype:  void HandleRxCE_PeriodicStateStart(void)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

#define RX_SYM_START_CNT (-1)

void HandleRxCE_PeriodicStateStart(void)
{

   if (gul_dbgMiscControl & DISABLE_RX_PERIODIC_TRANSITION)
   {
      //Disable PLL during the transition to periodic state
      if(gs_PeriodicPllDisable == 1)
      {
         gft_EnablePLL = FALSE;
      }
      return;
   }

   if((gus_VdslStatusFlag & BITMAP_DISABLE_RX_CE_VDSL2) == 0)
   {

      //Disable PLL during the transition to periodic state
      if(gs_PeriodicPllDisable == 1)
      {
         gft_EnablePLL = FALSE;
      }

      if(gs_HandleRxCE_PeriodicStateStart_s_count == -2)
      {
         gs_HandleRxCE_PeriodicStateStart_s_count++;
      }
      else if(gs_HandleRxCE_PeriodicStateStart_s_count == -1)
      {
         //Adjust the remote TX and local RX CS difference at the last symbol
         //of the state with CE
         //(this is necessary since the 6.2 HW does not allow the strymon
         //frame size to be less than FFT frame length
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, ChangeRxCE_PreFirstSym);

         if(gft_RxTxCsDiff_err == 1)
         {
            EnterFailStates(E_CODE_CSDIFF_ERR1);
         }
         else if(gft_RxTxCsDiff_err == 2)
         {
            EnterFailStates(E_CODE_CSDIFF_ERR2);
         }

         gs_HandleRxCE_PeriodicStateStart_s_count++;
      }
      else if(gs_HandleRxCE_PeriodicStateStart_s_count == 0)
      {
         //Program the HW so that the first symbol of O-P-Periodic has (2N+Beta) samples
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, ChangeRxCE_ForFirstSym);
         gs_HandleRxCE_PeriodicStateStart_s_count++;
      }
      else if(gs_HandleRxCE_PeriodicStateStart_s_count == 1)
      {
         //Program the HW so that the following symbols of O-P-Periodic has (2N) samples
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, DisableRxCE);

         if((gs_EnablePeriodicFrameRealign) && (gs_RxTxCsDiff != 0))
         {
            //Perform the frame realignment to compensate for Tx/RX CS different
            //gs_AlignmentOffset should be computed outside of this function
            AddFunctionToFifo(gp_RxLoadingFunctionFifo, ConfigRxFrameSize);
         }

         //Set the control bit to indicate the CE is removed
         gus_VdslStatusFlag |= BITMAP_DISABLE_RX_CE_VDSL2;

         //reset the count
         gs_HandleRxCE_PeriodicStateStart_s_count = RX_SYM_START_CNT;

      }
   }
}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : HandleRxCE_PeriodicStateEnd
 *
 *   This function handles the RX CE changes at the end of the periodic state
 *
 *  Prototype:  void HandleRxCE_PeriodicStateEnd(void)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void HandleRxCE_PeriodicStateEnd(void)
{
   static int16 s_count = RX_SYM_START_CNT;


   if (gul_dbgMiscControl & DISABLE_RX_PERIODIC_TRANSITION)
   {
      //Disable PLL during the transition to non-periodic state
      if(gs_PeriodicPllDisable == 1)
      {
         gft_EnablePLL = FALSE;
      }
      return;
   }

   if((gus_VdslStatusFlag & BITMAP_DISABLE_RX_CE_VDSL2) != 0)
   {

      //Disable PLL during the transition to non-periodic state
      if(gs_PeriodicPllDisable == 1)
      {
         gft_EnablePLL = FALSE;
      }


      //skip next frame if needed
      s_count += gft_SkipSymbol;

      if(s_count == -1)
      {
         //Perform this operation at the 2nd to the last symbol
         //to see if we need to combine the last two symbols into one
         //to achieve the frame alignment
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, ChangeRxFftLength_PreLastSym);

         s_count++;
      }
      else if(s_count == 0)
      {
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, ChangeRxFftLength_ForLastSym);
         s_count++;
      }
      //At this time, the HW is receiving the last frame
      //before this special frame boundary (i.e., (n*(s_m + 64)-1))
      else if(s_count == 1)
      {
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, InsertRxCE);
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, ConfigRxFrameSize);

         //clear the flag bit
         gus_VdslStatusFlag &= ~BITMAP_DISABLE_RX_CE_VDSL2;

         //reset the count
         s_count = RX_SYM_START_CNT;

      }
   }
}
