/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   RMedleyMsgHandler.c
*
*   This file contains the RT state function to transmit Medley state messages.
*
*
*-------------------------------------------------------------------------
*/


// ***********************************************************************************************************
// RMedleyMsgHandler.c
//
// History
//
// 06/05/2013 Varun : Added code(Debug option) to mark the end of training in Debug Buffer and initialize the DMA
//                to external SDRAM
//                Grep for "XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer"
//
// 21/05/2015 Palaksha/Vinay GR: XDSLRTFW-2368 : Enable Debug Traces in VRx318
//            Debug trace feature is enabled for VRX318 platform all modes except
//            when RTXds or RTXus or both enabled in 30a, Debug trace will be captured
//            only till Training (Untill ROP_SYNCHR6) and in showtime this will be diabled
//            Grep for "XDSLRTFW-2368"
// ************************************************************************************************************


#include "common.h"
#include "gdata.h"
#include "ModulateSocMessages.h"
#include "vdsl_state.h"
#include "states.h"
#include "OTrainingTxF.h"
#include "ORTrainingRxF.h"
#include "fifo.h"
#include "DSLEngin.h"
#include "socmessage.h"
#include "InitShowTimeTx.h"
#include "vdsl_xception.h"
#include "DebugBuffer.h"
#include "cmv.h"
#include "cmv_Data.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : RMedleyMsgHandler
 *
 *   This function is the RT state function to transmit Medley state messages.
 *
 *  Prototype:  void RMedleyMsgHandler(void)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *      gs_TxState -- (I) TX state
 *      gs_TxSubState -- (I/O) TX substate
 *      gl_TxSymbolCount -- (I) TX state symbol count
 *      gs_TxSubStateCnt -- (I/O) TX substate count
 *      gs_FormMsgFlag -- (I/O) flag to indicate if forming message is done or not
 *      gs_TxHDLCMsgState -- (I/O) the TX HDLC message handler substate
 *      gs_UpdateTxMsgIdxFlag -- (O) flag to indicate if the TX message index should be updated or not
 *      gs_TxGain -- (I) TX output tone gain level
 *      gs_TxNumBytesPerSymbol -- (I) the number of message bytes modulated to a symbol
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

/* =============================================== */
/* substates                              */
/* =============================================== */
#define R_MEDLEY_MSG_TX_INIT                  (0)
#define R_MEDLEY_MSG_TX_SHOW_INIT               (1)
#define R_MEDLEY_MSG_TX_START_MSG               (2)
#define R_MEDLEY_MSG_TX_MODULATE_MSG              (3)
#define R_MEDLEY_MSG_TX_IDLE                  (4)

void RMedleyMsgHandler(void)
{

   uint8 uca_octet[2];
   PtrToBkgdFunc ptrToFunction;

   switch (gs_TxSubState)
   {

   case R_MEDLEY_MSG_TX_INIT:

      if(gl_TxSymbolCount == 0)
      {
         //Modulate 1 or 2 HDLC flags into one symbol
         //(Note: gs_TxNumBytesPerSymbol is set to be either 1 or 2)
         uca_octet[0] = (uint8)HDLC_FLAG;
         uca_octet[1] = (uint8)HDLC_FLAG;
         ModulateHdlcOctets(uca_octet, gs_TxNumBytesPerSymbol);

         //Update the count of the number of the same message has been resent
         gs_NumRxRepeatRequest++;

         //If this is not the message to be resent
         if(gs_NumRxRepeatRequest == 1)
         {
            //Set this flag to TRUE, so guc_TxHDLCMsgIndex will increased in TxHDLCMsgHandler()
            gs_UpdateTxMsgIdxFlag = TRUE;

            switch(gs_TxState)
            {
            case VDSL2_R_MSG2_TX:

               ptrToFunction = (PtrToBkgdFunc)FormRMsg2Msg_VDSL2;
               break;

            case VDSL2_R_TPS_ACK_TX:

               ptrToFunction = (PtrToBkgdFunc)FormRTpsAckMsg_VDSL2;
               break;

            case VDSL2_R_PMS_TX:

               ptrToFunction = (PtrToBkgdFunc)FormRPmsMsg_VDSL2;
               break;

            case VDSL2_R_PMD_TX:

               // initialize variables and cores for showtime TX path
               ptrToFunction = (PtrToBkgdFunc)FormRPmdMsg_VDSL2;
               break;

            case VDSL2_R_REPEAT_REQUEST_TX:

               //Set this flag to FALSE, so guc_TxHDLCMsgIndex will not be changed in TxHDLCMsgHandler()
               gs_UpdateTxMsgIdxFlag = FALSE;
               ptrToFunction = (PtrToBkgdFunc)FormORRepeatRqstMsg_VDSL2;

            default:
               ptrToFunction = 0;
               break;
            } //switch

            gs_FormMsgFlag = TRAINING_IN_PROGRESS;
            if(ptrToFunction != 0)
            {
               AddFunctionToBkgdFifo(ptrToFunction);
            }
            else
            {
               EnterFailStates(E_CODE_TX_MEDLEY_FAIL);
            }

         }
         else //resend the previous message
         {
            //If after two resending of this message, go to fail state
            if(gs_NumRxRepeatRequest > NUM_RESEND_O_UPDATE)
            {
               EnterFailStates(E_CODE_TX_MEDLEY_FAIL);
            }
            else
            {
               //Set gs_UpdateTxMsgIdxFlag to FALSE so the message
               //index will not be increased (since this is a repeated message)
               gs_UpdateTxMsgIdxFlag = FALSE;
               gs_FormMsgFlag = TRAINING_DONE;
            }
         }
      } //if(gl_TxSymbolCount == 0)


      if(gs_FormMsgFlag == TRAINING_DONE)
      {
         if(gs_TxState == VDSL2_R_PMD_TX)
         {
//#if defined(ANXQ_35BLITE_PAUSE_DEBUG) || defined(VRX518_BRINGUP_DEBUG)
               // Pause to dump the R-PMD SOC message.
               if (gs_PauseControl == 0x501)
               {
                  gft_PauseOff = 0;
                  Pause(gs_PauseControl);
               }
//#endif // ANXQ_35BLITE_PAUSE_DEBUG
            guc_TxShowInitState = TX_SHOW_INIT_START;
            gs_TxSubState = R_MEDLEY_MSG_TX_SHOW_INIT;
         }
         else
         {
            gs_TxSubState = R_MEDLEY_MSG_TX_START_MSG;
         }
      }

      break;

   case R_MEDLEY_MSG_TX_SHOW_INIT:

      // Wait for the Anal 5 page to be loaded in
      // before kicking off the Tx Showtime initialization
      if (gft_StartTxShowinit == TRUE)
      {
         // call TxShowInitHandler() until TX showtime initialization is done
         if (guc_TxShowInitState != TX_SHOW_INIT_DONE)
         {
            if(guc_TxShowInitState == TX_SHOW_INIT_VARS)
            {
#ifdef DEBUG_TRACES
               // XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer(START)
               //Mark the end of training
               LogMessages(1,DEBUG_BUFFER_DELIMETER_TRAINING_END);

               if(((gt_DebugBuffControl.us_debugBuffer_StopStartCaptureData) & GHS_TRAINING_CAPTURE_DISABLE_MASK) == 0)
               {
                  if(PollForCodeSwapDone(VDSL_WRITE_DATA_TO_SRAM_DM_SWAPPAGE, guc_OffChipRequestHandle) == SWAP_DONE)
                  {
                     gta_BAR15LookUpTable[OFF_CHIP_DEBUG_BUF][OFF_CHIP_SOURCE_INDEX] = (int32)(gpusa_debugBuff); // update source address
                     gta_BAR15LookUpTable[OFF_CHIP_DEBUG_BUF][OFF_CHIP_DEST_INDEX] = (int32)gpuca_offChipBuff; // destination;
                     gta_BAR15LookUpTable[OFF_CHIP_DEBUG_BUF][OFF_CHIP_LENGTH_INDEX] = (gt_debugBufStatus.s_debugBufIndex<<1);    // size in bytes; make sure length is multiple of 4-bytes

                     // Free handle for PSD offchip request
                     FreeSwapHandle(&guc_OffChipRequestHandle);
                     guc_OffChipRequestHandle = RequestSwapOffChip(VDSL_WRITE_DATA_TO_SRAM_DM_SWAPPAGE, SWAP_TIMING_OFF, OFF_CHIP_DEBUG_BUF);


                     gpuca_offChipBuff=guca_offChipDebugBuff+(gt_debugBufStatus.s_debugBufIndex<<1); // increment the pointer of guc_offChipDebugBuff to suitable value
                     gul_DMA_Busy_Error=0;

                     gt_DebugBufferStatus.s_debugBuffer_GHS_TO_EXCHANGE_length+=gt_debugBufStatus.s_debugBufIndex;
                     gt_debugBufStatus.s_debugBufIndex=0; //reset the pointer to the internal debug buffer
                  }
                  else
                  {
                     gul_DMA_Busy_Error++;
                  }

                  // XDSLRTFW-2368 (Start)
                  if ( (gs_frame_rate_is_8khz) && (TESTArray[TEST_Control3] & TEST_Control3_Test28_Bit7Mask_DISDEBUGTRACE) &&
                        (gus_ReTxOptionsEnabled & (CPE_DS_US_RETX_CAPABLE|CPE_DS_RETX_CAPABLE)) )
                  {
                     gt_DebugBuffControl.us_debugBuffer_StopStartCaptureData = (US_RETX_ONLY_CAPTURE_DISABLE_MASK | SHOW_TIME_EVENT_DISABLE_MASK
                           | SHOW_TIME_CAPTURE_DISABLE_MASK);
                  }
                  // XDSLRTFW-2368 (End)
               }
               // XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer(END)
#endif // #ifdef DEBUG_TRACES
            }

            TxShowInitHandler();
         }
         else if (gft_OKToSendBGFlag == 1)
         {
            gs_TxSubState = R_MEDLEY_MSG_TX_START_MSG;
         }
      }

      break;

   case R_MEDLEY_MSG_TX_START_MSG:

      //if(gs_FormMsgFlag == TRAINING_DONE)
      {
         //Init. TxHDLCMsgHandler() to initial state
         gs_TxHDLCMsgState = HDLC_TX_START_NEW_MSG;

         //Go to next substate to transmit message
         gs_TxSubState = R_MEDLEY_MSG_TX_MODULATE_MSG;
      }
      break;


   case R_MEDLEY_MSG_TX_MODULATE_MSG:

      TxHDLCMsgHandler();

      if(gs_TxHDLCMsgState == HDLC_TX_CLOSING_FLAG_DONE)
      {
         //Set this flag to 2 to indicate that BG has been sent
         gft_OKToSendBGFlag = 2;

         //goto idle state
         gs_TxSubStateCnt = 0;
         gs_TxSubState = R_MEDLEY_MSG_TX_IDLE;
      }
      break;

   case R_MEDLEY_MSG_TX_IDLE:

      if(gs_TxSubStateCnt == 0)
      {
         //Modulate two HDLC flags into one symbol
         uca_octet[0] = (uint8)HDLC_FLAG;
         uca_octet[1] = (uint8)HDLC_FLAG;
         ModulateHdlcOctets(uca_octet, gs_TxNumBytesPerSymbol);

         gs_TxSubStateCnt++;
      }

      break;

   } //switch

}
