/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   RMsg1TxF_VDSL2_Bridge.c
*
*   This file contains RT state function to transmit R-MSG1 symbol.
*
*-------------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"
#include "ghs.h"
#include "vdsl_state.h"
#include "RTrainingTxF.h"
#include "ModulateSocMessages.h"
#include "vdsl_const.h"
#include "cmv.h"

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void RMsg1TxF_VDSL2_Bridge(void)
*
*   This function is a bridge state to load TRAIN_1_V2 swap page which contains
*   state machines for Channel Discovery and Training Phases. It is cascaded to
*   RMsg1TxF_VDSL2(). It is considered as part of VDSL2_R_MSG1_TX.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

#define R_MSG1_TX_BRIDGE_INITIALIZE         (0)
#define R_MSG1_TX_BRIDGE_MODULATE_ONE_BYTE   (1)
#define R_MSG1_TX_BRIDGE_IDLE            (2)

void RMsg1TxF_VDSL2_Bridge(void)
{
   uint8 uc_octet;
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START)
   gsa_IndirectStat0[4]=VDSL2_R_P_CHANNEL_DISCOVERY1;
   gsa_IndirectStat0[2]=VDSL2_R_MSG1;
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (END)
   switch (gs_TxSubState)
   {
   case R_MSG1_TX_BRIDGE_INITIALIZE:

      // if RX state is ready to detect O-P-SYNCHRO1, send R-MSG1
      if (gs_RxState == VDSL2_R_O_P_SYNCHRO1_RX)
      {
         // log start of R-MSG1 message
         gpt_DebugTiming->l_TxRMsg1_MsgStart = gl_TotalTxSymbolCount;

         //Set this flag to FALSE (so it will set to TRUE if O-Update is received)
         gs_MsgReceiveFlag = FALSE;

         //Not update Msg Index
         gs_UpdateTxMsgIdxFlag = FALSE;

         //Init. HDLC state machine state
         gs_TxHDLCMsgState  = HDLC_TX_START_NEW_MSG;

         //go to next substate
         gs_TxSubState = R_MSG1_TX_BRIDGE_MODULATE_ONE_BYTE;
      }
      break;

   case R_MSG1_TX_BRIDGE_MODULATE_ONE_BYTE:

      TxHDLCMsgHandler();

      //If O-Synchro1 is not received, repeatively send R_MSG1
      if(gs_MsgReceiveFlag == FALSE)
      {
         if(gs_TxHDLCMsgState == HDLC_TX_CLOSING_FLAG_DONE)
         {
            gs_TxHDLCMsgState = HDLC_TX_START_NEW_MSG;
         }
      }
      else //O-Synchro1 is received
      {
         //Generate HDLC flag
         uc_octet = (uint8)HDLC_FLAG   ;
         ModulateHdlcOctets(&uc_octet, 1);

         //Transfer next substate
         gs_TxSubStateCnt = 0;
         gs_TxSubState = R_MSG1_TX_BRIDGE_IDLE;
      }

      break;

   case R_MSG1_TX_BRIDGE_IDLE:

      //Sending 64 symbols after receiving O-Synchro1 if the lineproble is sent
      //We need to do this so that O-P-Periodic1 and R-P-Periodic 1 state
      //can be aligned better (otherwise it will affect the detection of
      //O-UPDATE)
      gs_TxSubStateCnt++;
      if(((gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG) == 0) &&
            (gul_OperationModeStatus_VDSL2 & V2_LINEPROBE) &&
            (gs_TxSubStateCnt < 64))
      {
         break;
      }

      //For the diag mode, making transfer to the next TX state
      //after sending out a current byte
      //if(gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG)
      gft_SocRepeatFlag = FALSE;

      //Transfer to the next TX state to send R-Synchro1
      gs_TxNextState = VDSL2_R_P_SYNCHRO1_TX;
      gpF_TxStateFunc = (PtrToFunc)RPSynchro1TxF_VDSL2;

      break;
   }
}
