/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   ORAckRxF_VDSL2.c
*
*   This file contains function to receive O-ACK, or REPEAT_REQUEST message
*
*-------------------------------------------------------------------------
*/
#include "vdsl_compiler.h"
#include "vdsl_state.h"
#include "gdata.h"
#include "states.h"
#include "fifo.h"
#include "ModulateSocMessages.h"
#include "codeswap.h"
#include "vdsl_xception.h"
#include "RTrainingTxF.h"
#include "ROTrainingRxF.h"
#include "ghs.h"
#include "vdsl_const.h"
#include "cmv.h"

// Vectoring Rx/Tx Sync symbol resync "R_O_ACK_RX"  - start/end
//#include "DetectDSSync_Vector_Handler.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : ROAckRxF_VDSL2
 *
 *   This function receives O-ACK, or REPEAT_REQUEST message
 *
 *  Prototype:  void ROAckRxF_VDSL2(void)
 *
 *
 *  Input Arguments:
 *      NONE
 *
 *  Output Arguments:
 *      NONE
 *
 *   Return:
 *      NONE
 *
 *  Global Variables Used:
 *      gs_RxSubState -- (I/O) substate number
 *      guc_NumberOfPossibleRxMsgs -- (I/O) the number of possible expected messages
 *      guca_PossibleRxMsgCodes[] -- (I/O) the message codes of the expected messages
 *      gs_MsgReceiveFlag -- (O) flag to indicate if the message decoding is ok or not
 *      gs_RxHDLCMsgState -- (I/O) state used in RxHDLCMsgHandler()
 *      guc_RxMsgCode -- (O) the RX message code
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */


/* =============================================== */
/* substates                              */
/* =============================================== */
#define R_O_ACK_RX_MSG_INIT            (0)
#define R_O_ACK_RX_DEMODULATE_MSG      (1)
#define R_O_ACK_RX_MSG_IDLE            (2)
// Vectoring Rx/Tx Sync symbol resync "R_O_ACK_RX"  - start
//#define R_O_ACK_RX_MSG_WAIT_FOR_CODESWAP_ALGHD_2       (3)
//#define R_O_ACK_RX_MSG_VECTOR_DEMODULATE_DS_SYNCSYMB   (4)
//#define R_O_ACK_RX_MSG_WAIT_FOR_CODESWAP_ALGHD_1       (5)
// Vectoring Rx/Tx Sync symbol resync "R_O_ACK_RX"  - end

void ROAckRxF_VDSL2(void)
{
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START)
   gsa_IndirectStat0[3]=VDSL2_R_O_P_CHANNEL_DISCOVERY2;
   gsa_IndirectStat0[2]=VDSL2_R_O_ACK;
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (END)
   switch (gs_RxSubState)
   {

      /* =============================================== */
      /* initialize RxMsgHandler */
      /* =============================================== */
   case R_O_ACK_RX_MSG_INIT:

      //Set the message code (expected message)
      guc_NumberOfPossibleRxMsgs = 2;
      guca_PossibleRxMsgCodes[0] = (uint8)VDSL2_SOC_MSG_O_ACK;
      guca_PossibleRxMsgCodes[1] = (uint8)SOC_MSG_REPEAT_REQUEST;

      //Initialize to the first substate in RxHDLCMsgHandler()
      gs_RxHDLCMsgState = 0;

      //Init. timer to an invalid value.  TX function will reset it
      gul_RxTimer = 0xFFFFFFFF;

      //go to next substate
      gs_RxSubState = R_O_ACK_RX_DEMODULATE_MSG;

      break;

      /* =============================================== */
      /* process received messages */
      /* =============================================== */
   case R_O_ACK_RX_DEMODULATE_MSG: // demodulate and delineate HDLC msg.

      //Decode the HDLC message
      RxHDLCMsgHandler();

      if(gs_RxHDLCMsgState == RX_HDLC_MSG_DECODE_IDLE)
      {
         if(gs_MsgReceiveFlag == TRUE)
         {
            //If SOC_MSG_REPEAT_REQUEST is received, instruct the TX side to retransmit this message
            if(guc_RxMsgCode == SOC_MSG_REPEAT_REQUEST)
            {
               //go to the next TX to resend R-PRM
               gs_TxNextState = VDSL2_R_PRM_TX;
               gpF_TxStateFunc = (PtrToFunc)RPDiscovery2TxF_VDSL2;
               gft_TxStateInitFlag = TRUE;

               if(gs_TxNextState == gs_TxState)
               {
                  gs_TxState = SAME_STATE;
               }

               //set the RX to go to the first substate to receive R-Update again
               gs_RxSubState = R_O_ACK_RX_MSG_INIT;

            }
            //If R_PRM is received,
            else if(guc_RxMsgCode == VDSL2_SOC_MSG_O_ACK)
            {
// Vectoring Rx/Tx Sync symbol resync "R_O_ACK_RX"  - start
//               if (gft_DSVectoringEnabled == TRUE)
//               {
//                  gs_RxSubState = R_O_ACK_RX_MSG_WAIT_FOR_CODESWAP_ALGHD_2;
//               }
//               else
// Vectoring Rx/Tx Sync symbol resync "R_O_ACK_RX"  - end
               {
                  //go to the next RX state to receive O-P-Synchro3
                  gs_RxNextState = VDSL2_R_O_P_SYNCHRO3_RX;
                  gpF_RxStateFunc = (PtrToFunc)ROPSynchro3RxF_VDSL2;

                  if(gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG)
                  {
                     //Disable the message demodulate in RxStateFunc()
                     gft_RxSocMsgDemodFlag = DISABLE_LD_DEMOD_SOC_MSG;
                  }

                  //go to the IDLE substate
                  gs_RxSubState = R_O_ACK_RX_MSG_IDLE;

                  //reset the counts for the next message
                  gs_NumRxRepeatRequest = 0;
                  gs_NumTxRepeatRequest = 0;
               }
            }
         }
         else //If the message received incorrect
         {
            //Received message either has FCS error or interpretation error
            EnterFailStates(E_CODE_RX_O_ACK_FAIL);
         }

      }

      if((gul_RxTimer != 0xFFFFFFFF) && (gul_RxTimer >= TIMEOUT_CNT_TWO_SECONDS))
      {
         //Check timeout
         if(gs_NumTxRepeatRequest < NUM_TX_REPEAT_REQUEST)
         {
            gs_NumTxRepeatRequest++;

            //go to the next TX state to send REPEAT_REQUEST
            gs_TxNextState = VDSL2_R_REPEAT_REQUEST_TX;
            gpF_TxStateFunc = (PtrToFunc)RPDiscovery2TxF_VDSL2;
            gft_TxStateInitFlag = TRUE;

            if(gs_TxNextState == gs_TxState)
            {
               gs_TxState = SAME_STATE;
            }
         }
         else
         {
            //go to fail state
            CheckTimeout(gul_RxTimer, TIMEOUT_CNT_TWO_SECONDS, E_CODE_RX_STATE_TIMEOUT);
         }
      }
      break;

// Vectoring Rx/Tx Sync symbol resync "R_O_ACK_RX"  - start
//   case R_O_ACK_RX_MSG_WAIT_FOR_CODESWAP_ALGHD_2:
//
//      // load coad swap page for DetectDSSync_Vector_Handler
//      FreeSwapHandle(&guc_PrimPageHandle);
//      guc_RxSwapActivity = CODESWAP_LOAD(VDSL_ALGHD_2_V2_PM_SWAPPAGE);
//
//      gs_VectorHandlerState = VECTOR_DEMODULATE_DS_SYNCSYMB_INIT;
//      gs_RxSubState = R_O_ACK_RX_MSG_VECTOR_DEMODULATE_DS_SYNCSYMB;
//
//      break;
//
//   case R_O_ACK_RX_MSG_VECTOR_DEMODULATE_DS_SYNCSYMB:
//      if (guc_RxSwapActivity == CODESWAP_DO_NOTHING)
//      {
//         if (gs_VectorHandlerState != VECTOR_DECODESYNCH_DONE)
//         {
//            DetectDSSync_Vector_Handler();
//         }
//         else
//         {
//            FreeSwapHandle(&guc_PrimPageHandle);
//            guc_RxSwapActivity = CODESWAP_LOAD(VDSL_ALGHD_1_V2_PM_SWAPPAGE);
//
//            gs_RxSubState = R_O_ACK_RX_MSG_WAIT_FOR_CODESWAP_ALGHD_1;
//         }
//      }
//      break;
//
//   case R_O_ACK_RX_MSG_WAIT_FOR_CODESWAP_ALGHD_1:
//      if (guc_RxSwapActivity == CODESWAP_DO_NOTHING)
//      {
//               gs_RxNextState = VDSL2_R_O_P_SYNCHRO3_RX;
//               gpF_RxStateFunc = (PtrToFunc)ROPSynchro3RxF_VDSL2;
//               gs_RxSubState = R_O_ACK_RX_MSG_IDLE;
//      }
//      break;
// Vectoring Rx/Tx Sync symbol resync "R_O_ACK_RX"  - end

   case R_O_ACK_RX_MSG_IDLE:

      //Do nothing, TX side will decide when to leave this state
      break;

   } //switch

   //Update timer
   if(gul_RxTimer != 0xFFFFFFFF)
   {
      gul_RxTimer++;
   }

// Vectoring Rx/Tx Sync symbol resync "R_O_ACK_RX"  - start
//   /* =============================================== */
//   /* State machine to request swap page            */
//   /* =============================================== */
//   switch(guc_RxSwapActivity)
//   {
//      case CODESWAP_LOAD(VDSL_ALGHD_2_V2_PM_SWAPPAGE):
//         if ((guc_PrimPageHandle = RequestSwap(VDSL_ALGHD_2_V2_PM_SWAPPAGE)) != INVALID_CODESWAP_HANDLE)
//         {
//            guc_RxSwapActivity = CODESWAP_CHECK(VDSL_ALGHD_2_V2_PM_SWAPPAGE);
//         }
//         break;
//
//      case CODESWAP_CHECK(VDSL_ALGHD_2_V2_PM_SWAPPAGE):
//         if (PollForCodeSwapDone(VDSL_ALGHD_2_V2_PM_SWAPPAGE, guc_PrimPageHandle) == SWAP_DONE)
//         {
//            guc_RxSwapActivity = CODESWAP_DO_NOTHING;
//         }
//         break;
//
//      case CODESWAP_LOAD(VDSL_ALGHD_1_V2_PM_SWAPPAGE):
//         if ((guc_PrimPageHandle = RequestSwap(VDSL_ALGHD_1_V2_PM_SWAPPAGE)) != INVALID_CODESWAP_HANDLE)
//         {
//            guc_RxSwapActivity = CODESWAP_CHECK(VDSL_ALGHD_1_V2_PM_SWAPPAGE);
//         }
//         break;
//
//      case CODESWAP_CHECK(VDSL_ALGHD_1_V2_PM_SWAPPAGE):
//         if (PollForCodeSwapDone(VDSL_ALGHD_1_V2_PM_SWAPPAGE, guc_PrimPageHandle) == SWAP_DONE)
//         {
//            guc_RxSwapActivity = CODESWAP_DO_NOTHING;
//         }
//         break;
//   } // end code swap switch
// Vectoring Rx/Tx Sync symbol resync "R_O_ACK_RX"  - end
}
