/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   ROMsg1RxF_VDSL2.c
*
*   This RT file contains the RX state function to receive the O-MSG1 message
*
*-------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"
#include "ghs.h"
#include "states.h"
#include "fifo.h"
#include "vdsl_state.h"
#include "ROTrainingRxF.h"
#include "vdsl_xception.h"
#include "IRI_IOf.h"
#include "ModulateSocMessages.h"
#include "V_STR_IOf.h"
#include "qt_memmap.h"
#include "LL_IOf.h"
#include "FormRErrorFeedbackMsg_VDSL2.h"
#include "vdsl_const.h"
#include "cmv.h"
#include "string.h"
#include "SynchDetect.h"

/*^^^
*------------------------------------------------------------------------
*
*  Name : ROMsg1RxF_VDSL2
*
*  Prototype:  void ROMsg1RxF_VDSL2(void)
*
*   This function contains four rx states
*         i. VDSL2_R_O_P_VECTOR2_RX       (184) : O-P Vector 2 related states
*        ii. VDSL2_R_O_P_SYNCHRO_V3_RX    (185) : O-P Synchro V3 related states
*       iii. VDSL2_R_0_P_VECTOR2_1_RX     (186) : O-P Vecotr 2-1 and O-P Synchro V4 related staes
*        iv. VDSL2_R_O_MSG1_RX            (87)  : for receiving O-MSG1 symbols
*
*  Input Arguments:
*
*  Output Arguments:
*
*   Return:
*      None
*
*  Global Variables Used:
*
*  Notes:
*  History :
*  24.05.2013 Abu : optimize OP-Synchro detection V4 (if sync-symbol interrupts OP-Synchro V4)
*                    Grep for XDSLRTFW-958 BUGFIX_DS_VDSL2_VECTORING_O_P_SYNCHRO_V4
*------------------------------------------------------------------------
*^^^
*/

/* =============================================== */
/* substates                              */
/* =============================================== */

// sub state definations for VDSL2_R_O_P_VECTOR2_RX state
#define R_O_P_VECTOR2_RX_O_P_VECTOR2                  (0)
// sub state definations for VDSL2_R_O_P_SYNCHRO_V3_RX state
#define R_O_P_SYNCHRO_V3_RX_DETECT                    (0)
// sub state definations for VDSL2_R_0_P_VECTOR2_1_RX state
#define R_0_P_VECTOR2_1_RX_O_P_VECTOR2_1              (0)
// sub state definations for VDSL2_R_O_MSG1_RX state
#define O_R_MSG_RX_INIT                               (0)
#define O_R_MSG_RX_DEMODULATE_MSG                     (1)

// sub state definations used in ROPSynchroVector34RxF_VDSL2 function
#define R_O_P_SYNCHRO_V34_RX_INIT                     (0)
#define R_O_P_SYNCHRO_V34_RX_DETECT                   (1)
#define R_O_P_SYNCHRO_V34_DONE                        (2)



#define SYNC_SYMBOL_DETECT_THRESH_CPE                 (14)


// RTV buffer test
uint8 guc_FEXTSymbolIndexk;
int16 gs_G9935ErrorFeedbackState = 0;
uint16 gus_NextErrorReportSymbolCount;
// XDSLRTFW-3003 : Vectoring - FW always sends the full ERB and is violating the 64 symbol constrain after receiving the O-P-SYNCHRO V4
int16 gs_G9935ErbTxCount;
int16 gs_G9935ErbTxCountRef;
//int16 gs_ErbSymShift = -2;

void ROPSynchroVector34RxF_VDSL2(void)
{
   switch (gs_VectorHandlerState)
   {

   case R_O_P_SYNCHRO_V34_RX_INIT:
      //Set the symbol detection count to 0
      gs_SynchSymbolDetectCnt = 0;

      //go to next substate
      gs_VectorHandlerState = R_O_P_SYNCHRO_V34_RX_DETECT;
      break;

   case R_O_P_SYNCHRO_V34_RX_DETECT:

      //Decode the R-P-Synchro signal
      if(DetectSynch(gpsa_RxToneBuf, gs_RxNumChannelsForMsgDecode) == TRUE)
      {
         //Indicate to the TX side that synchroV3/V4 is received

         gs_MsgReceiveOPSYNCHROV1Flag = TRUE;
         gs_VectorHandlerState = R_O_P_SYNCHRO_V34_DONE;
      }

      //Load the TC task to disable the PRBS reset
      if((gs_RxState == VDSL2_R_0_P_VECTOR2_1_RX)&&(gs_SynchSymbolDetectCnt == SYNC_SYMBOL_DETECT_THRESH_CPE))
      {
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, SwitchToRxMedleyPRBS);
#ifdef ENABLE_VR9_HW_ERR_CNT
         //Log the core error counts during the train phase
         //and reset the current counts for logging the core error counts during Medley
         if(gft_EnableCoreErrorCheck)
         {
            memcpy(gsa_StrymonOverflowCnt_train, gsa_StrymonOverflowCnt, (sizeof(int16)*17));
            memset(gsa_StrymonOverflowCnt, 0, (sizeof(int16)*17));

            memcpy(gusa_FTOverflowCnt_train, gusa_FTOverflowCnt, (sizeof(int16)*2));
            memset(gusa_FTOverflowCnt, 0, (sizeof(int16)*2));

            memcpy(gsa_TxQTErrorCnt_train, gsa_TxQTErrorCnt, (sizeof(int16)*4));
            memset(gsa_TxQTErrorCnt, 0, (sizeof(int16)*4));

            memcpy(gsa_RxQTErrorCnt_train, gsa_RxQTErrorCnt, (sizeof(int16)*4));
            memset(gsa_RxQTErrorCnt, 0, (sizeof(int16)*4));
         }
#endif //#ifdef ENABLE_VR9_HW_ERR_CNT
      }
      break;
   } //switch
}

void ROMsg1RxF_VDSL2(void)
{
   uint16 usa_FEXTSymbolPerSFIncrFactor[9] = { 256, 256, 128, 256 , 64, 256, 42, 256, 32 }; //corresponds to K = 1,2,4,6,8
   uint8 uc_K = gt_DecMsg_O_TA_Update.t_G9935_O_TA_Update_Prm.uc_FEXTSymbolsPerSF;

   if (gs_RxState == VDSL2_R_O_P_VECTOR2_RX)     // O-P Vector 2 states
   {
      // We are using this switch funchtion below only to make this state function code similar to other state function code
      gsa_IndirectStat0[3]=VDSL2_R_O_P_VECTOR2;    //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
      switch (gs_RxSubState)
      {

         /* =============================================== */
         /* initialize RxMsgHandler */
         /* =============================================== */
      case R_O_P_VECTOR2_RX_O_P_VECTOR2:

         // go to wait for O-P-SynchroV3 state
         gs_MsgReceiveOPSYNCHROV1Flag = FALSE;
         gs_VectorHandlerState = R_O_P_SYNCHRO_V34_RX_INIT;

         // go to new RX State
         gs_RxNextState = VDSL2_R_O_P_SYNCHRO_V3_RX;
         // During state change sub state will initialize to zero and the code
         // will go to R_O_P_SYNCHRO_V3_RX_DETECT sub state

         // XDSLRTFW-1242: Bugfix_ALL_VDSL2_ALL_CleanupGlobalVectoringTimeouts (Start/End)
         // Switch global state timout from OP_VECTOR1_STATE_TIMEOUT_LEN back
         // to normal VECTORING_STATE_TIMEOUT_LEN.
         // Note: This code is only active for Vectoring!
         if(guc_SwitchGlobalTimeout & SWITCH_GLOBAL_TIMEOUT_RX)
         {
            gl_RxStateTimeOutCount = VECTORING_STATE_TIMEOUT_LEN;
            guc_SwitchGlobalTimeout &= (~SWITCH_GLOBAL_TIMEOUT_RX);
         }
         break;
      }  // end switch
   } // end if of VDSL2_R_O_P_VECTOR2_RX state
   else if (gs_RxState == VDSL2_R_O_P_SYNCHRO_V3_RX)   // O-P Synchro V3 state
   {
      //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
      gsa_IndirectStat0[3]=VDSL2_R_O_P_SYNCHRO_V3;
      // We are using this switch funchtion below only to make this state function code similar to other state function code
      switch (gs_RxSubState)
      {

      case R_O_P_SYNCHRO_V3_RX_DETECT:
         if (gs_VectorHandlerState != R_O_P_SYNCHRO_V34_DONE)
         {
            // check for O-P Synchro V3
            ROPSynchroVector34RxF_VDSL2();

            if(gs_VectorHandlerState == R_O_P_SYNCHRO_V34_DONE)
            {
               // According to Table 10-9/G.993.5 field#2 requirment
               // First sync symbol after OP-SYNCHRO V3 should have the count 0!
               gs_RxSuperFrmCnt = 0;
               // Note: The handling of the counters comes at the end of the RxForeGround().
               //       Therefore the gs_RxFrmCnt must be considered too.
               if(gs_RxFrmCnt == RX_DATA_SYMBOLS_PER_SUPERFRAME)
               {
                  gs_RxSuperFrmCnt = -1;
               }
            }
         }
         else
         {
            // calculate first Symbol Count for Error Feedback
            gus_NextErrorReportSymbolCount = usa_FEXTSymbolPerSFIncrFactor[uc_K];

            // worst case we will skip 1 Super Frame before starting Feedback
            guc_FEXTSymbolIndexk           = 0;
            gs_G9935ErrorFeedbackState     = G9935_ERRORFB_ENABLE;

            //go to wait for O-P-SynchroV4 state
            gs_VectorHandlerState = R_O_P_SYNCHRO_V34_RX_INIT;

            // go to a new RX State
            gs_RxNextState = VDSL2_R_0_P_VECTOR2_1_RX;
            // During state change sub state will initialize to zero and the code
            // will go to R_0_P_VECTOR2_1_RX_O_P_VECTOR2_1 sub state
         }
         break;
      } // end switch
   } // end if of VDSL2_R_O_P_SYNCHRO_V3_RX state
   else if (gs_RxState == VDSL2_R_0_P_VECTOR2_1_RX) // combined O-P Vector 2-1 and O-P Synchro V3 states
   {
      //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
      gsa_IndirectStat0[3]=VDSL2_R_O_P_VECTOR2_1;
      // We are using this switch funchtion below only to make this state function code similar to other state function code
      switch (gs_RxSubState)
      {
      case R_0_P_VECTOR2_1_RX_O_P_VECTOR2_1:
            // check for O-P Synchro V4
            ROPSynchroVector34RxF_VDSL2();

            if (gs_VectorHandlerState == R_O_P_SYNCHRO_V34_DONE)
            {
               // Note: It could be that the Sync symbol can lay inside the synchroV4,
               //       Therefore the HW config to dump the error must be reverted!
//               if (gs_G9935ErrorFeedbackState == G9935_ERRORFB_DUMPED)
               {
                   AddFunctionToFifo(gp_RxLoadingFunctionFifo, Disable_HW_VectoringErbDump);
               }
               gs_G9935ErrorFeedbackState = G9935_ERRORFB_DISABLE;
            }

            switch (gs_G9935ErrorFeedbackState)
            {
               case G9935_ERRORFB_ENABLE:
//                  if (gs_RxFrmCnt == (gus_NextErrorReportSymbolCount+ gs_ErbSymShift))
                  if (gs_RxFrmCnt == (gus_NextErrorReportSymbolCount-2))
                  {
                     gs_FormMsgFlag = TRAINING_IN_PROGRESS;
                     AddFunctionToFifo(gp_RxLoadingFunctionFifo, Enable_HW_VectoringErbDump);

                     // Here we are in frame N-2 and next frame N will be the Feedback frame, sync symbol
                     gs_RxSuperFrmCnt_ForEOC = gs_RxSuperFrmCnt;                   // Super frame counter in ERB
                     gs_G9935ErrorFeedbackState = G9935_ERRORFB_DUMPED;
                  }
                  break;

               case G9935_ERRORFB_DUMPED:
                  // Here we are in frame N-1 and next frame should be the Sync frame
                  // were Hw will do the Error Read Out into IIBRAM based on settings changed at this Frame.

                  // Queue TC-task to restore RTV0 parameters
                  // Restore QT MISC and QT_RNG0 Register to their original value
                  AddFunctionToFifo(gp_RxLoadingFunctionFifo, Disable_HW_VectoringErbDump);
                  // disable RTV1
                  //ResetCoreReg(IRI_QT_REG_RX_FD_RNG1_ADDR, (1<<31));

                  gs_G9935ErrorFeedbackState = G9935_ERRORFB_START_FORM_MSG;
                  break;

               case G9935_ERRORFB_START_FORM_MSG:
                  // Here we are in frame N the Sync frame (256) and processing can be started.
                  AddFunctionToBkgdFifo((PtrToBkgdFunc)FormRErrorFeedbackMsg_VDSL2);
                  gs_G9935ErrorFeedbackState = G9935_ERRORFB_FORM_MSG;                // input to Tx FG
                  gs_G9935ErbTxCount = 0;
                  break;

               case G9935_ERRORFB_FORM_MSG:
                     gs_G9935ErbTxCount++;
                 break;

               case G9935_ERRORFB_SOCMSG_SENT:                                        // if message is already transmitted (Tx enables this state)
//                  if ( gs_PauseControl == 0x402)
//                  {
//                     gft_PauseOff = 0;
//                     Pause(gs_PauseControl);
//                  }
                  // XDSLRTFW-3003 : Vectoring - FW always sends the full ERB and is violating the 64 symbol constrain after receiving the O-P-SYNCHRO V4
                  if (gs_RxSuperFrmCnt_ForEOC == 0)
                  {
                     gs_G9935ErbTxCountRef = gs_G9935ErbTxCount;
                  }

                  // increment FEXT Symbol per SF index
                  guc_FEXTSymbolIndexk++;
                  gus_NextErrorReportSymbolCount += usa_FEXTSymbolPerSFIncrFactor[uc_K];
                  if(gus_NextErrorReportSymbolCount > 256)
                  {
                     guc_FEXTSymbolIndexk = 0;
                     gus_NextErrorReportSymbolCount = usa_FEXTSymbolPerSFIncrFactor[uc_K];
                  }
                  gs_G9935ErrorFeedbackState = G9935_ERRORFB_ENABLE;
                  break;

               case G9935_ERRORFB_DISABLE:
                  gsa_IndirectStat0[3]=VDSL2_R_O_P_SYNCHRO_V4;    //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)

                  if((gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG)==0)
                  {
                     //go to next substate
                     gs_RxSubState = O_R_MSG_RX_INIT;
                     gs_RxNextState = VDSL2_R_O_MSG1_RX;

                     // XDSLRTFW-1242: Bugfix_ALL_VDSL2_ALL_CleanupGlobalVectoringTimeouts (Start/End)
                     // Switch global state timout after OP-SYNCHROV4
                     // Note:
                     //       1) It is not possible to set the value here directly since
                     //          it is lower than the previous one. So the timeout check
                     //          in RxForeGround would directly kick in.
                     //       2) guc_SwitchGlobalTimeout must be initialized to zero
                     guc_SwitchGlobalTimeout |= SWITCH_GLOBAL_TIMEOUT_RX;
                  }
                  else
                  {
                     //XDSLRTFW-1621 DeltInVectoring (Start)
                     //Go to the next RX state to perform the training in Medley phase
                     gs_RxNextState = VDSL2_R_O_P_MEDLEY_RX_BRIDGE;
                     gpF_RxStateFunc = (PtrToFunc)ROPMedleyRxF_VDSL2_Bridge;
                     //In diagnostic mode, always set gs_RxNumBytesPerSymbol to 1
                     gs_RxNumBytesPerSymbol = 1;
                     //XDSLRTFW-1621 DeltInVectoring (End)
                  }
                  break;

            }  // End switch

         break; // break of R_O_P_VECTOR2_RX_O_P_VECTOR2 state
      } // end switch
   } // end if of  VDSL2_R_0_P_VECTOR2_1_RX state
   else if (gs_RxState == VDSL2_R_O_MSG1_RX)     // beginning of Channel Analysis, for receiving O-MSG1 symbols
   {
      //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START)
      gsa_IndirectStat0[3]=VDSL2_R_O_P_MEDLEY;
      gsa_IndirectStat0[2]=VDSL2_R_O_MSG1;
      //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (END)
      switch (gs_RxSubState)
      {


         /* =============================================== */
         /* initialize RxMsgHandler */
         /* =============================================== */
      case O_R_MSG_RX_INIT:

         // XDSLRTFW-1242: Bugfix_ALL_VDSL2_ALL_CleanupGlobalVectoringTimeouts (Start/End)
         // Switch global state timout from VECTORING_STATE_TIMEOUT_LEN back
         // to normal STATE_TIMEOUT_LEN.
         // Note: This code is only active for Vectoring!
         if(guc_SwitchGlobalTimeout & SWITCH_GLOBAL_TIMEOUT_RX)
         {
            gl_RxStateTimeOutCount = STATE_TIMEOUT_LEN;
            guc_SwitchGlobalTimeout &= (~SWITCH_GLOBAL_TIMEOUT_RX);
         }

         //Choose the desired number of bytes per DMT symbol in downstream
         gs_RxNumBytesPerSymbol = guc_ExchangePhaseRxNumBytesPerSymbol;
         if(gs_RxNumBytesPerSymbol > gt_DecMsg_O_TA_Update.uc_Bex_ds_O)
         {
            gs_RxNumBytesPerSymbol = gt_DecMsg_O_TA_Update.uc_Bex_ds_O;
         }

         //Set the message code (expected message) to R-MSG2
         guc_NumberOfPossibleRxMsgs = 1;
         guca_PossibleRxMsgCodes[0] = (uint8)VDSL2_SOC_MSG_O_MSG1;

         //Initialize to the first substate in RxHDLCMsgHandler()
         gs_RxHDLCMsgState = 0;

         //Init. a timer
         gul_RxTimer = 0;

         //go to next substate
         gs_RxSubState = O_R_MSG_RX_DEMODULATE_MSG;
         break;

         /* =============================================== */
         /* process received messages */
         /* =============================================== */
      case O_R_MSG_RX_DEMODULATE_MSG: // demodulate and delineate HDLC msg.

         //Decode the HDLC message
         RxHDLCMsgHandler();

         if(gs_RxHDLCMsgState == RX_HDLC_MSG_DECODE_IDLE)
         {
            if(gs_MsgReceiveFlag == TRUE)
            {
               //XDSLRTFW-521 NewFeatures_ALL_ALL_ALL_ATMVDSL2 (Start)
               //If there are no TC Modes communicated by DSLAM fail with error
               //Update the DSL 14 0 with the DSLAM Supported TC Mode
               gus_DSL_TC_Status = gt_DecMsg_O_Msg1_VDSL2.ta_DsBC[BC0].s_Control; // CMD_TC_StatusGet / DSL_TC_STATUS / DSL 14
               if ( ( ((gt_DecMsg_O_Msg1_VDSL2.ta_DsBC[BC0].s_Control & 0x1) != TPS_TC_TYPE_PTM) &&
                      ( (gt_DecMsg_O_Msg1_VDSL2.ta_DsBC[BC0].s_Control & 0x2)!= TPS_TC_TYPE_ATM) )
                     ||
                     ( ((gt_DecMsg_O_Msg1_VDSL2.ta_UsBC[BC0].s_Control & 0x1) != TPS_TC_TYPE_PTM) &&
                       ( (gt_DecMsg_O_Msg1_VDSL2.ta_UsBC[BC0].s_Control & 0x2)!= TPS_TC_TYPE_ATM) ) )
               {
                  EnterFailStates(E_CODE_TC_NOT_SUPPORTED);
               }
               else
               {
                  //XDSLRTFW-1983
                  //In VDSL2 training we see VDSL-ATM. As Not supported for TTNET Or Configuration mistake
                  //We switch to ADSL binary with Switching error code in VDSL
                  //As we switch to ADSL Binary, VDSL2 code point is removed from Short & Full CLR
                  //to get stable connection in ADSL
                  if ( ((gt_DecMsg_O_Msg1_VDSL2.ta_DsBC[BC0].s_Control & 0x2) == TPS_TC_TYPE_ATM) &&
                        ((gt_DecMsg_O_Msg1_VDSL2.ta_UsBC[BC0].s_Control & 0x2) == TPS_TC_TYPE_ATM) )
                  {
                     if(gus_TcModeUsed_PPE != 2)
                     {
                        gft_ATM_PTM_MisMatch_TTNet = 1;
                        EnterFailStates(E_CODE_GHS_S_XDSL_MODE);
                     }
                  }
                  //XDSLRTFW-1983
                  //Check the flag to execute next state
                  if (gft_ATM_PTM_MisMatch_TTNet != 1)
                  {
                     gft_ATM_PTM_MisMatch_TTNet = 0;
                     //Go to the next RX state to perform the training in Medley phase
                     gs_RxNextState = VDSL2_R_O_P_MEDLEY_RX_BRIDGE;
                     gpF_RxStateFunc = (PtrToFunc)ROPMedleyRxF_VDSL2_Bridge;

                     //reset the counts for the next message
                     gs_NumRxRepeatRequest = 0;
                     gs_NumTxRepeatRequest = 0;
                  }
               }
               //XDSLRTFW-521 NewFeatures_ALL_ALL_ALL_ATMVDSL2 (End)

            } //if(gs_MsgReceiveFlag == TRUE)
            else //If the message received incorrect
            {
               //Received message either has FCS error or interpretation error
               EnterFailStates(E_CODE_RX_O_MSG1_FAIL);
            }


         } //if(gs_RxHDLCMsgState == RX_HDLC_MSG_DECODE_IDLE)

         //Check if the RX timeout
         //MedleyMsgCheckRxTimer();

         break;
      } //switch
   } //end if of VDSL2_R_O_MSG1_RX state
   //Update timer
   if(gul_RxTimer != 0xFFFFFFFF)
   {
      gul_RxTimer++;
   }
}
