/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   ROMsgLdRxF_VDSL2Diag.c
*
*   This file contains function to receive O_MSG_LD, or REPEAT_REQUEST message
*
*-------------------------------------------------------------------------
*/

#include "vdsl_compiler.h"
#include "vdsl_state.h"
#include "gdata.h"
#include "states.h"
#include "fifo.h"
#include "ModulateSocMessages.h"
#include "RTrainingTxF.h"
#include "ROTrainingRxF.h"
#include "vdsl_xception.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : ROMsgLdRxF_VDSL2
 *
 *   This function receives R-MSG-LD, or REPEAT_REQUEST message
 *
 *  Prototype:  void ROMsgLdRxF_VDSL2(void)
 *
 *
 *  Input Arguments:
 *      NONE
 *
 *  Output Arguments:
 *      NONE
 *
 *   Return:
 *      NONE
 *
 *  Global Variables Used:
 *      gs_RxSubState -- (I/O) substate number
 *      guc_NumberOfPossibleRxMsgs -- (I/O) the number of possible expected messages
 *      guca_PossibleRxMsgCodes[] -- (I/O) the message codes of the expected messages
 *      gs_MsgReceiveFlag -- (O) flag to indicate if the message decoding is ok or not
 *      gs_RxHDLCMsgState -- (I/O) state used in RxHDLCMsgHandler()
 *      guc_RxMsgCode -- (O) the RX message code
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */


/* =============================================== */
/* substates                              */
/* =============================================== */
#define R_O_MSG_LD_RX_MSG_INIT            (0)
#define R_O_MSG_LD_RX_DEMODULATE_MSG      (1)
#define R_O_MSG_LD_RX_RECEIVE_SEG_ACK      (2)

//if(gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG)
//this function is only used in the diag. mode
void ROMsgLdRxF_VDSL2(void)
{

   switch (gs_RxSubState)
   {

      /* =============================================== */
      /* initialize RxMsgHandler */
      /* =============================================== */
   case R_O_MSG_LD_RX_MSG_INIT:

      //Set the message code (expected message) to R-UPDATE
      guc_NumberOfPossibleRxMsgs = 2;
      guca_PossibleRxMsgCodes[0] = (uint8)VDSL2_SOC_MSG_O_MSG_LD;
      guca_PossibleRxMsgCodes[1] = (uint8)SOC_MSG_REPEAT_REQUEST;

      //Initialize to the first substate in RxHDLCMsgHandler()
      gs_RxHDLCMsgState = 0;

      gft_RxMsgLdFlag = FALSE;

      //set it to 0xFFFFFFFF to disable timer
      gul_RxTimer = 0xFFFFFFFF;

      //go to next substate
      gs_RxSubState = R_O_MSG_LD_RX_DEMODULATE_MSG;

      break;

      /* =============================================== */
      /* process received messages */
      /* =============================================== */
   case R_O_MSG_LD_RX_DEMODULATE_MSG: // demodulate and delineate HDLC msg.

      //Decode the HDLC message
      RxHDLCMsgHandler();

      if(gs_RxHDLCMsgState == RX_HDLC_MSG_DECODE_IDLE)
      {
         if(gs_MsgReceiveFlag == TRUE)
         {
            //If SOC_MSG_REPEAT_REQUEST is received, instruct the TX side to retransmit this message
            if(guc_RxMsgCode == SOC_MSG_REPEAT_REQUEST)
            {
               //go to the next TX to resend O-MSG-LD
               gs_TxNextState = VDSL2_R_MSG_LD_TX;
               gpF_TxStateFunc = (PtrToFunc)RPTrain3TxF_VDSL2Diag;

               if(gs_TxNextState == gs_TxState)
               {
                  gs_TxState = SAME_STATE;
               }

               //set the RX to go to the first substate to receive R-Update again
               gs_RxSubState = R_O_MSG_LD_RX_MSG_INIT;
            }
            //If R_UPDATE is received,
            else if(guc_RxMsgCode == VDSL2_SOC_MSG_O_MSG_LD)
            {
               //Set the flag to indicate that O-MSG-LD has been received
               gft_RxMsgLdFlag = TRUE;

               //Initialize to the first substate in RxHDLCMsgHandler()
               gs_RxHDLCMsgState = 0;
               gs_RxSubState = R_O_MSG_LD_RX_RECEIVE_SEG_ACK;
            }
         }
         else //If the message received incorrect
         {
            //Received message either has FCS error or interpretation error
            EnterFailStates(E_CODE_RX_R_MDG_LD_FAIL);
         }
      }

      break;

   case R_O_MSG_LD_RX_RECEIVE_SEG_ACK:

      //Decode the HDLC message
      RxHDLCMsgHandler();

      break;
   } //switch

   //Update timer
   if(gul_RxTimer != 0xFFFFFFFF)
   {
      gul_RxTimer++;
   }
}
