/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   ROPMedleyRxF_VDSL2.c
*
*   This file contains RT state function to receive O-P-MEDLEY symbol.
*
*-------------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"
#include "ghs.h"
#include "vdsl_state.h"
#include "RTrainingTxF.h"
#include "ROTrainingRxF.h"
#include "vdsl_const.h"
#include "cmv.h"

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void ROPMedleyRxF_VDSL2(void)
*
*   This function, which is cascaded to ROPMedleyRxF_VDSL2_Bridge(), performs
*   RX processing needed in MEDLEY stat such as frame alignment, FDQ training,
*   SNR calculation, TDQ training, and Bitloading. in MEDLEY state.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void ROPMedleyRxF_VDSL2(void)
{
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
   gsa_IndirectStat0[3]=VDSL2_R_O_P_MEDLEY;
   //Call this function to perform the frame resynch, FDQ training, and SNR calculation
   MedleyTrainRxF();

   if (gs_RxProcessFlag == TRAINING_DONE)
   {
      //If not in the diag mode, go to transmit and receive message
      if((gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG) == 0)
      {
         gs_TxNextState = VDSL2_R_MSG2_TX;
         gpF_TxStateFunc = (PtrToFunc)RMedleyMsgTxF_VDSL2;

         gs_RxNextState = VDSL2_R_O_TPS_RX;
         gpF_RxStateFunc = (PtrToFunc)ROTpsRxF_VDSL2;
      }
      else //In the diag. mode, go to receive R-P-Synchro6
      {
         gs_RxNextState = VDSL2_R_O_P_SYNCHRO6_RX;
         gpF_RxStateFunc = (PtrToFunc)ROPSynchro6RxF_VDSL2Diag;
      }

      //reset the counts for the next message
      gs_NumRxRepeatRequest = 0;
      gs_NumTxRepeatRequest = 0;
   } //if (gs_RxProcessFlag == TRAINING_DONE)
}
