/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   ROPMedleyRxF_VDSL2_Bridge.c
*
*   This file contains RT state function to receive O-P-MEDLEY symbol.
*
*-------------------------------------------------------------------------------
*/

// ***********************************************************************************************************
// ROPMedleyRxF_VDSL2_Bridge.c
//
// History
//
// 15/02/2013 Vinjam : Memory Optimization. Re-used gsa_RxPathAtten_Tmp[] to store SNR with out virtual noise during LDM in channel Ananlysis phase.
//                  gpca_DELT_RxWithOutVnSnrBuf = (int8 *)(&gsa_RxPathAtten_Tmp[0]);
//                     Grep for XDSLRTFW-726 Bug_All_VDSL2_All_MemoryOptimization
// 8/10/2014 Vinay: Added code to support reporting of 3 more parameters (Recieve signal, Transmit signal, SOC message) to STAT 0
//            Grep for XDSLRTFW-1901
// ************************************************************************************************************

#include "common.h"
#include "gdata.h"
#include "vdsl_state.h"
#include "ROTrainingRxF.h"
#include "codeswap.h"
#include "cmv.h"
#include "vdsl_const.h"
#include "string.h"

//XDSLRTFW-726 Bug_All_VDSL2_All_MemoryOptimization (Start)
extern int8 *gpca_DELT_RxWithOutVnSnrBuf;
extern int16 gsa_RxPathAtten_Tmp[]; // Data overlay used to store SNR with out virtual noise in DELT mode
//XDSLRTFW-726 Bug_All_VDSL2_All_MemoryOptimization (End)

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void ROPMedleyRxF_VDSL2_Bridge(void)
*
*   This function starts receiving O-P-MEDLEY symbols, and acts as a bridge
*   state to load the next swap page which contains Analysis states.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

#define R_O_P_MEDLEY_RX_BRIDGE_CODESWAP         (0)
#define R_O_P_MEDLEY_RX_BRIDGE_CODESWAP_WAIT   (1)

void ROPMedleyRxF_VDSL2_Bridge(void)
{
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
   gsa_IndirectStat0[3]=VDSL2_R_O_P_MEDLEY;
   switch (gs_RxSubState)
   {
   case R_O_P_MEDLEY_RX_BRIDGE_CODESWAP:

      if (gs_TxState == VDSL2_R_P_MEDLEY_TX_BRIDGE)
      {
         // request codeswap
         FreeSwapHandle(&guc_PrimPageHandle);
         guc_RxSwapActivity = CODESWAP_LOAD(VDSL_ANAL_1_V2_PM_SWAPPAGE);
         gs_RxSubState = R_O_P_MEDLEY_RX_BRIDGE_CODESWAP_WAIT;
      }
      break;

   case R_O_P_MEDLEY_RX_BRIDGE_CODESWAP_WAIT:

      if (guc_RxSwapActivity == CODESWAP_DO_NOTHING)
      {
         //XDSLRTFW-726 Bug_All_VDSL2_All_MemoryOptimization (Start)
         if((gsa_IndirectStat0[0] == STAT_LoopDiagMode) && (guc_PortMode == 0))
         {
            //gpca_DELT_RxWithOutVnSnrBuf = (int8 *)(&gsa_RxPathAtten_Tmp[0]);
            gpca_DELT_RxWithOutVnSnrBuf = (int8 *)(void *)(&gsa_ELE_Tmp[0]);
            memset(gpca_DELT_RxWithOutVnSnrBuf, 0, sizeof(int8) * 4096);
         }
         //XDSLRTFW-726 Bug_All_VDSL2_All_MemoryOptimization (End)

         // go to the next RX state to receive O-P-MEDLEY
         gs_RxNextState = VDSL2_R_O_P_MEDLEY_RX;
         gpF_RxStateFunc = (PtrToFunc)ROPMedleyRxF_VDSL2;
      }
      break;
   }

   switch (guc_RxSwapActivity)
   {
   case CODESWAP_LOAD(VDSL_ANAL_1_V2_PM_SWAPPAGE):
      if ((guc_PrimPageHandle = RequestSwap(VDSL_ANAL_1_V2_PM_SWAPPAGE)) != INVALID_CODESWAP_HANDLE)
      {
         guc_RxSwapActivity = CODESWAP_CHECK(VDSL_ANAL_1_V2_PM_SWAPPAGE);
      }
      break;

   case CODESWAP_CHECK(VDSL_ANAL_1_V2_PM_SWAPPAGE):
      if (PollForCodeSwapDone(VDSL_ANAL_1_V2_PM_SWAPPAGE, guc_PrimPageHandle) == SWAP_DONE)
      {
         guc_RxSwapActivity = CODESWAP_DO_NOTHING;
      }
      break;
   }
}
