/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   ROPMultTrain2RxF_VDSL2.c
*
*   This RT file contains the several RX state functions to receive the following states
*   in the training phase:
*   O-P-PILOT2
*   O-P-ECT
*   O-P-TEQ
*   O-P-PILOT3
*   O-P-PERIODIC2
*
*-------------------------------------------------------------------------
*/
// ***********************************************************************************************************
// gdata.c
//
// History
//
// 19/09/2013 Fuss: Addded if-case to skip fct. ResetPllRefTone()
//            Grep for XDSLRTFW-1181: BugFix_DS_VDSL2_All_VecDSRateRunToRunVariation
// 8/10/2014 Vinay: Added code to support reporting of 3 more parameters (Recieve signal, Transmit signal, SOC message) to STAT 0
//            Grep for XDSLRTFW-1901
// ************************************************************************************************************

#include "common.h"
#include "gdata.h"
#include "states.h"
#include "fifo.h"
#include "vdsl_state.h"
#include "ROTrainingRxF.h"
#include "DSLEngin.h"
#include "vdsl_xception.h"
#include "TxPSDControl.h"
#include "PeriodicStateHandler_VDSL2.h"
#include "vdsl_const.h"
#include "cmv.h"

#include "cmv_Data.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : ROPPilot2RxF_VDSL2
 *
 *  Prototype:  void ROPPilot2RxF_VDSL2(void)
 *
 *   This is the state function for receiving O-P-PILOT2 symbols.
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *      gl_RxSymbolCount -- (I) RX symbol count
 *      gs_RxNextState -- (I/O) the next RX state
 *      gl_RxQuietLength -- (I) the RX QUIET3 state length in symbol
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

/* =============================================== */
/* substates                              */
/* =============================================== */
#define R_O_P_PILOT2_RX_INIT      (0)
#define R_O_P_PILOT2_RX_DETECT      (1)
#define R_O_P_PILOT2_RX_IDLE      (2)

void ROPPilot2RxF_VDSL2(void)
{
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
   gsa_IndirectStat0[3]=VDSL2_R_O_P_PILOT_2;
   //Decide the next state and save the information
   //in gs_RxNextState_ToBe and gpF_RxStateFunc_ToBe
   if(gl_RxSymbolCount == 0)
   {
      gs_RxNextState_ToBe = VDSL2_R_O_P_ECT_RX;
      NextRxTrainingState();
   }

   //If the next state is a periodic state,
   //turn off the CE upon transition to Periodic state
   if(gs_RxNextStatePeriodicFlag)
   {

      if(gl_RxSymbolCount >= (gl_RxPilot2Length-6+gs_HandleRxCE_Periodic2StateStart_StartSym_Offset))
      {
         HandleRxCE_PeriodicStateStart();
      }
   }

   //When the symbol count is reached to the specified value
   if(gl_RxSymbolCount == (gl_RxPilot2Length-1))
   {

      gs_RxNextState = gs_RxNextState_ToBe;
      gpF_RxStateFunc = gpF_RxStateFunc_ToBe;

      //Disable PLL during R_O_P_ECT
      if(gft_EctPllDisable == 1)
      {
         if(gs_RxNextState == VDSL2_R_O_P_ECT_RX)
         {
            gft_EnablePLL = FALSE;
         }
      }
   }
}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : ROPEctRxF_VDSL2
 *
 *  Prototype:  void ROPEctRxF_VDSL2(void)
 *
 *   This is the state function for receiving O-P-ETC symbols.
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *      gl_RxSymbolCount -- (I) RX symbol count
 *      gs_RxNextState -- (I/O) the next RX state
 *      gl_RxEctLength -- (I) the RX ECT state length in symbol
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

void ROPEctRxF_VDSL2(void)
{
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
   gsa_IndirectStat0[3]=VDSL2_R_O_P_ECT;
   //Decide the next state and save the information
   //in gs_RxNextState_ToBe and gpF_RxStateFunc_ToBe
   if(gl_RxSymbolCount == 0)
   {
      gs_RxNextState_ToBe = VDSL2_R_O_P_TEQ_RX;
      NextRxTrainingState();
   }

   //If the next state is a periodic state,
   //turn off the CE upon transition to Periodic state
   if(gs_RxNextStatePeriodicFlag)
   {
      if(gl_RxSymbolCount >= (gl_RxEctLength-6+gs_HandleRxCE_Periodic2StateStart_StartSym_Offset))
      {
         HandleRxCE_PeriodicStateStart();
      }
   }

   //When the symbol count is reached to the specified value
   if(gl_RxSymbolCount == (gl_RxEctLength-1))
   {
      gs_RxNextState = gs_RxNextState_ToBe;
      gpF_RxStateFunc = gpF_RxStateFunc_ToBe;
   }

}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : ROPTeqRxF_VDSL2
 *
 *  Prototype:  void ROPTeqRxF_VDSL2(void)
 *
 *   This is the state function for receiving R-O-P-TEQ symbols.
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *      gl_RxSymbolCount -- (I) RX symbol count
 *      gs_RxNextState -- (I/O) the next RX state
 *      gl_RxTeqLength -- (I) the R-P-REQ state length in symbols
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void ROPTeqRxF_VDSL2(void)
{
   //Decide the next state and save the information
   //in gs_RxNextState_ToBe and gpF_RxStateFunc_ToBe
   gsa_IndirectStat0[3]=VDSL2_R_O_P_TEQ;   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
   if(gl_RxSymbolCount == 1)
   {
      gs_RxNextState_ToBe = VDSL2_R_O_P_PILOT3_RX;
      NextRxTrainingState();

      // RESET REFERENCE IN PERIODIC
      //if(gs_PeriodicPllDisable == 1)
      {
         if(gft_EnablePLL == FALSE)
         {
            gft_EnablePLL = TRUE;
            // XDSLRTFW-1181: BugFix_DS_VDSL2_All_VecDSRateRunToRunVariation (Start/End)
            if(!(TESTArray[TEST_XDSLRTFW_CONFIG] & TEST_XDSLRTFW_CONFIG_SKIP_PLL_OP_TEQ))
            {
               // XDSLRTFW-3280 - Start / End - PLL improvement / pilot tone selection improvement
               // Set new Pll Reference for all 3 supported pilot tones.
               ResetPllRefTone(PT_ARRAY_IDX_0, &gt_PilotConfig, NULL, NULL, (int16)3);
            }
         }
      }
   }

   //Enable CE upon enter non-periodic state
   if(!gs_RxNextStatePeriodicFlag)
   {
      if(gl_RxSymbolCount >= gl_RxTeqLength-7+gs_HandleRxCE_Periodic2StateStart_EndSym_Offset)
      {
         HandleRxCE_PeriodicStateEnd();

         if(TESTArray[TEST_Mode] == STANDARD_STRYMON_CONNECT)
         {
            if(gft_SkipSymbol == 1)
            {
               gl_RxTeqLength--;
            }
         }
      }
   }

   //When the symbol count is reached to the specified value
   //go to the next RX state
   if(gl_RxSymbolCount == (gl_RxTeqLength-1))
   {
      gs_RxNextState = gs_RxNextState_ToBe;
      gpF_RxStateFunc = gpF_RxStateFunc_ToBe;
   }
}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : ROPPilot3RxF_VDSL2
 *
 *  Prototype:  void ROPPilot3RxF_VDSL2(void)
 *
 *   This is the state function for receiving O-P-PILOT3 symbols.
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *      gl_RxSymbolCount -- (I) RX symbol count
 *      gs_RxNextState -- (I/O) the next RX state
 *      gl_RxQuietLength -- (I) the RX QUIET3 state length in symbol
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

void ROPPilot3RxF_VDSL2(void)
{
   //Decide the next state and save the information
   //in gs_RxNextState_ToBe and gpF_RxStateFunc_ToBe
   gsa_IndirectStat0[3]=VDSL2_R_O_P_PILOT_3;    //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
   if(gl_RxSymbolCount == 1)
   {
      gs_RxNextState_ToBe = VDSL2_R_O_P_PERIODIC2_RX;
      NextRxTrainingState();

      // RESET REFERENCE IN PERIODIC
      //if(gs_PeriodicPllDisable == 1)
      {
         if(gft_EnablePLL == FALSE)
         {
            gft_EnablePLL = TRUE;
            // XDSLRTFW-1181: BugFix_DS_VDSL2_All_VecDSRateRunToRunVariation (Start/End)
            if(!(TESTArray[TEST_XDSLRTFW_CONFIG] & TEST_XDSLRTFW_CONFIG_SKIP_PLL_OP_Pilot3))
            {
               // XDSLRTFW-3280 - Start / End - PLL improvement / pilot tone selection improvement
               // Set new Pll Reference for all 3 supported pilot tones.
               ResetPllRefTone(PT_ARRAY_IDX_0, &gt_PilotConfig, NULL, NULL, (int16)3);
            }
         }
      }
   }

   //If the next state is a periodic state,
   //turn off the CE upon transition to Periodic state
   if(gs_RxNextStatePeriodicFlag)
   {
      if(gl_RxSymbolCount >= (gl_RxPilot3Length-6+gs_HandleRxCE_Periodic2StateStart_StartSym_Offset))
      {
         HandleRxCE_PeriodicStateStart();
      }
   }

   //When the symbol count is reached to the specified value
   if(gl_RxSymbolCount == (gl_RxPilot3Length-1))
   {
      gs_RxNextState = gs_RxNextState_ToBe;
      gpF_RxStateFunc = gpF_RxStateFunc_ToBe;
   }
}



/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : ROPPeriodic2RxF_VDSL2
 *
 *  Prototype:  void ROPPeriodic2RxF_VDSL2(void)
 *
 *   This is the state function for receiving O-P-PERIODIC2 symbols.
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *      gl_RxSymbolCount -- (I) RX symbol count
 *      gs_RxNextState -- (I/O) the next RX state
 *      gl_RxPeriodicLength -- (I) the RX ECT state length in symbol
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void ROPPeriodic2RxF_VDSL2(void)
{
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
   gsa_IndirectStat0[3]=VDSL2_R_O_P_PERIODIC2;
   // (wait a symbol for channel to stablized)
   if(gl_RxSymbolCount == 1)
   {
      // RESET REFERENCE IN PERIODIC
      //if(gs_PeriodicPllDisable == 1)
      {
         if(gft_EnablePLL == FALSE)
         {
            gft_EnablePLL = TRUE;
            // XDSLRTFW-1181: BugFix_DS_VDSL2_All_VecDSRateRunToRunVariation (Start/End)
            if(!(TESTArray[TEST_XDSLRTFW_CONFIG] & TEST_XDSLRTFW_CONFIG_SKIP_PLL_OP_Periodic2))
            {
               // XDSLRTFW-3280 - Start / End - PLL improvement / pilot tone selection improvement
               // Set new Pll Reference for all 3 supported pilot tones.
               ResetPllRefTone(PT_ARRAY_IDX_0, &gt_PilotConfig, NULL, NULL, (int16)3);
            }
         }
      }
   }

   //Enable CE upon enter non-periodic state
   if(gl_RxSymbolCount >= gl_RxPeriodicLength-7+gs_HandleRxCE_Periodic2StateStart_EndSym_Offset)
   {
      HandleRxCE_PeriodicStateEnd();

      if(TESTArray[TEST_Mode] == STANDARD_STRYMON_CONNECT)
      {
         if(gft_SkipSymbol == 1)
         {
            gl_RxPeriodicLength--;
         }
      }
   }

   //When the symbol count is reached to the specified value
   if(gl_RxSymbolCount == (gl_RxPeriodicLength-1))
   {
      //go to the next RX state
      gs_RxNextState = VDSL2_R_O_TA_UPDATE_RX;
      gpF_RxStateFunc = (PtrToFunc)ROTaUpdateRxF_VDSL2;
   }
}

