/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   ROPPeriodic1RxF_VDSL2.c
*
*   This file contains RT function to receive O-P-Periodic1
*
*-------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"
#include "states.h"
#include "fifo.h"
#include "vdsl_state.h"
#include "SnrHandler.h"
#include "IRI_Iof.h"
#include "PeriodicStateHandler_VDSL2.h"
#include "mul.h"
#include "ROTrainingRxF.h"
#include "vdsl_xception.h"
#include "vdsl_const.h"
#include "cmv.h"

#include "cmv_Data.h"

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void ROPPeriodic1RxF_VDSL2(void)
*
*   This function implements R_O_P_PERIODIC1_RX state machine.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

/* =============================================== */
/* substates                              */
/* =============================================== */
#define R_O_P_PERIODIC_RX_INIT         (0)
#define R_O_P_PERIODIC_RX_WAIT         (1)
#define R_O_P_PERIODIC_RX_SNR         (2)
#define R_O_P_PERIODIC_RX_IDLE          (3)

// TX and RX can be misaligned at most (128-15) frames (with CE) if LINEPROBE state is enabled
#define MAX_TX_RX_ALIGN_DIFF         (200) // in terms of # of frames without CE

void ROPPeriodic1RxF_VDSL2(void)
{
   int32 l_temp;
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
   gsa_IndirectStat0[3]=VDSL2_R_O_P_PERIODIC1;

   //Wait for a symbol for channel to be stablized
   // wait long enough for the echo to disappear, which is
   // contributed by CE inserted TX R_P_SYNCHRO_1 state
   // no need to wait this much if LINEPROBE state is enabled
   if (gl_RxSymbolCount == 80)
   {
      if (gs_PeriodicPllDisable == 1)
      {
         if (gs_TurnOffPLL_in_OPSYNCRO1 == 0)
         {
            gft_EnablePLL = TRUE;
         }
         //do not change the pilot reference, the feq taps used to calculate the periodic1 snrs below
         //are based on the current pilot reference - if we change the reference the constellation points
         //become slightly rotated and the snrs will degrade and will not reflect the true channel snr.
         //ResetPllRefTone(PT_ARRAY_IDX_0, &gt_PilotConfig, NULL, NULL, (int16)1);
      }
   }

   switch (gs_RxSubState)
   {
   case R_O_P_PERIODIC_RX_INIT:

      if (gs_TxState == VDSL2_R_P_PERIODIC1_TX)
      {
         gs_RxSubState = R_O_P_PERIODIC_RX_IDLE;

         gl_RxFixedStateLength = VDSL2_P_PERIODIC1_TX_LENGTH;
         if (!(gul_dbgMiscControl & DISABLE_RX_PERIODIC_TRANSITION))
         {
            //Compute the length of this state, L, such that L*(2N) = K*(2N+CElength)
            //where N is the number of tones, and K is the number of symbols in the periodic state with CE
            //Solve L = K*(1+ m*N/32/2N) = K * (1+m/64) = K + m*(k>>6)
            MULS16(l_temp, gs_m, (int16)(VDSL2_P_PERIODIC1_TX_LENGTH>>6));
            gl_RxFixedStateLength += l_temp;

            gs_RxSubState = R_O_P_PERIODIC_RX_WAIT;
         }
         gs_RxSubStateCnt = 0;
      }
      break;

   case R_O_P_PERIODIC_RX_WAIT:

      gs_RxSubStateCnt++;

      // put some additional delay so that both TX and RX are well past PERIODIC state transition
      if (gs_RxSubStateCnt == MAX_TX_RX_ALIGN_DIFF)
      {
         if(gs_PeriodicSnrCalcEnableFlag == TRUE)
         {
            gs_AlgHandlerState = SNR_INIT;
            gpsa_MeasuredSnrBuf = gsa_SnrBuf;

            // save the RxToneOffset currently being used for messaging.
            // it will be restored following the SNR calculation.
            // (SNR Handler modify RxToneOffset as they cycle thru bands).
            gs_RxToneOffsetSave = gs_RxToneOffset;

            //go to the next substate to compute SNR
            gs_RxSubState = R_O_P_PERIODIC_RX_SNR;
         }
         else
         {
            // go to substate to wait for next state
            gs_RxSubState = R_O_P_PERIODIC_RX_IDLE;
         }
      }
      break;

   case R_O_P_PERIODIC_RX_SNR:

      if (gs_AlgHandlerState != SNR_CALC_DONE)
      {
         SnrHandler();
      }
      else
      {

         if(TESTArray[TEST_StoreSramControl] & TEST_SAVE_PERIODIC1_SNR_ENABLE)
         {
            if(PollForCodeSwapDone(VDSL_WRITE_DATA_TO_SRAM_DM_SWAPPAGE, guc_OffChipRequestHandle) == SWAP_DONE)
            {
               gta_BAR15LookUpTable[OFF_CHIP_PERIODIC1_SNR][OFF_CHIP_SOURCE_INDEX] = (int32)gpsa_MeasuredSnrBuf;   // update source address
               gta_BAR15LookUpTable[OFF_CHIP_PERIODIC1_SNR][OFF_CHIP_DEST_INDEX] = (int32)&gsa_Periodic1SnrBuf[gs_RxNumTones* guc_ch_id];    // destination;
               gta_BAR15LookUpTable[OFF_CHIP_PERIODIC1_SNR][OFF_CHIP_LENGTH_INDEX] = ((gs_RxNumTones + 1)/2)*4;    // size in bytes; make sure length is multiple of 4-bytes

               // Free handle for PSD offchip request
               FreeSwapHandle(&guc_OffChipRequestHandle);
               guc_OffChipRequestHandle = RequestSwapOffChip(VDSL_WRITE_DATA_TO_SRAM_DM_SWAPPAGE, SWAP_TIMING_OFF, OFF_CHIP_PERIODIC1_SNR);
            }
            else
            {
               break;
            }
         }


         //restore the saved RxToneOffset used for messaging
         gs_RxToneOffset = gs_RxToneOffsetSave;
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, SetRxToneOffset);

         // go to the next substate to turn on cyclic extension and transition
         // place this check at the end of periodic state processes to ensure
         // all of them are done while both TX and RX are still in periodic state
         if (gl_RxSymbolCount >= gl_RxFixedStateLength-MAX_TX_RX_ALIGN_DIFF)
         {
            EnterFailStates(E_CODE_PERIODIC_PROC_TIMEOUT);
         }
         else
         {
            gs_RxSubState = R_O_P_PERIODIC_RX_IDLE;
         }
      }
      break;


   case R_O_P_PERIODIC_RX_IDLE:

      // turn off PLL 200 frames (in terms of symbol count without CE) before NON-PERIODIC state transition
      // to avoid echo coming from TX side, which is already in NON-PERIODIC state
      // no need to do it this early if LINEPROBE state is disabled
      if (!(gul_dbgMiscControl & DISABLE_RX_PERIODIC_TRANSITION))
      {
         if (gl_RxSymbolCount == gl_RxFixedStateLength-MAX_TX_RX_ALIGN_DIFF)
         {
            if (gs_PeriodicPllDisable == 1)
            {
               gft_EnablePLL = FALSE;
            }
         }

         if (gl_RxSymbolCount >= (gl_RxFixedStateLength-7+gs_HandleRxCE_PeriodicStateStart_EndSym_Offset))
         {
            HandleRxCE_PeriodicStateEnd();

            if(TESTArray[TEST_Mode] == STANDARD_STRYMON_CONNECT)
            {
               if(gft_SkipSymbol == 1)
               {
                  gl_RxFixedStateLength--;
               }
            }
         } //if (gl_RxSymbolCount >= gl_RxFixedStateLength-7)
      }

      // go to the next state to receive O-P-Synchro2 or R-P-Synchro2
      // (leaving this state a few of symbols earlier for the next state
      // to prepare for detecting O-P-Synchro2)
      if (gl_RxSymbolCount == gl_RxFixedStateLength-1)
      {
         //Transfer to the next state to detect R-P-Synchro2 signal
         gs_RxNextState = VDSL2_R_O_P_SYNCHRO2_RX;
         gpF_RxStateFunc = (PtrToFunc)ROPSynchro2RxF_VDSL2;
      }
      break;

   }
}
