/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   ROPQuietPilot1RxF_VDSL2.c
*
*   This file contains CPE function to receive O-P-Quiet/Pilot1
*
*-------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"
#include "states.h"
#include "fifo.h"
#include "vdsl_state.h"
#include "ROTrainingRxF.h"
#include "DSLEngin.h"
#include "IRI_IOf.h"
#include "ghs.h"
#include "PeriodicStateHandler_VDSL2.h"
#include "vdsl_const.h"
#include "cmv.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : ROPQuietPilot1RxF_VDSL2
 *
 *  Prototype:  void ROPQuietPilot1RxF_VDSL2(void)
 *
 *   This is the state function for detecting O-P-Quiet/O-P-Pilot1 symbols.
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */


/* =============================================== */
/* substates                              */
/* =============================================== */
#define R_O_P_QUIET_PILOT_RX_INIT      (0)
#define R_O_P_QUIET_PILOT_RX_WAIT      (1)

void ROPQuietPilot1RxF_VDSL2(void)
{
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
   gsa_IndirectStat0[3]=VDSL2_R_O_P_QUIET2_PILOT1;
   switch (gs_RxSubState)
   {

   case R_O_P_QUIET_PILOT_RX_INIT:

      //go to the next substate to update PLL
      gs_RxSubState = R_O_P_QUIET_PILOT_RX_WAIT;

      break;

   case R_O_P_QUIET_PILOT_RX_WAIT:

      // turn off PLL 128 frames before PERIODIC state transition to avoid
      // echo coming from TX side, which is already in PERIODIC state
      if (gl_RxSymbolCount == VDSL2_O_P_QUIET_PILOT1_TX_LENGTH-128)
      {
         if (gs_PeriodicPllDisable == 1)
         {
            gft_EnablePLL = FALSE;
         }
      }

      //turn off the CE upon transition to Periodic state
      if(gl_RxSymbolCount >= VDSL2_O_P_QUIET_PILOT1_TX_LENGTH-6)
      {
         HandleRxCE_PeriodicStateStart();
      }

      //When all the symbols are received, go to the next state
      if(gl_RxSymbolCount == VDSL2_O_P_QUIET_PILOT1_TX_LENGTH-1)
      {
         gs_RxNextState = VDSL2_R_O_P_PERIODIC1_RX;
         gpF_RxStateFunc = (PtrToFunc)ROPPeriodic1RxF_VDSL2;
      }
   } //switch

}
