/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   ROPSynchro1RxF_VDSL2.c
*
*   This file contains CPE function to receive O-P-SYNCHRO1
*
*-------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"
#include "states.h"
#include "fifo.h"
#include "vdsl_state.h"
#include "SynchDetect.h"
#include "RTrainingTxF.h"
#include "ROTrainingRxF.h"
#include "DSLEngin.h"
#include "IRI_IOf.h"
#include "ghs.h"
#include "vdsl_xception.h"
#include "PeriodicStateHandler_VDSL2.h"
#include "vdsl_const.h"
#include "cmv.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : ROPSynchro1RxF_VDSL2
 *
 *  Prototype:  void ROPSynchro1RxF_VDSL2(void)
 *
 *   This is the state function for detecting O-P-SYNCHRO1 symbols.
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */


/* =============================================== */
/* substates                              */
/* =============================================== */
#define R_O_P_SYNCHRO1_RX_INIT         (0)
#define R_O_P_SYNCHRO1_RX_DETECT      (1)

//Mei debug code
//if set to 1, the CPE will continously sending R-MSG1.
//This is a debug feature and can be used to measure the TX (US) PSD during the discorvery phase.
FlagT gft_ForceTxRMsg1 = 0;

void ROPSynchro1RxF_VDSL2(void)
{
//XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
   gsa_IndirectStat0[3]=VDSL2_R_O_P_SYNCHRO_1;
//Mei debug code
//Make CPE never detects O-Syncro1 so TX side will continousely send R-MSG1
   if(gft_ForceTxRMsg1)
   {
      return;
   }

   switch (gs_RxSubState)
   {

   case R_O_P_SYNCHRO1_RX_INIT:

      //Set the symbol detection count to 0
      gs_SynchSymbolDetectCnt = 0;

      //go to next substate
      gs_RxSubState = R_O_P_SYNCHRO1_RX_DETECT;

      // set the DeRotateMedleyPilot flag to use
      // decision directed method for determining pilot phase
      gft_DeRotateMedleyPilot = 1;

      break;

      // demodulate and delineate HDLC msg.
   case R_O_P_SYNCHRO1_RX_DETECT:

      //Decode the R-P-Synchro signal
      if(DetectSynch(gpsa_RxToneBuf, gs_RxNumChannelsForMsgDecode) == TRUE)
      {
         // log end of O-P-SYNCHRO1 detection
         gpt_DebugTiming->l_RxROPSynchro1_End = gl_TotalTxSymbolCount;

#if 1
         //Indicate to the TX side that synchro1 is received
         gs_MsgReceiveFlag = TRUE;
#else
         //Transfer TX state to send R-P-Synchro1
         if((gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG) == 0)
         {
            gs_TxNextState = VDSL2_R_P_SYNCHRO1_TX;
            gpF_TxStateFunc = (PtrToFunc)RPSynchro1TxF_VDSL2;
         }
         else
         {
            //Indicate to the TX side that synchro1 is received
            gs_MsgReceiveFlag = TRUE;
         }
#endif
         //Transfer to the next RX state to receive R-P-Lineprobe or R-P-Periodic
         if(gul_OperationModeStatus_VDSL2 & V2_LINEPROBE)
         {
            gs_RxNextState = VDSL2_R_O_P_QUIET_PILOT1_RX;
            gpF_RxStateFunc = (PtrToFunc)ROPQuietPilot1RxF_VDSL2;
         }
         else
         {
            gs_RxNextState = VDSL2_R_O_P_PERIODIC1_RX;
            gpF_RxStateFunc = (PtrToFunc)ROPPeriodic1RxF_VDSL2;
         }
      }
      else
      {
         //Perform timeout check
         if((gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG) == 1)
         {
            CheckTimeout(gl_RxSymbolCount, TIMEOUT_CNT_RX_O_P_SYNCHRO1, E_CODE_RX_SYNCHRO1_DETECT_FAIL);
         }
         else
         {
            int32 l_CurrentSymCnt;

            //Compute the current symbol count passed from the start of the discovery phase
            l_CurrentSymCnt = gl_TotalTxSymbolCount - gl_DiscoveryPhaseSymCnt_start;
            CheckTimeout(l_CurrentSymCnt, gl_SynchroTimeoutCnt, E_CODE_RX_SYNCHRO1_DETECT_FAIL);
         }
      }

      //If the R-P-Pilot is not sent, turn off the CE upon transition to Periodic state
      if(((gul_OperationModeStatus_VDSL2 & V2_LINEPROBE) == 0) &&
            (!(gul_dbgMiscControl & DISABLE_RX_PERIODIC_TRANSITION)))
      {
         if(gs_SynchSymbolDetectCnt >= (10+gs_HandleRxCE_PeriodicStateStart_StartSym_Offset))
         {
            HandleRxCE_PeriodicStateStart();
         }
      }

      break;
   } //switch

}
