/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   ROPSynchro2RxF_VDSL2.c
*
*   This file contains CPE function to receive O-P-SYNCHRO2
*-------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"
#include "states.h"
#include "fifo.h"
#include "vdsl_state.h"
#include "SynchDetect.h"
#include "RTrainingTxF.h"
#include "ROTrainingRxF.h"
#include "DSLEngin.h"
#include "IRI_IOf.h"
#include "ghs.h"
#include "vdsl_xception.h"
#include "vdsl_const.h"
#include "cmv.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : ROPSynchro2RxF_VDSL2
 *
 *  Prototype:  void ROPSynchro2RxF_VDSL2(void)
 *
 *   This is the state function for detecting O-P-SYNCHRO2 symbols.
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */


/* =============================================== */
/* substates                              */
/* =============================================== */
#define R_O_P_SYNCHRO_RX_INIT         (0)
#define R_O_P_SYNCHRO_RX_DETECT         (1)

void ROPSynchro2RxF_VDSL2(void)
{
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
   gsa_IndirectStat0[3]=VDSL2_R_O_P_SYNCHRO_2;
   switch (gs_RxSubState)
   {

   case R_O_P_SYNCHRO_RX_INIT:

      //Set the symbol detection count to 0
      gs_SynchSymbolDetectCnt = 0;

      //go to next substate
      gs_RxSubState = R_O_P_SYNCHRO_RX_DETECT;
      // Do not break intentionally- need to start synchro detection immediately
      //break;
      /* no break */




   case R_O_P_SYNCHRO_RX_DETECT:

      // by default skip the detection of O-P-SYNCHRO2 signal, but simply count
      if ((!(gul_dbgMiscControl & ENABLE_SYNCHRO2_DETECTION) && (gl_RxSymbolCount == 14)) ||
            DetectSynch(gpsa_RxToneBuf, gs_RxNumChannelsForMsgDecode) == TRUE)
      {
         //Enable the demodulation of SOC message for diag mode
         if(gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG)
         {
            gs_RxNumSocBitPerByte = 8;
            gft_RxSocMsgDemodFlag = ENABLE_LD_DEMOD_SOC_MSG;
         }

         // transfer to the next RX state to receive O-UPDATE message
         gs_NumTxRepeatRequest = 0;
         gs_RxNextState = VDSL2_R_O_UPDATE_RX;
         gpF_RxStateFunc = (PtrToFunc)ROUpdateRxF_VDSL2;
      }

      break;

   } //switch
}
